/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.BreakIterator;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.CSSLayoutViews;
import sferyx.administration.editors.CustomBoxPainter;
import sferyx.administration.editors.CustomEditorPane;
import sferyx.administration.editors.CustomGlyphPainter;
import sferyx.administration.editors.CustomLayoutBoxView;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.Row;
import sferyx.administration.editors.SequentialAttributeSet;
import sferyx.administration.editors.SferyxUtilities;

public class CustomInlineView
extends LabelView
implements CSSLayoutViews {
    boolean isUppercase = false;
    boolean afterInitUppercase = false;
    AttributeSet oldElementAttributes;
    AttributeSet attr;
    AttributeSet hOverAttr;
    boolean nowrap = false;
    boolean forceChange = false;
    boolean margin_right_em = false;
    boolean margin_left_em = false;
    static GlyphView.GlyphPainter defaultPainter;
    CustomBoxPainter boxPainter;
    Rectangle myRect;
    Color hypColor = null;
    private float longestWordSpan = -1.0f;

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    public CustomInlineView(Element elem) {
        super(elem);
    }

    public int getBreakWeight(int axis, float pos, float len) {
        boolean dislayLikeBlock;
        if (this.nowrap) {
            return 0;
        }
        if (axis != 0 || (dislayLikeBlock = SferyxUtilities.isDisplayLikeBlockView(this, this.getStyleSheet()))) {
            // empty if block
        }
        if (axis == 0) {
            int p0 = this.getStartOffset();
            GlyphView.GlyphPainter gp = this.getGlyphPainter();
            if (gp == null) {
                return 1000;
            }
            int p1 = gp.getBoundedPosition(this, p0, pos, len);
            if (p1 == p0) {
                return 0;
            }
            try {
                Segment s = this.getText(p0, p1);
                char[] text = s.array;
                int start = s.offset;
                int end = start + s.count;
                for (int i = start; i < end; ++i) {
                    if (text[i] != ' ' && text[i] != '-') continue;
                    return 2000;
                }
            }
            catch (Throwable thr) {
                // empty catch block
            }
            return 1000;
        }
        return super.getBreakWeight(axis, pos, len);
    }

    public boolean isAbsolutePositioning() {
        AttributeSet elementAttributes = this.getElement().getAttributes();
        if (elementAttributes.getAttribute("position") != null && elementAttributes.isDefined("position") && elementAttributes.getAttribute("position").toString().trim().equals("absolute")) {
            return true;
        }
        AttributeSet viewAttributes = this.getAttributes();
        return viewAttributes.getAttribute("position") != null && viewAttributes.getAttribute("position").toString().trim().equals("absolute");
    }

    public boolean isRelativePositioning() {
        AttributeSet elementAttributes = this.getElement().getAttributes();
        if (elementAttributes.getAttribute("position") != null && elementAttributes.isDefined("position") && elementAttributes.getAttribute("position").toString().trim().equals("relative")) {
            return true;
        }
        AttributeSet viewAttributes = this.getAttributes();
        return viewAttributes.getAttribute("position") != null && viewAttributes.getAttribute("position").toString().trim().equals("relative");
    }

    public int getAbsoluteX() {
        return SferyxUtilities.getAbsoluteY(this);
    }

    public int getAbsoluteY() {
        return SferyxUtilities.getAbsoluteY(this);
    }

    public Segment getText(int p0, int p1) {
        Segment text = super.getText(p0, p1);
        if (this.attr == null) {
            return text;
        }
        if (this.isUppercase) {
            // empty if block
        }
        if (this.attr != null && this.attr.getAttribute(CSS.Attribute.TEXT_TRANSFORM) != null && this.attr.containsAttribute(CSS.Attribute.TEXT_TRANSFORM, this.attr.getAttribute(CSS.Attribute.TEXT_TRANSFORM)) && this.attr.getAttribute(CSS.Attribute.TEXT_TRANSFORM).toString().equalsIgnoreCase("uppercase")) {
            char[] array = new char[text.array.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Character.toUpperCase(text.array[i]);
            }
            text.array = array;
            this.isUppercase = true;
        }
        this.afterInitUppercase = true;
        return text;
    }

    public AttributeSet getAttributes() {
        if (this.attr == null || this.forceChange) {
            StyleSheet sheet = this.getStyleSheet();
            this.attr = sheet.getViewAttributes(this);
        }
        this.forceChange = false;
        return this.attr;
    }

    public void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attr = this.getAttributes();
        Object decor = attr.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean u = decor != null ? decor.toString().indexOf("underline") >= 0 : false;
        this.setUnderline(u);
        boolean s = decor != null ? decor.toString().indexOf("line-through") >= 0 : false;
        this.setStrikeThrough(s);
        Object vAlign = attr.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        s = vAlign != null ? vAlign.toString().indexOf("sup") >= 0 : false;
        this.setSuperscript(s);
        s = vAlign != null ? vAlign.toString().indexOf("sub") >= 0 : false;
        this.setSubscript(s);
        Object whitespace = attr.getAttribute(CSS.Attribute.WHITE_SPACE);
        this.nowrap = whitespace != null && whitespace.equals("nowrap");
    }

    public AttributeSet getAttributes1() {
        StyleSheet sheet = this.getStyleSheet();
        if (this.oldElementAttributes == null) {
            this.oldElementAttributes = this.getElement().getAttributes().copyAttributes();
        }
        if (this.attr == null || this.oldElementAttributes != null && !this.oldElementAttributes.equals(this.getElement().getAttributes()) || this.forceChange) {
            this.attr = sheet.getViewAttributes(this);
            Object whitespace = this.attr.getAttribute(CSS.Attribute.WHITE_SPACE);
            this.nowrap = whitespace != null && whitespace.equals("nowrap");
            this.oldElementAttributes = this.getElement().getAttributes().copyAttributes();
            this.forceChange = false;
        }
        if (this.hOverAttr != null) {
            return new SequentialAttributeSet(new AttributeSet[]{this.hOverAttr, this.attr});
        }
        return this.attr;
    }

    public float getHeightCSSValue() {
        AttributeSet viewAttributes = this.getAttributes();
        float span = -1.0f;
        if (SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), viewAttributes, CSS.Attribute.HEIGHT) != null && (span = SferyxUtilities.getNumberFromCSString(SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), viewAttributes, CSS.Attribute.HEIGHT).toString())) != -1.0f) {
            return span;
        }
        AttributeSet elementAttributes = this.getElement().getAttributes();
        String emMargin = (String)elementAttributes.getAttribute("height");
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute("height");
        }
        if (emMargin == null) {
            emMargin = (String)elementAttributes.getAttribute(AlternativeCSSAttribute.HEIGHT);
        }
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute(AlternativeCSSAttribute.HEIGHT);
        }
        if (emMargin != null && elementAttributes.isDefined("height") || viewAttributes.isDefined(AlternativeCSSAttribute.HEIGHT) || elementAttributes.isDefined(AlternativeCSSAttribute.HEIGHT)) {
            if (emMargin != null && emMargin.indexOf("em") != -1 && emMargin.indexOf("rem") == -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f) {
                    Font font = this.getStyleSheet().getFont(viewAttributes);
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("rem") != -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f && this.getContainer() != null) {
                    View rootView = ((JEditorPane)this.getContainer()).getUI().getRootView((JEditorPane)this.getContainer());
                    Font font = this.getStyleSheet().getFont(rootView.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("%") != -1) {
                try {
                    float emValue = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")));
                    if (emValue != -1.0f && this.getParent() instanceof BoxView) {
                        int result = (int)((float)((BoxView)this.getParent()).getWidth() * emValue / 100.0f);
                        return result;
                    }
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
        }
        return span;
    }

    public float getWidthCSSValue() {
        float span = -1.0f;
        span = SferyxUtilities.getStyleSheetCSSWidthForView(this.getStyleSheet(), this);
        if (span != -1.0f) {
            return span;
        }
        AttributeSet elementAttributes = this.getElement().getAttributes();
        String emMargin = (String)elementAttributes.getAttribute("width");
        AttributeSet viewAttributes = this.getAttributes();
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute("width");
        }
        if (emMargin == null) {
            emMargin = (String)elementAttributes.getAttribute(AlternativeCSSAttribute.WIDTH);
        }
        if (emMargin == null) {
            emMargin = (String)viewAttributes.getAttribute(AlternativeCSSAttribute.WIDTH);
        }
        if (emMargin != null & (elementAttributes.isDefined("width") || viewAttributes.isDefined("width") || viewAttributes.isDefined(AlternativeCSSAttribute.WIDTH) || elementAttributes.isDefined(AlternativeCSSAttribute.WIDTH))) {
            if (emMargin != null && emMargin.indexOf("em") != -1 && emMargin.indexOf("rem") == -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f) {
                    Font font = this.getStyleSheet().getFont(this.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("rem") != -1) {
                float emValue = SferyxUtilities.convertEmValue(emMargin);
                if (emValue != -1.0f && this.getContainer() != null) {
                    View rootView = ((JEditorPane)this.getContainer()).getUI().getRootView((JEditorPane)this.getContainer());
                    Font font = this.getStyleSheet().getFont(rootView.getAttributes());
                    int result = (int)((float)font.getSize() * emValue);
                    this.margin_left_em = true;
                    return result;
                }
            } else if (emMargin != null && emMargin.indexOf("%") != -1) {
                try {
                    float emValue = Float.parseFloat(emMargin.substring(0, emMargin.indexOf("%")));
                    if (emValue != -1.0f && this.getParent() instanceof BoxView) {
                        int result = (int)((float)((BoxView)this.getParent()).getWidth() * emValue / 100.0f);
                        return result;
                    }
                }
                catch (Throwable thr) {
                    // empty catch block
                }
            }
        }
        return span;
    }

    public int getLeftRightBorderInset() {
        AttributeSet viewAttributes = this.getAttributes();
        return SferyxUtilities.getCellLeftBorderSize(viewAttributes, this.getElement()) + SferyxUtilities.getCellRightBorderSize(viewAttributes, this.getElement());
    }

    public float getPreferredSpan(int axis) {
        float span;
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return 0.0f;
        }
        boolean dislayLikeBlock = SferyxUtilities.isDisplayLikeBlockView(this, this.getStyleSheet());
        if (axis == 0) {
            span = -1.0f;
            float width = this.getWidthCSSValue();
            if (width != -1.0f && (span = width + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset()) != -1.0f) {
                return span;
            }
        }
        if (axis == 0 && dislayLikeBlock) {
            span = this.getWidthCSSValue();
            if (span != -1.0f) {
                return span + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftMargin() + (float)this.getRightMargin();
            }
            if (this.getParent() != null && this.getParent() instanceof BoxView && ((BoxView)this.getParent()).getWidth() > 0) {
                return ((BoxView)this.getParent()).getWidth();
            }
        }
        if (axis == 1 && dislayLikeBlock && (span = this.getHeightCSSValue()) != -1.0f) {
            return span;
        }
        float preferredSpan = super.getPreferredSpan(axis);
        if (axis == 1) {
            preferredSpan = preferredSpan + (float)this.getTopPadding() + (float)this.getBottomPadding();
        }
        if (axis == 0) {
            preferredSpan = preferredSpan + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftMargin() + (float)this.getRightMargin();
        }
        if (this.getGlyphPainter() != null && preferredSpan == 0.0f) {
            if (axis == 0) {
                return this.getGlyphPainter().getSpan(this, this.getStartOffset(), this.getEndOffset(), this.getTabExpander(), 0.0f);
            }
            return this.getGlyphPainter().getHeight(this);
        }
        return preferredSpan;
    }

    public float getMinimumSpanQuick(int axis) {
        if (axis == 0) {
            return this.getLongestWordSpan();
        }
        return super.getMinimumSpan(axis);
    }

    public float getMinimumSpan(int axis) {
        float preferredSpan;
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return 0.0f;
        }
        if (axis == 0) {
            float span = -1.0f;
            float width = this.getWidthCSSValue();
            if (width != -1.0f && (span = width + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset()) != -1.0f) {
                return span;
            }
        }
        if ((preferredSpan = this.getMinimumSpanQuick(axis)) == 0.0f && this.getGlyphPainter() != null) {
            if (axis == 0) {
                return this.getGlyphPainter().getSpan(this, this.getStartOffset(), this.getEndOffset(), this.getTabExpander(), 0.0f);
            }
            return this.getGlyphPainter().getHeight(this);
        }
        return preferredSpan;
    }

    public float getMaximumSpan(int axis) {
        View parentView;
        float span;
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return 0.0f;
        }
        boolean dislayLikeBlock = SferyxUtilities.isDisplayLikeBlockView(this, this.getStyleSheet());
        if (axis == 0) {
            span = -1.0f;
            float width = this.getWidthCSSValue();
            if (width != -1.0f && (span = width + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset()) != -1.0f) {
                return span;
            }
        }
        if (axis == 0 && dislayLikeBlock) {
            span = this.getWidthCSSValue();
            if (span != -1.0f) {
                return span + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftMargin() + (float)this.getRightMargin();
            }
            if (this.getParent() != null && this.getParent() instanceof BoxView && ((BoxView)this.getParent()).getWidth() > 0) {
                return ((BoxView)this.getParent()).getWidth();
            }
        }
        if (axis == 1 && dislayLikeBlock && (span = this.getHeightCSSValue()) != -1.0f) {
            return span;
        }
        if (axis == 0 && dislayLikeBlock && !SferyxUtilities.isFloatLeftView(this, ((EditorHTMLDocument)this.getElement().getDocument()).getStyleSheet()) && !SferyxUtilities.isFloatRightView(this, ((EditorHTMLDocument)this.getElement().getDocument()).getStyleSheet()) && this.getParent().getParent().getParent() instanceof CustomLayoutBoxView && (parentView = SferyxUtilities.getParentParagraph(this)) != null && parentView.getParent() != null) {
            return ((CustomLayoutBoxView)parentView.getParent()).getSpan(0, SferyxUtilities.indexOfView(parentView));
        }
        float preferredSpan = super.getMaximumSpan(axis);
        if (axis == 1) {
            preferredSpan = preferredSpan + (float)this.getTopPadding() + (float)this.getBottomPadding();
        }
        if (axis == 0) {
            preferredSpan = preferredSpan + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftMargin() + (float)this.getRightMargin();
        }
        if (preferredSpan == 0.0f && this.getGlyphPainter() != null) {
            if (axis == 0) {
                return this.getGlyphPainter().getSpan(this, this.getStartOffset(), this.getEndOffset(), this.getTabExpander(), 0.0f);
            }
            return this.getGlyphPainter().getHeight(this);
        }
        return preferredSpan;
    }

    public short getTextIndent() {
        short additionalShift = 0;
        Object object = this.getAttributes().getAttribute(CSS.Attribute.TEXT_INDENT);
        return additionalShift;
    }

    public int getRightMargin() {
        return SferyxUtilities.getRightMargin(this);
    }

    public int getLeftMargin() {
        return SferyxUtilities.getLeftMargin(this);
    }

    public int getTopMargin() {
        return SferyxUtilities.getTopMargin(this);
    }

    public int getBottomMargin() {
        return SferyxUtilities.getBottomMargin(this);
    }

    public int getRightPadding() {
        return SferyxUtilities.getRightPadding(this);
    }

    public int getLeftPadding() {
        return SferyxUtilities.getLeftPadding(this);
    }

    public int getTopPadding() {
        return SferyxUtilities.getTopPadding(this);
    }

    public int getBottomPadding() {
        return SferyxUtilities.getBottomPadding(this);
    }

    void checkTransformation(Graphics g, Rectangle alloc) {
        try {
            String transform = null;
            if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            } else if (this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN) != null && ((AttributeSet)this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN)).getAttribute("transform") != null && ((AttributeSet)this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN)).isDefined("transform")) {
                transform = ((AttributeSet)this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN)).getAttribute("transform").toString().toLowerCase().trim();
            } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            }
            if (transform != null && transform.startsWith("rotate(") && transform.endsWith(")") && transform.length() > 8) {
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                Rectangle rot_alloc = alloc;
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, rot_alloc.x + rot_alloc.width / 2, rot_alloc.y + rot_alloc.height / 2);
                AffineTransform curr_transf = ((Graphics2D)g).getTransform();
                if (curr_transf != null) {
                    curr_transf.concatenate(transf);
                    ((Graphics2D)g).setTransform(curr_transf);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void checkPainter() {
        this.setGlyphPainter(null);
        if (this.getGlyphPainter() == null) {
            if (defaultPainter == null) {
                defaultPainter = new CustomGlyphPainter();
            }
            if (this.getContainer() != null && ((CustomEditorPane)this.getContainer()).scale > 1.0) {
                this.setGlyphPainter(defaultPainter.getPainter(this, this.getStartOffset(), this.getEndOffset()));
            } else {
                super.checkPainter();
                this.setGlyphPainter(super.getGlyphPainter());
            }
        }
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Point r = new Point((int)x, (int)y);
        r = this.getInvertedTransformedPoint(r, a);
        x = r.x;
        y = r.y;
        return super.viewToModel(x, y, a, bias);
    }

    public Font getFont() {
        Font f = super.getFont();
        return f;
    }

    public void paint(Graphics g, Shape a) {
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        this.myRect = new Rectangle(alloc.x, alloc.y, alloc.width, alloc.height);
        if (!this.isVisible()) {
            return;
        }
        AttributeSet viewAttributes = this.getAttributes();
        AffineTransform saveAT = (AffineTransform)((Graphics2D)g).getTransform().clone();
        this.checkTransformation(g, alloc);
        if (this.boxPainter == null || !this.boxPainter.attr.equals(viewAttributes)) {
            this.boxPainter = new CustomBoxPainter(viewAttributes, this.getStyleSheet(), this);
        }
        this.boxPainter.paint(g, ((Rectangle)a).x, ((Rectangle)a).y, ((Rectangle)a).width, ((Rectangle)a).height, this);
        ((Rectangle)a).x += this.getTextIndent() + this.getLeftPadding();
        ((Rectangle)a).y += this.getTopPadding();
        super.paint(g, a);
        if (viewAttributes != null && viewAttributes.getAttribute(CSS.Attribute.TEXT_DECORATION) != null && viewAttributes.getAttribute(CSS.Attribute.TEXT_DECORATION).toString().equalsIgnoreCase("overline")) {
            Rectangle ca = (Rectangle)a;
            g.setColor(StyleConstants.getForeground(viewAttributes));
            g.drawLine(ca.x, ca.y, ca.x + ca.width, ca.y);
        }
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        GlyphView.GlyphPainter painter = this.getGlyphPainter();
        g.setColor(StyleConstants.getForeground(viewAttributes));
        boolean underline = false;
        AttributeSet elemAttr = this.getElement().getAttributes();
        if (elemAttr != null && elemAttr.getAttribute(CSS.Attribute.TEXT_DECORATION) != null && elemAttr.getAttribute(CSS.Attribute.TEXT_DECORATION).toString().toLowerCase().indexOf("underline") != -1) {
            underline = true;
        }
        boolean strike = false;
        if (elemAttr != null && elemAttr.getAttribute(CSS.Attribute.TEXT_DECORATION) != null && elemAttr.getAttribute(CSS.Attribute.TEXT_DECORATION).toString().toLowerCase().indexOf("line-through") != -1) {
            strike = true;
        }
        if (underline || strike) {
            int yTmp;
            View parent = this.getParent();
            if (parent != null && parent.getEndOffset() == p1) {
                Segment s = this.getText(p0, p1);
                while (s.count > 0 && Character.isWhitespace(s.array[s.count - 1])) {
                    --p1;
                    --s.count;
                }
            }
            int x0 = alloc.x;
            int p = this.getStartOffset();
            if (p != p0) {
                x0 += (int)painter.getSpan(this, p, p0, this.getTabExpander(), x0);
            }
            int x1 = x0 + (int)painter.getSpan(this, p0, p1, this.getTabExpander(), x0);
            int d = (int)painter.getDescent(this);
            int y = alloc.y + alloc.height - (int)painter.getDescent(this);
            if (underline) {
                yTmp = y;
                g.drawLine(x0, ++yTmp, x1, yTmp);
            }
            if (strike) {
                yTmp = y;
                g.drawLine(x0, yTmp -= (int)(painter.getAscent(this) * 0.3f), x1, yTmp);
            }
        }
        ((Graphics2D)g).setTransform(saveAT);
    }

    public void resetForegroundColorForHyperlink(Color color) {
        this.hypColor = color;
    }

    public Color getBackground() {
        return null;
    }

    public Color getForeground() {
        if (this.hypColor != null) {
            return this.hypColor;
        }
        return super.getForeground();
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Shape shape = super.modelToView(pos, a, b);
        shape = this.getTransformedShape(shape);
        return shape;
    }

    Shape getTransformedShape(Shape shape) {
        try {
            if (!(this.getParent() instanceof Row)) {
                return shape;
            }
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.getParent() instanceof Row && this.myRect != null) {
                Row parent = (Row)this.getParent();
                x = this.myRect.x;
                y = this.myRect.y;
                width = this.myRect.width;
                height = this.myRect.height;
            }
            Rectangle alloc = new Rectangle(x, y, width, height);
            String transform = null;
            if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            } else if (this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN) != null && ((AttributeSet)this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN)).getAttribute("transform") != null && ((AttributeSet)this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN)).isDefined("transform")) {
                transform = ((AttributeSet)this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN)).getAttribute("transform").toString().toLowerCase().trim();
            } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
            }
            if (transform != null && transform.startsWith("rotate(") && transform.endsWith(")") && transform.length() > 8) {
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, alloc.x + alloc.width / 2, alloc.y + alloc.height / 2);
                shape = transf.createTransformedShape(shape);
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        return shape;
    }

    Point getInvertedTransformedPoint(Point p, Shape shape) {
        block12: {
            try {
                if (!(this.getParent() instanceof Row)) {
                    return p;
                }
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.getParent() instanceof Row && this.myRect != null) {
                    Row parent = (Row)this.getParent();
                    x = this.myRect.x;
                    y = this.myRect.y;
                    width = this.myRect.width;
                    height = this.myRect.height;
                }
                Rectangle alloc = new Rectangle(x, y, width, height);
                String transform = null;
                if (this.getElement().getAttributes().getAttribute("transform") != null && this.getElement().getAttributes().isDefined("transform")) {
                    transform = this.getElement().getAttributes().getAttribute("transform").toString().toLowerCase().trim();
                } else if (this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN) != null && ((AttributeSet)this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN)).getAttribute("transform") != null && ((AttributeSet)this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN)).isDefined("transform")) {
                    transform = ((AttributeSet)this.getElement().getAttributes().getAttribute(HTML.Tag.SPAN)).getAttribute("transform").toString().toLowerCase().trim();
                } else if (this.getAttributes().getAttribute("transform") != null && this.getAttributes().isDefined("transform")) {
                    transform = this.getAttributes().getAttribute("transform").toString().toLowerCase().trim();
                }
                if (transform == null || !transform.startsWith("rotate(") || !transform.endsWith(")") || transform.length() <= 8) break block12;
                String angle = transform.substring(transform.indexOf("(") + 1, transform.indexOf(")"));
                if (angle.endsWith("deg")) {
                    angle = angle.substring(0, angle.indexOf("deg"));
                }
                AffineTransform transf = AffineTransform.getRotateInstance(Double.valueOf(angle) * Math.PI / 180.0, alloc.x + alloc.width / 2, alloc.y + alloc.height / 2);
                try {
                    transf = transf.createInverse();
                }
                catch (Throwable thr) {
                    // empty catch block
                }
                Point2D po = transf.transform(p, p);
                p = new Point((int)po.getX(), (int)po.getY());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return p;
    }

    public boolean isVisible() {
        Container c = this.getContainer();
        if (c != null && ((JComponent)c).getGraphics() != null) {
            Rectangle rect = ((JComponent)c).getGraphics().getClipRect();
            if (rect != null) {
                if (this.myRect == null) {
                    return true;
                }
                return this.myRect != null && this.myRect.intersects(rect);
            }
            return true;
        }
        return false;
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.longestWordSpan = -1.0f;
        super.insertUpdate(e, a, f);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.longestWordSpan = -1.0f;
        super.removeUpdate(e, a, f);
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.longestWordSpan = -1.0f;
        this.forceChange = true;
        super.changedUpdate(e, a, f);
    }

    float getLongestWordSpan() {
        if (this.longestWordSpan < 0.0f) {
            this.longestWordSpan = this.calculateLongestWordSpan();
        }
        return this.longestWordSpan;
    }

    float calculateLongestWordSpan() {
        float rv = 0.0f;
        Document doc = this.getDocument();
        String MultiByteProperty = "multiByte";
        rv = doc != null && Boolean.TRUE.equals(doc.getProperty(MultiByteProperty)) ? this.calculateLongestWordSpanUseBreakIterator() : this.calculateLongestWordSpanUseWhitespace();
        return rv;
    }

    float calculateLongestWordSpanUseBreakIterator() {
        float span = 0.0f;
        Document doc = this.getDocument();
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (p1 > p0) {
            try {
                FontMetrics metrics = this.getFontMetrics();
                Segment segment = new Segment();
                doc.getText(p0, p1 - p0, segment);
                Container c = this.getContainer();
                BreakIterator line = c != null ? BreakIterator.getLineInstance(c.getLocale()) : BreakIterator.getLineInstance();
                line.setText(segment);
                int start = line.first();
                int end = line.next();
                while (end != -1) {
                    if (end > start) {
                        span = Math.max(span, (float)metrics.charsWidth(segment.array, start, end - start));
                    }
                    start = end;
                    end = line.next();
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
        return span;
    }

    float calculateLongestWordSpanUseWhitespace() {
        float span = 0.0f;
        Document doc = this.getDocument();
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (p1 > p0) {
            try {
                int start;
                Segment segment = new Segment();
                doc.getText(p0, p1 - p0, segment);
                boolean CONTENT = false;
                boolean SPACES = true;
                boolean state = false;
                int end = start = segment.offset;
                FontMetrics metrics = this.getFontMetrics();
                int lastIndex = segment.offset + segment.count - 1;
                for (int i = segment.offset; i <= lastIndex; ++i) {
                    boolean updateSpan = false;
                    if (Character.isWhitespace(segment.array[i])) {
                        if (!state) {
                            updateSpan = true;
                            state = true;
                        }
                    } else {
                        if (state) {
                            end = start = i;
                            state = false;
                        } else {
                            end = i;
                        }
                        if (i == lastIndex) {
                            updateSpan = true;
                        }
                    }
                    if (!updateSpan || end <= start) continue;
                    span = Math.max(span, (float)metrics.charsWidth(segment.array, start, end - start + 1));
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
        return span;
    }
}

