/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.CSSLayoutViews;
import sferyx.administration.editors.CustomBoxPainter;
import sferyx.administration.editors.CustomLayoutBoxView;
import sferyx.administration.editors.CustomParagraphView;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.ResourceLoader;
import sferyx.administration.editors.SferyxUtilities;

public class CustomImageView
extends View
implements CSSLayoutViews {
    static Color selectionColor = null;
    private static boolean sIsInc = false;
    private static int sIncRate = 100;
    private static Icon sPendingImageIcon;
    private static Icon sMissingImageIcon;
    private static final String PENDING_IMAGE_SRC = "/sferyx/administration/editors/icons/image-delayed.gif";
    private static final String MISSING_IMAGE_SRC = "/sferyx/administration/editors/icons/image-failed.gif";
    private static final String IMAGE_CACHE_PROPERTY = "imageCache";
    static final int DEFAULT_WIDTH = 38;
    static final int DEFAULT_HEIGHT = 38;
    private static final int DEFAULT_BORDER = 2;
    static final int LOADING_FLAG = 1;
    static final int LINK_FLAG = 2;
    static final int WIDTH_FLAG = 4;
    static final int HEIGHT_FLAG = 8;
    static final int RELOAD_FLAG = 16;
    static final int RELOAD_IMAGE_FLAG = 32;
    static final int SYNC_LOAD_FLAG = 64;
    private AttributeSet attr;
    Image image;
    int width;
    int height;
    int state = 48;
    private Container container;
    protected Rectangle fBounds;
    private Color borderColor;
    private short borderSize;
    short leftInset;
    short rightInset;
    short topInset;
    short bottomInset;
    ImageObserver imageObserver;
    private View altView;
    private float vAlign;
    boolean margin_left_em = false;
    Rectangle paintBounds = new Rectangle();
    CustomBoxPainter customPainter;
    Hashtable imageCache = new Hashtable();
    boolean set = false;
    boolean lastUpdate = false;
    static /* synthetic */ Class class$javax$swing$text$html$ImageView;
    static /* synthetic */ Class class$javax$swing$text$html$HTMLEditorKit;

    public int getBreakWeight(int axis, float pos, float len) {
        boolean dislayLikeBlock;
        if (axis == 0 && (dislayLikeBlock = SferyxUtilities.isDisplayLikeBlockView(this, this.getStyleSheet())) && pos + len == (float)this.getElement().getEndOffset()) {
            return 3000;
        }
        return super.getBreakWeight(axis, pos, len);
    }

    public boolean isAbsolutePositioning() {
        AttributeSet elementAttributes = this.getElement().getAttributes();
        if (elementAttributes.getAttribute("position") != null && elementAttributes.isDefined("position") && elementAttributes.getAttribute("position").equals("absolute")) {
            return true;
        }
        AttributeSet viewAttributes = this.getAttributes();
        return viewAttributes.getAttribute("position") != null && viewAttributes.getAttribute("position").equals("absolute");
    }

    public boolean isRelativePositioning() {
        AttributeSet elementAttributes = this.getElement().getAttributes();
        if (elementAttributes.getAttribute("position") != null && elementAttributes.isDefined("position") && elementAttributes.getAttribute("position").equals("relative")) {
            return true;
        }
        AttributeSet viewAttributes = this.getAttributes();
        return viewAttributes.getAttribute("position") != null && viewAttributes.getAttribute("position").equals("relative");
    }

    public int getAbsoluteX() {
        int absoluteX = SferyxUtilities.getAbsoluteX(this);
        return absoluteX;
    }

    public int getAbsoluteY() {
        int absoluteY = SferyxUtilities.getAbsoluteY(this);
        return absoluteY;
    }

    public HTMLEditor getHTMLEditor() {
        Container container = this.getContainer();
        if (container == null) {
            return null;
        }
        Container parent = container.getParent();
        while (!(parent instanceof HTMLEditor)) {
            if ((parent = parent.getParent()) != null) continue;
            return null;
        }
        return (HTMLEditor)parent;
    }

    public boolean isSelected() {
        try {
            Container container = this.getContainer();
            if (container == null) {
                return false;
            }
            HTMLEditor htmlEditor = this.getHTMLEditor();
            if (htmlEditor == null) {
                return false;
            }
            if (container instanceof JEditorPane) {
                int caretPos = ((JEditorPane)container).getCaretPosition();
                Element slectedElem = ((HTMLDocument)this.getDocument()).getCharacterElement(caretPos);
                if (!((JEditorPane)container).isEditable()) {
                    return false;
                }
                if (slectedElem == this.getElement()) {
                    JEditorPane editorPane = (JEditorPane)container;
                    if (editorPane.getSelectionStart() == editorPane.getSelectionEnd() && this.getElement().getParentElement() != null && editorPane.getCaretPosition() != slectedElem.getStartOffset()) {
                        editorPane.setCaretPosition(slectedElem.getStartOffset());
                    }
                    return true;
                }
                if (this.paintBounds != null && this.getHTMLEditor() != null && this.getHTMLEditor().lastClickPosition != null && this.paintBounds.contains(this.getHTMLEditor().lastClickPosition)) {
                    JEditorPane editorPane = (JEditorPane)container;
                    if (editorPane.getSelectionStart() == editorPane.getSelectionEnd() && this.getElement().getParentElement() != null && editorPane.getCaretPosition() != slectedElem.getStartOffset()) {
                        editorPane.setCaretPosition(this.getElement().getStartOffset());
                    }
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public CustomImageView(Element elem) {
        super(elem);
        this.fBounds = new Rectangle();
        this.imageObserver = new ImageHandler();
        int red = SystemColor.textHighlight.getRed();
        int green = SystemColor.textHighlight.getGreen();
        int blue = SystemColor.textHighlight.getBlue();
        selectionColor = new Color(red, green, blue, 125);
        this.set = false;
    }

    public String getAltText() {
        return (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.ALT);
    }

    public URL getImageURL() {
        String src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        if (src == null) {
            return null;
        }
        if (src.startsWith("data:image/")) {
            return null;
        }
        src = SferyxUtilities.replaceAll(src, " ", "%20");
        src = SferyxUtilities.replaceAll(src, "&amp;", "&");
        URL reference = ((HTMLDocument)this.getDocument()).getBase();
        try {
            URL u = new URL(reference, src);
            return u;
        }
        catch (Throwable e) {
            try {
                File f = new File(src);
                if (f != null) {
                    URL fileURL = f.toURL();
                    URL u = new URL(reference, fileURL.toString());
                    return u;
                }
            }
            catch (Throwable exc) {
                // empty catch block
            }
            return null;
        }
    }

    public Icon getNoImageIcon() {
        this.loadDefaultIconsIfNecessary();
        return sMissingImageIcon;
    }

    public Icon getLoadingImageIcon() {
        this.loadDefaultIconsIfNecessary();
        return sPendingImageIcon;
    }

    public Image getImage() {
        if (this.getHTMLEditor() != null && this.getHTMLEditor().isDontLoadDocumentImages()) {
            return ((ImageIcon)this.getNoImageIcon()).getImage();
        }
        this.sync();
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadsSynchronously(boolean newValue) {
        CustomImageView customImageView = this;
        synchronized (customImageView) {
            this.state = newValue ? (this.state |= 0x40) : (this.state | 0x40) ^ 0x40;
        }
    }

    public boolean getLoadsSynchronously() {
        if (this.getHTMLEditor() != null && (this.getHTMLEditor().isLoadDocumentImagesInASeparateThread() || this.isSecureImage())) {
            return false;
        }
        return (this.state & 0x40) != 0;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    public AttributeSet getAttributes() {
        this.sync();
        return this.attr;
    }

    public String getToolTipText(float x, float y, Shape allocation) {
        return this.getAltText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertiesFromAttributes() {
        AttributeSet anchorAttr;
        AttributeSet attr;
        Object alignment;
        StyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
        this.borderSize = (short)this.getIntAttr(HTML.Attribute.BORDER, 0);
        if (this.borderSize != 0 || this.image == null) {
            // empty if block
        }
        this.leftInset = this.rightInset = (short)(this.getIntAttr(HTML.Attribute.HSPACE, 0) + this.borderSize);
        this.topInset = this.bottomInset = (short)(this.getIntAttr(HTML.Attribute.VSPACE, 0) + this.borderSize);
        this.leftInset = (short)(this.leftInset + ((short)this.getLeftMargin() + this.getLeftPadding()));
        this.rightInset = (short)(this.rightInset + ((short)this.getRightMargin() + this.getRightPadding()));
        this.bottomInset = (short)(this.bottomInset + ((short)this.getBottomMargin() + this.getBottomPadding()));
        this.topInset = (short)(this.topInset + ((short)this.getTopMargin() + this.getTopPadding()));
        this.borderColor = ((StyledDocument)this.getDocument()).getForeground(this.getAttributes());
        if (this.borderColor == null) {
            this.borderColor = Color.black;
        }
        if ((alignment = (attr = this.getElement().getAttributes()).getAttribute(HTML.Attribute.ALIGN)) != null && !attr.containsAttribute(HTML.Attribute.ALIGN, alignment)) {
            alignment = null;
        }
        if (alignment == null && SferyxUtilities.getStyleSheetCSSValueForElement(this.getElement(), CSS.Attribute.FLOAT) != null) {
            alignment = SferyxUtilities.getStyleSheetCSSValueForElement(this.getElement(), CSS.Attribute.FLOAT).toString();
        }
        this.vAlign = 1.0f;
        if (alignment != null) {
            if ("top".equals(alignment = alignment.toString()) || "left".equals(alignment) || "right".equals(alignment)) {
                this.vAlign = 0.0f;
            } else if ("middle".equals(alignment)) {
                this.vAlign = 0.5f;
            }
        }
        if ((anchorAttr = (AttributeSet)attr.getAttribute(HTML.Tag.A)) != null && anchorAttr.isDefined(HTML.Attribute.HREF)) {
            CustomImageView customImageView = this;
            synchronized (customImageView) {
                this.state |= 2;
            }
        }
        CustomImageView customImageView = this;
        synchronized (customImageView) {
            this.state = (this.state | 2) ^ 2;
        }
    }

    public int getRightMargin() {
        return SferyxUtilities.getRightMargin(this);
    }

    public int getLeftMargin() {
        return SferyxUtilities.getLeftMargin(this);
    }

    public int getTopMargin() {
        return SferyxUtilities.getTopMargin(this);
    }

    public int getBottomMargin() {
        return SferyxUtilities.getBottomMargin(this);
    }

    public int getRightPadding() {
        return SferyxUtilities.getRightPadding(this);
    }

    public int getLeftPadding() {
        return SferyxUtilities.getLeftPadding(this);
    }

    public int getTopPadding() {
        return SferyxUtilities.getTopPadding(this);
    }

    public int getBottomPadding() {
        return SferyxUtilities.getBottomPadding(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(View parent) {
        View oldParent = this.getParent();
        super.setParent(parent);
        Container container = this.container = parent != null ? this.getContainer() : null;
        if (oldParent != parent) {
            CustomImageView customImageView = this;
            synchronized (customImageView) {
                this.state |= 0x10;
            }
        }
        if (parent != null && parent.getParent() != null && parent.getParent() instanceof CustomParagraphView) {
            ((CustomParagraphView)parent.getParent()).containsImages = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
        CustomImageView customImageView = this;
        synchronized (customImageView) {
            this.state |= 0x30;
        }
        this.preferenceChanged(null, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, Shape a) {
        AttributeSet elemAttribs = this.getElement().getAttributes();
        if (elemAttribs != null && elemAttribs.getAttribute(HTML.Attribute.WIDTH) != null && elemAttribs.containsAttribute(HTML.Attribute.WIDTH, elemAttribs.getAttribute(HTML.Attribute.WIDTH)) && ((String)elemAttribs.getAttribute(HTML.Attribute.WIDTH)).indexOf("%") != -1) {
            this.width = this.getIntAttr(HTML.Attribute.WIDTH, this.width);
            this.preferenceChanged(this, true, true);
        }
        if (a == null) {
            return;
        }
        if (g == null) {
            return;
        }
        Rectangle clip1 = g.getClipBounds();
        this.paintBounds.x = ((Rectangle)a).x;
        this.paintBounds.y = ((Rectangle)a).y;
        this.paintBounds.width = ((Rectangle)a).width;
        this.paintBounds.height = ((Rectangle)a).height;
        try {
            block26: {
                try {
                    Icon icon;
                    Rectangle rect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                    Image image = this.getImage();
                    Rectangle clip = g.getClipBounds();
                    this.fBounds.setBounds(rect);
                    this.paintHighlights(g, a);
                    this.paintBorder(g, rect);
                    if (clip != null) {
                        g.clipRect(rect.x + this.leftInset, rect.y + this.topInset, rect.width - this.leftInset - this.rightInset, rect.height - this.topInset - this.bottomInset);
                    }
                    if (image != null) {
                        if (!this.hasPixels(image)) {
                            Icon icon2 = icon = image == null ? this.getNoImageIcon() : this.getLoadingImageIcon();
                            if (icon != null) {
                                icon.paintIcon(this.getContainer(), g, rect.x + this.leftInset, rect.y + this.topInset);
                            }
                        } else if (this.getHTMLEditor() != null && this.getHTMLEditor().isDontLoadDocumentImages()) {
                            g.drawImage(image, rect.x + this.leftInset, rect.y + this.topInset, this.imageObserver);
                        } else {
                            if (HTMLEditor.highQualityImageScalingEnabled) {
                                if (HTMLEditor.imageQualityRenderingHints != null) {
                                    ((Graphics2D)g).setRenderingHints(HTMLEditor.imageQualityRenderingHints);
                                } else {
                                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                                }
                            }
                            g.drawImage(image, rect.x + this.leftInset, rect.y + this.topInset, this.width, this.height, this.imageObserver);
                        }
                    } else {
                        View view;
                        icon = this.getNoImageIcon();
                        if (icon != null) {
                            icon.paintIcon(this.getContainer(), g, rect.x + this.leftInset, rect.y + this.topInset);
                        }
                        if ((view = this.getAltView()) != null && ((this.state & 4) == 0 || this.width > 38)) {
                            Rectangle altRect = new Rectangle(rect.x + this.leftInset + 38, rect.y + this.topInset, rect.width - this.leftInset - this.rightInset - 38, rect.height - this.topInset - this.bottomInset);
                            view.paint(g, altRect);
                        }
                    }
                    if (clip != null) {
                        // empty if block
                    }
                    if (!this.isSelected()) break block26;
                    try {
                        g.setXORMode(Color.white);
                        Rectangle rect1 = (Rectangle)a;
                        g.setColor(Color.black);
                        g.drawRect(rect1.x - 1, rect1.y - 1, rect1.width + 1, rect1.height + 1);
                        g.fillRect(rect1.x + rect1.width / 2 - 3, rect1.y + rect1.height - 6, 6, 6);
                        g.fillRect(rect1.x + rect1.width - 6, rect1.y + rect1.height / 2 - 3, 6, 6);
                        g.fillRect(rect1.x + rect1.width - 6, rect1.y + rect1.height - 6, 6, 6);
                        g.fillRect(rect1.x - 1, rect1.y + rect1.height / 2 - 3, 6, 6);
                        g.fillRect(rect1.x + rect1.width / 2 - 3, rect1.y - 1, 6, 6);
                        g.fillRect(rect1.x + rect1.width - 6, rect1.y - 1, 6, 6);
                        g.fillRect(rect1.x - 1, rect1.y - 1, 6, 6);
                        g.fillRect(rect1.x - 1, rect1.y + rect1.height - 6, 6, 6);
                        g.setPaintMode();
                    }
                    catch (Throwable thr) {
                        // empty catch block
                    }
                    if (this.getElement().getAttributes().getAttribute(HTML.Attribute.USEMAP) == null) break block26;
                    EditorHTMLDocument.CustomMap customMap = (EditorHTMLDocument.CustomMap)((EditorHTMLDocument)this.getDocument()).allMaps.get(this.getElement().getAttributes().getAttribute(HTML.Attribute.USEMAP));
                    Rectangle rect_ = new Rectangle(rect.x + this.leftInset, rect.y + this.topInset, rect.width - this.leftInset - this.rightInset, rect.height - this.topInset - this.bottomInset);
                    if (customMap == null) break block26;
                    customMap.paintAreas(g, rect_, rect_);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var12_14 = null;
                    if (clip1 != null) {
                        g.setClip(clip1.x, clip1.y, clip1.width, clip1.height);
                    }
                }
            }
            Object var12_13 = null;
            if (clip1 != null) {
                g.setClip(clip1.x, clip1.y, clip1.width, clip1.height);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (clip1 != null) {
                g.setClip(clip1.x, clip1.y, clip1.width, clip1.height);
            }
            throw throwable;
        }
    }

    public EditorHTMLDocument.CustomMap getImageMap() {
        if (this.getElement().getAttributes().getAttribute(HTML.Attribute.USEMAP) != null) {
            return (EditorHTMLDocument.CustomMap)((EditorHTMLDocument)this.getDocument()).allMaps.get(this.getElement().getAttributes().getAttribute(HTML.Attribute.USEMAP));
        }
        return null;
    }

    public boolean containsImageMap() {
        return this.getElement().getAttributes().getAttribute(HTML.Attribute.USEMAP) != null;
    }

    void paintHighlights(Graphics g, Shape shape) {
        JTextComponent tc;
        Highlighter h;
        if (this.container instanceof JTextComponent && (h = (tc = (JTextComponent)this.container).getHighlighter()) instanceof LayeredHighlighter) {
            ((LayeredHighlighter)h).paintLayeredHighlights(g, this.getStartOffset(), this.getEndOffset(), shape, tc, this);
        }
        if (this.customPainter == null) {
            this.customPainter = new CustomBoxPainter(this.getAttributes(), this.getStyleSheet(), this);
        }
        this.customPainter.paint(g, ((Rectangle)shape).x, ((Rectangle)shape).y, ((Rectangle)shape).width, ((Rectangle)shape).height, this);
    }

    void paintBorder(Graphics g, Rectangle rect) {
        Color color = this.borderColor;
        if (this.borderSize > 0 && color != null) {
            int xOffset = this.leftInset - this.borderSize;
            int yOffset = this.topInset - this.borderSize;
            g.setColor(color);
            for (int counter = 0; counter < this.borderSize; ++counter) {
                g.drawRect(rect.x + xOffset + counter, rect.y + yOffset + counter, rect.width - counter - counter - xOffset - xOffset - 1, rect.height - counter - counter - yOffset - yOffset - 1);
            }
        }
        Rectangle newRect = new Rectangle(rect);
        newRect.x += this.getLeftMargin();
        newRect.y += this.getTopMargin();
        newRect.width = newRect.width - this.getRightMargin() - this.getLeftMargin();
        newRect.height = newRect.height - this.getBottomMargin() - this.getTopMargin();
        SferyxUtilities.paintViewBorder(this, newRect, g);
    }

    public float getMaximumSpan(int axis) {
        return this.getMaximumSpan_(axis);
    }

    public float getMaximumSpan_(int axis) {
        try {
            if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
                return 0.0f;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.getMaximumSpan(axis);
    }

    public float getMinimumSpan(int axis) {
        return this.getMinimumSpan_(axis);
    }

    public float getMinimumSpan_(int axis) {
        try {
            if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
                return 0.0f;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.getMinimumSpan(axis);
    }

    public float getPreferredSpan(int axis) {
        return this.getPreferredSpan_(axis);
    }

    public float getPreferredSpan_(int axis) {
        AttributeSet elemAttribs;
        try {
            if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
                return 0.0f;
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        if (axis == 0 && (elemAttribs = this.getElement().getAttributes()) != null && elemAttribs.getAttribute(HTML.Attribute.WIDTH) != null && elemAttribs.containsAttribute(HTML.Attribute.WIDTH, elemAttribs.getAttribute(HTML.Attribute.WIDTH)) && ((String)elemAttribs.getAttribute(HTML.Attribute.WIDTH)).indexOf("%") != -1) {
            this.width = this.getIntAttr(HTML.Attribute.WIDTH, this.width);
            return this.width;
        }
        this.sync();
        if (axis == 0 && (this.state & 4) == 4) {
            this.getPreferredSpanFromAltView(axis);
            return this.width + this.leftInset + this.rightInset;
        }
        if (axis == 1 && (this.state & 8) == 8) {
            this.getPreferredSpanFromAltView(axis);
            return this.height + this.topInset + this.bottomInset;
        }
        Image image = this.getImage();
        if (image != null) {
            switch (axis) {
                case 0: {
                    return this.width + this.leftInset + this.rightInset;
                }
                case 1: {
                    return this.height + this.topInset + this.bottomInset;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
        View view = this.getAltView();
        float retValue = 0.0f;
        if (view != null) {
            retValue = view.getPreferredSpan(axis);
        }
        switch (axis) {
            case 0: {
                return retValue + (float)(this.width + this.leftInset + this.rightInset);
            }
            case 1: {
                return retValue + (float)(this.height + this.topInset + this.bottomInset);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public float getAlignment(int axis) {
        switch (axis) {
            case 1: {
                return this.vAlign;
            }
        }
        return super.getAlignment(axis);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        return null;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = (Rectangle)a;
        if (x < (float)(alloc.x + alloc.width)) {
            bias[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        bias[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    public void setSize(float width, float height) {
        View view;
        this.sync();
        if (this.getImage() == null && (view = this.getAltView()) != null) {
            view.setSize(Math.max(0.0f, width - (float)(38 + this.leftInset + this.rightInset)), Math.max(0.0f, height - (float)(this.topInset + this.bottomInset)));
        }
    }

    private boolean isLink() {
        return (this.state & 2) == 2;
    }

    boolean hasPixels(Image image) {
        return image != null && image.getHeight(this.imageObserver) > 0 && image.getWidth(this.imageObserver) > 0;
    }

    float getPreferredSpanFromAltView(int axis) {
        View view;
        if (this.getImage() == null && (view = this.getAltView()) != null) {
            return view.getPreferredSpan(axis);
        }
        return 0.0f;
    }

    private Icon makeIcon(String gifFile) throws IOException {
        int n;
        InputStream resource = this.getClass().getResourceAsStream(gifFile);
        if (resource == null) {
            System.err.println((class$javax$swing$text$html$ImageView == null ? (class$javax$swing$text$html$ImageView = CustomImageView.class$("javax.swing.text.html.ImageView")) : class$javax$swing$text$html$ImageView).getName() + "/" + gifFile + " not found.");
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((n = in.read(buffer)) > 0) {
            out.write(buffer, 0, n);
        }
        in.close();
        out.flush();
        buffer = out.toByteArray();
        if (buffer.length == 0) {
            System.err.println("warning: " + gifFile + " is zero-length");
            return null;
        }
        return new ImageIcon(buffer);
    }

    private void repaint(long delay) {
        if (this.container != null && this.fBounds != null) {
            this.container.repaint(delay, this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height);
        }
    }

    private void loadDefaultIconsIfNecessary() {
        try {
            if (sPendingImageIcon == null) {
                sPendingImageIcon = this.makeIcon(PENDING_IMAGE_SRC);
            }
            if (sMissingImageIcon == null) {
                sMissingImageIcon = this.makeIcon(MISSING_IMAGE_SRC);
            }
        }
        catch (Exception x) {
            System.err.println("ImageView: Couldn't load image icons");
        }
    }

    int getIntAttr(HTML.Attribute name, int deflt) {
        AttributeSet attr = this.getElement().getAttributes();
        if (attr.isDefined(name)) {
            int i;
            String val = (String)attr.getAttribute(name);
            if (val.endsWith("%")) {
                int img_size = -1;
                if (name == HTML.Attribute.WIDTH) {
                    img_size = ((CustomLayoutBoxView)this.getParent().getParent().getParent()).getSpan(0, SferyxUtilities.indexOfView(this.getParent().getParent()));
                } else if (name == HTML.Attribute.HEIGHT) {
                    img_size = this.image.getHeight(this.imageObserver);
                }
                String percent_value = val.substring(0, val.length() - 1);
                try {
                    if (img_size != Integer.MAX_VALUE) {
                        int percent_num = Integer.parseInt(percent_value);
                        if (percent_num >= 100) {
                            percent_num = 99;
                        }
                        float p = (float)percent_num * 0.01f;
                        if (img_size == 0) {
                            return deflt;
                        }
                        int result = (int)((float)img_size * p);
                        return result;
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            if (val == null) {
                i = deflt;
            } else {
                try {
                    i = (int)SferyxUtilities.getNumberFromCSString(val);
                }
                catch (NumberFormatException x) {
                    i = deflt;
                }
            }
            return i;
        }
        return deflt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sync() {
        int s = this.state;
        if ((s & 0x20) != 0) {
            this.refreshImage();
        }
        if (((s = this.state) & 0x10) != 0) {
            CustomImageView customImageView = this;
            synchronized (customImageView) {
                this.state = (this.state | 0x10) ^ 0x10;
            }
            this.setPropertiesFromAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshImage() {
        CustomImageView customImageView;
        CustomImageView customImageView2 = this;
        synchronized (customImageView2) {
            this.state = (this.state | 1 | 0x20 | 4 | 8) ^ 0x2C;
            this.image = null;
            this.height = 0;
            this.width = 0;
        }
        try {
            this.loadImage();
            this.updateImageSize();
            Object var4_3 = null;
            customImageView = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CustomImageView customImageView3 = this;
            synchronized (customImageView3) {
                this.state = (this.state | 1) ^ 1;
            }
            throw throwable;
        }
        synchronized (customImageView) {
            this.state = (this.state | 1) ^ 1;
        }
    }

    String getBase64EncodedImage() {
        ByteArrayOutputStream send = new ByteArrayOutputStream();
        byte[] abyte0 = new byte[1000];
        boolean flag = true;
        try {
            URL fileURL = this.getImageURL();
            if (fileURL == null) {
                String src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
                if (src.startsWith("data:image/")) {
                    return src;
                }
                return null;
            }
            final URLConnection urlConn = fileURL.openConnection();
            InputStream datainputstream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return urlConn.getInputStream();
                }
            });
            while (flag) {
                int j = datainputstream.available();
                int k = 0;
                if (fileURL.toString().startsWith("file:")) {
                    if (j >= abyte0.length) {
                        k = datainputstream.read(abyte0, 0, abyte0.length);
                    } else {
                        k = j;
                        datainputstream.read(abyte0, 0, k);
                        flag = false;
                    }
                } else {
                    if (j == 0) {
                        j = 1000;
                    }
                    if ((k = datainputstream.read(abyte0 = new byte[j])) == -1) break;
                }
                send.write(abyte0, 0, k);
            }
            send.flush();
            datainputstream.close();
            String prefix = "data:image/jpeg;base64,";
            if (fileURL.toString().toLowerCase().endsWith(".png")) {
                prefix = "data:image/png;base64,";
            } else if (fileURL.toString().toLowerCase().endsWith(".gif")) {
                prefix = "data:image/gif;base64,";
            } else if (fileURL.toString().toLowerCase().endsWith(".bmp")) {
                prefix = "data:image/bmp;base64,";
            } else if (fileURL.toString().toLowerCase().endsWith(".tiff")) {
                prefix = "data:image/tiff;base64,";
            }
            return prefix + SferyxUtilities.encodeBase64(send.toByteArray());
        }
        catch (Throwable _ex) {
            _ex.printStackTrace();
            return null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.image != null) {
            this.image.flush();
        }
        super.finalize();
    }

    private void loadImage() {
        BufferedImage buffImg;
        String srcS;
        final URL src = this.getImageURL();
        if (src == null && this.image == null && (srcS = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC)) != null && srcS.startsWith("data:image/") && srcS.indexOf(",") != -1 && srcS.indexOf(",") != srcS.length()) {
            try {
                ImageIO.scanForPlugins();
                if (!SferyxUtilities.isJVMOlder()) {
                    srcS = srcS.replaceAll("(\\r|\\n)", "");
                } else {
                    if (srcS.indexOf("\r") != -1) {
                        srcS = SferyxUtilities.replaceAll(srcS, "\r", "");
                    }
                    if (srcS.indexOf("\n") != -1) {
                        srcS = SferyxUtilities.replaceAll(srcS, "\n", "");
                    }
                }
                buffImg = ImageIO.read(new ByteArrayInputStream(SferyxUtilities.decodeBase64(srcS.substring(srcS.indexOf(",") + 1))));
                if (buffImg != null) {
                    this.image = buffImg;
                    return;
                }
            }
            catch (Throwable thr) {
                if (!SferyxUtilities.isJVMOlder()) {
                    srcS = srcS.replaceAll("(\\r|\\n)", "");
                } else {
                    if (srcS.indexOf("\r") != -1) {
                        srcS = SferyxUtilities.replaceAll(srcS, "\r", "");
                    }
                    if (srcS.indexOf("\n") != -1) {
                        srcS = SferyxUtilities.replaceAll(srcS, "\n", "");
                    }
                }
                try {
                    this.image = Toolkit.getDefaultToolkit().createImage(SferyxUtilities.decodeBase64(srcS.substring(srcS.indexOf(",") + 1)));
                    if (this.image != null) {
                        return;
                    }
                }
                catch (Throwable thrr) {
                    // empty catch block
                }
            }
        }
        Image newImage = null;
        if (src != null) {
            if (this.imageCache.get(src) != null && (HTMLEditor.loadDocumentImagesInASeparateThread_ || this.isSecureImage())) {
                this.image = (Image)this.imageCache.get(src);
                return;
            }
            if (HTMLEditor.loadDocumentImagesInASeparateThread_ && this.image == null || this.isSecureImage()) {
                Runnable imageThread = new Runnable(){

                    public void run() {
                        if (src.toString().toLowerCase().endsWith(".bmp")) {
                            try {
                                ImageIO.scanForPlugins();
                                BufferedImage buffImg = ImageIO.read(src);
                                if (buffImg != null) {
                                    CustomImageView.this.image = buffImg;
                                    CustomImageView.this.updateImageSize();
                                    CustomImageView.this.safePreferenceChanged();
                                    return;
                                }
                            }
                            catch (Throwable thr) {
                                // empty catch block
                            }
                        }
                        try {
                            CustomImageView.this.image = Toolkit.getDefaultToolkit().getImage(CustomImageView.this.getImageURL());
                            Toolkit.getDefaultToolkit().prepareImage(CustomImageView.this.image, -1, -1, CustomImageView.this.imageObserver);
                            CustomImageView.this.imageCache.put(CustomImageView.this.getImageURL(), CustomImageView.this.image);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        CustomImageView.this.updateImageSize();
                        CustomImageView.this.safePreferenceChanged();
                    }
                };
                SwingUtilities.invokeLater(imageThread);
                return;
            }
            try {
                HTMLEditor htmlEditor = this.getHTMLEditor();
                newImage = htmlEditor != null && htmlEditor.isDisableImageCaching() ? Toolkit.getDefaultToolkit().createImage(src) : Toolkit.getDefaultToolkit().getImage(src);
            }
            catch (Throwable thr) {
                // empty catch block
            }
            if (newImage != null && this.getLoadsSynchronously()) {
                ImageIcon ii = new ImageIcon();
                ii.setImage(newImage);
            }
            if (src.toString().toLowerCase().endsWith(".bmp")) {
                try {
                    ImageIO.scanForPlugins();
                    buffImg = ImageIO.read(src);
                    if (buffImg != null) {
                        this.image = newImage = buffImg;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.image = newImage;
    }

    private void loadImage1() {
        URL src = this.getImageURL();
        Image newImage = null;
        if (src != null && (newImage = Toolkit.getDefaultToolkit().getImage(src)) != null && this.getLoadsSynchronously()) {
            ImageIcon ii = new ImageIcon();
            ii.setImage(newImage);
        }
        this.image = newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImageSize() {
        int newWidth = -1;
        int newHeight = -1;
        int newState = 0;
        Image newImage = this.getImage();
        if (newImage != null) {
            float ratio;
            Element elem = this.getElement();
            AttributeSet attr = elem.getAttributes();
            newWidth = this.getIntAttr(HTML.Attribute.WIDTH, -1);
            if (newWidth <= 0) {
                newWidth = (int)SferyxUtilities.getStyleSheetCSSWidthForView(this.getStyleSheet(), this);
            }
            boolean cssWidth = false;
            if (newWidth > 0) {
                newState |= 4;
                cssWidth = true;
            }
            if ((newHeight = this.getIntAttr(HTML.Attribute.HEIGHT, -1)) <= 0) {
                newHeight = (int)SferyxUtilities.getStyleSheetCSSHeightForView(this.getStyleSheet(), this);
            }
            if (newHeight > 0) {
                newState |= 8;
            }
            if (newWidth <= 0) {
                if (newHeight > 0) {
                    int default_Height = newImage.getHeight(this.imageObserver);
                    if (default_Height > 0) {
                        ratio = (float)newHeight / (float)default_Height;
                        int default_Width = newImage.getWidth(this.imageObserver);
                        newWidth = (int)((float)default_Width * ratio);
                        newState |= 4;
                    }
                } else {
                    newWidth = newImage.getWidth(this.imageObserver);
                    if (newWidth <= 0) {
                        newWidth = 38;
                    }
                }
            }
            if (newHeight <= 0) {
                if (newWidth > 0 && (newState & 4) == 4) {
                    int default_Width = newImage.getWidth(this.imageObserver);
                    if (default_Width <= 0) {
                        default_Width = newWidth;
                    }
                    if (default_Width > 0) {
                        ratio = (float)newWidth / (float)default_Width;
                        int default_Height = newImage.getHeight(this.imageObserver);
                        if (default_Height <= 0) {
                            default_Height = newWidth;
                        }
                        newHeight = (int)((float)default_Height * ratio);
                        newState |= 8;
                    }
                } else {
                    newHeight = newImage.getHeight(this.imageObserver);
                    if (newHeight <= 0) {
                        newHeight = 38;
                    }
                }
            }
            if ((newState & 0xC) != 0) {
                if (this.getHTMLEditor() == null || !this.getHTMLEditor().isLoadDocumentImagesInASeparateThread() && !this.isSecureImage()) {
                    Toolkit.getDefaultToolkit().prepareImage(newImage, newWidth, newHeight, this.imageObserver);
                }
            } else if (this.getHTMLEditor() == null || !this.getHTMLEditor().isLoadDocumentImagesInASeparateThread() && !this.isSecureImage()) {
                Toolkit.getDefaultToolkit().prepareImage(newImage, -1, -1, this.imageObserver);
            }
            boolean createText = false;
            CustomImageView customImageView = this;
            synchronized (customImageView) {
                if (this.image != null) {
                    if ((newState & 4) == 4 || this.width == 0) {
                        this.width = newWidth;
                    }
                    if ((newState & 8) == 8 || this.height == 0) {
                        this.height = newHeight;
                    }
                } else {
                    createText = true;
                    if ((newState & 4) == 4) {
                        this.width = newWidth;
                    }
                    if ((newState & 8) == 8) {
                        this.height = newHeight;
                    }
                }
                this.state |= newState;
                this.state = (this.state | 1) ^ 1;
            }
            if (createText) {
                this.updateAltTextView();
            }
        } else if (this.getHTMLEditor() == null || !this.getHTMLEditor().isLoadDocumentImagesInASeparateThread() && !this.isSecureImage()) {
            this.height = 38;
            this.width = 38;
            this.updateBorderForNoImage();
            this.updateAltTextView();
        }
    }

    boolean isSecureImage() {
        if (this.getImageURL() != null) {
            return this.getImageURL().toString().toLowerCase().startsWith("https://");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAltTextView() {
        String text = this.getAltText();
        if (text != null) {
            ImageLabelView newView = new ImageLabelView(this.getElement(), text);
            CustomImageView customImageView = this;
            synchronized (customImageView) {
                this.altView = newView;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    View getAltView() {
        View view;
        CustomImageView customImageView = this;
        synchronized (customImageView) {
            view = this.altView;
        }
        if (view != null && view.getParent() == null) {
            view.setParent(this.getParent());
        }
        return view;
    }

    private void safePreferenceChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.preferenceChanged(null, true, true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CustomImageView.this.preferenceChanged(null, true, true);
                }
            });
        }
    }

    private void updateBorderForNoImage() {
        if (this.borderSize == 0) {
            this.borderSize = 1;
            this.leftInset = (short)(this.leftInset + this.borderSize);
            this.rightInset = (short)(this.rightInset + this.borderSize);
            this.bottomInset = (short)(this.bottomInset + this.borderSize);
            this.topInset = (short)(this.topInset + this.borderSize);
        }
    }

    static InputStream getResourceAsStream(String name) {
        try {
            return ResourceLoader.getResourceAsStream(name);
        }
        catch (Throwable e) {
            return (class$javax$swing$text$html$HTMLEditorKit == null ? (class$javax$swing$text$html$HTMLEditorKit = CustomImageView.class$("javax.swing.text.html.HTMLEditorKit")) : class$javax$swing$text$html$HTMLEditorKit).getResourceAsStream(name);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ImageLabelView
    extends InlineView {
        private Segment segment;
        private Color fg;

        ImageLabelView(Element e, String text) {
            super(e);
            this.reset(text);
        }

        public void reset(String text) {
            this.segment = new Segment(text.toCharArray(), 0, text.length());
        }

        public void paint(Graphics g, Shape a) {
            GlyphView.GlyphPainter painter = this.getGlyphPainter();
            if (painter != null) {
                g.setColor(this.getForeground());
                painter.paint(this, g, a, this.getStartOffset(), this.getEndOffset());
            }
        }

        public Segment getText(int p0, int p1) {
            if (p0 < 0 || p1 > this.segment.array.length) {
                throw new RuntimeException("ImageLabelView: Stale view");
            }
            this.segment.offset = p0;
            this.segment.count = p1 - p0;
            return this.segment;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return this.segment.array.length;
        }

        public View breakView(int axis, int p0, float pos, float len) {
            return this;
        }

        public Color getForeground() {
            View parent;
            if (this.fg == null && (parent = this.getParent()) != null) {
                Document doc = this.getDocument();
                AttributeSet attr = parent.getAttributes();
                if (attr != null && doc instanceof StyledDocument) {
                    this.fg = ((StyledDocument)doc).getForeground(attr);
                }
            }
            return this.fg;
        }
    }

    private class ImageHandler
    implements ImageObserver {
        private ImageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean imageUpdate(Image img, int flags, int x, int y, int newWidth, int newHeight) {
            if (CustomImageView.this.image == null || CustomImageView.this.image != img) {
                return false;
            }
            if ((flags & 0xC0) != 0) {
                CustomImageView.this.repaint(0L);
                CustomImageView customImageView = CustomImageView.this;
                synchronized (customImageView) {
                    if (CustomImageView.this.image == img) {
                        CustomImageView.this.image = null;
                        if ((CustomImageView.this.state & 4) != 4) {
                            CustomImageView.this.width = 38;
                        }
                        if ((CustomImageView.this.state & 8) != 8) {
                            CustomImageView.this.height = 38;
                        }
                        CustomImageView.this.updateBorderForNoImage();
                    }
                    if ((CustomImageView.this.state & 1) == 1) {
                        return false;
                    }
                }
                CustomImageView.this.updateAltTextView();
                CustomImageView.this.safePreferenceChanged();
                return false;
            }
            short changed = 0;
            if ((flags & 2) != 0) {
                changed = (short)(changed | 1);
            }
            if ((flags & 1) != 0) {
                changed = (short)(changed | 2);
            }
            CustomImageView customImageView = CustomImageView.this;
            synchronized (customImageView) {
                if (CustomImageView.this.image != img) {
                    return false;
                }
                if ((changed & 2) == 2 && (CustomImageView.this.state & 4) == 0) {
                    CustomImageView.this.width = newWidth;
                }
                if ((changed & 1) == 1 && (CustomImageView.this.state & 8) == 0) {
                    CustomImageView.this.height = newHeight;
                }
                if ((CustomImageView.this.state & 1) == 1) {
                    return true;
                }
            }
            if (changed != 0) {
                Document doc = CustomImageView.this.getDocument();
                try {
                    if (doc instanceof AbstractDocument) {
                        ((AbstractDocument)doc).readLock();
                    }
                    CustomImageView.this.safePreferenceChanged();
                }
                finally {
                    if (doc instanceof AbstractDocument) {
                        ((AbstractDocument)doc).readUnlock();
                    }
                }
                return true;
            }
            if ((flags & 0x30) != 0) {
                CustomImageView.this.repaint(0L);
            } else if ((flags & 8) != 0 && sIsInc) {
                CustomImageView.this.repaint(sIncRate);
            }
            if ((flags & 0x20) == 0 && !CustomImageView.this.lastUpdate) {
                CustomImageView.this.updateImageSize();
                CustomImageView.this.safePreferenceChanged();
                CustomImageView.this.lastUpdate = true;
            }
            return (flags & 0x20) == 0;
        }
    }
}

