/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import sferyx.administration.editors.CustomEditorPane;
import sferyx.administration.editors.EditorHTMLDocument;

public class CustomHighlighter
extends DefaultHighlighter {
    public boolean suspendPainting = false;
    JTextComponent editor;
    Color originalColor;

    public void install(JTextComponent c) {
        this.editor = c;
        this.originalColor = this.editor.getSelectedTextColor();
        super.install(c);
    }

    public void setSuspendPainting(boolean b) {
        this.suspendPainting = b;
    }

    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void cleanSpellingHighlights(int fromPosition) {
    }

    public void cleanSpellingHighlights(int fromPosition, int toPosition) {
    }

    public void cleanSpellingHighlights() {
    }

    public void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
        EditorHTMLDocument htdoc = (EditorHTMLDocument)editor.getDocument();
        if (!htdoc.selectedCells.isEmpty() && htdoc.getTableCellElement(p0) != null && htdoc.selectedCells.contains(htdoc.getTableCellElement(p0))) {
            ((CustomEditorPane)editor).setTempSelectedTextColor(Color.black);
            return;
        }
        if (!htdoc.selectedCells.isEmpty() && htdoc.getTableCellElement(p1) != null && htdoc.selectedCells.contains(htdoc.getTableCellElement(p1))) {
            ((CustomEditorPane)editor).setTempSelectedTextColor(Color.black);
            return;
        }
        if (this.originalColor != null) {
            editor.setSelectedTextColor(this.originalColor);
        } else {
            editor.setSelectedTextColor(Color.white);
        }
        if (this.suspendPainting) {
            return;
        }
        try {
            super.paintLayeredHighlights(g, p0, p1, viewBounds, editor, view);
        }
        catch (Throwable thr) {
            // empty catch block
        }
    }

    boolean viewInSelectedTable(View view, int startPosition, int endPosition, JTextComponent editor) {
        Element cellElement = ((EditorHTMLDocument)editor.getDocument()).getTableCellElement(startPosition);
        return cellElement != null && ((EditorHTMLDocument)editor.getDocument()).selectedCells.contains(cellElement);
    }

    public Highlighter.Highlight[] getHighlights() {
        Highlighter.Highlight[] orginalHighlights = super.getHighlights();
        Vector<Highlighter.Highlight> realHighlightsVector = new Vector<Highlighter.Highlight>();
        for (int i = 0; i < orginalHighlights.length; ++i) {
            realHighlightsVector.addElement(orginalHighlights[i]);
        }
        Object[] realHighlights = new Highlighter.Highlight[realHighlightsVector.size()];
        realHighlightsVector.copyInto(realHighlights);
        return realHighlights;
    }
}

