/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.InlineView;
import sferyx.administration.editors.CustomBRView;
import sferyx.administration.editors.CustomBlockInlineXMLTagView;
import sferyx.administration.editors.CustomBlockView;
import sferyx.administration.editors.CustomBlockXMLTagView;
import sferyx.administration.editors.CustomEmptyXMLTagView;
import sferyx.administration.editors.CustomFormInputView;
import sferyx.administration.editors.CustomFormView;
import sferyx.administration.editors.CustomImageView;
import sferyx.administration.editors.CustomInlineView;
import sferyx.administration.editors.CustomLayerView;
import sferyx.administration.editors.CustomLayoutBoxView;
import sferyx.administration.editors.CustomListView;
import sferyx.administration.editors.CustomObjectView;
import sferyx.administration.editors.CustomParagraphView;
import sferyx.administration.editors.CustomSimpleListView;
import sferyx.administration.editors.CustomSimpleParagraphView;
import sferyx.administration.editors.CustomTableView;
import sferyx.administration.editors.CustomUnknownTagView;
import sferyx.administration.editors.CustomXMLTagsGrammarSpecification;
import sferyx.administration.editors.CustomizableObjectView;
import sferyx.administration.editors.EmptyView;
import sferyx.administration.editors.FoldingView;
import sferyx.administration.editors.HRuleView;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.IFrameView;
import sferyx.administration.editors.PreParagraphView;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.TableView;

public class CustomHTMLFactory
extends HTMLEditorKit.HTMLFactory {
    View lastTableView;
    boolean added = false;
    Vector shadows = new Vector();
    boolean layeringDisabled = true;
    boolean count = false;

    boolean isLayered(Element elem) {
        if (this.layeringDisabled) {
            return false;
        }
        return SferyxUtilities.isLayered(elem);
    }

    private void addShadow() {
        if (this.lastTableView != null) {
            View parentView = this.lastTableView.getParent();
            CustomTableView customView = new CustomTableView(this.lastTableView.getElement(), this.lastTableView, true);
            this.lastTableView.append(customView);
        }
    }

    public View create(Element elem) {
        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        String ver = null;
        String os = null;
        try {
            ver = System.getProperty("java.version");
            os = System.getProperty("os.name");
        }
        catch (Throwable thorw) {
            // empty catch block
        }
        if (o instanceof HTML.Tag) {
            HTML.Tag kind = (HTML.Tag)o;
            if (this.isLayered(elem)) {
                return new CustomLayerView(elem);
            }
            if (kind == HTML.Tag.FORM) {
                return new CustomFormView(elem, 1);
            }
            if (kind == HTML.Tag.OBJECT || kind == HTML.Tag.APPLET) {
                Object custom_rendering = elem.getAttributes().getAttribute("use_custom_object_rendering");
                if (custom_rendering != null && custom_rendering.toString().equalsIgnoreCase("true")) {
                    return new CustomizableObjectView(elem);
                }
                return new CustomObjectView(elem);
            }
            if (kind == HTML.Tag.IMG) {
                return new CustomImageView(elem);
            }
            if (ver != null && os != null && !ver.startsWith("1.2") && HTMLEditor.imageAlignmentActive) {
                if (kind == HTML.Tag.IMPLIED) {
                    String ws = (String)elem.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (ws != null && ws.equals("pre")) {
                        return new PreParagraphView(elem);
                    }
                    return new CustomParagraphView(elem);
                }
                if (kind == HTML.Tag.P || kind == HTML.Tag.H1 || kind == HTML.Tag.H2 || kind == HTML.Tag.H3 || kind == HTML.Tag.H4 || kind == HTML.Tag.H5 || kind == HTML.Tag.H6 || kind == HTML.Tag.DT) {
                    return new CustomParagraphView(elem);
                }
                if (kind == HTML.Tag.HR) {
                    return new HRuleView(elem);
                }
                if (kind.toString().equalsIgnoreCase("iframe")) {
                    return new IFrameView(elem);
                }
                if (kind == HTML.Tag.BODY) {
                    return new CustomLayoutBoxView(elem, 1){

                        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
                            try {
                                r = super.calculateMajorAxisRequirements(axis, r);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (r != null) {
                                r.maximum = Integer.MAX_VALUE;
                            }
                            return r;
                        }
                    };
                }
                if (kind == HTML.Tag.CONTENT) {
                    return new CustomInlineView(elem);
                }
                if (kind == HTML.Tag.BR) {
                    return new CustomBRView(elem);
                }
                if (kind == HTML.Tag.HTML) {
                    return new CustomBlockView(elem, 1);
                }
                if (kind == HTML.Tag.OL || kind == HTML.Tag.UL) {
                    return new CustomListView(elem);
                }
                if (kind == HTML.Tag.A && SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.DISPLAY) != null && SferyxUtilities.getStyleSheetCSSValueForElement(elem, CSS.Attribute.DISPLAY).toString().equalsIgnoreCase("block")) {
                    return new CustomParagraphView(elem);
                }
                if (elem.getName().equalsIgnoreCase("nav") || elem.getName().equalsIgnoreCase("footer") || elem.getName().equalsIgnoreCase("section") || elem.getName().equalsIgnoreCase("article") || elem.getName().equalsIgnoreCase("aside") || elem.getName().equalsIgnoreCase("header")) {
                    return new CustomBlockView(elem, 1);
                }
                if (kind == HTML.Tag.LI || kind == HTML.Tag.CENTER || kind == HTML.Tag.DL || kind == HTML.Tag.DD || kind == HTML.Tag.DIV || kind == HTML.Tag.BLOCKQUOTE || kind == HTML.Tag.PRE || kind == HTML.Tag.CAPTION || kind == HTML.Tag.FORM || kind.toString().equalsIgnoreCase("fieldset")) {
                    if (elem.getAttributes().getAttribute("textfolding") != null && elem.getAttributes().isDefined("textfolding") && elem.getAttributes().getAttribute("textfolding").equals("true")) {
                        return new FoldingView(elem, 1);
                    }
                    return new CustomBlockView(elem, 1);
                }
            } else if (ver != null && os != null && ver.startsWith("1.2")) {
                if (kind == HTML.Tag.IMPLIED) {
                    String ws = (String)elem.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (ws != null && ws.equals("pre")) {
                        return super.create(elem);
                    }
                    return new CustomSimpleParagraphView(elem);
                }
                if (kind == HTML.Tag.P || kind == HTML.Tag.H1 || kind == HTML.Tag.H2 || kind == HTML.Tag.H3 || kind == HTML.Tag.H4 || kind == HTML.Tag.H5 || kind == HTML.Tag.H6 || kind == HTML.Tag.DT) {
                    return new CustomSimpleParagraphView(elem);
                }
                if (kind == HTML.Tag.FORM) {
                    return new CustomFormView(elem, 1);
                }
                if (kind == HTML.Tag.OL || kind == HTML.Tag.UL) {
                    return new CustomSimpleListView(elem);
                }
            }
            if (kind == HTML.Tag.TR) {
                return new CustomBlockView(elem, 1);
            }
            if (kind == HTML.Tag.TD || kind == HTML.Tag.TH) {
                return new CustomBlockView(elem, 1);
            }
            if (kind == HTML.Tag.TABLE) {
                TableView defaultView = new TableView(elem);
                if (defaultView != null) {
                    return defaultView;
                }
                this.lastTableView = defaultView;
                return defaultView;
            }
            if (kind == HTML.Tag.TITLE || kind == HTML.Tag.META || kind == HTML.Tag.LINK || kind == HTML.Tag.STYLE || kind == HTML.Tag.SCRIPT || kind == HTML.Tag.AREA || kind == HTML.Tag.MAP || kind == HTML.Tag.PARAM || kind == HTML.Tag.APPLET) {
                return new CustomUnknownTagView(elem);
            }
            if (kind == HTML.Tag.SPAN) {
                return new InlineView(elem);
            }
            if (kind == HTML.Tag.CONTENT) {
                return new CustomInlineView(elem);
            }
            if (kind == HTML.Tag.COMMENT) {
                return new CustomUnknownTagView(elem);
            }
            if (kind instanceof HTML.UnknownTag) {
                Object tagType = CustomXMLTagsGrammarSpecification.getGrammarSpecification().get(kind.toString());
                if (tagType != null) {
                    if (((Boolean)tagType).booleanValue()) {
                        return new CustomEmptyXMLTagView(elem);
                    }
                    String tagName = kind.toString();
                    Hashtable renderingMappingTable = CustomXMLTagsGrammarSpecification.getRenderingModesSpecification();
                    String renderingMode = (String)renderingMappingTable.get(tagName);
                    if (CustomXMLTagsGrammarSpecification.isTreatAllBlockTagsAsBlocks()) {
                        return new CustomBlockXMLTagView(elem, 1);
                    }
                    if (renderingMode == null) {
                        return new CustomBlockInlineXMLTagView(elem, 1);
                    }
                    if (renderingMode.equals("BLOCK_TAG")) {
                        return new CustomBlockXMLTagView(elem, 1);
                    }
                    if (renderingMode.equals("INLINE_TAG")) {
                        return new CustomBlockXMLTagView(elem, 1);
                    }
                    return new CustomBlockXMLTagView(elem, 1);
                }
                return new CustomUnknownTagView(elem);
            }
            if (kind == HTML.Tag.INPUT || kind == HTML.Tag.SELECT || kind == HTML.Tag.TEXTAREA) {
                return new CustomFormInputView(elem);
            }
        }
        try {
            return super.create(elem);
        }
        catch (Throwable thr) {
            return new EmptyView(elem);
        }
    }
}

