/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.FormView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.CSSLayoutViews;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.adapters.CustomTagAdapter;
import sferyx.administration.editors.adapters.GenericTagAdapter;

public class CustomFormInputView
extends FormView
implements CSSLayoutViews {
    boolean margin_right_em = false;
    boolean margin_left_em = false;
    boolean customComponent = false;
    Component c;

    public boolean isAbsolutePositioning() {
        if (this.getElement().getAttributes().getAttribute("position") != null && this.getElement().getAttributes().isDefined("position") && this.getElement().getAttributes().getAttribute("position").equals("absolute")) {
            return true;
        }
        return this.getAttributes().getAttribute("position") != null && this.getAttributes().getAttribute("position").equals("absolute");
    }

    public boolean isRelativePositioning() {
        if (this.getElement().getAttributes().getAttribute("position") != null && this.getElement().getAttributes().isDefined("position") && this.getElement().getAttributes().getAttribute("position").equals("relative")) {
            return true;
        }
        return this.getAttributes().getAttribute("position") != null && this.getAttributes().getAttribute("position").equals("relative");
    }

    public int getAbsoluteX() {
        int absoluteX = SferyxUtilities.getAbsoluteX(this);
        return absoluteX;
    }

    public int getAbsoluteY() {
        int absoluteY = SferyxUtilities.getAbsoluteY(this);
        return absoluteY;
    }

    public int getLeftMargin() {
        return SferyxUtilities.getLeftMargin(this);
    }

    public int getRightMargin() {
        return SferyxUtilities.getRightMargin(this);
    }

    public int getBottomMargin() {
        return SferyxUtilities.getBottomMargin(this);
    }

    public int getTopMargin() {
        return SferyxUtilities.getTopMargin(this);
    }

    public CustomFormInputView(Element elem) {
        super(elem);
    }

    protected void submitData(String data) {
        try {
            super.submitData(data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void paint(Graphics g, Shape a) {
        if (this.getParent() != null && SferyxUtilities.isViewNotVisible(this.getParent(), ((HTMLDocument)this.getElement().getDocument()).getStyleSheet()) || SferyxUtilities.isViewNotVisible(this, ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            Container comp = this.c.getParent();
            if (comp != null) {
                ((JComponent)comp).setPreferredSize(new Dimension(0, 0));
            } else {
                ((JComponent)this.c).setPreferredSize(new Dimension(0, 0));
            }
            return;
        }
        super.paint(g, a);
    }

    public void paint_(Graphics g, Shape a) {
        Container comp = this.c.getParent();
        if (comp != null) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            comp.setBounds(alloc.x, alloc.y, alloc.width, alloc.height);
        }
    }

    public float getMaximumSpan(int axis) {
        if (this.getParent() != null && SferyxUtilities.isViewNotVisible(this.getParent(), ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return 0.0f;
        }
        if (SferyxUtilities.isViewNotVisible(this, ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return 0.0f;
        }
        AttributeSet attr = this.getElement().getAttributes();
        String type = (String)attr.getAttribute(HTML.Attribute.TYPE);
        if (type != null && (type.toLowerCase().equals("button") || type.toLowerCase().equals("submit") || type.toLowerCase().equals("password"))) {
            super.getMaximumSpan(axis);
            return this.getPreferredSpan(axis);
        }
        if (this.customComponent) {
            super.getMaximumSpan(axis);
            return this.getPreferredSpan(axis);
        }
        return super.getMaximumSpan(axis);
    }

    public float getMinimumSpan(int axis) {
        if (this.getParent() != null && SferyxUtilities.isViewNotVisible(this.getParent(), ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return 0.0f;
        }
        if (SferyxUtilities.isViewNotVisible(this, ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return 0.0f;
        }
        if (this.customComponent && this.customComponent && this.c != null && axis == 0) {
            return this.c.getPreferredSize().width;
        }
        return super.getMinimumSpan(axis);
    }

    public float getPreferredSpan(int axis) {
        if (this.getParent() != null && SferyxUtilities.isViewNotVisible(this.getParent(), ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return 0.0f;
        }
        if (SferyxUtilities.isViewNotVisible(this, ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return 0.0f;
        }
        if (this.customComponent && this.c != null && axis == 0) {
            return this.c.getPreferredSize().width;
        }
        return super.getPreferredSpan(axis);
    }

    protected Component createComponent() {
        if (this.getParent() != null && SferyxUtilities.isViewNotVisible(this.getParent(), ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return null;
        }
        if (SferyxUtilities.isViewNotVisible(this, ((HTMLDocument)this.getElement().getDocument()).getStyleSheet())) {
            return null;
        }
        AttributeSet attr = this.getElement().getAttributes();
        String type = (String)attr.getAttribute(HTML.Attribute.TYPE);
        Object model = attr.getAttribute(StyleConstants.ModelAttribute);
        if (type != null && type.toLowerCase().equals("button")) {
            String value = (String)attr.getAttribute(HTML.Attribute.VALUE);
            if (value == null) {
                value = "";
            }
            JButton button = new JButton(value);
            if (model != null) {
                button.setModel((ButtonModel)model);
                button.setMaximumSize(button.getPreferredSize());
            }
            this.c = button;
            this.setPropertiesFromCSS(button);
            return this.c;
        }
        Component component = super.createComponent();
        Element elem = this.getElement();
        String classAttrib = (String)elem.getAttributes().getAttribute(HTML.Attribute.CLASS);
        String valueAttrib = (String)elem.getAttributes().getAttribute(HTML.Attribute.VALUE);
        String adapterType = (String)elem.getAttributes().getAttribute("adapter_type");
        if (classAttrib != null && classAttrib.equals("custom_tag") && adapterType != null && adapterType.equals("mathml")) {
            MutableAttributeSet attribs;
            EditorHTMLDocument htdoc;
            GenericTagAdapter adapter;
            block14: {
                this.customComponent = true;
                Component original_com = component;
                adapter = null;
                htdoc = (EditorHTMLDocument)elem.getDocument();
                attribs = (MutableAttributeSet)elem.getAttributes();
                try {
                    component = new JPanel();
                    ((JComponent)component).setAlignmentY(0.6f);
                    ((JPanel)component).setOpaque(false);
                    ((JPanel)component).setLayout(new FlowLayout(1, 0, 0));
                    if (attribs.getAttribute("custom_tag_adapter") == null) {
                        adapter = new CustomTagAdapter();
                        adapter.setCustomTagString((String)HTMLEditor.statementsDecoding.get((String)attribs.getAttribute(HTML.Attribute.VALUE)));
                        adapter.setElement(elem);
                        if (this.getContainer() != null && this.getContainer() instanceof JEditorPane && !((JEditorPane)this.getContainer()).isEditable()) {
                            adapter.setEnabled(false);
                        }
                        adapter.setVisualRepresentationComponent(component);
                    } else {
                        adapter = (CustomTagAdapter)attribs.getAttribute("custom_tag_adapter");
                        adapter.setReusedVisualRepresentationComponent(component);
                    }
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                    if (original_com == null) break block14;
                    ((JButton)original_com).setHorizontalTextPosition(0);
                    ((JButton)original_com).setVerticalTextPosition(3);
                    ((JButton)original_com).setMargin(new Insets(0, 0, 0, 0));
                    ((JButton)original_com).setBorderPainted(false);
                    ((JButton)original_com).setContentAreaFilled(false);
                    ((JButton)original_com).setBorder(null);
                    adapter = new GenericTagAdapter();
                    adapter.setCustomTagString((String)HTMLEditor.statementsDecoding.get((String)attribs.getAttribute(HTML.Attribute.VALUE)));
                    adapter.setElement(elem);
                    component = original_com;
                    adapter.setVisualRepresentationComponent(component);
                    ((JButton)component).setText("Unable to load Sferyx EquationEditor");
                }
            }
            if (adapter != null) {
                try {
                    htdoc.unlock();
                    htdoc.lock();
                    attribs.addAttribute("custom_tag_adapter", adapter);
                    htdoc.unlock();
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                }
            }
        }
        this.setPropertiesFromCSS(component);
        this.c = component;
        return component;
    }

    void setPropertiesFromCSS(Component component) {
        try {
            Element elem = this.getElement();
            StyleSheet ss = ((EditorHTMLDocument)elem.getDocument()).getStyleSheet();
            SimpleAttributeSet sas = new SimpleAttributeSet();
            String selector = SferyxUtilities.getSelectorStringForElement(this.getElement());
            Style id_attribs = ss.getRule(selector);
            if (id_attribs != null && id_attribs.getAttributeCount() < 0) {
                sas.addAttributes(id_attribs);
            }
            if (sas != null && !sas.isEmpty()) {
                component.setFont(((EditorHTMLDocument)elem.getDocument()).getStyleSheet().getFont(sas));
                if (((EditorHTMLDocument)elem.getDocument()).getStyleSheet().getForeground(sas) != null) {
                    component.setForeground(((EditorHTMLDocument)elem.getDocument()).getStyleSheet().getForeground(sas));
                }
                if (((EditorHTMLDocument)elem.getDocument()).getStyleSheet().getBackground(sas) != null) {
                    component.setBackground(((EditorHTMLDocument)elem.getDocument()).getStyleSheet().getBackground(sas));
                }
            }
            float width = SferyxUtilities.getStyleSheetCSSWidthForElement(ss, sas);
            float height = SferyxUtilities.getStyleSheetCSSHeightForElement(ss, sas);
            if (width > 0.0f) {
                ((JComponent)component).setPreferredSize(new Dimension((int)width, component.getPreferredSize().height));
            }
            if (height > 0.0f) {
                ((JComponent)component).setPreferredSize(new Dimension(component.getPreferredSize().width, (int)height));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isHiddenField() {
        return this.getElement().getAttributes().getAttribute(HTML.Attribute.TYPE) != null && this.getElement().getAttributes().getAttribute(HTML.Attribute.TYPE).toString().equalsIgnoreCase("hidden");
    }

    public Image getPrintableImage() {
        if (this.c == null) {
            return null;
        }
        boolean imgMode = true;
        int imgWidth = this.c.getSize().width;
        int imgHeight = this.c.getSize().height;
        Image img = this.c.createImage(imgWidth, imgHeight);
        Graphics imgGraphics = img.getGraphics();
        this.c.paintAll(imgGraphics);
        return img;
    }
}

