/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.CustomHighlighter;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.extensions.ElementEditabilityEvaluator;

public class CustomEditorPane
extends JEditorPane {
    static Font font = new Font("Serif", 0, 12);
    boolean dontPaintInvisibleCells = false;
    boolean wrapLinesAlways;
    boolean editable = true;
    boolean disableFocusRequests = false;
    double scale = 1.0;
    ElementEditabilityEvaluator elementEvaluator = null;
    static /* synthetic */ Class class$sferyx$administration$editors$CustomHTMLEditorKit;

    public CustomEditorPane() {
        this.setFont(font);
    }

    public void setDontPaintInvisibleCells(boolean paint) {
        this.dontPaintInvisibleCells = paint;
    }

    public boolean isDontPaintInvisibleCells() {
        return this.dontPaintInvisibleCells;
    }

    public void setWrapParagraphLinesAlwaysOnEditorSize(boolean wrapAlways) {
        this.wrapLinesAlways = wrapAlways;
    }

    public boolean isWrapParagraphLinesAlwaysOnEditorSize() {
        return this.wrapLinesAlways;
    }

    public void setDisableFocusRequests(boolean disable) {
        this.disableFocusRequests = disable;
    }

    public void requestFocus() {
        if (this.disableFocusRequests) {
            return;
        }
        super.requestFocus();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.scale > 1.0) {
            d.width = Math.round((float)this.scale * (float)d.width);
            d.height = Math.round((float)this.scale * (float)d.height);
        }
        return d;
    }

    public void scrollRectToVisible(Rectangle aRect) {
        if (this.scale > 1.0) {
            aRect.x = (int)((double)aRect.x * this.scale);
            aRect.y = (int)((double)aRect.y * this.scale);
            aRect.width = (int)((double)aRect.width * this.scale);
            aRect.height = (int)((double)aRect.height * this.scale);
            this.getParent().doLayout();
            super.scrollRectToVisible(aRect);
            return;
        }
        super.scrollRectToVisible(aRect);
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.scale > 1.0) {
            int minSize = (int)((double)this.getUI().getMinimumSize((JComponent)this).width * this.scale);
            int prefSize = (int)((double)this.getUI().getPreferredSize((JComponent)this).width * this.scale);
            int parentSize = this.getParent().getSize().width;
            if (minSize < prefSize && minSize < parentSize) {
                return true;
            }
            if (minSize > parentSize && minSize == prefSize) {
                return false;
            }
        }
        return super.getScrollableTracksViewportWidth();
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.scale > 1.0 && (double)this.getUI().getPreferredSize((JComponent)this).height * this.scale > (double)this.getVisibleRect().height) {
            return false;
        }
        return super.getScrollableTracksViewportHeight();
    }

    public void processMouseEvent(MouseEvent e) {
        if (this.scale > 1.0) {
            e.translatePoint(-((int)((double)e.getX() - 1.0 / this.scale * (double)e.getX())), -((int)((double)e.getY() - 1.0 / this.scale * (double)e.getY())));
        }
        try {
            super.processMouseEvent(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (this.scale > 1.0) {
            e.translatePoint(-((int)((double)e.getX() - 1.0 / this.scale * (double)e.getX())), -((int)((double)e.getY() - 1.0 / this.scale * (double)e.getY())));
        }
        super.processMouseMotionEvent(e);
    }

    public void paint(Graphics g) {
        if (this.scale > 1.0) {
            this.getParent().doLayout();
            ((Graphics2D)g).scale(this.scale, this.scale);
        }
        super.paint(g);
        if (this.scale > 1.0) {
            ((Graphics2D)g).scale(1.0 / this.scale, 1.0 / this.scale);
        }
    }

    public void update(Graphics g) {
        super.update(g);
    }

    public void layout() {
        try {
            if (((EditorHTMLDocument)this.getDocument()).loading) {
                return;
            }
            super.layout();
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    public int getCaretPosition() {
        int caretPos = super.getCaretPosition();
        try {
            EditorHTMLDocument htdoc = (EditorHTMLDocument)this.getDocument();
            Element elem = htdoc.getBodyElement();
            if (elem != null && caretPos < elem.getStartOffset()) {
                return elem.getStartOffset();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return caretPos;
    }

    public void setSelectionStart(int pos) {
        try {
            EditorHTMLDocument htdoc = (EditorHTMLDocument)this.getDocument();
            Element elem = htdoc.getBodyElement();
            if (elem != null && pos < elem.getStartOffset()) {
                super.setSelectionStart(elem.getStartOffset());
                return;
            }
            super.setSelectionStart(pos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setTempSelectedTextColor(Color color) {
        super.setSelectedTextColor(color);
    }

    public void setSelectedTextColor(Color color) {
        super.setSelectedTextColor(color);
        if (this.getHighlighter() instanceof CustomHighlighter) {
            ((CustomHighlighter)this.getHighlighter()).originalColor = color;
        }
    }

    public void setSelectionEnd(int pos) {
        try {
            EditorHTMLDocument htdoc = (EditorHTMLDocument)this.getDocument();
            Element elem = htdoc.getBodyElement();
            if (elem != null && pos < elem.getStartOffset()) {
                super.setSelectionEnd(elem.getStartOffset());
                return;
            }
            super.setSelectionEnd(pos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void moveCaretPosition(int caretPos) {
        try {
            EditorHTMLDocument htdoc = (EditorHTMLDocument)this.getDocument();
            Element elem = htdoc.getBodyElement();
            if (elem != null && caretPos < elem.getStartOffset()) {
                super.moveCaretPosition(elem.getStartOffset());
                return;
            }
            if (elem != null && caretPos >= elem.getEndOffset()) {
                super.moveCaretPosition(elem.getEndOffset() - 1);
                return;
            }
            super.moveCaretPosition(caretPos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setComponentOrientation(ComponentOrientation orientation) {
        try {
            if (orientation == ComponentOrientation.LEFT_TO_RIGHT) {
                try {
                    StyleSheet defaultStyles = ((HTMLEditorKit)this.getEditorKit()).getStyleSheet();
                    InputStream is = (class$sferyx$administration$editors$CustomHTMLEditorKit == null ? (class$sferyx$administration$editors$CustomHTMLEditorKit = CustomEditorPane.class$("sferyx.administration.editors.CustomHTMLEditorKit")) : class$sferyx$administration$editors$CustomHTMLEditorKit).getResourceAsStream("/sferyx/administration/editors/icons/sferyx.css");
                    BufferedReader r = new BufferedReader(new InputStreamReader(is));
                    defaultStyles.loadRules(r, null);
                    is.close();
                }
                catch (Throwable thr) {}
            } else if (orientation == ComponentOrientation.RIGHT_TO_LEFT) {
                StyleSheet defaultStyles = ((HTMLEditorKit)this.getEditorKit()).getStyleSheet();
                InputStream is = (class$sferyx$administration$editors$CustomHTMLEditorKit == null ? (class$sferyx$administration$editors$CustomHTMLEditorKit = CustomEditorPane.class$("sferyx.administration.editors.CustomHTMLEditorKit")) : class$sferyx$administration$editors$CustomHTMLEditorKit).getResourceAsStream("/sferyx/administration/editors/icons/sferyx_rtl.css");
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                defaultStyles.loadRules(r, null);
                is.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.setComponentOrientation(orientation);
    }

    public void setText(String t) {
        super.setText(t);
    }

    public void setCaretPosition(int caretPos) {
        try {
            EditorHTMLDocument htdoc = (EditorHTMLDocument)this.getDocument();
            Element elem = htdoc.getBodyElement();
            if (elem != null && caretPos < elem.getStartOffset()) {
                super.setCaretPosition(elem.getStartOffset());
                return;
            }
            if (elem != null && caretPos >= elem.getEndOffset()) {
                super.setCaretPosition(elem.getEndOffset() - 1);
                return;
            }
            super.setCaretPosition(caretPos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setElementEditabilityEvaluator(ElementEditabilityEvaluator eee) {
        this.elementEvaluator = eee;
        if (this.getDocument() instanceof EditorHTMLDocument && this.elementEvaluator != null) {
            ((EditorHTMLDocument)this.getDocument()).setElementEditabilityEvaluator(this.elementEvaluator);
        }
    }

    public ElementEditabilityEvaluator getElementEditabilityEvaluator() {
        return this.elementEvaluator;
    }

    public void setDocument(Document document) {
        if (document instanceof EditorHTMLDocument && this.elementEvaluator != null) {
            ((EditorHTMLDocument)document).setElementEditabilityEvaluator(this.elementEvaluator);
        }
        super.setDocument(document);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

