/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import sferyx.administration.editors.EditorHTMLDocument;

class CustomCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    JTextComponent component;
    boolean async = false;
    boolean visible;
    int dot;
    int mark;
    Object selectionTag;
    boolean selectionVisible;
    Timer flasher;
    Point magicCaretPosition;
    transient Position.Bias dotBias;
    transient Position.Bias markBias;
    boolean dotLTR;
    boolean markLTR;
    transient UpdateHandler updateHandler = new UpdateHandler();
    private transient int[] flagXPoints = new int[3];
    private transient int[] flagYPoints = new int[3];
    private transient FocusListener focusListener;
    private transient NavigationFilter.FilterBypass filterBypass;
    private transient ClipboardOwner clipboardOwner;
    private boolean ownsSelection;
    private boolean forceCaretPositionChange;
    private transient boolean shouldHandleRelease;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    CustomCaret() {
        this.setBlinkRate(500);
    }

    boolean getAsynchronousMovement() {
        return this.async;
    }

    void setAsynchronousMovement(boolean m) {
        this.async = m;
    }

    protected final JTextComponent getComponent() {
        return this.component;
    }

    protected final synchronized void repaint() {
        if (this.component != null) {
            this.component.repaint(this.x, this.y, this.width, this.height);
        }
    }

    protected synchronized void damage(Rectangle r) {
        if (r != null) {
            this.x = r.x - 4;
            this.y = r.y;
            this.width = 10;
            this.height = r.height;
            this.repaint();
        }
    }

    protected void adjustVisibility(Rectangle nloc) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.component != null) {
                this.component.scrollRectToVisible(nloc);
            }
        } else {
            SwingUtilities.invokeLater(new SafeScroller(nloc));
        }
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    protected void positionCaret(MouseEvent e) {
        Point pt = new Point(e.getX(), e.getY());
        Position.Bias[] biasRet = new Position.Bias[1];
        int pos = this.component.getUI().viewToModel(this.component, pt, biasRet);
        if (biasRet[0] == null) {
            biasRet[0] = Position.Bias.Forward;
        }
        if (pos >= 0) {
            this.setDot(pos, biasRet[0]);
        }
    }

    protected void moveCaret(MouseEvent e) {
        Point pt = new Point(e.getX(), e.getY());
        Position.Bias[] biasRet = new Position.Bias[1];
        int pos = this.component.getUI().viewToModel(this.component, pt, biasRet);
        if (biasRet[0] == null) {
            biasRet[0] = Position.Bias.Forward;
        }
        if (pos >= 0) {
            this.moveDot(pos, biasRet[0]);
        }
    }

    public void focusGained(FocusEvent e) {
        if (this.component.isEnabled()) {
            if (this.component.isEditable()) {
                this.setVisible(true);
            }
            this.setSelectionVisible(true);
        }
    }

    public void focusLost(FocusEvent e) {
        this.setVisible(false);
    }

    Action getDefaultAction(String actionName) {
        Action[] actions = ((JEditorPane)this.component).getEditorKit().getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (!actions[i].getValue("Name").equals(actionName)) continue;
            return actions[i];
        }
        return null;
    }

    public void mouseClicked(MouseEvent e) {
        if (!e.isConsumed()) {
            JTextComponent c;
            int nclicks = e.getClickCount();
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getClickCount() == 2) {
                    Action a = this.getDefaultAction("select-word");
                    a.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, e.getWhen(), e.getModifiers()));
                } else if (e.getClickCount() == 3) {
                    Action a = this.getDefaultAction("select-line");
                    a.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, e.getWhen(), e.getModifiers()));
                }
            } else if (SwingUtilities.isMiddleMouseButton(e) && nclicks == 1 && this.component.isEditable() && this.component.isEnabled() && (c = (JTextComponent)e.getSource()) != null) {
                try {
                    Toolkit tk = c.getToolkit();
                    Clipboard buffer = tk.getSystemSelection();
                    if (buffer != null) {
                        Transferable trans;
                        this.adjustCaret(e);
                        TransferHandler th = c.getTransferHandler();
                        if (th != null && (trans = buffer.getContents(null)) != null) {
                            th.importData(c, trans);
                        }
                        this.adjustFocus(true);
                    }
                }
                catch (HeadlessException he) {
                    // empty catch block
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.isConsumed()) {
                this.shouldHandleRelease = true;
            } else {
                this.shouldHandleRelease = false;
                this.adjustCaretAndFocus(e);
            }
        }
    }

    void adjustCaretAndFocus(MouseEvent e) {
        this.adjustCaret(e);
        this.adjustFocus(false);
    }

    private void adjustCaret(MouseEvent e) {
        if ((e.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(e);
        } else {
            this.positionCaret(e);
        }
    }

    private void adjustFocus(boolean inWindow) {
        if (this.component != null && this.component.isEnabled() && this.component.isRequestFocusEnabled()) {
            if (inWindow) {
                this.component.requestFocusInWindow();
            } else {
                this.component.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.shouldHandleRelease && SwingUtilities.isLeftMouseButton(e)) {
            this.adjustCaretAndFocus(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e)) {
            this.moveCaret(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void paint(Graphics g) {
        if (this.isVisible()) {
            try {
                Element bidi;
                TextUI mapper = this.component.getUI();
                Rectangle r = mapper.modelToView(this.component, this.dot, this.dotBias);
                if (r == null || r.width == 0 && r.height == 0) {
                    return;
                }
                if (this.width > 0 && this.height > 0 && !this._contains(r.x, r.y, r.width, r.height)) {
                    Rectangle clip = g.getClipBounds();
                    if (clip != null && !clip.contains(this)) {
                        this.repaint();
                    }
                    this.damage(r);
                }
                g.setColor(this.component.getCaretColor());
                g.drawRect(r.x, r.y, r.width, r.height - 1);
                Document doc = this.component.getDocument();
                if (doc instanceof AbstractDocument && (bidi = ((AbstractDocument)doc).getBidiRootElement()) != null && bidi.getElementCount() > 1) {
                    this.flagXPoints[0] = r.x;
                    this.flagYPoints[0] = r.y;
                    this.flagXPoints[1] = r.x;
                    this.flagYPoints[1] = r.y + 4;
                    this.flagYPoints[2] = r.y;
                    this.flagXPoints[2] = this.dotLTR ? r.x + 5 : r.x - 4;
                    g.fillPolygon(this.flagXPoints, this.flagYPoints, 3);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void install(JTextComponent c) {
        this.component = c;
        Document doc = c.getDocument();
        this.mark = 0;
        this.dot = 0;
        this.markLTR = true;
        this.dotLTR = true;
        this.dotBias = this.markBias = Position.Bias.Forward;
        if (doc != null) {
            doc.addDocumentListener(this.updateHandler);
        }
        c.addPropertyChangeListener(this.updateHandler);
        this.focusListener = new FocusHandler(this);
        c.addFocusListener(this.focusListener);
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        if (this.component.hasFocus()) {
            this.focusGained(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(JTextComponent c) {
        c.removeMouseListener(this);
        c.removeMouseMotionListener(this);
        if (this.focusListener != null) {
            c.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        c.removePropertyChangeListener(this.updateHandler);
        Document doc = c.getDocument();
        if (doc != null) {
            doc.removeDocumentListener(this.updateHandler);
        }
        CustomCaret customCaret = this;
        synchronized (customCaret) {
            this.component = null;
        }
        if (this.flasher != null) {
            this.flasher.stop();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CustomCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CustomCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CustomCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? CustomCaret.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void setSelectionVisible(boolean vis) {
        if (vis != this.selectionVisible) {
            this.selectionVisible = vis;
            if (this.selectionVisible) {
                Highlighter h = this.component.getHighlighter();
                if (this.dot != this.mark && h != null && this.selectionTag == null) {
                    int p0 = Math.min(this.dot, this.mark);
                    int p1 = Math.max(this.dot, this.mark);
                    Highlighter.HighlightPainter p = this.getSelectionPainter();
                    try {
                        this.selectionTag = h.addHighlight(p0, p1, p);
                    }
                    catch (BadLocationException bl) {
                        this.selectionTag = null;
                    }
                }
            } else if (this.selectionTag != null) {
                Highlighter h = this.component.getHighlighter();
                h.removeHighlight(this.selectionTag);
                this.selectionTag = null;
            }
        }
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean e) {
        if (this.component != null) {
            TextUI mapper = this.component.getUI();
            if (this.visible != e) {
                this.visible = e;
                try {
                    Rectangle loc = mapper.modelToView(this.component, this.dot, this.dotBias);
                    this.damage(loc);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (this.flasher != null) {
            if (this.visible) {
                this.flasher.start();
            } else {
                this.flasher.stop();
            }
        }
    }

    public void setBlinkRate(int rate) {
        if (rate != 0) {
            if (this.flasher == null) {
                this.flasher = new Timer(rate, this.updateHandler);
            }
            this.flasher.setDelay(rate);
        } else if (this.flasher != null) {
            this.flasher.stop();
            this.flasher.removeActionListener(this.updateHandler);
            this.flasher = null;
        }
    }

    public int getBlinkRate() {
        return this.flasher == null ? 0 : this.flasher.getDelay();
    }

    public int getDot() {
        return this.dot;
    }

    public int getMark() {
        return this.mark;
    }

    public void setDot(int dot) {
        this.setDot(dot, Position.Bias.Forward);
    }

    public void moveDot(int dot) {
        this.moveDot(dot, Position.Bias.Forward);
    }

    void moveDot(int dot, Position.Bias dotBias) {
        if (!this.component.isEnabled()) {
            this.setDot(dot, dotBias);
            return;
        }
        if (dot != this.dot) {
            NavigationFilter filter = this.component.getNavigationFilter();
            if (filter != null) {
                filter.moveDot(this.getFilterBypass(), dot, dotBias);
            } else {
                this.handleMoveDot(dot, dotBias);
            }
        }
    }

    void handleMoveDot(int dot, Position.Bias dotBias) {
        Highlighter h;
        this.changeCaretPosition(dot, dotBias);
        if (this.selectionVisible && (h = this.component.getHighlighter()) != null) {
            int p1;
            int p0 = Math.min(dot, this.mark);
            if (p0 == (p1 = Math.max(dot, this.mark))) {
                if (this.selectionTag != null) {
                    h.removeHighlight(this.selectionTag);
                    this.selectionTag = null;
                }
            } else {
                try {
                    if (this.selectionTag != null) {
                        h.changeHighlight(this.selectionTag, p0, p1);
                    } else {
                        Highlighter.HighlightPainter p = this.getSelectionPainter();
                        this.selectionTag = h.addHighlight(p0, p1, p);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    void setDot(int dot, Position.Bias dotBias) {
        NavigationFilter filter = this.component.getNavigationFilter();
        if (filter != null) {
            filter.setDot(this.getFilterBypass(), dot, dotBias);
        } else {
            this.handleSetDot(dot, dotBias);
        }
    }

    void handleSetDot(int dot, Position.Bias dotBias) {
        Document doc = this.component.getDocument();
        if (doc != null) {
            dot = Math.min(dot, doc.getLength());
        }
        if ((dot = Math.max(dot, 0)) == 0) {
            dotBias = Position.Bias.Forward;
        }
        this.mark = dot;
        if (this.dot != dot || this.dotBias != dotBias || this.selectionTag != null || this.forceCaretPositionChange) {
            this.changeCaretPosition(dot, dotBias);
        }
        this.markBias = this.dotBias;
        this.markLTR = this.dotLTR;
        Highlighter h = this.component.getHighlighter();
        if (h != null && this.selectionTag != null) {
            h.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    Position.Bias getDotBias() {
        return this.dotBias;
    }

    Position.Bias getMarkBias() {
        return this.markBias;
    }

    boolean isDotLeftToRight() {
        return this.dotLTR;
    }

    boolean isMarkLeftToRight() {
        return this.markLTR;
    }

    boolean isPositionLTR(int position, Position.Bias bias) {
        Document doc = this.component.getDocument();
        if (doc instanceof AbstractDocument) {
            if (bias == Position.Bias.Backward && --position < 0) {
                position = 0;
            }
            return ((EditorHTMLDocument)doc).isLeftToRightDoc(position, position);
        }
        return true;
    }

    Position.Bias guessBiasForOffset(int offset, Position.Bias lastBias, boolean lastLTR) {
        if (lastLTR != this.isPositionLTR(offset, lastBias)) {
            lastBias = Position.Bias.Backward;
        } else if (lastBias != Position.Bias.Backward && lastLTR != this.isPositionLTR(offset, Position.Bias.Backward)) {
            lastBias = Position.Bias.Backward;
        }
        if (lastBias == Position.Bias.Backward && offset > 0) {
            try {
                Segment s = new Segment();
                this.component.getDocument().getText(offset - 1, 1, s);
                if (s.count > 0 && s.array[s.offset] == '\n') {
                    lastBias = Position.Bias.Forward;
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
        return lastBias;
    }

    void changeCaretPosition(int dot, Position.Bias dotBias) {
        this.repaint();
        if (this.flasher != null && this.flasher.isRunning()) {
            this.visible = true;
            this.flasher.restart();
        }
        this.dot = dot;
        this.dotBias = dotBias;
        this.dotLTR = this.isPositionLTR(dot, dotBias);
        this.fireStateChanged();
        this.updateSystemSelection();
        this.setMagicCaretPosition(null);
        Runnable callRepaintNewCaret = new Runnable(){

            public void run() {
                if (CustomCaret.this.component != null) {
                    TextUI mapper = CustomCaret.this.component.getUI();
                    Document doc = CustomCaret.this.component.getDocument();
                    if (mapper != null && doc != null) {
                        Rectangle newLoc;
                        try {
                            newLoc = mapper.modelToView(CustomCaret.this.component, CustomCaret.this.dot, CustomCaret.this.dotBias);
                        }
                        catch (BadLocationException e) {
                            newLoc = null;
                        }
                        if (newLoc != null) {
                            CustomCaret.this.component.scrollRectToVisible(newLoc);
                            if (CustomCaret.this.getMagicCaretPosition() == null) {
                                CustomCaret.this.setMagicCaretPosition(new Point(newLoc.x, newLoc.y));
                            } else {
                                CustomCaret.this.getMagicCaretPosition().x = newLoc.x;
                                CustomCaret.this.getMagicCaretPosition().y = newLoc.y;
                            }
                        }
                        CustomCaret.this.damage(newLoc);
                    }
                }
            }
        };
        SwingUtilities.invokeLater(callRepaintNewCaret);
    }

    void repaintNewCaret() {
        if (this.component != null) {
            TextUI mapper = this.component.getUI();
            Document doc = this.component.getDocument();
            if (mapper != null && doc != null) {
                Rectangle newLoc;
                try {
                    newLoc = mapper.modelToView(this.component, this.dot, this.dotBias);
                }
                catch (BadLocationException e) {
                    newLoc = null;
                }
                if (newLoc != null) {
                    this.adjustVisibility(newLoc);
                    if (this.getMagicCaretPosition() == null) {
                        this.setMagicCaretPosition(new Point(newLoc.x, newLoc.y));
                    } else {
                        this.getMagicCaretPosition().x = newLoc.x;
                        this.getMagicCaretPosition().y = newLoc.y;
                    }
                }
                this.damage(newLoc);
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clip;
        if (this.dot != this.mark && this.component != null && (clip = this.getSystemSelection()) != null) {
            clip.setContents(new StringSelection(this.component.getSelectedText()), this.getClipboardOwner());
            this.ownsSelection = true;
        }
    }

    private Clipboard getSystemSelection() {
        try {
            return this.component.getToolkit().getSystemSelection();
        }
        catch (HeadlessException he) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private ClipboardOwner getClipboardOwner() {
        if (this.clipboardOwner == null) {
            this.clipboardOwner = new ClipboardHandler();
        }
        return this.clipboardOwner;
    }

    private void ensureValidPosition() {
        int length = this.component.getDocument().getLength();
        if (this.dot > length || this.mark > length) {
            this.handleSetDot(length, Position.Bias.Forward);
        }
    }

    public void setMagicCaretPosition(Point p) {
        this.magicCaretPosition = p;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        String s = "Dot=(" + this.dot + ", " + this.dotBias + ")";
        s = s + " Mark=(" + this.mark + ", " + this.markBias + ")";
        return s;
    }

    private NavigationFilter.FilterBypass getFilterBypass() {
        if (this.filterBypass == null) {
            this.filterBypass = new DefaultFilterBypass();
        }
        return this.filterBypass;
    }

    private boolean _contains(int X, int Y, int W, int H) {
        int w = this.width;
        int h = this.height;
        if ((w | h | W | H) < 0) {
            return false;
        }
        int x = this.x;
        int y = this.y;
        if (X < x || Y < y) {
            return false;
        }
        if (W > 0) {
            w += x;
            if ((W += X) <= X ? w >= x || W > w : w >= x && W > w) {
                return false;
            }
        } else if (x + w < X) {
            return false;
        }
        if (H > 0) {
            h += y;
            if ((H += Y) <= Y ? h >= y || H > h : h >= y && H > h) {
                return false;
            }
        } else if (y + h < Y) {
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.updateHandler = new UpdateHandler();
        this.dotBias = !s.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
        this.markBias = !s.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeBoolean(this.dotBias == Position.Bias.Backward);
        s.writeBoolean(this.markBias == Position.Bias.Backward);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DefaultFilterBypass
    extends NavigationFilter.FilterBypass {
        private DefaultFilterBypass() {
        }

        public Caret getCaret() {
            return CustomCaret.this;
        }

        public void setDot(int dot, Position.Bias bias) {
            CustomCaret.this.handleSetDot(dot, bias);
        }

        public void moveDot(int dot, Position.Bias bias) {
            CustomCaret.this.handleMoveDot(dot, bias);
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener {
        UpdateHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!(CustomCaret.this.visible || CustomCaret.this.width != 0 && CustomCaret.this.height != 0 || CustomCaret.this.component == null)) {
                TextUI mapper = CustomCaret.this.component.getUI();
                try {
                    Rectangle r = mapper.modelToView(CustomCaret.this.component, CustomCaret.this.dot, CustomCaret.this.dotBias);
                    if (r != null && r.width != 0 && r.height != 0) {
                        CustomCaret.this.setVisible(true);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            CustomCaret.this.visible = !CustomCaret.this.visible;
            CustomCaret.this.repaint();
        }

        public void insertUpdate(DocumentEvent e) {
            if (CustomCaret.this.async || SwingUtilities.isEventDispatchThread()) {
                int newMark;
                boolean adjust = false;
                int offset = e.getOffset();
                int length = e.getLength();
                int newDot = CustomCaret.this.dot;
                short changed = 0;
                if (newDot >= offset) {
                    newDot += length;
                    changed = (short)(changed | 1);
                }
                if ((newMark = CustomCaret.this.mark) >= offset) {
                    newMark += length;
                    changed = (short)(changed | 2);
                }
                if (changed != 0) {
                    Position.Bias dotBias = CustomCaret.this.dotBias;
                    if (CustomCaret.this.dot == offset) {
                        boolean isNewline;
                        Document doc = CustomCaret.this.component.getDocument();
                        try {
                            Segment s = new Segment();
                            doc.getText(newDot - 1, 1, s);
                            isNewline = s.count > 0 && s.array[s.offset] == '\n';
                        }
                        catch (BadLocationException ble) {
                            isNewline = false;
                        }
                        dotBias = isNewline ? Position.Bias.Forward : Position.Bias.Backward;
                    }
                    if (newMark == newDot) {
                        CustomCaret.this.setDot(newDot, dotBias);
                        CustomCaret.this.ensureValidPosition();
                    } else {
                        CustomCaret.this.setDot(newMark, CustomCaret.this.markBias);
                        if (CustomCaret.this.getDot() == newMark) {
                            CustomCaret.this.moveDot(newDot, dotBias);
                        }
                        CustomCaret.this.ensureValidPosition();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(DocumentEvent e) {
            if (CustomCaret.this.async || SwingUtilities.isEventDispatchThread()) {
                boolean adjust = false;
                int offs0 = e.getOffset();
                int offs1 = offs0 + e.getLength();
                int newDot = CustomCaret.this.dot;
                boolean adjustDotBias = false;
                if (newDot >= offs1) {
                    if ((newDot -= offs1 - offs0) == offs1) {
                        adjustDotBias = true;
                    }
                } else if (newDot >= offs0) {
                    newDot = offs0;
                    adjustDotBias = true;
                }
                int newMark = CustomCaret.this.mark;
                boolean adjustMarkBias = false;
                if (newMark >= offs1) {
                    if ((newMark -= offs1 - offs0) == offs1) {
                        adjustMarkBias = true;
                    }
                } else if (newMark >= offs0) {
                    newMark = offs0;
                    adjustMarkBias = true;
                }
                if (newMark == newDot) {
                    CustomCaret.this.forceCaretPositionChange = true;
                    try {
                        CustomCaret.this.setDot(newDot, CustomCaret.this.guessBiasForOffset(newDot, CustomCaret.this.dotBias, CustomCaret.this.dotLTR));
                    }
                    finally {
                        CustomCaret.this.forceCaretPositionChange = false;
                    }
                    CustomCaret.this.ensureValidPosition();
                } else {
                    Position.Bias dotBias = CustomCaret.this.dotBias;
                    Position.Bias markBias = CustomCaret.this.markBias;
                    if (adjustDotBias) {
                        dotBias = CustomCaret.this.guessBiasForOffset(newDot, dotBias, CustomCaret.this.dotLTR);
                    }
                    if (adjustMarkBias) {
                        markBias = CustomCaret.this.guessBiasForOffset(CustomCaret.this.mark, markBias, CustomCaret.this.markLTR);
                    }
                    CustomCaret.this.setDot(newMark, markBias);
                    if (CustomCaret.this.getDot() == newMark) {
                        CustomCaret.this.moveDot(newDot, dotBias);
                    }
                    CustomCaret.this.ensureValidPosition();
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            if (oldValue instanceof Document || newValue instanceof Document) {
                CustomCaret.this.setDot(0);
                if (oldValue != null) {
                    ((Document)oldValue).removeDocumentListener(this);
                }
                if (newValue != null) {
                    ((Document)newValue).addDocumentListener(this);
                }
            }
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private transient FocusListener fl;

        FocusHandler(FocusListener fl) {
            this.fl = fl;
        }

        public void focusGained(FocusEvent e) {
            this.fl.focusGained(e);
        }

        public void focusLost(FocusEvent e) {
            this.fl.focusLost(e);
        }
    }

    private class ClipboardHandler
    implements ClipboardOwner {
        private ClipboardHandler() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            if (CustomCaret.this.ownsSelection) {
                CustomCaret.this.ownsSelection = false;
                if (CustomCaret.this.component != null && !CustomCaret.this.component.hasFocus()) {
                    CustomCaret.this.setSelectionVisible(false);
                }
            }
        }
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;

        SafeScroller(Rectangle r) {
            this.r = r;
        }

        public void run() {
            if (CustomCaret.this.component != null) {
                CustomCaret.this.component.scrollRectToVisible(this.r);
            }
        }
    }
}

