/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.HiddenValue;
import sferyx.administration.editors.SferyxUtilities;

public class CustomBoxPainter {
    String newPosition = "";
    String newRepeat = "";
    String newURL = "";
    String newColor = "";
    String newImage = "";
    String newAttachment = "";
    View view;
    AttributeSet attr;
    StyleSheet ss;
    public Color bg;
    ImageIcon image;
    BufferedImage buffImg;
    Object cachedBackgroundValue;
    static Hashtable imageCache = new Hashtable();

    public CustomBoxPainter(AttributeSet a, StyleSheet ss, View view) {
        this.view = view;
        this.ss = ss;
        this.parseBackground(a, ss);
        this.parseBackgroundColor(a, ss);
        if (!this.newColor.equals("")) {
            if (this.newColor.startsWith("rgba(")) {
                String colors = this.newColor.substring(5, this.newColor.length() - 1);
                if (!colors.trim().equals("") && !colors.trim().equals(",,,")) {
                    StringTokenizer st = new StringTokenizer(colors, ",");
                    float[] rgb = new float[4];
                    int i = 0;
                    if (st.countTokens() == 4) {
                        while (st.hasMoreTokens()) {
                            try {
                                rgb[i] = Float.parseFloat(st.nextToken().trim());
                                if (rgb[i] > 1.0f) {
                                    rgb[i] = rgb[i] / 255.0f;
                                }
                            }
                            catch (Throwable thr) {
                                thr.printStackTrace();
                            }
                            ++i;
                        }
                        try {
                            this.bg = new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
                        }
                        catch (Throwable thr) {
                            thr.printStackTrace();
                        }
                    }
                }
            } else if (this.newColor.startsWith("rgb(")) {
                String colors = this.newColor.substring(4, this.newColor.length() - 1);
                if (!colors.trim().equals("") && !colors.trim().equals(",,,")) {
                    StringTokenizer st = new StringTokenizer(colors, ",");
                    float[] rgb = new float[3];
                    int i = 0;
                    if (st.countTokens() == 3) {
                        while (st.hasMoreTokens()) {
                            try {
                                rgb[i] = Float.parseFloat(st.nextToken().trim());
                                if (rgb[i] > 1.0f) {
                                    rgb[i] = rgb[i] / 255.0f;
                                }
                            }
                            catch (Throwable thr) {
                                thr.printStackTrace();
                            }
                            ++i;
                        }
                        try {
                            this.bg = new Color(rgb[0], rgb[1], rgb[2]);
                        }
                        catch (Throwable thr) {
                            thr.printStackTrace();
                        }
                    }
                }
            } else {
                this.bg = this.newColor.startsWith("transparent") ? null : ss.stringToColor(this.newColor);
            }
        } else {
            this.bg = ss.getBackground(a);
        }
        this.getBackgroundImage(a);
        this.attr = a;
    }

    void parseBackground(AttributeSet attr, StyleSheet ss) {
        this.newPosition = "";
        this.newRepeat = "";
        this.newURL = "";
        this.newColor = "";
        this.newImage = "";
        this.newAttachment = "";
        Object background = attr.getAttribute(HiddenValue.BACKGROUND);
        if (background == null) {
            background = attr.getAttribute(CSS.Attribute.BACKGROUND);
        }
        if (background != null && background.toString() != null) {
            String value = background.toString();
            if ((value = SferyxUtilities.replaceAll(value, "!important", "")).indexOf(",") != -1) {
                int rgbIndex = value.indexOf("rgb(");
                if (rgbIndex == -1) {
                    rgbIndex = value.indexOf("rgba(");
                }
                if (rgbIndex != -1) {
                    int rgbEnd = value.indexOf(")", rgbIndex);
                    int commaIndex = value.indexOf(",", rgbEnd);
                    if (commaIndex != -1) {
                        value = value.substring(0, commaIndex);
                    }
                } else {
                    int commaIndex = value.indexOf(",");
                    if (commaIndex != -1) {
                        value = value.substring(0, commaIndex);
                    }
                }
            }
            if (value.indexOf("rgb(") != -1) {
                this.newColor = value.substring(value.indexOf("rgb("), value.indexOf(")", value.indexOf("rgb(")) + 1);
                value = SferyxUtilities.replaceAll(value, this.newColor, "");
            }
            if (value.indexOf("rgba(") != -1) {
                this.newColor = value.substring(value.indexOf("rgba("), value.indexOf(")", value.indexOf("rgba(")) + 1);
                value = SferyxUtilities.replaceAll(value, this.newColor, "");
            }
            if (value.indexOf("url(") != -1) {
                this.newImage = value.substring(value.indexOf("url("), value.indexOf(")", value.indexOf("url(")) + 1);
                value = SferyxUtilities.replaceAll(value, this.newImage, "");
            }
            StringTokenizer st = new StringTokenizer(value, " ");
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (!nextToken.startsWith("rgb(") && !nextToken.startsWith("rgba(") && nextToken.indexOf(",") != -1) {
                    nextToken = nextToken.substring(0, nextToken.indexOf(","));
                }
                if (nextToken.toLowerCase().startsWith("url(") || nextToken.toLowerCase().startsWith("none")) continue;
                if (nextToken.toLowerCase().startsWith("#") || ss.stringToColor(nextToken) != null && nextToken.length() >= 3) {
                    this.newColor = nextToken;
                    continue;
                }
                if (nextToken.toLowerCase().equals("repeat") || nextToken.toLowerCase().equals("repeat-x") || nextToken.toLowerCase().equals("repeat-y") || nextToken.toLowerCase().equals("no-repeat")) {
                    this.newRepeat = nextToken.toLowerCase();
                    continue;
                }
                if (nextToken.toLowerCase().equals("top") || nextToken.toLowerCase().equals("center") || nextToken.toLowerCase().equals("right") || nextToken.toLowerCase().equals("left") || nextToken.toLowerCase().equals("bottom") || nextToken.toLowerCase().equals("left") || nextToken.toLowerCase().endsWith("%") || nextToken.toLowerCase().endsWith("px") || nextToken.toLowerCase().endsWith("em") || Character.isDigit(nextToken.charAt(0))) {
                    this.newPosition = this.newPosition + " " + nextToken;
                    continue;
                }
                if (!nextToken.toLowerCase().equals("scroll") && !nextToken.toLowerCase().equals("fixed")) continue;
                this.newAttachment = nextToken.toLowerCase();
            }
            this.newPosition = this.newPosition.trim();
        }
    }

    void parseBackgroundColor(AttributeSet attr, StyleSheet ss) {
        Object background = attr.getAttribute(CSS.Attribute.BACKGROUND_COLOR);
        if (background != null && background.toString() != null) {
            this.newColor = background.toString();
        }
    }

    public void paint(Graphics g, float x, float y, float w, float h, View v) {
        block89: {
            if (this.cachedBackgroundValue != this.getBackgroundValue()) {
                this.buffImg = null;
                this.image = null;
                this.getBackgroundImage(v.getAttributes());
            }
            try {
                Rectangle clip;
                block90: {
                    if (this.bg != null) {
                        g.setColor(this.bg);
                        g.fillRect((int)x, (int)y, (int)w, (int)h);
                    }
                    if (this.image == null) break block89;
                    clip = g.getClipRect();
                    if (clip != null) {
                        if (this.view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY) {
                            if (this.view.getContainer() != null) {
                                int height = ((JScrollPane)this.view.getContainer().getParent().getParent()).getHeight();
                                if ((float)height > h) {
                                    h = height;
                                }
                                g.clipRect((int)x, (int)y, (int)w, (int)h);
                            }
                        } else {
                            g.clipRect((int)x, (int)y, (int)w, (int)h);
                        }
                    }
                    try {
                        StringTokenizer st;
                        int tokNumber;
                        Object background;
                        Object repeat = this.attr.getAttribute(CSS.Attribute.BACKGROUND_REPEAT);
                        Object position = this.attr.getAttribute(CSS.Attribute.BACKGROUND_POSITION);
                        if ((position == null || position.toString() == null) && this.attr.getAttribute("background-position") != null) {
                            position = this.attr.getAttribute("background-position");
                        }
                        if ((background = this.attr.getAttribute(HiddenValue.BACKGROUND)) == null) {
                            background = this.attr.getAttribute(CSS.Attribute.BACKGROUND);
                        }
                        this.parseBackground(this.attr, ((EditorHTMLDocument)this.view.getElement().getDocument()).getStyleSheet());
                        if (!this.newRepeat.equals("")) {
                            repeat = this.newRepeat;
                        }
                        if (!this.newPosition.equals("")) {
                            position = this.newPosition;
                        }
                        if (position != null) {
                            if ((position = position.toString()) == null) {
                                position = "";
                            }
                        } else {
                            position = "";
                        }
                        if (repeat != null) {
                            if ((repeat = repeat.toString()) == null) {
                                repeat = "repeat";
                            }
                        } else {
                            repeat = "repeat";
                        }
                        int imageWidth = this.image.getIconWidth();
                        int imageHeight = this.image.getIconHeight();
                        if (imageHeight <= 0 || imageWidth <= 0) {
                            if (clip != null) {
                                g.setClip(clip.x, clip.y, clip.width, clip.height);
                            }
                            return;
                        }
                        if (repeat.equals("repeat") && position.equals("")) {
                            StringTokenizer st2;
                            int tokNumber2;
                            if (imageWidth < 50 && imageHeight < 50 && this.buffImg == null) {
                                int multiplier = 10;
                                this.buffImg = new BufferedImage(multiplier * imageWidth, multiplier * imageHeight, 2);
                                for (int i = 0; i <= multiplier * imageWidth; i += imageWidth) {
                                    for (int j = 0; j <= multiplier * imageHeight; j += imageHeight) {
                                        this.image.paintIcon(null, this.buffImg.getGraphics(), i, j);
                                    }
                                }
                                imageWidth = multiplier * imageWidth;
                                imageHeight = multiplier * imageHeight;
                                this.image.setImage(this.buffImg);
                            }
                            int newX = (int)x;
                            int newY = (int)y;
                            if (position != null && (tokNumber2 = (st2 = new StringTokenizer(position.toString())).countTokens()) >= 2) {
                                String x_ = st2.nextToken();
                                String y_ = st2.nextToken();
                                if (x_.indexOf("%") != -1) {
                                    x_ = x_.substring(0, x_.indexOf("%"));
                                    int percentX = Integer.parseInt(x_);
                                    newX = (int)(w * (float)percentX / 100.0f - (float)this.image.getIconWidth() + x);
                                } else {
                                    try {
                                        newX = (int)(SferyxUtilities.getNumberFromCSString(x_) + x);
                                    }
                                    catch (Throwable thr) {
                                        // empty catch block
                                    }
                                }
                                if (y_.indexOf("%") != -1) {
                                    y_ = y_.substring(0, y_.indexOf("%"));
                                    int percentY = Integer.parseInt(y_);
                                    newY = (int)(h * (float)percentY / 100.0f - (float)this.image.getIconHeight() + y);
                                } else {
                                    try {
                                        newY = (int)(SferyxUtilities.getNumberFromCSString(y_) + y);
                                    }
                                    catch (Throwable thr) {
                                        // empty catch block
                                    }
                                }
                            }
                            y = newY;
                            x = newX;
                            int i = (int)x;
                            while ((float)i < (float)((int)x) + w) {
                                int j = (int)y;
                                while ((float)j < (float)((int)y) + h) {
                                    this.image.paintIcon(null, g, i, j);
                                    j += imageHeight;
                                }
                                i += imageWidth;
                            }
                            break block90;
                        }
                        if (repeat.equals("repeat-x")) {
                            int offset_y = (int)y;
                            if (position.equals("0 100%")) {
                                offset_y = (int)y + (int)(h - (float)imageHeight);
                            } else if (position.equals("left center") || position.equals("center left") || position.equals("left") || position.equals("0 50%") || position.equals("bottom center") || position.equals("center bottom") || position.equals("50% 100%") || position.equals("center center") || position.equals("center") || position.equals("50% 50%")) {
                                offset_y = (int)y + (int)(h / 2.0f - (float)(imageHeight / 2));
                            } else {
                                StringTokenizer st3;
                                int tokNumber3;
                                int newX = (int)x;
                                int newY = (int)y;
                                if (position != null && (tokNumber3 = (st3 = new StringTokenizer(position.toString())).countTokens()) >= 2) {
                                    String x_ = st3.nextToken();
                                    String y_ = st3.nextToken();
                                    if (x_.indexOf("%") != -1) {
                                        x_ = x_.substring(0, x_.indexOf("%"));
                                        int percentX = Integer.parseInt(x_);
                                        newX = (int)(w * (float)percentX / 100.0f - (float)this.image.getIconWidth() + x);
                                    } else {
                                        try {
                                            newX = x_.trim().equalsIgnoreCase("left") ? (int)x : (x_.trim().equalsIgnoreCase("right") ? (int)(x + w - (float)imageWidth) : (int)(SferyxUtilities.getNumberFromCSString(x_) + x));
                                        }
                                        catch (Throwable thr) {
                                            // empty catch block
                                        }
                                    }
                                    if (y_.indexOf("%") != -1) {
                                        y_ = y_.substring(0, y_.indexOf("%"));
                                        int percentY = Integer.parseInt(y_);
                                        newY = (int)(h * (float)percentY / 100.0f - (float)this.image.getIconHeight() + y);
                                    } else {
                                        try {
                                            newY = y_.trim().equalsIgnoreCase("top") ? (int)y : (y_.trim().equalsIgnoreCase("bottom") ? (int)(y + h - (float)imageHeight) : (int)(SferyxUtilities.getNumberFromCSString(y_) + y));
                                        }
                                        catch (Throwable thr) {
                                            // empty catch block
                                        }
                                    }
                                }
                                offset_y = newY;
                                x = newX;
                            }
                            int i = (int)x;
                            while ((float)i < (float)((int)x) + w) {
                                this.image.paintIcon(null, g, i, offset_y);
                                i += imageWidth;
                            }
                            break block90;
                        }
                        if (repeat.equals("repeat-y")) {
                            int offset_x = (int)x;
                            if (position.equals("100% 0")) {
                                offset_x = (int)x + (int)(w - (float)imageWidth);
                            } else if (position.equals("top center") || position.equals("center top") || position.equals("top") || position.equals("50% 0") || position.equals("center center") || position.equals("center") || position.equals("50% 50%")) {
                                offset_x = (int)x + (int)(w / 2.0f - (float)(imageWidth / 2));
                            } else if (position.equals("right center") || position.equals("center right") || position.equals("right") || position.equals("100% 50%")) {
                                offset_x = (int)x + (int)(w - (float)imageWidth);
                            } else {
                                StringTokenizer st4;
                                int tokNumber4;
                                int newX = (int)x;
                                int newY = (int)y;
                                if (position != null && (tokNumber4 = (st4 = new StringTokenizer(position.toString())).countTokens()) >= 2) {
                                    String x_ = st4.nextToken();
                                    String y_ = st4.nextToken();
                                    if (x_.indexOf("%") != -1) {
                                        x_ = x_.substring(0, x_.indexOf("%"));
                                        int percentX = Integer.parseInt(x_);
                                        newX = (int)(w * (float)percentX / 100.0f - (float)this.image.getIconWidth() + x);
                                    } else {
                                        try {
                                            newX = x_.trim().equalsIgnoreCase("left") ? (int)x : (x_.trim().equalsIgnoreCase("right") ? (int)(x + w - (float)imageWidth) : (int)(SferyxUtilities.getNumberFromCSString(x_) + x));
                                        }
                                        catch (Throwable thr) {
                                            // empty catch block
                                        }
                                    }
                                    if (y_.indexOf("%") != -1) {
                                        y_ = y_.substring(0, y_.indexOf("%"));
                                        int percentY = Integer.parseInt(y_);
                                        newY = (int)(h * (float)percentY / 100.0f - (float)this.image.getIconHeight() + y);
                                    } else {
                                        try {
                                            newY = y_.trim().equalsIgnoreCase("top") ? (int)y : (y_.trim().equalsIgnoreCase("bottom") ? (int)(y + h - (float)imageHeight) : (int)(SferyxUtilities.getNumberFromCSString(y_) + y));
                                        }
                                        catch (Throwable thr) {
                                            // empty catch block
                                        }
                                    }
                                }
                                offset_x = newX;
                                y = newY;
                            }
                            int j = (int)y;
                            while ((float)j < (float)((int)y) + h) {
                                this.image.paintIcon(null, g, offset_x, j);
                                j += imageHeight;
                            }
                            break block90;
                        }
                        if (position.equals("top left") || position.equals("left top") || position.equals("0 0") || position.equals("top") || position.equals("left 0") || position.equals("0 left")) {
                            this.image.paintIcon(null, g, (int)x, (int)y);
                            break block90;
                        }
                        if (position.equals("top center") || position.equals("center top") || position.equals("top") || position.equals("50% 0")) {
                            this.image.paintIcon(null, g, (int)x + (int)(w / 2.0f - (float)(imageWidth / 2)), (int)y);
                            break block90;
                        }
                        if (position.equals("right top") || position.equals("top right") || position.equals("100% 0") || position.equals("right") || position.equals("right 0") || position.equals("0 right")) {
                            this.image.paintIcon(null, g, (int)(x + w - (float)imageWidth), (int)y);
                            break block90;
                        }
                        if (position.equals("left center") || position.equals("center left") || position.equals("left") || position.equals("0 50%")) {
                            this.image.paintIcon(null, g, (int)x, (int)y + (int)(h / 2.0f - (float)(imageHeight / 2)));
                            break block90;
                        }
                        if (position.equals("right center") || position.equals("center right") || position.equals("right") || position.equals("100% 50%")) {
                            this.image.paintIcon(null, g, (int)(x + w - (float)imageWidth), (int)y + (int)(h / 2.0f - (float)(imageHeight / 2)));
                            break block90;
                        }
                        if (position.equals("center center") || position.equals("center") || position.equals("50% 50%")) {
                            this.image.paintIcon(null, g, (int)x + (int)(w / 2.0f - (float)(imageWidth / 2)), (int)y + (int)(h / 2.0f - (float)(imageHeight / 2)));
                            break block90;
                        }
                        if (position.equals("bottom center") || position.equals("center bottom") || position.equals("50% 100%")) {
                            this.image.paintIcon(null, g, (int)x + (int)(w / 2.0f - (float)(imageWidth / 2)), (int)y + (int)(h - (float)imageHeight));
                            break block90;
                        }
                        if (position.equals("bottom left") || position.equals("left bottom") || position.equals("0 100%") || position.equals("bottom")) {
                            this.image.paintIcon(null, g, (int)x, (int)y + (int)(h - (float)imageHeight));
                            break block90;
                        }
                        if (position.equals("bottom right") || position.equals("right bottom") || position.equals("100% 100%")) {
                            this.image.paintIcon(null, g, (int)x + (int)(w - (float)imageWidth), (int)y + (int)(h - (float)imageHeight));
                            break block90;
                        }
                        int newX = (int)x;
                        int newY = (int)y;
                        if (position != null && (tokNumber = (st = new StringTokenizer(position.toString())).countTokens()) >= 2) {
                            String x_ = st.nextToken();
                            String y_ = st.nextToken();
                            if (x_.indexOf("%") != -1) {
                                x_ = x_.substring(0, x_.indexOf("%"));
                                int percentX = Integer.parseInt(x_);
                                newX = (int)(w * (float)percentX / 100.0f - (float)this.image.getIconWidth() + x);
                            } else {
                                try {
                                    newX = x_.trim().equalsIgnoreCase("left") ? (int)x : (x_.trim().equalsIgnoreCase("right") ? (int)(x + w - (float)imageWidth) : (int)(SferyxUtilities.getNumberFromCSString(x_) + x));
                                }
                                catch (Throwable thr) {
                                    // empty catch block
                                }
                            }
                            if (y_.indexOf("%") != -1) {
                                y_ = y_.substring(0, y_.indexOf("%"));
                                int percentY = Integer.parseInt(y_);
                                newY = (int)(h * (float)percentY / 100.0f - (float)this.image.getIconHeight() + y);
                            } else {
                                try {
                                    newY = y_.trim().equalsIgnoreCase("top") ? (int)y : (y_.trim().equalsIgnoreCase("bottom") ? (int)(y + h - (float)imageHeight) : (int)(SferyxUtilities.getNumberFromCSString(y_) + y));
                                }
                                catch (Throwable thr) {
                                    // empty catch block
                                }
                            }
                        }
                        this.image.paintIcon(null, g, newX, newY);
                    }
                    catch (Throwable thr) {
                        thr.printStackTrace();
                    }
                }
                if (clip != null) {
                    g.setClip(clip.x, clip.y, clip.width, clip.height);
                }
            }
            catch (Throwable thr1) {
                thr1.printStackTrace();
            }
        }
    }

    public void paint_orig(Graphics g, float x, float y, float w, float h, View v) {
        block54: {
            if (this.cachedBackgroundValue != this.getBackgroundValue()) {
                this.buffImg = null;
                this.image = null;
                this.getBackgroundImage(v.getAttributes());
            }
            try {
                Rectangle clip;
                block55: {
                    if (this.bg != null) {
                        g.setColor(this.bg);
                        g.fillRect((int)x, (int)y, (int)w, (int)h);
                    }
                    if (this.image == null) break block54;
                    clip = g.getClipRect();
                    if (clip != null) {
                        if (this.view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY) {
                            if (this.view.getContainer() != null) {
                                int height = ((JScrollPane)this.view.getContainer().getParent().getParent()).getHeight();
                                if ((float)height > h) {
                                    h = height;
                                }
                                g.clipRect((int)x, (int)y, (int)w, (int)h);
                            }
                        } else {
                            g.clipRect((int)x, (int)y, (int)w, (int)h);
                        }
                    }
                    try {
                        StringTokenizer st;
                        int tokNumber;
                        Object repeat = this.attr.getAttribute(CSS.Attribute.BACKGROUND_REPEAT);
                        Object position = this.attr.getAttribute(CSS.Attribute.BACKGROUND_POSITION);
                        if (position != null) {
                            if ((position = position.toString()) == null) {
                                position = "";
                            }
                        } else {
                            position = "";
                        }
                        if (repeat != null) {
                            if ((repeat = repeat.toString()) == null) {
                                repeat = "repeat";
                            }
                        } else {
                            repeat = "repeat";
                        }
                        int imageWidth = this.image.getIconWidth();
                        int imageHeight = this.image.getIconHeight();
                        if (imageHeight <= 0 || imageWidth <= 0) {
                            if (clip != null) {
                                g.setClip(clip.x, clip.y, clip.width, clip.height);
                            }
                            return;
                        }
                        if (repeat.equals("repeat")) {
                            if (imageWidth < 50 && imageHeight < 50 && this.buffImg == null) {
                                int multiplier = 10;
                                this.buffImg = new BufferedImage(multiplier * imageWidth, multiplier * imageHeight, 2);
                                for (int i = 0; i <= multiplier * imageWidth; i += imageWidth) {
                                    for (int j = 0; j <= multiplier * imageHeight; j += imageHeight) {
                                        this.image.paintIcon(null, this.buffImg.getGraphics(), i, j);
                                    }
                                }
                                imageWidth = multiplier * imageWidth;
                                imageHeight = multiplier * imageHeight;
                                this.image.setImage(this.buffImg);
                            }
                            int i = (int)x;
                            while ((float)i < (float)((int)x) + w) {
                                int j = (int)y;
                                while ((float)j < (float)((int)y) + h) {
                                    this.image.paintIcon(null, g, i, j);
                                    j += imageHeight;
                                }
                                i += imageWidth;
                            }
                            break block55;
                        }
                        if (repeat.equals("repeat-x")) {
                            int offset_y = (int)y;
                            if (((String)position).indexOf("bottom") != -1 || position.equals("0 100%")) {
                                offset_y = (int)y + (int)(h - (float)imageHeight);
                            } else if (position.equals("left center") || position.equals("center left") || position.equals("left") || position.equals("0 50%") || position.equals("bottom center") || position.equals("center bottom") || position.equals("50% 100%") || position.equals("center center") || position.equals("center") || position.equals("50% 50%")) {
                                offset_y = (int)y + (int)(h / 2.0f - (float)(imageHeight / 2));
                            }
                            int i = (int)x;
                            while ((float)i < (float)((int)x) + w) {
                                this.image.paintIcon(null, g, i, offset_y);
                                i += imageWidth;
                            }
                            break block55;
                        }
                        if (repeat.equals("repeat-y")) {
                            int offset_x = (int)x;
                            if (((String)position).indexOf("right") != -1 || position.equals("100% 0")) {
                                offset_x = (int)x + (int)(w - (float)imageWidth);
                            } else if (position.equals("top center") || position.equals("center top") || position.equals("top") || position.equals("50% 0") || position.equals("right center") || position.equals("center right") || position.equals("right") || position.equals("100% 50%") || position.equals("center center") || position.equals("center") || position.equals("50% 50%")) {
                                offset_x = (int)x + (int)(w / 2.0f - (float)(imageWidth / 2));
                            }
                            int j = (int)y;
                            while ((float)j < (float)((int)y) + h) {
                                this.image.paintIcon(null, g, offset_x, j);
                                j += imageHeight;
                            }
                            break block55;
                        }
                        if (position.equals("top left") || position.equals("left top") || position.equals("0 0") || position.equals("top")) {
                            this.image.paintIcon(null, g, (int)x, (int)y);
                            break block55;
                        }
                        if (position.equals("top center") || position.equals("center top") || position.equals("top") || position.equals("50% 0")) {
                            this.image.paintIcon(null, g, (int)x + (int)(w / 2.0f - (float)(imageWidth / 2)), (int)y);
                            break block55;
                        }
                        if (position.equals("right top") || position.equals("top right") || position.equals("100% 0") || position.equals("right")) {
                            this.image.paintIcon(null, g, (int)(x + w - (float)imageWidth), (int)y);
                            break block55;
                        }
                        if (position.equals("left center") || position.equals("center left") || position.equals("left") || position.equals("0 50%")) {
                            this.image.paintIcon(null, g, (int)x, (int)y + (int)(h / 2.0f - (float)(imageHeight / 2)));
                            break block55;
                        }
                        if (position.equals("right center") || position.equals("center right") || position.equals("right") || position.equals("100% 50%")) {
                            this.image.paintIcon(null, g, (int)(x + w - (float)imageWidth), (int)y + (int)(h / 2.0f - (float)(imageHeight / 2)));
                            break block55;
                        }
                        if (position.equals("center center") || position.equals("center") || position.equals("50% 50%")) {
                            this.image.paintIcon(null, g, (int)x + (int)(w / 2.0f - (float)(imageWidth / 2)), (int)y + (int)(h / 2.0f - (float)(imageHeight / 2)));
                            break block55;
                        }
                        if (position.equals("bottom center") || position.equals("center bottom") || position.equals("50% 100%")) {
                            this.image.paintIcon(null, g, (int)x + (int)(w / 2.0f - (float)(imageWidth / 2)), (int)y + (int)(h - (float)imageHeight));
                            break block55;
                        }
                        if (position.equals("bottom left") || position.equals("left bottom") || position.equals("0 100%") || position.equals("bottom")) {
                            this.image.paintIcon(null, g, (int)x, (int)y + (int)(h - (float)imageHeight));
                            break block55;
                        }
                        if (position.equals("bottom right") || position.equals("right bottom") || position.equals("100% 100%")) {
                            this.image.paintIcon(null, g, (int)x + (int)(w - (float)imageWidth), (int)y + (int)(h - (float)imageHeight));
                            break block55;
                        }
                        int newX = (int)x;
                        int newY = (int)y;
                        if (position != null && (tokNumber = (st = new StringTokenizer(position.toString())).countTokens()) == 2) {
                            String x_ = st.nextToken();
                            String y_ = st.nextToken();
                            if (x_.indexOf("%") != -1) {
                                x_ = x_.substring(0, x_.indexOf("%"));
                                int percentX = Integer.parseInt(x_);
                                newX = (int)(w * (float)percentX / 100.0f - (float)this.image.getIconWidth() + x);
                            } else {
                                try {
                                    newX = (int)(SferyxUtilities.getNumberFromCSString(x_) + x);
                                }
                                catch (Throwable thr) {
                                    // empty catch block
                                }
                            }
                            if (y_.indexOf("%") != -1) {
                                y_ = y_.substring(0, y_.indexOf("%"));
                                int percentY = Integer.parseInt(y_);
                                newY = (int)(h * (float)percentY / 100.0f - (float)this.image.getIconHeight() + y);
                            } else {
                                try {
                                    newY = (int)(SferyxUtilities.getNumberFromCSString(y_) + y);
                                }
                                catch (Throwable thr) {
                                    // empty catch block
                                }
                            }
                        }
                        this.image.paintIcon(null, g, newX, newY);
                    }
                    catch (Throwable thr) {
                        thr.printStackTrace();
                    }
                }
                if (clip != null) {
                    g.setClip(clip.x, clip.y, clip.width, clip.height);
                }
            }
            catch (Throwable thr1) {
                thr1.printStackTrace();
            }
        }
    }

    Object getBackgroundValue() {
        Object value = this.attr.getAttribute(CSS.Attribute.BACKGROUND_IMAGE);
        if (value == null) {
            value = this.attr.getAttribute(AlternativeCSSAttribute.BACKGROUND_IMAGE);
        }
        if (value == null) {
            value = this.attr.getAttribute(HTML.Attribute.BACKGROUND);
        }
        try {
            if (!this.newImage.equals("")) {
                value = this.newImage;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    ImageIcon getBackgroundImage(AttributeSet attr) {
        try {
            HTMLEditor htmlEditor = SferyxUtilities.getHostHTMLEditor(this.view);
            if (htmlEditor != null && htmlEditor.isDontLoadDocumentImages()) {
                return null;
            }
        }
        catch (Throwable thr) {
            // empty catch block
        }
        Object value = attr.getAttribute(CSS.Attribute.BACKGROUND_IMAGE);
        if (value == null && (value = attr.getAttribute(AlternativeCSSAttribute.BACKGROUND_IMAGE)) != null && value.toString() != null && !value.toString().equals("none") && attr.isDefined(AlternativeCSSAttribute.BACKGROUND_IMAGE)) {
            return this.getBackgroundImage(value.toString());
        }
        if (value == null) {
            value = attr.getAttribute(HTML.Attribute.BACKGROUND);
        }
        if (value != null && value.toString() != null && !value.toString().equals("none") && (attr.isDefined(CSS.Attribute.BACKGROUND_IMAGE) || attr.isDefined(HTML.Attribute.BACKGROUND))) {
            return this.getBackgroundImage(value.toString());
        }
        if (!this.newImage.equals("")) {
            return this.getBackgroundImage(this.newImage);
        }
        return null;
    }

    ImageIcon getBackgroundImage(String value) {
        String keyValue = value;
        if (imageCache.get(keyValue) != null) {
            this.image = (ImageIcon)imageCache.get(keyValue);
            return this.image;
        }
        if (value != null && !value.startsWith("none")) {
            this.cachedBackgroundValue = value;
            if (this.image == null) {
                try {
                    String convertedString = SferyxUtilities.convertStyleDeclarationtoURL(value.toString());
                    if (convertedString.startsWith("data:")) {
                        return null;
                    }
                    if (convertedString.toString().indexOf("(") != -1 && convertedString.toString().indexOf(")") != -1) {
                        return null;
                    }
                    URL url = new URL(this.ss.getBase(), convertedString);
                    if (url != null) {
                        this.image = new ImageIcon(url);
                    }
                    if (this.image != null && keyValue != null && !imageCache.contains(keyValue)) {
                        imageCache.put(keyValue, new ImageIcon(this.image.getImage()));
                    }
                }
                catch (Throwable thr) {
                    return null;
                }
            }
            if (this.image != null && keyValue != null && !imageCache.contains(keyValue)) {
                imageCache.put(keyValue, new ImageIcon(this.image.getImage()));
            }
            return this.image;
        }
        return null;
    }

    private void safePreferenceChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.view.preferenceChanged(null, true, true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CustomBoxPainter.this.view.preferenceChanged(null, true, true);
                }
            });
        }
    }

    private class CImageHandler
    implements ImageObserver {
        private CImageHandler() {
        }

        public boolean imageUpdate(Image img, int flags, int x, int y, int newWidth, int newHeight) {
            System.out.println("loading!!!");
            if ((flags & 0x20) == 0) {
                CustomBoxPainter.this.image = new ImageIcon(img);
                System.out.println("finished!!!");
                CustomBoxPainter.this.safePreferenceChanged();
                return false;
            }
            return true;
        }
    }
}

