/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;

public class CustomBodyView
extends BlockView {
    Rectangle tempRect = new Rectangle();
    float minSpanY = -1.0f;
    float maxSpanY = -1.0f;
    float prefSpanY = -1.0f;
    float minSpanX = -1.0f;
    float maxSpanX = -1.0f;
    float prefSpanX = -1.0f;

    public CustomBodyView(Element elem, int axis) {
        super(elem, axis);
    }

    public AttributeSet getAttributes() {
        return this.getElement().getAttributes();
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        int n = this.getViewCount();
        int x = alloc.x + this.getLeftInset();
        int y = alloc.y + this.getTopInset();
        Rectangle clip = g.getClipBounds();
        for (int i = 0; i < n; ++i) {
            this.tempRect.x = x + this.getOffset(0, i);
            this.tempRect.y = y + this.getOffset(1, i);
            this.tempRect.width = this.getSpan(0, i);
            this.tempRect.height = this.getSpan(1, i);
            if (!this.tempRect.intersects(clip)) continue;
            this.paintChild(g, this.tempRect, i);
        }
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        int n = this.getViewCount();
        CSS.Attribute key = axis == 0 ? CSS.Attribute.WIDTH : CSS.Attribute.HEIGHT;
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            int min = (int)v.getMinimumSpan(axis);
            int max = (int)v.getMaximumSpan(axis);
            AttributeSet a = v.getAttributes();
            if (max < targetSpan) {
                float align = v.getAlignment(axis);
                offsets[i] = (int)((float)(targetSpan - max) * align);
                spans[i] = max;
                continue;
            }
            offsets[i] = 0;
            spans[i] = Math.max(min, targetSpan);
        }
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        long minimum = 0L;
        long maximum = 0L;
        long preferred = 0L;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            spans[i] = (int)v.getPreferredSpan(axis);
            preferred += (long)spans[i];
            minimum = (long)((float)minimum + v.getMinimumSpan(axis));
            maximum = (long)((float)maximum + v.getMaximumSpan(axis));
        }
        long desiredAdjustment = (long)targetSpan - preferred;
        float adjustmentFactor = 0.0f;
        if (desiredAdjustment != 0L) {
            float maximumAdjustment;
            float f = maximumAdjustment = desiredAdjustment > 0L ? (float)(maximum - preferred) : (float)(preferred - minimum);
            if (maximumAdjustment == 0.0f) {
                adjustmentFactor = 0.0f;
            } else {
                adjustmentFactor = (float)desiredAdjustment / maximumAdjustment;
                adjustmentFactor = Math.min(adjustmentFactor, 1.0f);
                adjustmentFactor = Math.max(adjustmentFactor, -1.0f);
            }
        }
        int totalOffset = 0;
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            offsets[i] = totalOffset;
            int availableSpan = adjustmentFactor > 0.0f ? (int)v.getMaximumSpan(axis) - spans[i] : spans[i] - (int)v.getMinimumSpan(axis);
            float adjF = adjustmentFactor * (float)availableSpan;
            adjF = adjF < 0.0f ? (adjF -= 0.5f) : (adjF += 0.5f);
            int adj = (int)adjF;
            int n2 = i;
            spans[n2] = spans[n2] + adj;
            totalOffset = (int)Math.min((long)totalOffset + (long)spans[i], Integer.MAX_VALUE);
        }
    }

    public float getAlignment(int axis) {
        return 0.0f;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        float min = 0.0f;
        float pref = 0.0f;
        float max = 0.0f;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            min += v.getMinimumSpan(axis);
            pref += v.getPreferredSpan(axis);
            max += v.getMaximumSpan(axis);
        }
        if (r == null) {
            r = new SizeRequirements();
        }
        r.alignment = 0.5f;
        r.minimum = (int)min;
        r.preferred = (int)pref;
        r.maximum = (int)max;
        return r;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        int min = 0;
        long pref = 0L;
        int max = Integer.MAX_VALUE;
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            min = Math.max((int)v.getMinimumSpan(axis), min);
            pref = Math.max((long)((int)v.getPreferredSpan(axis)), pref);
            max = Math.max((int)v.getMaximumSpan(axis), max);
        }
        if (r == null) {
            r = new SizeRequirements();
            r.alignment = 0.5f;
        }
        r.preferred = (int)pref;
        r.minimum = min;
        r.maximum = max;
        return r;
    }

    protected void setPropertiesFromAttributes() {
    }

    public int getResizeWeight(int axis) {
        return 1;
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.prefSpanX = -1.0f;
        this.minSpanX = -1.0f;
        this.maxSpanX = -1.0f;
        this.prefSpanY = -1.0f;
        this.minSpanY = -1.0f;
        this.maxSpanY = -1.0f;
        super.changedUpdate(e, a, f);
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.prefSpanX = -1.0f;
        this.minSpanX = -1.0f;
        this.maxSpanX = -1.0f;
        this.prefSpanY = -1.0f;
        this.minSpanY = -1.0f;
        this.maxSpanY = -1.0f;
        super.insertUpdate(e, a, f);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.prefSpanX = -1.0f;
        this.minSpanX = -1.0f;
        this.maxSpanX = -1.0f;
        this.prefSpanY = -1.0f;
        this.minSpanY = -1.0f;
        this.maxSpanY = -1.0f;
        super.removeUpdate(e, a, f);
    }

    public float getMaximumSpan1(int axis) {
        int n = this.getViewCount();
        float totalSpan = 0.0f;
        if (axis == 0) {
            if (this.maxSpanX != -1.0f) {
                return this.maxSpanX;
            }
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                float span = v.getMaximumSpan(axis);
                if (!(span > totalSpan)) continue;
                totalSpan = span;
            }
            this.maxSpanX = totalSpan;
            return totalSpan;
        }
        if (this.maxSpanY != -1.0f) {
            return this.maxSpanY;
        }
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            float span = v.getMaximumSpan(axis);
            totalSpan += span;
        }
        this.maxSpanY = totalSpan;
        return totalSpan;
    }

    public float getMinimumSpan1(int axis) {
        int n = this.getViewCount();
        float totalSpan = 0.0f;
        if (axis == 0) {
            if (this.minSpanX != -1.0f) {
                return this.minSpanX;
            }
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                float span = v.getMinimumSpan(axis);
                if (!(span > totalSpan)) continue;
                totalSpan = span;
            }
            this.minSpanX = totalSpan;
            return totalSpan;
        }
        if (this.minSpanY != -1.0f) {
            return this.minSpanY;
        }
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            float span = v.getMinimumSpan(axis);
            totalSpan += span;
        }
        this.minSpanY = totalSpan;
        return totalSpan;
    }

    public float getPreferredSpan1(int axis) {
        int n = this.getViewCount();
        float totalSpan = 0.0f;
        if (axis == 0) {
            if (this.prefSpanX != -1.0f) {
                return this.prefSpanX;
            }
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                float span = v.getPreferredSpan(axis);
                if (!(span > totalSpan)) continue;
                totalSpan = span;
            }
            this.prefSpanX = totalSpan;
            return totalSpan;
        }
        if (this.prefSpanY != -1.0f) {
            return this.prefSpanY;
        }
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            float span = v.getPreferredSpan(axis);
            totalSpan += span;
        }
        this.prefSpanY = totalSpan;
        return totalSpan;
    }
}

