/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import sferyx.administration.editors.CustomLayoutBoxView;
import sferyx.administration.editors.CustomUnknownTagView;
import sferyx.administration.editors.SferyxUtilities;

public class CustomBlockView
extends CustomLayoutBoxView {
    public CustomBlockView(Element elem, int axis) {
        super(elem, axis);
    }

    public boolean containsOnlyFloats() {
        if (this.getWidthCSSValue() != -1.0f) {
            return false;
        }
        if (this.getAttributes().getAttribute(CSS.Attribute.WIDTH) != null && (this.getAttributes().getAttribute(CSS.Attribute.WIDTH).toString().indexOf("%") != -1 || this.getAttributes().getAttribute(CSS.Attribute.WIDTH).toString().indexOf("em") != -1 || this.getAttributes().getAttribute(CSS.Attribute.WIDTH).toString().indexOf("auto") != -1)) {
            return false;
        }
        if (this.getAttributes().getAttribute(HTML.Attribute.WIDTH) != null && (this.getAttributes().getAttribute(HTML.Attribute.WIDTH).toString().indexOf("%") != -1 || this.getAttributes().getAttribute(HTML.Attribute.WIDTH).toString().indexOf("em") != -1 || this.getAttributes().getAttribute(HTML.Attribute.WIDTH).toString().indexOf("auto") != -1)) {
            return false;
        }
        if (SferyxUtilities.isClearBothView(this, this.getStyleSheet()) || SferyxUtilities.isClearRightView(this, this.getStyleSheet())) {
            return false;
        }
        for (int i = 0; i < this.getViewCount(); ++i) {
            View v = this.getView(i);
            if (SferyxUtilities.isFloatLeftView(v, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(v, this.getStyleSheet()) || v instanceof CustomUnknownTagView) continue;
            return false;
        }
        return true;
    }

    public float getMaximumSpan(int axis) {
        return this.getMaximumSpan_(axis);
    }

    public float getMaximumSpan_(int axis) {
        float width;
        float span;
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return 0.0f;
        }
        if (SferyxUtilities.matchNameAttribute(this.getElement(), HTML.Tag.BODY) || SferyxUtilities.matchNameAttribute(this.getElement(), HTML.Tag.HTML)) {
            return super.getMaximumSpan(axis);
        }
        if (axis == 0) {
            span = -1.0f;
            width = this.getWidthCSSValue();
            if (width != -1.0f && (span = width + (float)this.getLeftPadding() + (float)this.getRightPadding()) != -1.0f) {
                return span;
            }
        }
        if (axis == 1) {
            span = -1.0f;
            width = this.getHeightCSSValue();
            if (width != -1.0f && (span = width + (float)this.getTopPadding() + (float)this.getBottomPadding()) != -1.0f) {
                return span;
            }
        }
        if (axis == 0 && (SferyxUtilities.isFloatLeftView(this, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(this, this.getStyleSheet()))) {
            float floatSpan = this.getPreferredSpan(0);
            return floatSpan;
        }
        if (axis != 0 || this.containsOnlyFloats()) {
            // empty if block
        }
        if (axis == 0 && (SferyxUtilities.isFloatLeftView(this, this.getStyleSheet()) || SferyxUtilities.isFloatRightView(this, this.getStyleSheet()) || this.isAbsolutePositioning())) {
            float prefSpan = span = super.getPreferredSpan(axis);
            float minSpan = this.getMinimumSpan(axis);
            float widthCSS = this.getWidthCSSValue();
            if (widthCSS != -1.0f) {
                float floatSpan;
                span = widthCSS + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset();
                if (span == -1.0f) {
                    span = prefSpan;
                }
                if ((floatSpan = this.getFloatingChildrenSpan(axis) + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset()) > span && !SferyxUtilities.isOverflowHidden(this, this.getStyleSheet())) {
                    return floatSpan;
                }
                if (minSpan > span && !SferyxUtilities.isOverflowHidden(this, this.getStyleSheet())) {
                    return minSpan;
                }
                return span;
            }
            float floatSpan = this.getFloatingChildrenSpan(axis) + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset();
            if (floatSpan > span) {
                return floatSpan;
            }
            return span;
        }
        if (axis == 0) {
            float min_span;
            float maxSpan = span = super.getMaximumSpan(axis);
            if (this.getWidthCSSValue() != -1.0f) {
                span = this.getWidthCSSValue() + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset();
            }
            if (span == -1.0f) {
                span = maxSpan;
            }
            if (span < (min_span = this.getMinimumSpan(axis))) {
                return min_span;
            }
            return span;
        }
        if (axis == 1) {
            int maxSpan = this.getMaxSpan(0, this.getViewCount(), this.spans_Y, this.offsets_Y);
            float min_span = this.getMinimumSpan(axis);
            float span2 = -1.0f;
            if (SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT) != null) {
                span2 = SferyxUtilities.getNumberFromCSString(SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT).toString());
                if (span2 > min_span) {
                    return span2;
                }
                if (span2 != -1.0f) {
                    return span2;
                }
            }
            return maxSpan;
        }
        return super.getMaximumSpan(axis);
    }

    public float getPreferredSpan(int axis) {
        return this.getPreferredSpan_(axis);
    }

    public float getPreferredSpan_(int axis) {
        float width;
        float span;
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return 0.0f;
        }
        if (SferyxUtilities.matchNameAttribute(this.getElement(), HTML.Tag.BODY)) {
            return super.getPreferredSpan(axis);
        }
        if (axis == 0) {
            span = -1.0f;
            width = this.getWidthCSSValue();
            if (width != -1.0f && (span = width + (float)this.getLeftPadding() + (float)this.getRightPadding()) != -1.0f) {
                return span;
            }
        }
        if (axis == 1) {
            span = -1.0f;
            width = this.getHeightCSSValue();
            if (width != -1.0f && (span = width + (float)this.getTopPadding() + (float)this.getBottomPadding()) != -1.0f) {
                return span;
            }
        }
        if (axis == 1) {
            int maxSpan = this.getMaxSpan(0, this.getViewCount(), this.spans_Y, this.offsets_Y);
            float span2 = -1.0f;
            if (SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT) != null && (span2 = SferyxUtilities.getNumberFromCSString(SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT).toString())) != -1.0f) {
                return span2;
            }
            return maxSpan;
        }
        if (axis == 0) {
            span = this.getWidthCSSValue();
            if (span != -1.0f) {
                span = span + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset();
            }
            float min_span = this.getMinimumSpan(axis);
            if (span != -1.0f) {
                return span;
            }
            float floatSpan = this.getFloatingChildrenSpan(axis) + (float)this.getLeftPadding() + (float)this.getRightPadding() + (float)this.getLeftRightBorderInset();
            if (floatSpan > super.getPreferredSpan(axis)) {
                return floatSpan;
            }
        }
        return super.getPreferredSpan(axis);
    }

    public float getMinimumSpan(int axis) {
        return this.getMinimumSpan_(axis);
    }

    public float getMinimumSpan_(int axis) {
        float span;
        float width;
        float span2;
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return 0.0f;
        }
        if (axis == 0) {
            span2 = -1.0f;
            width = this.getWidthCSSValue();
            if (width != -1.0f && (span2 = width + (float)this.getLeftPadding() + (float)this.getRightPadding()) != -1.0f) {
                return span2;
            }
        }
        if (axis == 1) {
            span2 = -1.0f;
            width = this.getHeightCSSValue();
            if (width != -1.0f && (span2 = width + (float)this.getTopPadding() + (float)this.getBottomPadding()) != -1.0f) {
                return span2;
            }
        }
        if (axis != 0 || this.containsOnlyFloats()) {
            // empty if block
        }
        if (SferyxUtilities.matchNameAttribute(this.getElement(), HTML.Tag.BODY)) {
            return super.getMinimumSpan(axis);
        }
        if (axis == 1) {
            int maxSpan = this.getMaxSpan(0, this.getViewCount(), this.spans_Y, this.offsets_Y);
            try {
                span = super.getMinimumSpan(axis);
                if (SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT) != null && (span = SferyxUtilities.getNumberFromCSString(SferyxUtilities.getStyleSheetCSSValueForElement(this.getStyleSheet(), this.getAttributes(), CSS.Attribute.HEIGHT).toString())) != -1.0f) {
                    return span;
                }
            }
            catch (Throwable thr) {
                // empty catch block
            }
            return maxSpan;
        }
        float orig_span = super.getMinimumSpan(axis) - (float)this.getLeftInset() - (float)this.getRightInset();
        if (axis == 0) {
            span = orig_span;
            return orig_span;
        }
        return orig_span;
    }

    public void paint(Graphics g, Shape allocation) {
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return;
        }
        Rectangle origClip = g.getClipBounds();
        if (SferyxUtilities.isOverflowHidden(this, this.getStyleSheet())) {
            Container container = this.getContainer();
            int w = (int)this.getWidthCSSValue();
            int h = (int)this.getHeightCSSValue();
            Rectangle overflow = new Rectangle(((Rectangle)allocation).x, ((Rectangle)allocation).y, w > 0 ? w : ((Rectangle)allocation).width, h > 0 ? h : ((Rectangle)allocation).height);
            if (container != null) {
                Rectangle intersection = overflow.intersection(((JComponent)container).getVisibleRect());
                if (origClip != null && w > 0 && w < origClip.width) {
                    g.setClip(intersection);
                } else if (origClip != null && h > 0 && h < origClip.height) {
                    g.setClip(intersection);
                } else if (origClip == null && (w > 0 || h > 0)) {
                    g.setClip(intersection);
                }
            }
        }
        try {
            super.paint(g, allocation);
        }
        catch (Throwable thr) {
            // empty catch block
        }
        if (SferyxUtilities.isOverflowHidden(this, this.getStyleSheet()) && origClip != null) {
            g.setClip(origClip);
        }
    }

    public boolean isVisible() {
        if (SferyxUtilities.isViewNotVisible(this, this.getStyleSheet())) {
            return false;
        }
        return super.isVisible();
    }
}

