/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import javax.swing.text.AttributeSet;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.CustomTableRowView;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.TableView;
import sferyx.administration.editors.TiledLayoutHandler;

class ColumnLayoutHandler
extends TiledLayoutHandler {
    TableView tv;
    private int col;
    private int[] percentages;
    private int[] adjustmentWeights;
    private int[] offsets;
    private int[] spans;

    public ColumnLayoutHandler(TableView tv) {
        this.tv = tv;
    }

    void disablePercentages() {
        this.percentages = null;
    }

    private void updatePercentagesAndAdjustmentWeights(int span) {
        try {
            this.adjustmentWeights = new int[this.tv.columnRequirements.length];
            for (int i = 0; i < this.tv.columnRequirements.length; ++i) {
                this.adjustmentWeights[i] = 0;
            }
            this.percentages = this.tv.relativeCells ? new int[this.tv.columnRequirements.length] : new int[this.tv.columnRequirements.length];
            int nrows = this.tv.getRowCount();
            int totalcolumnspan = 0;
            for (int rowIndex = 0; rowIndex < nrows; ++rowIndex) {
                CustomTableRowView row = this.tv.getRow(rowIndex);
                int col = 0;
                int ncells = row.getViewCount();
                boolean totalCurrentSpan = false;
                int cell = 0;
                while (cell < ncells) {
                    View cv = row.getView(cell);
                    while (row.isFilled(col)) {
                        ++col;
                    }
                    int rowSpan = this.tv.getRowsOccupied(cv);
                    int colSpan = this.tv.getColumnsOccupied(cv);
                    AttributeSet a = cv.getAttributes();
                    Object lv = a.getAttribute(CSS.Attribute.WIDTH);
                    if (lv == null) {
                        lv = a.getAttribute(AlternativeCSSAttribute.WIDTH);
                    }
                    if (lv != null) {
                        boolean isPercentage = lv.toString().endsWith("%");
                        float value = SferyxUtilities.getNumberFromCSString(lv.toString());
                        int len = (int)value;
                        if (isPercentage) {
                            value = Float.parseFloat(lv.toString().substring(0, lv.toString().indexOf("%"))) / 100.0f;
                            if (value == 1.0f && ncells > 1) {
                                value /= (float)ncells;
                            } else if (value == 1.0f && ncells == 1) {
                                value /= (float)colSpan;
                            }
                        }
                        if (isPercentage) {
                            len = (int)(value * (float)span / (float)colSpan + 0.5f);
                        }
                        for (int i = 0; i < colSpan; ++i) {
                            if (isPercentage && this.percentages != null) {
                                this.percentages[col + i] = Math.max(this.percentages[col + i], len);
                                if (value >= 1.0f || this.percentages[col + i] + totalcolumnspan > span) {
                                    this.percentages[col + i] = span - totalcolumnspan;
                                }
                                totalcolumnspan += this.percentages[col + i];
                            } else {
                                totalcolumnspan += len;
                            }
                            this.adjustmentWeights[col + i] = 1;
                        }
                    }
                    col += colSpan - 1;
                    ++cell;
                    ++col;
                }
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    public void setLayoutArrays(int[] offsets, int[] spans, int targetSpan) {
        this.offsets = offsets;
        this.spans = spans;
        this.updatePercentagesAndAdjustmentWeights(targetSpan);
    }

    int getCount() {
        return this.tv.columnRequirements.length;
    }

    void setIndex(int i) {
        this.col = i;
    }

    void setOffset(int offs) {
        this.offsets[this.col] = offs;
    }

    int getOffset() {
        return this.offsets[this.col];
    }

    void setSpan(int span) {
        this.spans[this.col] = span;
    }

    int getSpan() {
        return this.spans[this.col];
    }

    float getMinimumSpan(float parentSpan) {
        if (this.percentages != null && this.percentages[this.col] != 0) {
            return Math.max(this.percentages[this.col], this.tv.columnRequirements[this.col].minimum);
        }
        return this.tv.columnRequirements[this.col].minimum;
    }

    float getPreferredSpan(float parentSpan) {
        if (this.percentages != null && this.percentages[this.col] != 0) {
            return Math.max(this.percentages[this.col], this.tv.columnRequirements[this.col].preferred);
        }
        return this.tv.columnRequirements[this.col].preferred;
    }

    float getMaximumSpan(float parentSpan) {
        if (this.percentages != null && this.percentages[this.col] != 0) {
            float maxSpan = Math.max(this.percentages[this.col], this.tv.columnRequirements[this.col].maximum);
            if (parentSpan < maxSpan) {
                return parentSpan;
            }
            return maxSpan;
        }
        return this.tv.columnRequirements[this.col].maximum;
    }

    float getLeadingCollapseSpan() {
        return this.tv.cellSpacing;
    }

    float getTrailingCollapseSpan() {
        return this.tv.cellSpacing;
    }

    int getAdjustmentWeight() {
        return this.adjustmentWeights[this.col];
    }
}

