/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorChooserDialog
extends JDialog
implements ChangeListener {
    Color selectedColor = null;
    Color initialColor = null;
    public static int OK_BUTTON = 0;
    public static int AUTOMATIC_BUTTON = 1;
    public static int CANCEL_BUTTON = 2;
    int actionResult = 0;
    private JButton autoButton;
    private JColorChooser colorChooserPanel;
    private JButton cancelButton;
    private JPanel buttonsPanel;
    private JButton okButton;

    public ColorChooserDialog(Frame parent, boolean modal, String title) {
        super(parent, modal);
        this.setTitle(title);
        this.initComponents();
        this.colorChooserPanel.getSelectionModel().addChangeListener(this);
        this.setSelectedColor(this.colorChooserPanel.getBackground());
    }

    public ColorChooserDialog(Dialog parent, boolean modal, String title) {
        super(parent, modal);
        this.setTitle(title);
        this.initComponents();
        this.colorChooserPanel.getSelectionModel().addChangeListener(this);
        this.setSelectedColor(this.colorChooserPanel.getBackground());
    }

    private void initComponents() {
        this.colorChooserPanel = new JColorChooser();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.autoButton = new JButton();
        this.cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ColorChooserDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().add((Component)this.colorChooserPanel, "Center");
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorChooserDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.okButton);
        this.autoButton.setText("Automatic");
        this.autoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorChooserDialog.this.autoButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.autoButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorChooserDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.actionResult = CANCEL_BUTTON;
        this.setVisible(false);
        this.dispose();
    }

    private void autoButtonActionPerformed(ActionEvent evt) {
        this.actionResult = AUTOMATIC_BUTTON;
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.actionResult = OK_BUTTON;
        this.setVisible(false);
        this.dispose();
    }

    public void setSelectedColor(Color c) {
        this.initialColor = c;
        if (c != null) {
            this.colorChooserPanel.setColor(c);
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    private void closeDialog(WindowEvent evt) {
        this.actionResult = CANCEL_BUTTON;
        this.setVisible(false);
        this.dispose();
    }

    public int getActionResult() {
        return this.actionResult;
    }

    public void setVisible(boolean b) {
        if (b) {
            if (this.initialColor == null) {
                this.colorChooserPanel.setColor(this.colorChooserPanel.getBackground());
            }
            this.selectedColor = null;
        }
        this.setSize(440, 440);
        if (b) {
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public static void main(String[] args) {
    }

    public void stateChanged(ChangeEvent e) {
        this.selectedColor = this.colorChooserPanel.getColor();
    }
}

