/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class ButtonFormFieldPropertiesDialog
extends JDialog {
    private JTextField onClickTextField;
    private JSeparator layoutSeparator;
    private JLabel fieldNameLabel;
    private JTextField fieldNameTextField;
    private JPanel jPanel1;
    private JComboBox fieldTypeComboBox;
    private JComboBox styleClassComboBox;
    private JLabel styleClassLabel;
    private JLabel fieldType;
    private JButton cancelButton;
    private JLabel fieldPropertiesLabel;
    private JSeparator buttonsSeparator;
    private JLabel fieldValueLabel;
    private JLabel onClickLabel;
    private JButton okButton;
    private JTextField fieldValueTextField;
    JFileChooser fileChooser;
    AttributeSet attributes;
    boolean cancel = false;
    public HTMLEditor htmlPanel;

    public ButtonFormFieldPropertiesDialog(Frame parent, boolean modal) {
        super(parent, true);
        this.initComponents();
    }

    public ButtonFormFieldPropertiesDialog(Dialog parent, boolean modal) {
        super(parent, true);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.fieldPropertiesLabel = new JLabel();
        this.layoutSeparator = new JSeparator();
        this.fieldType = new JLabel();
        this.fieldTypeComboBox = new JComboBox();
        this.fieldValueTextField = new JTextField();
        this.fieldNameTextField = new JTextField();
        this.fieldValueLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.buttonsSeparator = new JSeparator();
        this.fieldNameLabel = new JLabel();
        this.styleClassLabel = new JLabel();
        this.styleClassComboBox = new JComboBox();
        this.onClickLabel = new JLabel();
        this.onClickTextField = new JTextField();
        this.setTitle("Push Button Properties");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ButtonFormFieldPropertiesDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(null);
        this.fieldPropertiesLabel.setHorizontalAlignment(4);
        this.fieldPropertiesLabel.setText("Form Field Properties");
        this.jPanel1.add(this.fieldPropertiesLabel);
        this.fieldPropertiesLabel.setBounds(10, 10, 240, 16);
        this.jPanel1.add(this.layoutSeparator);
        this.layoutSeparator.setBounds(255, 18, 165, 2);
        this.fieldType.setHorizontalAlignment(4);
        this.fieldType.setText("Button type:");
        this.jPanel1.add(this.fieldType);
        this.fieldType.setBounds(0, 100, 120, 15);
        this.fieldTypeComboBox.setEditable(true);
        this.fieldTypeComboBox.setFont(new Font("Dialog", 0, 11));
        this.fieldTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"submit", "reset", "button"}));
        this.fieldTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ButtonFormFieldPropertiesDialog.this.fieldTypeComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.fieldTypeComboBox);
        this.fieldTypeComboBox.setBounds(130, 100, 100, 20);
        this.fieldValueTextField.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.add(this.fieldValueTextField);
        this.fieldValueTextField.setBounds(150, 70, 270, 19);
        this.fieldNameTextField.setFont(new Font("Dialog", 0, 11));
        this.jPanel1.add(this.fieldNameTextField);
        this.fieldNameTextField.setBounds(150, 40, 270, 19);
        this.fieldValueLabel.setHorizontalAlignment(4);
        this.fieldValueLabel.setText("Value/label:");
        this.jPanel1.add(this.fieldValueLabel);
        this.fieldValueLabel.setBounds(10, 70, 130, 16);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ButtonFormFieldPropertiesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.okButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ButtonFormFieldPropertiesDialog.this.okButtonMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                ButtonFormFieldPropertiesDialog.this.okButtonMouseReleased(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.okButton.setBounds(170, 190, 120, 26);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ButtonFormFieldPropertiesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.cancelButton.setBounds(300, 190, 120, 26);
        this.jPanel1.add(this.buttonsSeparator);
        this.buttonsSeparator.setBounds(20, 170, 400, 2);
        this.fieldNameLabel.setHorizontalAlignment(4);
        this.fieldNameLabel.setText("Field name:");
        this.jPanel1.add(this.fieldNameLabel);
        this.fieldNameLabel.setBounds(10, 40, 130, 16);
        this.styleClassLabel.setHorizontalAlignment(4);
        this.styleClassLabel.setText("Style:");
        this.jPanel1.add(this.styleClassLabel);
        this.styleClassLabel.setBounds(10, 130, 110, 16);
        this.styleClassComboBox.setEditable(true);
        this.styleClassComboBox.setFocusCycleRoot(true);
        this.styleClassComboBox.setVerifyInputWhenFocusTarget(false);
        this.jPanel1.add(this.styleClassComboBox);
        this.styleClassComboBox.setBounds(130, 130, 130, 20);
        this.onClickLabel.setHorizontalAlignment(4);
        this.onClickLabel.setText("OnClick:");
        this.jPanel1.add(this.onClickLabel);
        this.onClickLabel.setBounds(240, 100, 80, 16);
        this.jPanel1.add(this.onClickTextField);
        this.onClickTextField.setBounds(330, 100, 90, 20);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void okButtonMousePressed(MouseEvent evt) {
        this.okButton.requestFocus();
    }

    private void okButtonMouseReleased(MouseEvent evt) {
    }

    private void fieldTypeComboBoxActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.cancel = true;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.cancel = true;
        this.setVisible(false);
    }

    public void setVisible(boolean b) {
        this.setSize(440, 270);
        if (b) {
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
    }

    public void initDialogFields(AttributeSet attribs) {
        this.attributes = attribs;
        String formFieldName = (String)attribs.getAttribute(HTML.Attribute.NAME);
        if (formFieldName != null && this.attributes.containsAttribute(HTML.Attribute.NAME, formFieldName)) {
            this.fieldNameTextField.setText(formFieldName);
        } else {
            this.fieldNameTextField.setText("");
        }
        String formFieldValue = (String)attribs.getAttribute(HTML.Attribute.VALUE);
        if (formFieldValue != null && this.attributes.containsAttribute(HTML.Attribute.VALUE, formFieldValue)) {
            this.fieldValueTextField.setText(formFieldValue);
        } else {
            this.fieldValueTextField.setText("");
        }
        String fieldType = (String)attribs.getAttribute(HTML.Attribute.TYPE);
        if (fieldType != null && this.attributes.containsAttribute(HTML.Attribute.TYPE, fieldType)) {
            this.fieldTypeComboBox.setSelectedItem(fieldType.toLowerCase());
        } else {
            this.fieldTypeComboBox.setSelectedItem("button");
        }
        this.styleClassComboBox.setModel(new DefaultComboBoxModel(this.htmlPanel.getStyleClasses()));
        String styleClass = (String)attribs.getAttribute(HTML.Attribute.CLASS);
        if (styleClass != null && this.attributes.containsAttribute(HTML.Attribute.CLASS, styleClass)) {
            this.styleClassComboBox.setSelectedItem(styleClass);
        } else {
            this.styleClassComboBox.setSelectedIndex(-1);
        }
        this.styleClassComboBox.setRenderer(this.htmlPanel.getStyleClassRendererInstance());
        Object onClickAttribute = SferyxUtilities.getIgnoreCaseAttributeName("onclick", attribs);
        if (onClickAttribute != null) {
            this.onClickTextField.setText(onClickAttribute.toString());
        } else {
            this.onClickTextField.setText("");
        }
        this.okButton.requestFocus();
    }

    public AttributeSet getNewAttributes() {
        if (this.cancel) {
            return null;
        }
        SimpleAttributeSet newAttribs = new SimpleAttributeSet(this.attributes);
        newAttribs.addAttribute(HTML.Attribute.TYPE, this.fieldTypeComboBox.getSelectedItem());
        newAttribs.addAttribute(HTML.Attribute.NAME, this.fieldNameTextField.getText());
        newAttribs.addAttribute(HTML.Attribute.VALUE, this.fieldValueTextField.getText());
        if (this.styleClassComboBox.getSelectedItem() != null && !this.styleClassComboBox.getSelectedItem().equals("")) {
            newAttribs.addAttribute(HTML.Attribute.CLASS, this.styleClassComboBox.getSelectedItem());
        } else {
            newAttribs.removeAttribute(HTML.Attribute.CLASS);
        }
        if (this.onClickTextField.getText() != null && !this.onClickTextField.getText().trim().equals("")) {
            newAttribs.addAttribute("onclick", this.onClickTextField.getText());
        } else {
            newAttribs.removeAttribute("onclick");
        }
        return newAttribs;
    }

    public void initFileDialog(JFileChooser fileCh) {
        this.fileChooser = fileCh;
    }
}

