/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.ColorChooserDialog;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class BorderDesignPanel
extends JPanel {
    boolean okButtonPressed = false;
    HTMLEditor htmlPanel;
    Component parentDialog = this;
    AttributeSet attribs;
    Element elem;
    private JLabel topBorderColor;
    private JPanel rightBorderPanel;
    private JComboBox rightBorderStyle;
    private JComboBox rightBorderWidth;
    private JPanel topBorderPanel;
    private JButton cancelButton;
    private JLabel rightBorderColor;
    private JPanel previewPanelHolder;
    private JLabel leftBorderColor;
    private JComboBox bottomBorderWidth;
    private JComboBox topBorderStyle;
    private JComboBox topBorderWidth;
    private JPanel leftBorderPanel;
    private JComboBox leftBorderStyle;
    private JComboBox bottomBorderStyle;
    private JPanel bottomBorderPanel;
    private JComboBox leftBorderWidth;
    private JLabel bottomBorderColor;
    private JButton okButton;

    public BorderDesignPanel() {
        this.initComponents();
        this.previewPanelHolder.add((Component)new previewPanel(), "Center");
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.leftBorderPanel = new JPanel();
        this.leftBorderColor = new JLabel();
        this.leftBorderStyle = new JComboBox();
        this.leftBorderWidth = new JComboBox();
        this.topBorderPanel = new JPanel();
        this.topBorderColor = new JLabel();
        this.topBorderStyle = new JComboBox();
        this.topBorderWidth = new JComboBox();
        this.rightBorderPanel = new JPanel();
        this.rightBorderStyle = new JComboBox();
        this.rightBorderWidth = new JComboBox();
        this.rightBorderColor = new JLabel();
        this.bottomBorderPanel = new JPanel();
        this.bottomBorderStyle = new JComboBox();
        this.bottomBorderWidth = new JComboBox();
        this.bottomBorderColor = new JLabel();
        this.previewPanelHolder = new JPanel();
        this.setLayout(null);
        this.setBorder(new TitledBorder("Borders"));
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BorderDesignPanel.this.okButtonActionPerformed(evt);
            }
        });
        this.add(this.okButton);
        this.okButton.setBounds(140, 240, 100, 26);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BorderDesignPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.add(this.cancelButton);
        this.cancelButton.setBounds(250, 240, 90, 26);
        this.leftBorderPanel.setLayout(null);
        this.leftBorderPanel.setBorder(new TitledBorder("Left Border"));
        this.leftBorderColor.setOpaque(true);
        this.leftBorderColor.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                BorderDesignPanel.this.leftBorderColorMouseReleased(evt);
            }
        });
        this.leftBorderPanel.add(this.leftBorderColor);
        this.leftBorderColor.setBounds(20, 90, 60, 23);
        this.leftBorderStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"solid", "dotted", "dashed", "double", "groove", "ridge", "inset", "outset", "none"}));
        this.leftBorderStyle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderDesignPanel.this.leftBorderStyleItemStateChanged(evt);
            }
        });
        this.leftBorderPanel.add(this.leftBorderStyle);
        this.leftBorderStyle.setBounds(20, 30, 60, 25);
        this.leftBorderWidth.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "20", "30", "50"}));
        this.leftBorderWidth.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderDesignPanel.this.leftBorderWidthItemStateChanged(evt);
            }
        });
        this.leftBorderPanel.add(this.leftBorderWidth);
        this.leftBorderWidth.setBounds(20, 60, 60, 25);
        this.add(this.leftBorderPanel);
        this.leftBorderPanel.setBounds(10, 50, 100, 130);
        this.topBorderPanel.setLayout(null);
        this.topBorderPanel.setBorder(new TitledBorder("Top Border"));
        this.topBorderPanel.setToolTipText("null");
        this.topBorderColor.setOpaque(true);
        this.topBorderColor.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                BorderDesignPanel.this.topBorderColorMouseReleased(evt);
            }
        });
        this.topBorderPanel.add(this.topBorderColor);
        this.topBorderColor.setBounds(170, 20, 60, 23);
        this.topBorderStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"solid", "dotted", "dashed", "double", "groove", "ridge", "inset", "outset", "none"}));
        this.topBorderStyle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderDesignPanel.this.topBorderStyleItemStateChanged(evt);
            }
        });
        this.topBorderPanel.add(this.topBorderStyle);
        this.topBorderStyle.setBounds(30, 20, 60, 25);
        this.topBorderWidth.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "20", "30", "50"}));
        this.topBorderWidth.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderDesignPanel.this.topBorderWidthItemStateChanged(evt);
            }
        });
        this.topBorderPanel.add(this.topBorderWidth);
        this.topBorderWidth.setBounds(100, 20, 60, 25);
        this.add(this.topBorderPanel);
        this.topBorderPanel.setBounds(120, 10, 240, 60);
        this.rightBorderPanel.setLayout(null);
        this.rightBorderPanel.setBorder(new TitledBorder("Right Border"));
        this.rightBorderStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"solid", "dotted", "dashed", "double", "groove", "ridge", "inset", "outset", "none"}));
        this.rightBorderStyle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderDesignPanel.this.rightBorderStyleItemStateChanged(evt);
            }
        });
        this.rightBorderPanel.add(this.rightBorderStyle);
        this.rightBorderStyle.setBounds(20, 30, 60, 25);
        this.rightBorderWidth.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "20", "30", "50"}));
        this.rightBorderWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BorderDesignPanel.this.rightBorderWidthActionPerformed(evt);
            }
        });
        this.rightBorderWidth.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderDesignPanel.this.rightBorderWidthItemStateChanged(evt);
            }
        });
        this.rightBorderPanel.add(this.rightBorderWidth);
        this.rightBorderWidth.setBounds(20, 60, 60, 25);
        this.rightBorderColor.setOpaque(true);
        this.rightBorderColor.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                BorderDesignPanel.this.rightBorderColorMouseReleased(evt);
            }
        });
        this.rightBorderPanel.add(this.rightBorderColor);
        this.rightBorderColor.setBounds(20, 90, 60, 23);
        this.add(this.rightBorderPanel);
        this.rightBorderPanel.setBounds(370, 50, 100, 130);
        this.bottomBorderPanel.setLayout(null);
        this.bottomBorderPanel.setBorder(new TitledBorder("Bottom Border"));
        this.bottomBorderStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"solid", "dotted", "dashed", "double", "groove", "ridge", "inset", "outset", "none"}));
        this.bottomBorderStyle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderDesignPanel.this.bottomBorderStyleItemStateChanged(evt);
            }
        });
        this.bottomBorderPanel.add(this.bottomBorderStyle);
        this.bottomBorderStyle.setBounds(20, 30, 60, 25);
        this.bottomBorderWidth.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "20", "30", "50"}));
        this.bottomBorderWidth.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BorderDesignPanel.this.bottomBorderWidthItemStateChanged(evt);
            }
        });
        this.bottomBorderPanel.add(this.bottomBorderWidth);
        this.bottomBorderWidth.setBounds(90, 30, 60, 25);
        this.bottomBorderColor.setOpaque(true);
        this.bottomBorderColor.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                BorderDesignPanel.this.bottomBorderColorMouseReleased(evt);
            }
        });
        this.bottomBorderPanel.add(this.bottomBorderColor);
        this.bottomBorderColor.setBounds(160, 30, 60, 23);
        this.add(this.bottomBorderPanel);
        this.bottomBorderPanel.setBounds(120, 160, 240, 70);
        this.previewPanelHolder.setLayout(new BorderLayout());
        this.previewPanelHolder.setBorder(new TitledBorder("Preview"));
        this.add(this.previewPanelHolder);
        this.previewPanelHolder.setBounds(130, 80, 220, 70);
    }

    private void leftBorderColorMouseReleased(MouseEvent evt) {
        this.showColorDialog((JLabel)evt.getSource());
        if (this.attribs != null) {
            ((MutableAttributeSet)this.attribs).addAttribute("border-left-color", this.leftBorderColor.getText());
            this.setPreview(this.attribs);
        }
    }

    private void bottomBorderColorMouseReleased(MouseEvent evt) {
        this.showColorDialog((JLabel)evt.getSource());
        if (this.attribs != null) {
            ((MutableAttributeSet)this.attribs).addAttribute("border-bottom-color", this.bottomBorderColor.getText());
            this.setPreview(this.attribs);
        }
    }

    private void rightBorderColorMouseReleased(MouseEvent evt) {
        this.showColorDialog((JLabel)evt.getSource());
        if (this.attribs != null) {
            ((MutableAttributeSet)this.attribs).addAttribute("border-right-color", this.rightBorderColor.getText());
            this.setPreview(this.attribs);
        }
    }

    private void topBorderColorMouseReleased(MouseEvent evt) {
        this.showColorDialog((JLabel)evt.getSource());
        if (this.attribs != null) {
            ((MutableAttributeSet)this.attribs).addAttribute("border-top-color", this.topBorderColor.getText());
            this.setPreview(this.attribs);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.okButtonPressed = false;
        this.parentDialog.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.okButtonPressed = true;
        this.parentDialog.setVisible(false);
    }

    private void leftBorderStyleItemStateChanged(ItemEvent evt) {
        if (this.attribs != null) {
            if (evt.getStateChange() == 1) {
                ((MutableAttributeSet)this.attribs).addAttribute("border-left-style", this.leftBorderStyle.getSelectedItem().toString());
                this.setPreview(this.attribs);
            }
        }
    }

    private void leftBorderWidthItemStateChanged(ItemEvent evt) {
        if (this.attribs != null) {
            ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute((MutableAttributeSet)this.attribs, CSS.Attribute.BORDER_LEFT_WIDTH, this.leftBorderWidth.getSelectedItem().toString());
            this.setPreview(this.attribs);
        }
    }

    private void bottomBorderStyleItemStateChanged(ItemEvent evt) {
        if (this.attribs != null) {
            if (evt.getStateChange() == 1) {
                ((MutableAttributeSet)this.attribs).addAttribute("border-bottom-style", this.bottomBorderStyle.getSelectedItem().toString());
                this.setPreview(this.attribs);
            }
        }
    }

    private void bottomBorderWidthItemStateChanged(ItemEvent evt) {
        if (this.attribs != null) {
            if (evt.getStateChange() == 1) {
                ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute((MutableAttributeSet)this.attribs, CSS.Attribute.BORDER_BOTTOM_WIDTH, this.bottomBorderWidth.getSelectedItem().toString());
                this.setPreview(this.attribs);
            }
        }
    }

    private void rightBorderWidthItemStateChanged(ItemEvent evt) {
        if (this.attribs != null) {
            if (evt.getStateChange() == 1) {
                ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute((MutableAttributeSet)this.attribs, CSS.Attribute.BORDER_RIGHT_WIDTH, this.rightBorderWidth.getSelectedItem().toString());
                this.setPreview(this.attribs);
            }
        }
    }

    private void rightBorderStyleItemStateChanged(ItemEvent evt) {
        if (this.attribs != null) {
            if (evt.getStateChange() == 1) {
                ((MutableAttributeSet)this.attribs).addAttribute("border-right-style", this.rightBorderStyle.getSelectedItem().toString());
                this.setPreview(this.attribs);
            }
        }
    }

    private void topBorderWidthItemStateChanged(ItemEvent evt) {
        if (this.attribs != null) {
            if (evt.getStateChange() == 1) {
                ((HTMLDocument)this.htmlPanel.getInternalJEditorPane().getDocument()).getStyleSheet().addCSSAttribute((MutableAttributeSet)this.attribs, CSS.Attribute.BORDER_TOP_WIDTH, this.topBorderWidth.getSelectedItem().toString());
                this.setPreview(this.attribs);
            }
        }
    }

    private void topBorderStyleItemStateChanged(ItemEvent evt) {
        if (this.attribs != null) {
            if (evt.getStateChange() == 1) {
                ((MutableAttributeSet)this.attribs).addAttribute("border-top-style", this.topBorderStyle.getSelectedItem().toString());
                this.setPreview(this.attribs);
            }
        }
    }

    private void rightBorderWidthActionPerformed(ActionEvent evt) {
    }

    public void setElement(Element e) {
        this.okButtonPressed = false;
        this.elem = e;
    }

    public void setPreview(AttributeSet as) {
        this.attribs = as.copyAttributes();
        this.previewPanelHolder.repaint();
    }

    public void setTopBorderValues(int size, String style, Color color) {
        this.topBorderWidth.setSelectedItem(size + "");
        this.topBorderStyle.setSelectedItem(style);
        this.topBorderColor.setBackground(color);
        if (color == null || color.getAlpha() == 0) {
            this.topBorderColor.setBackground(Color.black);
            this.topBorderColor.setOpaque(true);
        } else {
            this.topBorderColor.setBackground(color);
        }
    }

    public void setBottomBorderValues(int size, String style, Color color) {
        this.bottomBorderWidth.setSelectedItem(size + "");
        this.bottomBorderStyle.setSelectedItem(style);
        this.bottomBorderColor.setBackground(color);
        if (color == null || color.getAlpha() == 0) {
            this.bottomBorderColor.setBackground(Color.black);
            this.bottomBorderColor.setOpaque(true);
        } else {
            this.bottomBorderColor.setBackground(color);
        }
    }

    public void setLeftBorderValues(int size, String style, Color color) {
        this.leftBorderWidth.setSelectedItem(size + "");
        this.leftBorderStyle.setSelectedItem(style);
        this.leftBorderColor.setBackground(color);
        if (color == null || color.getAlpha() == 0) {
            this.leftBorderColor.setBackground(Color.black);
            this.leftBorderColor.setOpaque(true);
        } else {
            this.leftBorderColor.setBackground(color);
        }
    }

    public void setRightBorderValues(int size, String style, Color color) {
        this.rightBorderWidth.setSelectedItem(size + "");
        this.rightBorderStyle.setSelectedItem(style);
        if (color == null || color.getAlpha() == 0) {
            this.rightBorderColor.setBackground(Color.black);
            this.rightBorderColor.setOpaque(true);
        } else {
            this.rightBorderColor.setBackground(color);
        }
    }

    void showColorDialog(JLabel borderColorPreviewLabel) {
        if (this.htmlPanel.colorChooserDialog == null) {
            this.htmlPanel.colorChooserDialog = SwingUtilities.windowForComponent(this.htmlPanel) instanceof Frame ? new ColorChooserDialog((Frame)SwingUtilities.windowForComponent(this.htmlPanel), true, this.htmlPanel.getTranslatedString("Choose Border Color")) : new ColorChooserDialog((Dialog)SwingUtilities.windowForComponent(this.htmlPanel), true, this.htmlPanel.getTranslatedString("Choose Border Color"));
        }
        this.htmlPanel.colorChooserDialog.setTitle(this.htmlPanel.getTranslatedString("Choose Border Color"));
        if (borderColorPreviewLabel.isOpaque()) {
            this.htmlPanel.colorChooserDialog.setSelectedColor(borderColorPreviewLabel.getBackground());
        } else {
            this.htmlPanel.colorChooserDialog.setSelectedColor(null);
        }
        this.htmlPanel.translateContainer(this.htmlPanel.colorChooserDialog);
        this.htmlPanel.colorChooserDialog.setVisible(true);
        int result = this.htmlPanel.colorChooserDialog.getActionResult();
        ColorChooserDialog cfr_ignored_0 = this.htmlPanel.colorChooserDialog;
        if (result == ColorChooserDialog.OK_BUTTON) {
            Color newColor = this.htmlPanel.colorChooserDialog.getSelectedColor();
            if (newColor == null) {
                return;
            }
            borderColorPreviewLabel.setBackground(newColor);
            borderColorPreviewLabel.setOpaque(true);
            borderColorPreviewLabel.setText(this.htmlPanel.colorToString(newColor));
        }
    }

    class previewPanel
    extends JPanel {
        previewPanel() {
        }

        public void paint(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Rectangle childRect = new Rectangle(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            g.setClip(childRect.x, childRect.y, childRect.width + 1, childRect.height + 1);
            if (BorderDesignPanel.this.attribs != null && BorderDesignPanel.this.elem != null) {
                Stroke stroke;
                String style;
                Stroke origStroke;
                int bottomBorderWidth = SferyxUtilities.getCellBottomBorderSize(BorderDesignPanel.this.attribs, BorderDesignPanel.this.elem);
                int topBorderWidth = SferyxUtilities.getCellTopBorderSize(BorderDesignPanel.this.attribs, BorderDesignPanel.this.elem);
                int rightBorderWidth = SferyxUtilities.getCellRightBorderSize(BorderDesignPanel.this.attribs, BorderDesignPanel.this.elem);
                int leftBorderWidth = SferyxUtilities.getCellLeftBorderSize(BorderDesignPanel.this.attribs, BorderDesignPanel.this.elem);
                String st = SferyxUtilities.getBottomBorderStyle(BorderDesignPanel.this.attribs);
                if (bottomBorderWidth < 0 && st != null && !st.trim().equals("") && !st.trim().equalsIgnoreCase("none")) {
                    bottomBorderWidth = 2;
                }
                if (st != null && st.equalsIgnoreCase("none")) {
                    bottomBorderWidth = 0;
                }
                if (bottomBorderWidth > 0) {
                    origStroke = ((Graphics2D)g).getStroke();
                    g.setColor(SferyxUtilities.getBottomBorderColor(BorderDesignPanel.this.elem, BorderDesignPanel.this.attribs));
                    style = SferyxUtilities.getBottomBorderStyle(BorderDesignPanel.this.attribs);
                    stroke = origStroke;
                    stroke = SferyxUtilities.getBorderStroke(stroke, bottomBorderWidth, style);
                    ((Graphics2D)g).setStroke(stroke);
                    ((Graphics2D)g).drawLine(childRect.x, childRect.y + childRect.height - bottomBorderWidth / 2, childRect.x + childRect.width, childRect.y + childRect.height - bottomBorderWidth / 2);
                }
                st = SferyxUtilities.getTopBorderStyle(BorderDesignPanel.this.attribs);
                if (topBorderWidth < 0 && st != null && !st.trim().equals("") && !st.trim().equalsIgnoreCase("none")) {
                    topBorderWidth = 2;
                }
                if (st != null && st.equalsIgnoreCase("none")) {
                    topBorderWidth = 0;
                }
                if (topBorderWidth > 0) {
                    origStroke = ((Graphics2D)g).getStroke();
                    g.setColor(SferyxUtilities.getTopBorderColor(BorderDesignPanel.this.elem, BorderDesignPanel.this.attribs));
                    style = SferyxUtilities.getTopBorderStyle(BorderDesignPanel.this.attribs);
                    stroke = origStroke;
                    stroke = SferyxUtilities.getBorderStroke(stroke, topBorderWidth, style);
                    ((Graphics2D)g).setStroke(stroke);
                    ((Graphics2D)g).drawLine(childRect.x, childRect.y + topBorderWidth / 2, childRect.x + childRect.width, childRect.y + topBorderWidth / 2);
                }
                st = SferyxUtilities.getRightBorderStyle(BorderDesignPanel.this.attribs);
                if (rightBorderWidth < 0 && st != null && !st.trim().equals("") && !st.trim().equalsIgnoreCase("none")) {
                    rightBorderWidth = 2;
                }
                if (st != null && st.equalsIgnoreCase("none")) {
                    rightBorderWidth = 0;
                }
                if (rightBorderWidth > 0) {
                    origStroke = ((Graphics2D)g).getStroke();
                    g.setColor(SferyxUtilities.getRightBorderColor(BorderDesignPanel.this.elem, BorderDesignPanel.this.attribs));
                    style = SferyxUtilities.getRightBorderStyle(BorderDesignPanel.this.attribs);
                    stroke = origStroke;
                    stroke = SferyxUtilities.getBorderStroke(stroke, rightBorderWidth, style);
                    ((Graphics2D)g).setStroke(stroke);
                    ((Graphics2D)g).drawLine(childRect.x + childRect.width - rightBorderWidth / 2, childRect.y, childRect.x + childRect.width - rightBorderWidth / 2, childRect.y + childRect.height);
                }
                st = SferyxUtilities.getLeftBorderStyle(BorderDesignPanel.this.attribs);
                if (leftBorderWidth < 0 && st != null && !st.trim().equals("") && !st.trim().equalsIgnoreCase("none")) {
                    leftBorderWidth = 2;
                }
                if (st != null && st.equalsIgnoreCase("none")) {
                    leftBorderWidth = 0;
                }
                if (leftBorderWidth > 0) {
                    origStroke = ((Graphics2D)g).getStroke();
                    g.setColor(SferyxUtilities.getLeftBorderColor(BorderDesignPanel.this.elem, BorderDesignPanel.this.attribs));
                    style = SferyxUtilities.getLeftBorderStyle(BorderDesignPanel.this.attribs);
                    stroke = origStroke;
                    stroke = SferyxUtilities.getBorderStroke(stroke, leftBorderWidth, style);
                    ((Graphics2D)g).setStroke(stroke);
                    ((Graphics2D)g).drawLine(childRect.x + leftBorderWidth / 2, childRect.y, childRect.x + leftBorderWidth / 2, childRect.y + childRect.height);
                }
            }
        }
    }
}

