/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import sferyx.administration.editors.BorderDesignPanel;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.SferyxUtilities;

public class BorderDesignDialog
extends JDialog {
    BorderDesignPanel borderDesignPanel = new BorderDesignPanel();
    HTMLEditor htmlPanel;

    public BorderDesignDialog(Frame parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.setResizable(false);
        this.getContentPane().add((Component)this.borderDesignPanel, "Center");
        this.borderDesignPanel.parentDialog = this;
    }

    public BorderDesignDialog(Dialog parent, boolean modal) {
        super(parent, true);
        this.initComponents();
        this.getContentPane().add((Component)this.borderDesignPanel, "Center");
        this.setResizable(false);
        this.borderDesignPanel.parentDialog = this;
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                BorderDesignDialog.this.closeDialog(evt);
            }
        });
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void initDialogFields(AttributeSet attribs, Element elem) {
        int topSize = SferyxUtilities.getCellTopBorderSize(attribs, elem);
        String topStyle = SferyxUtilities.getTopBorderStyle(attribs);
        Color topColor = SferyxUtilities.getTopBorderColor(elem, attribs);
        int rightSize = SferyxUtilities.getCellRightBorderSize(attribs, elem);
        String rightStyle = SferyxUtilities.getRightBorderStyle(attribs);
        Color rightColor = SferyxUtilities.getRightBorderColor(elem, attribs);
        int leftSize = SferyxUtilities.getCellLeftBorderSize(attribs, elem);
        String leftStyle = SferyxUtilities.getLeftBorderStyle(attribs);
        Color leftColor = SferyxUtilities.getLeftBorderColor(elem, attribs);
        int bottomSize = SferyxUtilities.getCellBottomBorderSize(attribs, elem);
        String bottomStyle = SferyxUtilities.getBottomBorderStyle(attribs);
        Color bottomColor = SferyxUtilities.getBottomBorderColor(elem, attribs);
        this.borderDesignPanel.setTopBorderValues(topSize, topStyle, topColor);
        this.borderDesignPanel.setBottomBorderValues(bottomSize, bottomStyle, bottomColor);
        this.borderDesignPanel.setLeftBorderValues(leftSize, leftStyle, leftColor);
        this.borderDesignPanel.setRightBorderValues(rightSize, rightStyle, rightColor);
        SimpleAttributeSet sas = new SimpleAttributeSet(attribs);
        this.borderDesignPanel.setElement(elem);
        this.borderDesignPanel.setPreview(sas);
    }

    public AttributeSet getNewAttributes() {
        if (!this.borderDesignPanel.okButtonPressed) {
            return null;
        }
        return this.borderDesignPanel.attribs;
    }

    public void setHTMLEditor(HTMLEditor editor) {
        this.borderDesignPanel.htmlPanel = editor;
        this.htmlPanel = editor;
    }

    public static void main(String[] args) {
        new BorderDesignDialog((Frame)new JFrame(), true).show();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setSize(490, 310);
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        this.borderDesignPanel.setVisible(true);
        super.setVisible(b);
    }
}

