/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import sferyx.administration.editors.HTMLEditor;

public class BookmarkPropertiesDialog
extends JDialog {
    AttributeSet attributes;
    boolean cancel = false;
    HTMLEditor htmlPanel;
    private JScrollPane bookmarksScrollPane;
    private JButton OkButton;
    private JLabel jLabel1;
    private JLabel bookmarkLabel;
    private JPanel CenterPanel;
    private JButton CancelButton;
    private JTextField bookmarkNameTextField;
    private JList bookmarksList;
    private JPanel SouthPanel;
    private JLabel bookmarksLabel;

    public BookmarkPropertiesDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public BookmarkPropertiesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.CenterPanel = new JPanel();
        this.bookmarkLabel = new JLabel();
        this.bookmarkNameTextField = new JTextField();
        this.bookmarksScrollPane = new JScrollPane();
        this.bookmarksList = new JList();
        this.bookmarksLabel = new JLabel();
        this.SouthPanel = new JPanel();
        this.OkButton = new JButton();
        this.CancelButton = new JButton();
        this.jLabel1.setText("jLabel1");
        this.setTitle("Bookmark Properties");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                BookmarkPropertiesDialog.this.closeDialog(evt);
            }
        });
        this.CenterPanel.setLayout(null);
        this.CenterPanel.setBorder(new TitledBorder("Boomark Properties:"));
        this.bookmarkLabel.setHorizontalAlignment(4);
        this.bookmarkLabel.setText("Name:");
        this.CenterPanel.add(this.bookmarkLabel);
        this.bookmarkLabel.setBounds(10, 30, 100, 16);
        this.CenterPanel.add(this.bookmarkNameTextField);
        this.bookmarkNameTextField.setBounds(120, 27, 190, 26);
        this.bookmarksScrollPane.setViewportView(this.bookmarksList);
        this.CenterPanel.add(this.bookmarksScrollPane);
        this.bookmarksScrollPane.setBounds(120, 60, 190, 160);
        this.bookmarksLabel.setHorizontalAlignment(4);
        this.bookmarksLabel.setText("All bookmarks:");
        this.CenterPanel.add(this.bookmarksLabel);
        this.bookmarksLabel.setBounds(10, 60, 100, 16);
        this.getContentPane().add((Component)this.CenterPanel, "Center");
        this.OkButton.setText("Ok");
        this.OkButton.setPreferredSize(new Dimension(100, 26));
        this.OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarkPropertiesDialog.this.OkButtonActionPerformed(evt);
            }
        });
        this.SouthPanel.add(this.OkButton);
        this.CancelButton.setText("Cancel");
        this.CancelButton.setToolTipText("Cancel");
        this.CancelButton.setPreferredSize(new Dimension(100, 26));
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookmarkPropertiesDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.SouthPanel.add(this.CancelButton);
        this.getContentPane().add((Component)this.SouthPanel, "South");
        this.pack();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.cancel = true;
        this.dispose();
    }

    private void OkButtonActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new BookmarkPropertiesDialog((Frame)new JFrame(), true).show();
    }

    public void setBookmarks(Vector bookmarks) {
        this.bookmarksList.setModel(new DefaultComboBoxModel(bookmarks));
    }

    public void initDialogFields(AttributeSet attribs) {
        this.attributes = attribs;
        SimpleAttributeSet href = (SimpleAttributeSet)attribs.getAttribute(HTML.Tag.A);
        if (href != null) {
            String bookmarkName = (String)href.getAttribute(HTML.Attribute.NAME);
            if (bookmarkName != null && href.containsAttribute(HTML.Attribute.NAME, bookmarkName)) {
                this.bookmarkNameTextField.setText(bookmarkName);
            } else {
                this.bookmarkNameTextField.setText("");
            }
        } else {
            this.bookmarkNameTextField.setText("");
        }
        this.OkButton.requestFocus();
    }

    public AttributeSet getNewAttributes() {
        if (this.cancel) {
            return null;
        }
        SimpleAttributeSet newAttribs = new SimpleAttributeSet(this.attributes);
        MutableAttributeSet hrefSet = (MutableAttributeSet)this.attributes.getAttribute(HTML.Tag.A);
        if (hrefSet == null) {
            hrefSet = new SimpleAttributeSet();
        }
        if (!this.bookmarkNameTextField.getText().equals("") && this.bookmarkNameTextField.getText() != null) {
            hrefSet.addAttribute(HTML.Attribute.NAME, this.bookmarkNameTextField.getText());
            newAttribs.addAttribute(HTML.Tag.A, hrefSet);
            if (!this.htmlPanel.bookmarks.contains(this.bookmarkNameTextField.getText())) {
                this.htmlPanel.bookmarks.addElement(this.bookmarkNameTextField.getText());
            }
        } else {
            Object attributeValue = hrefSet.getAttribute(HTML.Attribute.NAME);
            hrefSet.removeAttribute(HTML.Attribute.NAME);
            if (attributeValue != null) {
                this.htmlPanel.bookmarks.removeElement(attributeValue);
            }
        }
        return newAttribs;
    }

    public void setVisible(boolean b) {
        this.setSize(370, 310);
        if (b) {
            this.setLocation((int)((double)this.getParent().getLocationOnScreen().x + this.getParent().getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0), (int)((double)this.getParent().getLocationOnScreen().y + this.getParent().getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0));
        }
        super.setVisible(b);
        if (b) {
            this.bookmarkNameTextField.requestFocus();
        }
    }

    public void setHtmlPanel(HTMLEditor html_Panel) {
        this.htmlPanel = html_Panel;
    }
}

