/*
 * Decompiled with CFR 0.152.
 */
package sferyx.administration.editors;

import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sferyx.administration.editors.AlternativeCSSAttribute;
import sferyx.administration.editors.EditorHTMLDocument;
import sferyx.administration.editors.ExternalCustomStyleSheet;
import sferyx.administration.editors.HTMLEditor;
import sferyx.administration.editors.HiddenValue;
import sferyx.administration.editors.RubyTag;
import sferyx.administration.editors.SferyxUtilities;
import sferyx.administration.editors.XHTMLWriter;

public class AttributeSetTranslator {
    HTMLDocument doc;
    private boolean writeCSS = false;
    MutableAttributeSet convAttr = new SimpleAttributeSet();
    MutableAttributeSet oConvAttr = new SimpleAttributeSet();

    public AttributeSet convertToHTML(AttributeSet from, MutableAttributeSet to) {
        if (to == null) {
            to = this.convAttr;
        }
        to.removeAttributes(to);
        if (HTMLEditor.isForcedSpanGeneration()) {
            this.convertToHTML40(from, to);
        } else {
            to = this.convertToHTML32(from, (MutableAttributeSet)to.copyAttributes());
        }
        return to;
    }

    public static boolean isFontAttributesAlreadyDefined(AttributeSet from, Object key) {
        boolean defined = false;
        if (from.isDefined(HTML.Tag.SPAN) && ((AttributeSet)from.getAttribute(HTML.Tag.SPAN)).containsAttribute(key, from.getAttribute(key))) {
            defined = true;
        }
        if (from.isDefined(RubyTag.Ruby) && ((AttributeSet)from.getAttribute(RubyTag.Ruby)).containsAttribute(key, from.getAttribute(key))) {
            defined = true;
        }
        if (from.isDefined(HTML.Tag.A) && ((AttributeSet)from.getAttribute(HTML.Tag.A)).containsAttribute(key, from.getAttribute(key))) {
            defined = true;
        }
        return defined;
    }

    public MutableAttributeSet convertToHTML32(AttributeSet from, MutableAttributeSet to) {
        if (from == null) {
            return to;
        }
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof HiddenValue) continue;
            if (key instanceof CSS.Attribute || key instanceof AlternativeCSSAttribute || XHTMLWriter.isAdditionStyleDefinition(key)) {
                if (key == CSS.Attribute.FONT_SIZE) {
                    if (from.getAttribute(key) == null) continue;
                    String htmlValue = from.getAttribute(key).toString();
                    if (!(!(!htmlValue.endsWith("pt") & !htmlValue.endsWith("px")) || htmlValue.endsWith("em") || htmlValue.endsWith("ex") || htmlValue.endsWith("%") || htmlValue.trim().equals("xx-small") || htmlValue.trim().equals("x-small") || htmlValue.trim().equals("small") || htmlValue.trim().equals("medium") || htmlValue.trim().equals("large") || htmlValue.trim().equals("x-large") || htmlValue.trim().equals("xx-large"))) {
                        if (HTMLEditor.jvm_version.startsWith("1.3")) {
                            value = value + " font-size:" + this.doc.getStyleSheet().getFont(from).getSize() + "px" + ";";
                            continue;
                        }
                        value = value + " font-size:" + this.doc.getStyleSheet().getFont(from).getSize() + "px" + ";";
                        continue;
                    }
                    value = value + " font-size:" + htmlValue + ";";
                    continue;
                }
                if (key == CSS.Attribute.FONT_WEIGHT) {
                    Object weightValue = from.getAttribute(CSS.Attribute.FONT_WEIGHT);
                    if (weightValue != null && !weightValue.toString().equals("normal")) {
                        if (weightValue.toString().equalsIgnoreCase("bold") || weightValue.toString().equalsIgnoreCase("bolder") || weightValue.toString().equalsIgnoreCase("boldest")) {
                            AttributeSetTranslator.addAttribute(to, HTML.Tag.B, SimpleAttributeSet.EMPTY);
                            continue;
                        }
                        value = value + " " + key + ":" + from.getAttribute(key) + ";";
                        continue;
                    }
                    if (weightValue == null || !weightValue.toString().equals("normal") || !from.isDefined(CSS.Attribute.FONT_WEIGHT)) continue;
                    value = value + " " + key + ":" + from.getAttribute(key) + ";";
                    continue;
                }
                if (key == CSS.Attribute.FONT_STYLE) {
                    String s = from.getAttribute(key).toString();
                    if (s.indexOf("italic") < 0) continue;
                    AttributeSetTranslator.addAttribute(to, HTML.Tag.I, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == CSS.Attribute.TEXT_DECORATION) {
                    String decor = from.getAttribute(key).toString();
                    if (decor.indexOf("underline") >= 0) {
                        AttributeSetTranslator.addAttribute(to, HTML.Tag.U, SimpleAttributeSet.EMPTY);
                    }
                    if (decor.indexOf("line-through") < 0) continue;
                    AttributeSetTranslator.addAttribute(to, HTML.Tag.STRIKE, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == CSS.Attribute.VERTICAL_ALIGN) {
                    String vAlign = from.getAttribute(key).toString();
                    if (vAlign.indexOf("sup") >= 0) {
                        AttributeSetTranslator.addAttribute(to, HTML.Tag.SUP, SimpleAttributeSet.EMPTY);
                    }
                    if (vAlign.indexOf("sub") < 0) continue;
                    AttributeSetTranslator.addAttribute(to, HTML.Tag.SUB, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == CSS.Attribute.TEXT_ALIGN && from.isDefined(HTML.Attribute.ALIGN)) {
                    AttributeSetTranslator.addAttribute(to, HTML.Attribute.ALIGN, from.getAttribute(key).toString());
                    continue;
                }
                if (from.getAttribute(key) == null || from.getAttribute(key).toString() == null || from.getAttribute(key).toString().equals("")) continue;
                value = value + " " + key + ":" + from.getAttribute(key) + ";";
                continue;
            }
            if (key == HTML.Tag.FONT && from.getAttribute(key) != null && from.getAttribute(key) instanceof AttributeSet) {
                AttributeSet fontAttribs = (AttributeSet)from.getAttribute(key);
                SimpleAttributeSet differentFontAttributes = new SimpleAttributeSet();
                Enumeration<?> keysF = fontAttribs.getAttributeNames();
                while (keysF.hasMoreElements()) {
                    Object keyF = keysF.nextElement();
                    if (key instanceof HiddenValue) continue;
                    if (keyF instanceof CSS.Attribute || key instanceof AlternativeCSSAttribute) {
                        if (keyF == CSS.Attribute.FONT_SIZE) {
                            if (fontAttribs.getAttribute(keyF) == null) continue;
                            String htmlValue = fontAttribs.getAttribute(keyF).toString();
                            if (!(!(!htmlValue.endsWith("pt") & !htmlValue.endsWith("px")) || htmlValue.endsWith("em") || htmlValue.endsWith("%") || htmlValue.trim().equals("xx-small") || htmlValue.trim().equals("x-small") || htmlValue.trim().equals("small") || htmlValue.trim().equals("medium") || htmlValue.trim().equals("large") || htmlValue.trim().equals("x-large") || htmlValue.trim().equals("xx-large"))) {
                                if (HTMLEditor.jvm_version.startsWith("1.3")) {
                                    value = value + " font-size:" + this.doc.getStyleSheet().getFont(fontAttribs).getSize() + "px" + ";";
                                    continue;
                                }
                                value = value + " font-size:" + this.doc.getStyleSheet().getFont(fontAttribs).getSize() + "px" + ";";
                                continue;
                            }
                            value = value + " font-size:" + htmlValue + ";";
                            continue;
                        }
                        value = value + " " + keyF + ":" + fontAttribs.getAttribute(keyF) + ";";
                        continue;
                    }
                    if (keyF == HTML.Attribute.COLOR || keyF == HTML.Attribute.SIZE || keyF == HTML.Attribute.FACE || keyF == EditorHTMLDocument.sferyxInternalEmbeddedTagsCount) continue;
                    differentFontAttributes.addAttribute(keyF, fontAttribs.getAttribute(keyF));
                }
                if (differentFontAttributes.isEmpty()) continue;
                to.addAttribute(HTML.Tag.FONT, differentFontAttributes);
                continue;
            }
            if (key != HTML.Tag.B && key != HTML.Tag.I && key != HTML.Tag.U) {
                if (key instanceof AlternativeCSSAttribute || key instanceof String && (key.toString().equalsIgnoreCase("width") || key.toString().equalsIgnoreCase("height"))) continue;
                to.addAttribute(key, from.getAttribute(key));
                continue;
            }
            if (from.getAttribute(key) == null || !(from.getAttribute(key) instanceof AttributeSet) || ((AttributeSet)from.getAttribute(key)).getAttributeCount() <= 0) continue;
            to.addAttribute(key, from.getAttribute(key));
        }
        if (value.length() > 0) {
            MutableAttributeSet sas;
            if (!SferyxUtilities.matchNameAttribute(from, HTML.Tag.CONTENT)) {
                if (from.getAttribute(HTML.Tag.SPAN) != null) {
                    sas = this.convertToHTML32((MutableAttributeSet)from.getAttribute(HTML.Tag.SPAN), new SimpleAttributeSet());
                    to.addAttribute(HTML.Tag.SPAN, sas);
                    to.addAttribute(HTML.Attribute.STYLE, value.trim());
                } else if (!value.trim().equals("")) {
                    to.addAttribute(HTML.Attribute.STYLE, value.trim());
                }
            } else {
                sas = new SimpleAttributeSet();
                ((SimpleAttributeSet)sas).addAttribute(HTML.Attribute.STYLE, value.trim());
                if (from.getAttribute(HTML.Tag.SPAN) != null) {
                    MutableAttributeSet nsas = this.convertToHTML32((MutableAttributeSet)from.getAttribute(HTML.Tag.SPAN), new SimpleAttributeSet());
                    if (nsas.getAttribute(HTML.Attribute.STYLE) != null) {
                        value = value + ";" + (String)nsas.getAttribute(HTML.Attribute.STYLE);
                        ((SimpleAttributeSet)sas).addAttributes(nsas);
                        ((SimpleAttributeSet)sas).addAttribute(HTML.Attribute.STYLE, value.trim());
                    } else {
                        ((SimpleAttributeSet)sas).addAttributes(nsas);
                    }
                    to.addAttribute(HTML.Tag.SPAN, sas);
                } else {
                    to.addAttribute(HTML.Tag.SPAN, sas);
                }
            }
        }
        return to;
    }

    public static MutableAttributeSet convertToHTML32_orig(AttributeSet from, MutableAttributeSet to) {
        if (from == null) {
            return to;
        }
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            MutableAttributeSet sas;
            Object key = keys.nextElement();
            if (key instanceof CSS.Attribute || key instanceof AlternativeCSSAttribute) {
                if (key == CSS.Attribute.FONT_FAMILY || key == CSS.Attribute.FONT_SIZE || key == CSS.Attribute.COLOR) {
                    if (from == null || from.getAttribute(StyleConstants.NameAttribute) instanceof HTML.UnknownTag) continue;
                    if (!AttributeSetTranslator.isFontAttributesAlreadyDefined(from, key) || from.getAttribute(HTML.Tag.FONT) == null) {
                        AttributeSetTranslator.createFontAttribute((CSS.Attribute)key, from, to);
                        continue;
                    }
                    if (from.getAttribute(HTML.Tag.FONT) != null) {
                        to.addAttribute(HTML.Tag.FONT, from.getAttribute(HTML.Tag.FONT));
                        continue;
                    }
                    sas = (MutableAttributeSet)((AttributeSet)from.getAttribute(HTML.Tag.SPAN)).copyAttributes();
                    sas.addAttribute(key, from.getAttribute(key));
                    if (to.getAttribute(HTML.Tag.SPAN) == null) {
                        to.addAttribute(HTML.Tag.SPAN, sas);
                        continue;
                    }
                    MutableAttributeSet spanset = (MutableAttributeSet)to.getAttribute(HTML.Tag.SPAN);
                    sas.addAttributes(spanset);
                    to.addAttribute(HTML.Tag.SPAN, sas);
                    continue;
                }
                if (key == CSS.Attribute.FONT_WEIGHT) {
                    Object weightValue = from.getAttribute(CSS.Attribute.FONT_WEIGHT);
                    if (weightValue == null || weightValue.toString().equals("normal")) continue;
                    AttributeSetTranslator.addAttribute(to, HTML.Tag.B, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == CSS.Attribute.FONT_STYLE) {
                    String s = from.getAttribute(key).toString();
                    if (s.indexOf("italic") < 0) continue;
                    AttributeSetTranslator.addAttribute(to, HTML.Tag.I, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == CSS.Attribute.TEXT_DECORATION) {
                    String decor = from.getAttribute(key).toString();
                    if (decor.indexOf("underline") >= 0) {
                        AttributeSetTranslator.addAttribute(to, HTML.Tag.U, SimpleAttributeSet.EMPTY);
                    }
                    if (decor.indexOf("line-through") < 0) continue;
                    AttributeSetTranslator.addAttribute(to, HTML.Tag.STRIKE, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == CSS.Attribute.VERTICAL_ALIGN) {
                    String vAlign = from.getAttribute(key).toString();
                    if (vAlign.indexOf("sup") >= 0) {
                        AttributeSetTranslator.addAttribute(to, HTML.Tag.SUP, SimpleAttributeSet.EMPTY);
                    }
                    if (vAlign.indexOf("sub") < 0) continue;
                    AttributeSetTranslator.addAttribute(to, HTML.Tag.SUB, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (key == CSS.Attribute.TEXT_ALIGN && from.isDefined(HTML.Attribute.ALIGN)) {
                    AttributeSetTranslator.addAttribute(to, HTML.Attribute.ALIGN, from.getAttribute(key).toString());
                    continue;
                }
                if (from.getAttribute(key) == null || from.getAttribute(key).toString() == null) continue;
                if (value.length() > 0) {
                    value = value + "; ";
                }
                if (from.getAttribute(key) == null) continue;
                value = value + key + ": " + from.getAttribute(key);
                continue;
            }
            if (key.toString().equalsIgnoreCase("visibility")) {
                if (value.length() > 0) {
                    value = value + "; ";
                }
                if (from.getAttribute(key) == null) continue;
                value = value + key + ": " + from.getAttribute(key);
                continue;
            }
            if (key instanceof HTML.Tag && from.getAttribute(key) instanceof AttributeSet && key == HTML.Tag.FONT) {
                if (from.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.SCRIPT || from.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.COMMENT || from == null || from.getAttribute(StyleConstants.NameAttribute) instanceof HTML.UnknownTag) continue;
                sas = new SimpleAttributeSet();
                to.addAttribute(HTML.Tag.FONT, from.getAttribute(key));
                continue;
            }
            if (from.getAttribute(key) == null || from.getAttribute(key).toString() == null) continue;
            to.addAttribute(key, from.getAttribute(key));
        }
        if (value.length() > 0 && !SferyxUtilities.matchNameAttribute(from, HTML.Tag.SCRIPT)) {
            to.addAttribute(HTML.Attribute.STYLE, value);
            if (to.getAttribute(HTML.Tag.SPAN) != null && to.getAttribute(HTML.Tag.SPAN) instanceof MutableAttributeSet) {
                ((MutableAttributeSet)to.getAttribute(HTML.Tag.SPAN)).addAttribute(HTML.Attribute.STYLE, value);
            } else if (to.getAttribute(HTML.Tag.SPAN) == null && SferyxUtilities.matchNameAttribute(to, HTML.Tag.CONTENT)) {
                SimpleAttributeSet currSpan = new SimpleAttributeSet();
                currSpan.addAttribute(HTML.Attribute.STYLE, value);
                to.addAttribute(HTML.Tag.SPAN, currSpan);
            }
        }
        return to;
    }

    private static void createFontAttribute(CSS.Attribute a, AttributeSet from, MutableAttributeSet to) {
        MutableAttributeSet fontAttr;
        block20: {
            fontAttr = (MutableAttributeSet)to.getAttribute(HTML.Tag.FONT);
            if (fontAttr == null) {
                fontAttr = new SimpleAttributeSet();
                to.addAttribute(HTML.Tag.FONT, fontAttr);
            }
            String htmlValue = from.getAttribute(a).toString();
            if (a == CSS.Attribute.FONT_FAMILY) {
                fontAttr.addAttribute(HTML.Attribute.FACE, htmlValue);
            } else if (a == CSS.Attribute.FONT_SIZE) {
                if (!(!(!htmlValue.endsWith("pt") & !htmlValue.endsWith("px")) || htmlValue.endsWith("em") || htmlValue.endsWith("%") || htmlValue.trim().equals("xx-small") || htmlValue.trim().equals("x-small") || htmlValue.trim().equals("small") || htmlValue.trim().equals("medium") || htmlValue.trim().equals("large") || htmlValue.trim().equals("x-large") || htmlValue.trim().equals("xx-large"))) {
                    try {
                        float currvalue = Float.parseFloat(htmlValue);
                        if (currvalue < 8.0f) {
                            if (HTMLEditor.jvm_version.startsWith("1.3")) {
                                fontAttr.addAttribute(HTML.Attribute.SIZE, ExternalCustomStyleSheet.getIndexOfSize(Float.parseFloat(htmlValue)) + "");
                            } else {
                                fontAttr.addAttribute(HTML.Attribute.SIZE, htmlValue);
                            }
                            break block20;
                        }
                        if (fontAttr.getAttribute(HTML.Attribute.STYLE) != null && fontAttr.isDefined(HTML.Attribute.STYLE)) {
                            String styleAttr = fontAttr.getAttribute(HTML.Attribute.STYLE).toString();
                            fontAttr.addAttribute(HTML.Attribute.STYLE, styleAttr.trim().endsWith(";") ? styleAttr + "font-size:" + htmlValue + "px" : styleAttr + ";font-size:" + htmlValue + "px");
                            break block20;
                        }
                        fontAttr.addAttribute(HTML.Attribute.STYLE, "font-size:" + htmlValue + "px");
                    }
                    catch (Throwable thr) {}
                } else if (fontAttr.getAttribute(HTML.Attribute.STYLE) != null && fontAttr.isDefined(HTML.Attribute.STYLE)) {
                    String styleAttr = fontAttr.getAttribute(HTML.Attribute.STYLE).toString();
                    if (styleAttr.indexOf("font-size:" + htmlValue) == -1) {
                        fontAttr.addAttribute(HTML.Attribute.STYLE, styleAttr.trim().endsWith(";") ? styleAttr + "font-size:" + htmlValue : styleAttr + ";font-size:" + htmlValue);
                    }
                } else {
                    fontAttr.addAttribute(HTML.Attribute.STYLE, "font-size:" + htmlValue);
                }
            } else if (a == CSS.Attribute.COLOR) {
                fontAttr.addAttribute(HTML.Attribute.COLOR, htmlValue);
            } else if (a == CSS.Attribute.BACKGROUND_COLOR) {
                fontAttr.addAttribute(CSS.Attribute.BACKGROUND_COLOR, htmlValue);
            }
        }
        if (from.getAttribute(HTML.Tag.FONT) != null && ((AttributeSet)from.getAttribute(HTML.Tag.FONT)).getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount) != null) {
            fontAttr.addAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount, ((AttributeSet)from.getAttribute(HTML.Tag.FONT)).getAttribute(EditorHTMLDocument.sferyxInternalEmbeddedTagsCount));
        }
    }

    public MutableAttributeSet convertToHTML40(AttributeSet from, MutableAttributeSet to) {
        if (from == null) {
            return to;
        }
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof HiddenValue) continue;
            if (key instanceof CSS.Attribute || key instanceof AlternativeCSSAttribute || XHTMLWriter.isAdditionStyleDefinition(key)) {
                if (key == CSS.Attribute.FONT_SIZE) {
                    if (from.getAttribute(key) == null) continue;
                    String htmlValue = from.getAttribute(key).toString();
                    if (!(!(!htmlValue.endsWith("pt") & !htmlValue.endsWith("px")) || htmlValue.endsWith("em") || htmlValue.endsWith("ex") || htmlValue.endsWith("%") || htmlValue.trim().equals("xx-small") || htmlValue.trim().equals("x-small") || htmlValue.trim().equals("small") || htmlValue.trim().equals("medium") || htmlValue.trim().equals("large") || htmlValue.trim().equals("x-large") || htmlValue.trim().equals("xx-large"))) {
                        if (HTMLEditor.jvm_version.startsWith("1.3")) {
                            value = value + " font-size:" + this.doc.getStyleSheet().getFont(from).getSize() + "px" + ";";
                            continue;
                        }
                        value = value + " font-size:" + this.doc.getStyleSheet().getFont(from).getSize() + "px" + ";";
                        continue;
                    }
                    value = value + " font-size:" + htmlValue + ";";
                    continue;
                }
                if (from.getAttribute(key) == null || from.getAttribute(key).toString() == null || from.getAttribute(key).toString().equals("")) continue;
                value = value + " " + key + ":" + from.getAttribute(key) + ";";
                continue;
            }
            if (key == HTML.Tag.FONT && from.getAttribute(key) != null && from.getAttribute(key) instanceof AttributeSet) {
                AttributeSet fontAttribs = (AttributeSet)from.getAttribute(key);
                SimpleAttributeSet differentFontAttributes = new SimpleAttributeSet();
                Enumeration<?> keysF = fontAttribs.getAttributeNames();
                while (keysF.hasMoreElements()) {
                    Object keyF = keysF.nextElement();
                    if (key instanceof HiddenValue) continue;
                    if (keyF instanceof CSS.Attribute || key instanceof AlternativeCSSAttribute) {
                        if (keyF == CSS.Attribute.FONT_SIZE) {
                            if (fontAttribs.getAttribute(keyF) == null) continue;
                            String htmlValue = fontAttribs.getAttribute(keyF).toString();
                            if (!(!(!htmlValue.endsWith("pt") & !htmlValue.endsWith("px")) || htmlValue.endsWith("em") || htmlValue.endsWith("%") || htmlValue.trim().equals("xx-small") || htmlValue.trim().equals("x-small") || htmlValue.trim().equals("small") || htmlValue.trim().equals("medium") || htmlValue.trim().equals("large") || htmlValue.trim().equals("x-large") || htmlValue.trim().equals("xx-large"))) {
                                if (HTMLEditor.jvm_version.startsWith("1.3")) {
                                    value = value + " font-size:" + this.doc.getStyleSheet().getFont(fontAttribs).getSize() + "px" + ";";
                                    continue;
                                }
                                value = value + " font-size:" + this.doc.getStyleSheet().getFont(fontAttribs).getSize() + "px" + ";";
                                continue;
                            }
                            value = value + " font-size:" + htmlValue + ";";
                            continue;
                        }
                        value = value + " " + keyF + ":" + fontAttribs.getAttribute(keyF) + ";";
                        continue;
                    }
                    if (keyF == HTML.Attribute.COLOR || keyF == HTML.Attribute.SIZE || keyF == HTML.Attribute.FACE || keyF == EditorHTMLDocument.sferyxInternalEmbeddedTagsCount) continue;
                    differentFontAttributes.addAttribute(keyF, fontAttribs.getAttribute(keyF));
                }
                if (differentFontAttributes.isEmpty()) continue;
                to.addAttribute(HTML.Tag.FONT, differentFontAttributes);
                continue;
            }
            if (key != HTML.Tag.B && key != HTML.Tag.I && key != HTML.Tag.U) {
                if (key instanceof AlternativeCSSAttribute || key instanceof String && (key.toString().equalsIgnoreCase("width") || key.toString().equalsIgnoreCase("height"))) continue;
                to.addAttribute(key, from.getAttribute(key));
                continue;
            }
            if (from.getAttribute(key) == null || !(from.getAttribute(key) instanceof AttributeSet) || ((AttributeSet)from.getAttribute(key)).getAttributeCount() <= 0) continue;
            to.addAttribute(key, from.getAttribute(key));
        }
        if (value.length() > 0) {
            MutableAttributeSet sas;
            if (!SferyxUtilities.matchNameAttribute(from, HTML.Tag.CONTENT)) {
                if (from.getAttribute(HTML.Tag.SPAN) != null) {
                    sas = this.convertToHTML32((MutableAttributeSet)from.getAttribute(HTML.Tag.SPAN), new SimpleAttributeSet());
                    to.addAttribute(HTML.Tag.SPAN, sas);
                    to.addAttribute(HTML.Attribute.STYLE, value.trim());
                } else if (!value.trim().equals("")) {
                    to.addAttribute(HTML.Attribute.STYLE, value.trim());
                }
            } else {
                sas = new SimpleAttributeSet();
                ((SimpleAttributeSet)sas).addAttribute(HTML.Attribute.STYLE, value.trim());
                if (from.getAttribute(HTML.Tag.SPAN) != null) {
                    MutableAttributeSet nsas = this.convertToHTML32((MutableAttributeSet)from.getAttribute(HTML.Tag.SPAN), new SimpleAttributeSet());
                    if (nsas.getAttribute(HTML.Attribute.STYLE) != null) {
                        value = value + ";" + (String)nsas.getAttribute(HTML.Attribute.STYLE);
                        ((SimpleAttributeSet)sas).addAttributes(nsas);
                        ((SimpleAttributeSet)sas).addAttribute(HTML.Attribute.STYLE, value.trim());
                    } else {
                        ((SimpleAttributeSet)sas).addAttributes(nsas);
                    }
                    to.addAttribute(HTML.Tag.SPAN, sas);
                } else {
                    to.addAttribute(HTML.Tag.SPAN, sas);
                }
            }
        }
        return to;
    }

    private void convertToHTML40_orig(AttributeSet from, MutableAttributeSet to) {
        if (from == null) {
            return;
        }
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof CSS.Attribute) {
                if (key == CSS.Attribute.FONT_SIZE) {
                    if (from.getAttribute(key) == null) continue;
                    String htmlValue = from.getAttribute(key).toString();
                    if (!(!(!htmlValue.endsWith("pt") & !htmlValue.endsWith("px")) || htmlValue.endsWith("em") || htmlValue.endsWith("ex") || htmlValue.endsWith("%") || htmlValue.trim().equals("xx-small") || htmlValue.trim().equals("x-small") || htmlValue.trim().equals("small") || htmlValue.trim().equals("medium") || htmlValue.trim().equals("large") || htmlValue.trim().equals("x-large") || htmlValue.trim().equals("xx-large"))) {
                        if (HTMLEditor.jvm_version.startsWith("1.3")) {
                            value = value + " font-size:" + this.doc.getStyleSheet().getFont(from).getSize() + "px" + ";";
                            continue;
                        }
                        value = value + " font-size:" + this.doc.getStyleSheet().getFont(from).getSize() + "px" + ";";
                        continue;
                    }
                    value = value + " font-size:" + htmlValue + ";";
                    continue;
                }
                if (from.getAttribute(key) == null || from.getAttribute(key).toString() == null || from.getAttribute(key).toString().equals("")) continue;
                value = value + " " + key + ":" + from.getAttribute(key) + ";";
                continue;
            }
            if (key == HTML.Tag.FONT && from.getAttribute(key) != null && from.getAttribute(key) instanceof AttributeSet) {
                AttributeSet fontAttribs = (AttributeSet)from.getAttribute(key);
                Enumeration<?> keysF = fontAttribs.getAttributeNames();
                while (keysF.hasMoreElements()) {
                    Object keyF = keysF.nextElement();
                    if (!(keyF instanceof CSS.Attribute)) continue;
                    if (keyF == CSS.Attribute.FONT_SIZE) {
                        if (fontAttribs.getAttribute(keyF) == null) continue;
                        String htmlValue = fontAttribs.getAttribute(keyF).toString();
                        if (!(!(!htmlValue.endsWith("pt") & !htmlValue.endsWith("px")) || htmlValue.endsWith("em") || htmlValue.endsWith("%") || htmlValue.trim().equals("xx-small") || htmlValue.trim().equals("x-small") || htmlValue.trim().equals("small") || htmlValue.trim().equals("medium") || htmlValue.trim().equals("large") || htmlValue.trim().equals("x-large") || htmlValue.trim().equals("xx-large"))) {
                            if (HTMLEditor.jvm_version.startsWith("1.3")) {
                                value = value + " font-size:" + this.doc.getStyleSheet().getFont(fontAttribs).getSize() + "px" + ";";
                                continue;
                            }
                            value = value + " font-size:" + this.doc.getStyleSheet().getFont(fontAttribs).getSize() + "px" + ";";
                            continue;
                        }
                        value = value + " font-size:" + htmlValue + ";";
                        continue;
                    }
                    value = value + " " + keyF + ":" + fontAttribs.getAttribute(keyF) + ";";
                }
                continue;
            }
            if (key != HTML.Tag.B && key != HTML.Tag.I && key != HTML.Tag.U) {
                to.addAttribute(key, from.getAttribute(key));
                continue;
            }
            if (from.getAttribute(key) == null || !(from.getAttribute(key) instanceof AttributeSet) || ((AttributeSet)from.getAttribute(key)).getAttributeCount() <= 0) continue;
            to.addAttribute(key, from.getAttribute(key));
        }
        if (value.length() > 0) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(HTML.Attribute.STYLE, value);
            if (from.getAttribute(HTML.Tag.SPAN) != null) {
                sas.addAttributes(((MutableAttributeSet)from.getAttribute(HTML.Tag.SPAN)).copyAttributes());
                to.addAttribute(HTML.Tag.SPAN, sas);
            } else {
                to.addAttribute(HTML.Tag.SPAN, sas);
            }
        }
    }

    private static void addAttribute(MutableAttributeSet to, Object key, Object value) {
        Object attr = to.getAttribute(key);
        if (attr == null || attr == SimpleAttributeSet.EMPTY) {
            to.addAttribute(key, value);
        } else if (attr instanceof MutableAttributeSet && value instanceof AttributeSet) {
            ((MutableAttributeSet)attr).addAttributes((AttributeSet)value);
        }
    }
}

