/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.rl;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SwfSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean aPe = true;
    private boolean aPf;
    private String aPg;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean KQ() {
        return false;
    }

    boolean aca() {
        return true;
    }

    boolean agV() {
        return this.aPe;
    }

    public String getTempFolder() {
        return this.aPg;
    }

    public void setTempFolder(String string) {
        this.aPg = string;
    }

    public boolean getPrettyFormat() {
        return this.aPf;
    }

    public void setPrettyFormat(boolean bl2) {
        this.aPf = bl2;
    }

    public static SaveOptions createSaveOptions(int n2) {
        switch (n2) {
            case 1: 
            case 200: {
                return new DocSaveOptions(n2);
            }
            case 8: 
            case 9: 
            case 10: 
            case 201: 
            case 202: {
                return new OoxmlSaveOptions(n2);
            }
            case 6: {
                return new RtfSaveOptions();
            }
            case 5: {
                return new WordML2003SaveOptions();
            }
            case 15: {
                return new PdfSaveOptions();
            }
            case 16: {
                return new XpsSaveOptions();
            }
            case 17: {
                return new XamlFixedSaveOptions();
            }
            case 18: {
                return new SwfSaveOptions();
            }
            case 4: 
            case 13: 
            case 14: {
                return new HtmlSaveOptions(n2);
            }
            case 12: 
            case 203: {
                return new OdtSaveOptions(n2);
            }
            case 2: {
                return new TxtSaveOptions();
            }
            case 20: {
                return new XamlFlowSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String string) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.extensionToSaveFormat(rl.bi(string)));
    }
}

