/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.jj;
import asposewobfuscated.rh;
import asposewobfuscated.rj;
import asposewobfuscated.rm;
import asposewobfuscated.sx;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.pa;
import java.io.EOFException;
import java.text.ParseException;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static final sx bY = new sx("doc", "dot", "docx", "docm", "dotx", "dotm", "fopc", "rtf", "xml", "wml", "wordml", "pdf", "xps", "swf", "html", "htm", "xhtml", "mht", "mhtm", "mhtml", "msg", "eml", "odt", "ott", "txt", "epub", "xaml");

    private FileFormatUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileFormatInfo detectFileFormat(String string) throws Exception {
        jj.h(string, "fileName");
        rj rj2 = rh.bf(string);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.C(rj2);
            return fileFormatInfo;
        }
        finally {
            if (rj2 != null) {
                ((rm)rj2).close();
            }
        }
    }

    static FileFormatInfo C(rm rm2) throws Exception {
        if (rm2 == null) {
            throw new IllegalArgumentException("stream");
        }
        try {
            pa pa2 = new pa();
            return pa2.A(rm2);
        }
        catch (Exception exception) {
            throw FileFormatUtil.a(exception);
        }
    }

    static Exception a(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ParseException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    public static String loadFormatToExtension(int n2) {
        switch (n2) {
            case 1: {
                return ".doc";
            }
            case 200: {
                return ".dot";
            }
            case 5: {
                return ".docx";
            }
            case 201: {
                return ".docm";
            }
            case 202: {
                return ".dotx";
            }
            case 203: {
                return ".dotm";
            }
            case 8: {
                return ".xml";
            }
            case 3: {
                return ".rtf";
            }
            case 4: {
                return ".wml";
            }
            case 2: {
                return ".html";
            }
            case 7: {
                return ".mhtml";
            }
            case 6: {
                return ".odt";
            }
            case 204: {
                return ".ott";
            }
            case 999: {
                return ".docx";
            }
        }
        throw new IllegalArgumentException("Unknown load format.");
    }

    public static int saveFormatToLoadFormat(int n2) {
        switch (n2) {
            case 1: {
                return 1;
            }
            case 200: {
                return 200;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 201;
            }
            case 201: {
                return 202;
            }
            case 202: {
                return 203;
            }
            case 10: {
                return 8;
            }
            case 6: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 13: {
                return 7;
            }
            case 12: {
                return 6;
            }
            case 203: {
                return 204;
            }
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                return 1;
            }
            case 200: {
                return 200;
            }
            case 5: {
                return 8;
            }
            case 201: {
                return 9;
            }
            case 202: {
                return 201;
            }
            case 203: {
                return 202;
            }
            case 8: {
                return 10;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 7: {
                return 13;
            }
            case 6: {
                return 12;
            }
            case 204: {
                return 203;
            }
            case 999: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int n2) {
        switch (n2) {
            case 1: {
                return ".doc";
            }
            case 200: {
                return ".dot";
            }
            case 8: {
                return ".docx";
            }
            case 9: {
                return ".docm";
            }
            case 201: {
                return ".dotx";
            }
            case 202: {
                return ".dotm";
            }
            case 10: {
                return ".fopc";
            }
            case 6: {
                return ".rtf";
            }
            case 5: {
                return ".wml";
            }
            case 15: {
                return ".pdf";
            }
            case 16: {
                return ".xps";
            }
            case 17: {
                return ".xaml";
            }
            case 18: {
                return ".swf";
            }
            case 4: {
                return ".html";
            }
            case 13: {
                return ".mht";
            }
            case 12: {
                return ".odt";
            }
            case 203: {
                return ".ott";
            }
            case 2: {
                return ".txt";
            }
            case 14: {
                return ".epub";
            }
            case 20: {
                return ".xaml";
            }
        }
        throw new IllegalStateException("Unknown save format.");
    }

    public static int extensionToSaveFormat(String string) {
        if (string == null) {
            throw new IllegalArgumentException("extension");
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        switch (bY.bA(string.toLowerCase())) {
            case 0: {
                return 1;
            }
            case 1: {
                return 200;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 201;
            }
            case 5: {
                return 202;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 6;
            }
            case 8: 
            case 9: 
            case 10: {
                return 5;
            }
            case 11: {
                return 15;
            }
            case 12: {
                return 16;
            }
            case 13: {
                return 18;
            }
            case 14: 
            case 15: 
            case 16: {
                return 4;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return 13;
            }
            case 22: {
                return 12;
            }
            case 23: {
                return 203;
            }
            case 24: {
                return 2;
            }
            case 25: {
                return 14;
            }
            case 26: {
                return 20;
            }
        }
        return 0;
    }
}

