/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.opensoundcontrol.OscAddressSpace;
import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscMessage;
import com.bitwig.extension.api.opensoundcontrol.OscMethod;
import com.bitwig.extension.api.opensoundcontrol.OscModule;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ChainSelector;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorDevice;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.DeviceLayer;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.Transport;

public class gpA
extends ControllerExtension {
    private Transport WCG;
    private MasterTrack t3p;
    private CursorTrack W1d;
    private CursorDevice pqd;
    private ChainSelector ocA;
    private DeviceLayer LQe;
    private SettableIntegerValue BiT;
    private IntegerValue PB;

    public gpA(mxs mxs2, ControllerHost controllerHost) {
        super(mxs2, controllerHost);
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        this.WCG = controllerHost.createTransport();
        this.t3p = controllerHost.createMasterTrack(1);
        this.W1d = controllerHost.createCursorTrack("osc-cursor-track", "OSC cursor track", 1, 1, true);
        this.pqd = this.W1d.createCursorDevice();
        this.ocA = this.pqd.createChainSelector();
        this.LQe = this.ocA.activeChain();
        this.BiT = this.ocA.activeChainIndex();
        this.PB = this.ocA.chainCount();
        this.LQe.name().markInterested();
        this.PB.markInterested();
        this.BiT.markInterested();
        this.WCG();
    }

    @Override
    public void exit() {
    }

    @Override
    public void flush() {
    }

    private void WCG() {
        OscModule oscModule = ((ControllerHost)this.getHost()).getOscModule();
        OscAddressSpace oscAddressSpace = oscModule.createAddressSpace();
        oscAddressSpace.setName("bitwig");
        oscAddressSpace.registerObjectMethods("/bitwig/transport", this.WCG);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorDevice", this.pqd);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorTrack", this.W1d);
        oscAddressSpace.registerObjectMethods("/bitwig/masterTrack", this.t3p);
        oscAddressSpace.registerObjectMethods("/bitwig/", this);
        oscAddressSpace.registerDefaultMethod(this::WCG);
        oscAddressSpace.setShouldLogMessages(true);
        oscModule.createUdpServer(9001, oscAddressSpace);
    }

    private void WCG(OscConnection oscConnection, OscMessage oscMessage) {
        ((ControllerHost)this.getHost()).println("OSC method not found for " + oscMessage.getAddressPattern() + "(" + oscMessage.getTypeTag() + ")");
    }

    @OscMethod(address="/test/int")
    public void handleTestInt(int n2) {
        ((ControllerHost)this.getHost()).println("int value: " + n2);
    }

    @OscMethod(address="/test/long")
    public void handleTestLong(long l2) {
        ((ControllerHost)this.getHost()).println("long value: " + l2);
    }

    @OscMethod(address="/test/float")
    public void handleTestFloat(float f2) {
        ((ControllerHost)this.getHost()).println("float value: " + f2);
    }

    @OscMethod(address="/test/double")
    public void handleTestDouble(double d2) {
        ((ControllerHost)this.getHost()).println("double value: " + d2);
    }

    @OscMethod(address="/test/bool")
    public void handleTestBool(boolean bl2) {
        ((ControllerHost)this.getHost()).println("boolean value: " + bl2);
    }

    @OscMethod(address="/test/string")
    public void handleTestString(String string) {
        ((ControllerHost)this.getHost()).println("string value: " + string);
    }

    @OscMethod(address="/test/ping")
    public void handleTestPing(OscConnection oscConnection) {
        oscConnection.sendMessage("/test/pong", new Object[0]);
    }

    @OscMethod(address="/test/chain-selector/select-next")
    public void handleChainSelectorNext() {
        this.ocA.selectNext();
    }

    @OscMethod(address="/test/chain-selector/select-prev")
    public void handleChainSelectorPrev() {
        this.ocA.selectPrevious();
    }

    @OscMethod(address="/test/chain-selector/select-first")
    public void handleChainSelectorFirst() {
        this.ocA.selectFirst();
    }

    @OscMethod(address="/test/chain-selector/select-last")
    public void handleChainSelectorLast() {
        this.ocA.selectLast();
    }

    @OscMethod(address="/test/chain-selector/cycle-next")
    public void handleChainSelectorCycleNext() {
        this.ocA.cycleNext();
    }

    @OscMethod(address="/test/chain-selector/cycle-prev")
    public void handleChainSelectorCyclePrev() {
        this.ocA.cyclePrevious();
    }

    @OscMethod(address="/test/chain-selector/test-active-chain")
    public void handleChainSelectorTestActiveChain() {
        ((ControllerHost)this.getHost()).println("ChainSelectorIndex: " + this.BiT.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorChainCount: " + this.PB.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorActiveChainName: " + this.LQe.name().get());
    }
}

