/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.ControllerExtensionDefinition;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorDeviceFollowMode;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.HardwareControlType;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.MidiOut;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.extension.controller.api.Transport;

public class edQ
extends ControllerExtension {
    private final String WCG;
    private final String t3p;
    private final int W1d;
    private final int pqd;
    private final byte[] ocA;
    private final byte[] LQe;
    private CursorTrack BiT;
    private PinnableCursorDevice PB;
    private CursorRemoteControlsPage LZT;
    private Transport aaP;
    private MidiOut hFD;
    private TrackBank WGS;

    public edQ(ControllerExtensionDefinition controllerExtensionDefinition, ControllerHost controllerHost, int n2, int n3, byte[] byArray, byte[] byArray2) {
        super(controllerExtensionDefinition, controllerHost);
        this.WCG = controllerExtensionDefinition.getHardwareModel() + (n2 > 0 ? " Keys" : "");
        this.t3p = controllerExtensionDefinition.getHardwareModel() + " Pads";
        this.W1d = n2;
        this.pqd = n3;
        this.ocA = byArray;
        this.LQe = byArray2;
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        MidiIn midiIn = controllerHost.getMidiInPort(0);
        midiIn.setMidiCallback(this::WCG);
        midiIn.setSysexCallback(this::WCG);
        midiIn.createNoteInput(this.WCG, "80????", "90????", "b001??", "e0????", "b040??").setShouldConsumeEvents(true);
        if (this.W1d > 0) {
            midiIn.createNoteInput(this.t3p, "89????", "99????").setShouldConsumeEvents(true);
        }
        this.hFD = controllerHost.getMidiOutPort(0);
        this.hFD.sendSysex(this.ocA);
        this.BiT = controllerHost.createCursorTrack("X2mini-track-cursor", "X2mini", 0, 0, true);
        if (this.pqd == 9) {
            this.BiT.volume().setIndication(true);
        }
        this.PB = this.BiT.createCursorDevice("X2mini-device-cursor", "X2mini", 0, CursorDeviceFollowMode.FIRST_INSTRUMENT);
        int n2 = Math.min(this.pqd, 8);
        this.LZT = this.PB.createCursorRemoteControlsPage(n2);
        this.LZT.setHardwareLayout(HardwareControlType.KNOB, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.LZT.getParameter(i2).setIndication(true);
        }
        this.aaP = controllerHost.createTransport();
        this.WGS = controllerHost.createTrackBank(8, 0, 0, true);
    }

    private void WCG(String string) {
        ((ControllerHost)this.getHost()).println("received sysex: " + string);
    }

    private void WCG(int n2, int n3, int n4) {
        int n5 = n2 & 0xF;
        int n6 = n2 >> 4 & 0xF;
        ((ControllerHost)this.getHost()).println("msg: " + n6 + ", channel: " + n5 + ", data1: " + n3 + ", data2: " + n4);
        if (n2 == 176) {
            if (16 <= n3 && n3 <= 23) {
                this.LZT.getParameter(n3 - 16).value().set(n4, 128);
            } else if (n3 == 7) {
                this.BiT.volume().set(n4, 128);
            }
            if (24 <= n3 && n3 <= 31) {
                this.BiT.selectChannel((Channel)this.WGS.getItemAt(n3 - 24));
            }
        } else if (n2 == 160) {
            switch (n3) {
                case 90: {
                    if (n4 != 127) break;
                    this.aaP.rewind();
                    break;
                }
                case 91: {
                    if (n4 != 127) break;
                    this.aaP.fastForward();
                    break;
                }
                case 92: {
                    if (n4 != 127) break;
                    this.aaP.stop();
                    break;
                }
                case 93: {
                    if (n4 != 127) break;
                    this.aaP.play();
                    break;
                }
                case 94: {
                    if (n4 != 127) break;
                    this.aaP.isArrangerLoopEnabled().toggle();
                    break;
                }
                case 95: {
                    if (n4 != 127) break;
                    this.aaP.record();
                }
            }
        }
    }

    @Override
    public void exit() {
        this.hFD.sendSysex(this.LQe);
    }

    @Override
    public void flush() {
    }
}

