/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.win32_windowing_system;

import com.bitwig.base.platform.NativeMemoryBlock;
import com.bitwig.base.platform.UNF;
import com.bitwig.base.platform.kK;

class Win32DIBSectionMemoryBlock
extends kK {
    private static final UNF W1d = new UNF("Windows DIB");
    private long pqd;
    private NativeMemoryBlock ocA;

    private Win32DIBSectionMemoryBlock(long l2, long l4, int n2, int n3, NativeMemoryBlock nativeMemoryBlock) {
        super(nativeMemoryBlock.WCG());
        this.pqd = l2;
        this.ocA = nativeMemoryBlock;
    }

    public static Win32DIBSectionMemoryBlock WCG(long l2, int n2, int n3) {
        int n4 = Win32DIBSectionMemoryBlock.WCG(n2, n3);
        long[] lArray = Win32DIBSectionMemoryBlock.t3p(l2, n2, n3);
        assert (bhE.t3p(lArray.length == 2));
        long l4 = lArray[0];
        long l5 = lArray[1];
        NativeMemoryBlock nativeMemoryBlock = W1d.WCG(l5, n4);
        return new Win32DIBSectionMemoryBlock(l4, l2, n2, n3, nativeMemoryBlock);
    }

    @Override
    public void W1d() {
        assert (bhE.WCG(!this.t3p()));
        if (this.ocA != null) {
            this.ocA.W1d();
            this.ocA = null;
            Win32DIBSectionMemoryBlock.releaseNative(this.pqd);
            super.W1d();
            this.pqd = 0L;
            assert (bhE.WCG(this.ocA == null));
        }
        assert (bhE.WCG(this.pqd == 0L));
    }

    public NativeMemoryBlock pqd() {
        assert (bhE.t3p(this.ocA != null));
        return this.ocA;
    }

    private static int WCG(int n2, int n3) {
        return n2 * n3 * 4;
    }

    private static long[] t3p(long l2, int n2, int n3) {
        long[] lArray = Win32DIBSectionMemoryBlock.createNative(l2, n2, n3);
        if (lArray == null) {
            throw new OutOfMemoryError("Could not allocate native memory block");
        }
        assert (bhE.t3p(lArray.length == 2));
        return lArray;
    }

    public long ocA() {
        return this.pqd;
    }

    private static native long[] createNative(long var0, int var2, int var3);

    private static native void releaseNative(long var0);
}

