/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.widget.core.timeline.interaction;

import com.bitwig.base.geom.DoublePoint;
import com.bitwig.flt.app.l2R;
import com.bitwig.flt.widget.core.timeline.interaction.AbstractAutomationDragAction;
import com.bitwig.flt.widget.core.timeline.renderer.Cxa;
import com.bitwig.flt.widget.core.timeline.ygI;
import com.bitwig.flt.widget.theme.xGt;
import com.bitwig.graphics.luf;
import com.bitwig.ramona.core.gMo;
import com.bitwig.windowing_system.MkB;
import com.bitwig.windowing_system.V3i;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class AutomationEventDragAction
extends AbstractAutomationDragAction {
    private xAG mProperties;
    private double mLocalMouseDownTime;
    public double mMouseDownTime;
    public double mNormalizedMouseDownValue;
    public double mReferenceNormalizedValue;
    public List mEvents;
    public double mTimeDelta;
    public double mNormalizedValueDelta;
    public double mTotalDeltaX;
    public double mTotalDeltaY;
    private int mInsertionIndexOfNewEvent = -1;
    private final boolean mAllowTimeEditing;
    private final double mEffectiveTimeOfFoundEvent;
    private final ygI mWidget;
    private LMD mTimeline;
    private MkB mCursorStyle = bEz.mKL;
    private DoublePoint mMouseDownPosition;
    private YZG mReferenceEvent;
    private double mMinEventTime;
    private double mMaxEventTime;
    private double mNormalizedMovementPerPixel;
    private boolean mShouldContinueLastEdit;
    private final RS mValueType;
    private final yHn mParentNoteOrClip;

    public AutomationEventDragAction(ygI ygI2, LMD lMD, yHn yHn2, RS rS2, DoublePoint doublePoint, cBN cBN2, boolean bl2, boolean bl3, double d2, double d3) {
        assert (bhj.ocA(ygI2 != null));
        assert (bhj.ocA(doublePoint != null));
        assert (bhj.ocA(lMD != null));
        this.mWidget = ygI2;
        this.mTimeline = lMD;
        this.mParentNoteOrClip = yHn2;
        this.mValueType = rS2;
        this.mAllowTimeEditing = bl3;
        this.mEffectiveTimeOfFoundEvent = d2;
        this.mNormalizedMovementPerPixel = AutomationEventDragAction.calculateNormalizedMovementPerPixel(lMD.ocA(), ygI2.WGS(ygI2.oRp()));
        JHP jHP = lMD.nzZ();
        this.mMouseDownTime = this.mWidget.W1d(doublePoint.pqd());
        if (ygI2.qW_() && jHP != null) {
            this.mMouseDownTime = Us.t3p(this.mMouseDownTime, jHP.w2F(), jHP.VBE());
        }
        this.mReferenceNormalizedValue = this.mNormalizedMouseDownValue = d3;
        if (bl2) {
            WMD wMD = this.mWidget.WCG(lMD);
            this.mLocalMouseDownTime = xpS.WCG(wMD, this.mMouseDownTime, (WMD)lMD);
            this.mInsertionIndexOfNewEvent = lMD.BiT(this.mLocalMouseDownTime);
        } else {
            this.mInsertionIndexOfNewEvent = -1;
        }
        if (this.mInsertionIndexOfNewEvent >= 0) {
            this.mNormalizedMouseDownValue = this.mReferenceNormalizedValue = this.mWidget.WCG(lMD, this.mMouseDownTime, false);
        }
    }

    @Override
    public boolean appliesChangesImmediately() {
        return false;
    }

    @Override
    public String getTitle() {
        return "Move Automation Events";
    }

    @Override
    public Set getLocks() {
        return Collections.emptySet();
    }

    @Override
    public String getDragDescription() {
        if (this.mInsertionIndexOfNewEvent != -1) {
            String string = "mouse.insert_point.desc";
            return X3n.WCG(string);
        }
        return super.getDragDescription();
    }

    @Override
    protected boolean wantsToAdjustMouseMoveSpeed() {
        return true;
    }

    protected YZG getValueEvent(gMo gMo2) {
        if (gMo2 instanceof tf1) {
            return ((tf1)gMo2).t3p();
        }
        if (gMo2 instanceof tZo) {
            return ((tZo)gMo2).t3p();
        }
        return (YZG)gMo2;
    }

    @Override
    protected double calculateMouseMoveDeltaX(bXf bXf2) {
        if (!this.mAllowTimeEditing) {
            return 0.0;
        }
        double d2 = AutomationEventDragAction.calculateScaleFactor(bXf2);
        return bXf2.YD() * d2;
    }

    @Override
    protected double calculateMouseMoveDeltaY(bXf bXf2) {
        double d2 = AutomationEventDragAction.calculateScaleFactor(bXf2);
        return bXf2.bmK() * d2;
    }

    @Override
    protected double validateMouseMoveX(double d2) {
        assert (bhj.W1d(this.mReferenceEvent != null));
        if (this.mReferenceEvent != null) {
            return this.mWidget.k_(this.mEffectiveTimeOfFoundEvent + this.mTimeDelta);
        }
        return d2;
    }

    @Override
    protected double validateMouseMoveY(double d2) {
        assert (bhj.W1d(this.mReferenceEvent != null));
        assert (bhj.ocA(this.mValueType != null));
        if (this.mReferenceEvent != null && this.mValueType != null) {
            double d3 = this.mReferenceEvent.WCG(this.mValueType);
            return this.mWidget.WCG(d3, this.mTimeline, this.mParentNoteOrClip, this.mValueType);
        }
        return d2;
    }

    public static double calculateNormalizedMovementPerPixel(RS rS2, long l2) {
        double d2 = 0.01;
        if (rS2 instanceof fIN) {
            fIN fIN2 = (fIN)rS2;
            double d3 = fIN2.lt_() - fIN2.t3p();
            if (fIN2.xzw() > 0.0 && d3 > 0.0) {
                d2 = fIN2.xzw() / d3;
            }
        }
        d2 = Math.min(d2, 1.5 / (double)l2);
        return d2;
    }

    public static double calculateScaleFactor(bXd bXd2) {
        return bXd2.BiT().WCG() ? 0.1 : 1.0;
    }

    public void beginEventEditing(bXd bXd2, gMo gMo2, List list) {
        this.mReferenceEvent = this.getValueEvent(gMo2);
        this.mEvents = list;
        this.mMouseDownPosition = bXd2.UaU();
        this.mShouldContinueLastEdit = false;
        this.mMinEventTime = Double.MAX_VALUE;
        this.mMaxEventTime = -1.7976931348623157E308;
        for (gMo gMo3 : list) {
            YZG yZG = this.getValueEvent(gMo3);
            this.mMinEventTime = Math.min(this.mMinEventTime, yZG.w2F());
            this.mMaxEventTime = Math.max(this.mMaxEventTime, yZG.w2F());
        }
        if (this.mInsertionIndexOfNewEvent < 0) {
            this.mReferenceNormalizedValue = this.getValueEvent(gMo2).aaP();
            aBe aBe2 = this.mWidget.WCG().LQe();
            aBe2.WCG((Collection)this.mWidget.W1d(list));
            this.mProperties = (xAG)aBe2.hFD();
            if (this.mProperties != null) {
                this.mProperties.ocA();
            }
        } else {
            this.mWidget.WCG().uNU();
            if (this.getValueGrid() != null && this.getValueType() instanceof fIN && !bXd2.BiT().WCG()) {
                this.mNormalizedMouseDownValue = this.mWidget.n_(this.mNormalizedMouseDownValue);
            }
            this.mReferenceEvent = this.mTimeline.WCG(this.mLocalMouseDownTime, this.mReferenceNormalizedValue, 0.0, this.mWidget.WCG().LQe());
        }
    }

    protected RS getValueType() {
        return this.mValueType;
    }

    protected Esg getValueGrid() {
        return this.mWidget.sN_();
    }

    @Override
    public void finishEventEditing() {
        if (this.mInsertionIndexOfNewEvent >= 0) {
            this.mTimeline.kp_();
        } else if (this.mProperties != null) {
            this.mProperties.hH_();
        }
    }

    @Override
    public void cancelEventEditing() {
        if (this.mInsertionIndexOfNewEvent >= 0) {
            this.mTimeline.kq_();
        } else if (this.mProperties != null) {
            this.mProperties.BiT();
        }
    }

    @Override
    public void updateEditEvents(bXf bXf2) {
        if (this.mAllowTimeEditing) {
            this.mTotalDeltaX += bXf2.YD();
            this.mTimeDelta = this.calculateEventDragTimeDistance(bXf2, this.mTotalDeltaX, true);
        } else {
            this.mTimeDelta = 0.0;
        }
        this.mTotalDeltaY += bXf2.bmK();
        this.mNormalizedValueDelta = this.calculateValueDelta(this.mTotalDeltaY, bXf2);
        if (this.mInsertionIndexOfNewEvent >= 0) {
            this.mTimeline.WCG(this.mTimeDelta, this.mNormalizedValueDelta, 0.0);
        } else if (this.mProperties != null) {
            this.mProperties.WCG(this.mTimeDelta, this.mNormalizedValueDelta);
        }
        this.mShouldContinueLastEdit = true;
        this.mWidget.ziM();
    }

    @Override
    public String getTooltip(cBN cBN2) {
        RS rS2 = this.mWidget.sL_();
        double d2 = Us.t3p(this.mNormalizedMouseDownValue, 0.0, 1.0);
        return LWr.WCG(d2, rS2);
    }

    @Override
    public String getDragTooltip(cBN cBN2) {
        RS rS2 = this.mWidget.sL_();
        double d2 = Us.t3p(this.mReferenceEvent != null ? this.mReferenceEvent.WCG(rS2) : this.mNormalizedMouseDownValue + this.mNormalizedValueDelta, 0.0, 1.0);
        return LWr.WCG(d2, rS2);
    }

    protected double calculateValueDelta(double d2, bXf bXf2) {
        double d3 = -d2 * this.mNormalizedMovementPerPixel;
        tZY tZY2 = this.mWidget.PU1();
        boolean bl2 = bXf2.BiT().WCG();
        if (this.getValueGrid() != null && this.getValueType() instanceof fIN && (tZY2.MtC() && !bl2 || !tZY2.MtC() && bl2)) {
            double d4 = this.mReferenceNormalizedValue + d3;
            d4 = this.mWidget.n_(d4);
            return d4 - this.mReferenceNormalizedValue;
        }
        return d3;
    }

    protected double calculateEventDragTimeDistance(bXd bXd2, double d2, boolean bl2) {
        double d3 = d2 * this.mWidget.OyK();
        if (bl2) {
            double d4 = this.mEffectiveTimeOfFoundEvent + d3;
            d4 = this.mWidget.t3p(d4, bXd2.BiT());
            return d4 - this.mEffectiveTimeOfFoundEvent;
        }
        return d3;
    }

    @Override
    public MkB getMouseCursorStyle() {
        return this.mAllowTimeEditing ? this.mCursorStyle : l2R.uZE;
    }

    @Override
    public MkB getMouseDragCursorStyle() {
        return V3i.pqd;
    }

    @Override
    protected boolean wantsToPaintPreview() {
        return true;
    }

    @Override
    protected void paintPreview(luf luf2) {
        super.paintPreview(luf2);
        if (this.mInsertionIndexOfNewEvent != -1 && this.mTimeline.KOw() != null) {
            double d2 = this.mWidget.WCG(this.mNormalizedMouseDownValue, this.mTimeline, this.mParentNoteOrClip, this.mValueType);
            double d3 = this.mWidget.k_(this.mMouseDownTime);
            ygI ygI2 = this.getWidget();
            xGt xGt2 = (xGt)ygI2.sF_();
            gnD gnD2 = xGt2.aaP().PB().WCG(ygI2);
            luf2.W1d(gnD2);
            luf2.UaU();
            luf2.WCG((long)d3, (long)d2);
            luf2.ocA(luf2.YD());
            double d4 = luf2.YD() * 4.0 * 1.0;
            Cxa.WCG(luf2, ygI2, 0.0, 0.0, d4);
            luf2.aaP();
            luf2.FAX();
        }
    }

    @Override
    protected void schedulePreviewPaintUpdate(long l2, double d2) {
        if (this.mInsertionIndexOfNewEvent != -1 && this.mTimeline.KOw() != null && this.mWidget.c2e() != null) {
            double d3 = this.mWidget.WCG(this.mNormalizedMouseDownValue, this.mTimeline, this.mParentNoteOrClip, this.mValueType);
            double d4 = this.mWidget.k_(this.mMouseDownTime);
            double d5 = this.mWidget.i1O() * 4.0 * 1.25;
            long l4 = (int)d5 * 2;
            this.mWidget.t3p((long)(d4 - d5), (long)(d3 - d5), l4, l4);
        }
    }

    private String calculateText(double d2) {
        return LWr.WCG(d2, this.getValueType());
    }

    public MkB getCursorStyle() {
        return this.mCursorStyle;
    }

    public void setCursorStyle(MkB mkB) {
        this.mCursorStyle = mkB;
    }

    public double getMouseDownTime() {
        return this.mMouseDownTime;
    }

    public double getNormalizedMouseDownValue() {
        return this.mNormalizedMouseDownValue;
    }

    public double getReferenceNormalizedValue() {
        return this.mReferenceNormalizedValue;
    }

    public List getEvents() {
        return this.mEvents;
    }

    public double getTimeDelta() {
        return this.mTimeDelta;
    }

    public double getNormalizedValueDelta() {
        return this.mNormalizedValueDelta;
    }

    public int getInsertionIndexOfNewEvent() {
        return this.mInsertionIndexOfNewEvent;
    }

    public boolean isAllowTimeEditing() {
        return this.mAllowTimeEditing;
    }

    public double getEffectiveTimeOfFoundEvent() {
        return this.mEffectiveTimeOfFoundEvent;
    }

    public ygI getWidget() {
        return this.mWidget;
    }

    public LMD getTimeline() {
        return this.mTimeline;
    }

    public yHn getParentNoteOrClip() {
        return this.mParentNoteOrClip;
    }

    public DoublePoint getMouseDownPosition() {
        return this.mMouseDownPosition;
    }
}

