/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class StringValueProxy
extends ValueProxy
implements YLB,
StringValue {
    private PkP mValue;
    private final PkP mDefaultValue;

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.mValue = this.mDefaultValue = this.createControlSurfaceStringValue(string);
    }

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, "");
    }

    @Override
    public Class getTargetType() {
        return yqD.class;
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        assert (bhj.W1d(n2 >= 1));
        return this.mValue.getLimited(n2);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        assert (bhj.WCG(this.isControlSurfaceThread()));
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(pkP -> stringValueChangedCallback.valueChanged(pkP.get()));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(pkP -> {
            if (pkP == this.mDefaultValue) {
                stringValueChangedCallback.valueChanged(string);
            } else {
                stringValueChangedCallback.valueChanged(pkP.getLimited(n2));
            }
        });
    }

    protected void sendDefaultValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        controlSurfaceStringValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(yqD yqD2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(yqD2 != null));
        if (yqD2.isObservable()) {
            yqD2.removeListener(this);
        }
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(yqD yqD2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(yqD2 != null));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(this.isActiveOnDocumentThread()));
        if (yqD2.isObservable()) {
            yqD2.addListener(this);
        }
        this.updateValue();
    }

    public PkP getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(BeJ beJ2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(Objects.equals(beJ2.WCG(), this.getTarget())));
        this.updateValue();
    }

    private void updateValue() {
        assert (bhj.W1d(this.isDocumentThread()));
        String string = (String)((yqD)this.getTarget()).getValue();
        assert (bhj.W1d(string != null));
        PkP pkP = this.createControlSurfaceStringValue(string);
        assert (bhj.W1d(pkP != null));
        this.queueNotifyObservers(pkP);
    }

    private void queueNotifyObservers(PkP pkP) {
        assert (bhj.W1d(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(pkP));
    }

    protected PkP createControlSurfaceStringValue(String string) {
        assert (bhj.W1d(this.isDocumentThread() || this.isInitializingDriver()));
        if (string.isEmpty()) {
            return PkP.EMPTY;
        }
        return new DeV(string);
    }

    private void notifyObservers(PkP pkP) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInterested()));
        if (!pkP.equals(this.mValue)) {
            this.mValue = pkP;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(pkP);
                }
            }
        }
    }
}

