/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableStringValueProxy;
import com.bitwig.ramona.core.gMo;

public class StringSetting
extends SettableStringValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private syp mIsEnabled;
    private syp mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private gMo mSetting;

    public StringSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject, string3);
        this.notEmpty(string, "label");
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(qD qD2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(qD2 != null));
        assert (bhj.ocA(this.mSetting == null));
        this.mSetting = qD2;
        this.setTarget(qD2.PB());
        this.connectEnableAndVisibleValues(qD2.YD(), qD2.AhM());
    }

    public void disconnectFromSetting(qD qD2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(qD2 != null));
        assert (bhj.ocA(this.mSetting == qD2));
        this.disconnectEnableAndVisibleValues(qD2.YD(), qD2.AhM());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(KGN kGN) {
        assert (bhj.ocA(this.mSetting == null));
        this.mSetting = kGN;
        this.setTarget(kGN.t3p());
        this.connectEnableAndVisibleValues(kGN.aaP(), kGN.hFD());
    }

    public void disconnectFromSetting(KGN kGN) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(kGN != null));
        assert (bhj.ocA(this.mSetting == kGN));
        this.disconnectEnableAndVisibleValues(kGN.aaP(), kGN.hFD());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(syp syp2, syp syp3) {
        this.mIsEnabled = syp2;
        this.mIsVisible = syp3;
    }

    private void disconnectEnableAndVisibleValues(syp syp2, syp syp3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public gMo getSetting() {
        return this.mSetting;
    }
}

