/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ObjectValueChangedCallback;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Arrays;
import java.util.Objects;

public class StringArrayValueProxy
extends ValueProxy
implements YLB,
StringArrayValue {
    private final String[] mDefaultValue;
    private String[] mValue;

    public StringArrayValueProxy(ControlSurfaceObject controlSurfaceObject, String[] stringArray) {
        super(controlSurfaceObject);
        this.mDefaultValue = stringArray;
        this.mValue = stringArray;
    }

    @Override
    public Class getTargetType() {
        return phC.class;
    }

    @Override
    public String[] get() {
        this.checkCanGet();
        return this.mValue;
    }

    public void addValueObserver(ObjectValueChangedCallback objectValueChangedCallback) {
        this.doAddValueObserver(objectValueChangedCallback);
    }

    protected void sendDefaultValue(ObjectValueChangedCallback objectValueChangedCallback) {
        objectValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void connectToTarget(phC phC2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(phC2 != null));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(this.isActiveOnDocumentThread()));
        phC2.addListener(this);
        this.queueNotifyObservers((String[])phC2.getValue());
    }

    protected void disconnectFromTarget(phC phC2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(phC2 != null));
        phC2.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    public void eventOccurred(BeJ beJ2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(this.getTarget() != null));
        assert (bhj.W1d(Objects.equals(beJ2.WCG(), this.getTarget())));
        String[] stringArray = (String[])((phC)this.getTarget()).getValue();
        this.queueNotifyObservers(stringArray);
    }

    private void queueNotifyObservers(String[] stringArray) {
        assert (bhj.W1d(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(stringArray));
    }

    private void notifyObservers(String[] stringArray) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInterested()));
        if (!Arrays.equals(stringArray, this.mValue)) {
            this.mValue = stringArray;
            if (this.mObservers != null) {
                for (ObjectValueChangedCallback objectValueChangedCallback : this.mObservers) {
                    objectValueChangedCallback.valueChanged(stringArray);
                }
            }
        }
    }
}

