/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.flt.control_surface.values.ManuallyMappedRangedValueTarget;
import java.util.ArrayList;
import java.util.List;

class MultiManuallyMappedRangedValueTarget
extends ManuallyMappedRangedValueTarget
implements CJF {
    private final List mManualMappings;
    private final P3Z mEventSource = new P3Z(false);

    public MultiManuallyMappedRangedValueTarget(List list) {
        assert (bhj.W1d(list != null));
        assert (bhj.W1d(list.size() >= 2));
        this.mManualMappings = new ArrayList(list);
    }

    @Override
    public void connected() {
        super.connected();
        for (FdK fdK : this.mManualMappings) {
            fdK.WCG(this);
        }
    }

    @Override
    public void disconnected() {
        super.disconnected();
        for (FdK fdK : this.mManualMappings) {
            fdK.t3p(this);
        }
    }

    public int getManualMappingCount() {
        return this.mManualMappings.size();
    }

    public FdK getManualMappingAt(int n2) {
        return (FdK)this.mManualMappings.get(n2);
    }

    @Override
    public String getName() {
        return "*Multi*";
    }

    @Override
    public JRA getValueChangedEventSource() {
        return this.mEventSource;
    }

    @Override
    public double getCurrentValue() {
        double d2 = 1.0;
        for (FdK fdK : this.mManualMappings) {
            double d3 = fdK.BiT();
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    @Override
    public boolean isSettable() {
        return true;
    }

    @Override
    public void setCurrentValue(double d2) {
        assert (bhj.W1d(d2 >= 0.0 && d2 <= 1.0));
        for (FdK fdK : this.mManualMappings) {
            fdK.t3p(d2);
        }
    }

    @Override
    public void incrementNormalized(double d2) {
        for (FdK fdK : this.mManualMappings) {
            fdK.ocA(d2);
        }
    }

    @Override
    public double valueToNormalizedValue(double d2) {
        return d2;
    }

    @Override
    public double normalizedValueToValue(double d2) {
        return d2;
    }

    @Override
    public PkP createTruncatableStringForValue(double d2) {
        assert (bhj.W1d(d2 >= 0.0 && d2 <= 1.0));
        int n2 = (int)Math.round(d2 * 100.0);
        return new lSD(n2);
    }

    @Override
    public void eventOccurred(Object object) {
        this.mEventSource.setBoolValue(!this.mEventSource.getBoolValue());
    }

    @Override
    public boolean isContinuous() {
        return true;
    }
}

