/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.UnassignedValueObserver;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IntegerValueProxy
extends ValueProxy
implements YLB,
IntegerValue {
    private int mValue;
    private final int mDefaultValue;
    private List mUnassignedObservers;

    public IntegerValueProxy(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject);
        this.mValue = n2;
        this.mDefaultValue = n2;
    }

    public IntegerValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0);
    }

    @Override
    public Class getTargetType() {
        return xrp.class;
    }

    @Override
    public int get() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public int getControlSurfaceValue() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.doAddValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        if (n2 == this.mDefaultValue) {
            this.addValueObserver(integerValueChangedCallback);
        } else {
            this.checkIsInitializingDriver();
            this.notNull(integerValueChangedCallback, "callback");
            this.doMarkInterested();
            if (this.mUnassignedObservers == null) {
                this.mUnassignedObservers = new ArrayList(2);
            }
            this.mUnassignedObservers.add(new UnassignedValueObserver(integerValueChangedCallback, n2));
        }
    }

    protected void sendDefaultValue(IntegerValueChangedCallback integerValueChangedCallback) {
        integerValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(xrp xrp2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(xrp2 != null));
        xrp2.removeListener(this);
        this.queueNotifyObserversUnassigned();
    }

    protected void connectToTarget(xrp xrp2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(xrp2 != null));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(this.isActiveOnDocumentThread()));
        xrp2.addListener(this);
        this.queueNotifyObservers(xrp2.getIntegerValue());
    }

    public int getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(BeJ beJ2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(Objects.equals(beJ2.WCG(), this.getTarget())));
        int n2 = ((xrp)this.getTarget()).getIntegerValue();
        this.queueNotifyObservers(n2);
    }

    private void queueNotifyObserversUnassigned() {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(this.mDefaultValue, false));
    }

    private void queueNotifyObservers(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(n2, true));
    }

    private void notifyObservers(int n2, boolean bl2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(!bl2 ? n2 == this.mDefaultValue : true));
        if (n2 != this.mValue) {
            this.mValue = n2;
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(n2);
                }
            }
            if (bl2 && this.mUnassignedObservers != null) {
                for (Object object : this.mUnassignedObservers) {
                    ((UnassignedValueObserver)object).mCallback.valueChanged(n2);
                }
            }
        }
        if (!bl2 && this.mUnassignedObservers != null) {
            for (Object object : this.mUnassignedObservers) {
                ((UnassignedValueObserver)object).mCallback.valueChanged(((UnassignedValueObserver)object).mUnassignedValue);
            }
        }
    }
}

