/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.EnumValueChangedCallback;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class EnumValueProxy
extends ValueProxy
implements YLB,
SettableEnumValue {
    private String mValue;
    private final String mInitialValue;
    private final String[] mOptions;

    public EnumValueProxy(ControlSurfaceObject controlSurfaceObject, String[] stringArray, String string) {
        super(controlSurfaceObject);
        assert (bhj.W1d(stringArray != null));
        assert (bhj.ocA(stringArray.length > 0));
        this.mOptions = stringArray;
        this.mInitialValue = string;
        this.mValue = string;
    }

    @Override
    public Class getTargetType() {
        return yqD.class;
    }

    public void addValueObserver(EnumValueChangedCallback enumValueChangedCallback) {
        this.doAddValueObserver(enumValueChangedCallback);
    }

    protected void sendDefaultValue(EnumValueChangedCallback enumValueChangedCallback) {
        enumValueChangedCallback.valueChanged(this.mInitialValue);
    }

    @Override
    public void set(String string) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (string == null) {
            throw new mHK("value cannot be null");
        }
        this.exec(() -> this.doSet(string));
    }

    private void doSet(String string) {
        assert (bhj.W1d(this.isDocumentThread()));
        yqD yqD2 = (yqD)this.getTarget();
        if (yqD2 != null) {
            yqD2.setValue(string);
        }
    }

    protected void disconnectFromTarget(yqD yqD2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(yqD2 != null));
        yqD2.removeListener(this);
        this.queueNotifyObservers(this.mInitialValue);
    }

    protected void connectToTarget(yqD yqD2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(yqD2 != null));
        yqD2.addListener(this);
        this.queueNotifyObservers((String)yqD2.getValue());
    }

    public String[] getOptions() {
        return this.mOptions;
    }

    public String getDefaultValue() {
        return this.mInitialValue;
    }

    public void eventOccurred(BeJ beJ2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(Objects.equals(beJ2.WCG(), this.getTarget())));
        String string = (String)((yqD)this.getTarget()).getValue();
        this.queueNotifyObservers(string);
    }

    private void queueNotifyObservers(String string) {
        assert (bhj.W1d(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(string));
    }

    private void notifyObservers(String string) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInterested()));
        if (!string.equals(this.mValue)) {
            this.mValue = string;
            if (this.mObservers != null) {
                for (EnumValueChangedCallback enumValueChangedCallback : this.mObservers) {
                    enumValueChangedCallback.valueChanged(string);
                }
            }
        }
    }

    @Override
    public String get() {
        assert (bhj.WCG(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }
}

