/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.EnumValueProxy;
import com.bitwig.ramona.core.gMo;

public class EnumSetting
extends EnumValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private syp mIsEnabled;
    private syp mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private gMo mSetting;

    public EnumSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String[] stringArray, String string3) {
        super(controlSurfaceObject, stringArray, string3);
        if (string == null || string.isEmpty()) {
            throw new mHK("Error: label for setting can't be empty.");
        }
        if (stringArray.length < 2) {
            throw new mHK("Enum settings should have at least two options.");
        }
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(uJj uJj2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(uJj2 != null));
        assert (bhj.ocA(this.mSetting == null));
        this.mSetting = uJj2;
        this.setTarget(uJj2.PB());
        this.connectEnableAndVisibleValues(uJj2.YD(), uJj2.AhM());
    }

    public void disconnectFromSetting(uJj uJj2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(uJj2 != null));
        assert (bhj.ocA(this.mSetting == uJj2));
        this.disconnectEnableAndVisibleValues(uJj2.YD(), uJj2.AhM());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(tF tF2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.ocA(this.mSetting == null));
        assert (bhj.W1d(tF2 != null));
        this.mSetting = tF2;
        this.setTarget(tF2.t3p());
        this.connectEnableAndVisibleValues(tF2.aaP(), tF2.hFD());
    }

    public void disconnectFromSetting(tF tF2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(tF2 != null));
        assert (bhj.ocA(this.mSetting == tF2));
        this.disconnectEnableAndVisibleValues(tF2.aaP(), tF2.hFD());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(syp syp2, syp syp3) {
        this.mIsEnabled = syp2;
        this.mIsVisible = syp3;
    }

    private void disconnectEnableAndVisibleValues(syp syp2, syp syp3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public gMo getSetting() {
        return this.mSetting;
    }
}

