/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.flt.control_surface.values.DoubleValueWithValueTypeRangedValueTarget;
import com.bitwig.flt.control_surface.values.RangedValueTarget;
import com.bitwig.ramona.core.l2R;

public class DoubleValueRangedValueTarget
extends RangedValueTarget {
    private final String mName;
    private final BzU mDoubleValue;
    private final double mMin;
    private final double mMax;

    public static RangedValueTarget createForAttribute(l2R l2R2) {
        assert (bhj.W1d(l2R2 != null));
        RS rS2 = xeN.WCG(l2R2);
        assert (bhj.W1d(rS2 != null ? rS2 instanceof fIN : true));
        if (rS2 instanceof fIN) {
            return new DoubleValueWithValueTypeRangedValueTarget(l2R2.WGS(), l2R2, (fIN)rS2);
        }
        Double d2 = (Double)l2R2.getMinValue();
        assert (bhj.W1d(d2 != null));
        Double d3 = (Double)l2R2.getMaxValue();
        assert (bhj.W1d(d3 != null));
        return new DoubleValueRangedValueTarget(l2R2.WGS(), l2R2, d2 != null ? d2 : -1.7976931348623157E308, d3 != null ? d3 : Double.MAX_VALUE);
    }

    public DoubleValueRangedValueTarget(String string, BzU bzU2, double d2, double d3) {
        assert (bhj.W1d(string != null));
        assert (bhj.W1d(!string.isEmpty()));
        assert (bhj.W1d(bzU2 != null));
        this.mName = string;
        this.mDoubleValue = bzU2;
        this.mMin = d2;
        this.mMax = d3;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isSettable() {
        return this.mDoubleValue.isSettable();
    }

    @Override
    public BzU getValueChangedEventSource() {
        return this.mDoubleValue;
    }

    @Override
    public double getCurrentValue() {
        return this.mDoubleValue.getDoubleValue();
    }

    @Override
    public void setCurrentValue(double d2) {
        this.mDoubleValue.setDoubleValue(d2);
    }

    @Override
    public double valueToNormalizedValue(double d2) {
        double d3 = (d2 - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
        assert (bhj.W1d(d3 >= 0.0 && d3 <= 1.0));
        return d3;
    }

    @Override
    public double normalizedValueToValue(double d2) {
        assert (bhj.W1d(d2 >= 0.0 && d2 <= 1.0));
        return this.getMinValue() + d2 * (this.getMaxValue() - this.getMinValue());
    }

    @Override
    public PkP createTruncatableStringForValue(double d2) {
        String string = String.valueOf(d2);
        return new idl(string);
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    public double getMinValue() {
        return this.mMin;
    }

    private double getMaxValue() {
        return this.mMax;
    }
}

