/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class DoubleValueProxy
extends ValueProxy
implements YLB,
DoubleValue {
    private double mValue;
    private final double mDefaultValue;

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject, double d2) {
        super(controlSurfaceObject);
        this.mValue = d2;
        this.mDefaultValue = d2;
    }

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0.0);
    }

    @Override
    public Class getTargetType() {
        return BzU.class;
    }

    @Override
    public double get() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public double getControlSurfaceValue() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        doubleValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(BzU bzU2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(bzU2 != null));
        bzU2.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(BzU bzU2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(bzU2 != null));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(this.isActiveOnDocumentThread()));
        bzU2.addListener(this);
        this.queueNotifyObservers(bzU2.getDoubleValue());
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(BeJ beJ2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(Objects.equals(beJ2.WCG(), this.getTarget())));
        double d2 = ((BzU)this.getTarget()).getDoubleValue();
        this.queueNotifyObservers(d2);
    }

    private void queueNotifyObservers(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(d2));
    }

    private void notifyObservers(double d2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInterested()));
        if (d2 != this.mValue) {
            this.mValue = d2;
            if (this.mObservers != null) {
                for (DoubleValueChangedCallback doubleValueChangedCallback : this.mObservers) {
                    doubleValueChangedCallback.valueChanged(d2);
                }
            }
        }
    }
}

