/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedStringValue$1;
import com.bitwig.flt.control_surface.values.ComputedStringValue$2;
import com.bitwig.flt.control_surface.values.ComputedValue;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;

public class ComputedStringValue
extends ComputedValue
implements StringValue {
    private PkP mValue;
    private PkP mDocumentValue;
    private final PkP mDefaultValue;

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject, PkP pkP) {
        super(controlSurfaceObject);
        assert (bhj.W1d(pkP != null));
        this.mValue = pkP;
        this.mDocumentValue = pkP;
        this.mDefaultValue = pkP;
    }

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, PkP.EMPTY);
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        return this.mValue.getLimited(n2);
    }

    public String getValue() {
        assert (bhj.W1d(this.isDocumentThread()));
        return this.mDocumentValue.get();
    }

    public void setValue(PkP pkP) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(pkP != null));
        if (!pkP.equals(this.mDocumentValue)) {
            this.mDocumentValue = pkP;
            if (this.isInterested()) {
                this.queueNotifyObservers(pkP);
            }
        }
    }

    public final void setValue(String string) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(string != null));
        this.setValue(this.createControlSurfaceStringValue(string));
    }

    public void unassign() {
        assert (bhj.W1d(this.isDocumentThread()));
        this.setValue(this.mDefaultValue);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new ComputedStringValue$1(this, stringValueChangedCallback));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new ComputedStringValue$2(this, stringValueChangedCallback, string, n2));
    }

    protected void sendInitialValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        controlSurfaceStringValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(PkP pkP) {
        assert (bhj.W1d(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(pkP));
    }

    private void notifyObservers(PkP pkP) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInterested()));
        if (!pkP.equals(this.mValue)) {
            this.mValue = pkP;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(pkP);
                }
            }
        }
    }

    protected PkP createControlSurfaceStringValue(String string) {
        assert (bhj.W1d(this.isDocumentThread() || this.isInitializingDriver()));
        assert (bhj.W1d(string != null));
        if (string.isEmpty()) {
            return PkP.EMPTY;
        }
        return new DeV(string);
    }

    protected PkP getControlSurfaceString() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.mValue != null));
        return this.mValue;
    }

    static /* synthetic */ PkP access$000(ComputedStringValue computedStringValue) {
        return computedStringValue.mDefaultValue;
    }
}

