/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.controller.api.ColorValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;

public class ComputedColorValue
extends ComputedValue
implements ColorValue {
    private gnD mValue;
    private gnD mDocumentValue;

    public ComputedColorValue(ControlSurfaceObject controlSurfaceObject, gnD gnD2) {
        super(controlSurfaceObject);
        this.mValue = gnD2;
        this.mDocumentValue = gnD2;
    }

    @Override
    public float red() {
        assert (bhj.WCG(this.isControlSurfaceThread()));
        return this.mValue.LQe();
    }

    @Override
    public float green() {
        assert (bhj.WCG(this.isControlSurfaceThread()));
        return this.mValue.BiT();
    }

    @Override
    public float blue() {
        assert (bhj.WCG(this.isControlSurfaceThread()));
        return this.mValue.PB();
    }

    @Override
    public float alpha() {
        assert (bhj.WCG(this.isControlSurfaceThread()));
        this.newSince(5);
        return this.mValue.LZT();
    }

    public gnD getValue() {
        assert (bhj.WCG(this.isDocumentThread()));
        return this.mDocumentValue;
    }

    public void setValue(gnD gnD2) {
        assert (bhj.WCG(this.isDocumentThread()));
        if (!gnD2.WCG(this.mDocumentValue)) {
            this.mDocumentValue = gnD2;
            if (this.isInterested()) {
                this.queueNotifyObservers(gnD2);
            }
        }
    }

    public void addValueObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.doAddValueObserver(colorValueChangedCallback);
    }

    protected void sendInitialValue(ColorValueChangedCallback colorValueChangedCallback) {
        colorValueChangedCallback.valueChanged(this.mValue.LQe(), this.mValue.BiT(), this.mValue.PB());
    }

    private void queueNotifyObservers(gnD gnD2) {
        assert (bhj.WCG(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(gnD2));
    }

    private void notifyObservers(gnD gnD2) {
        assert (bhj.WCG(this.isControlSurfaceThread()));
        assert (bhj.WCG(this.isInterested()));
        if (!gnD2.WCG(this.mValue)) {
            this.mValue = gnD2;
            if (this.mObservers != null) {
                for (ColorValueChangedCallback colorValueChangedCallback : this.mObservers) {
                    colorValueChangedCallback.valueChanged(gnD2.LQe(), gnD2.BiT(), gnD2.PB());
                }
            }
        }
    }
}

