/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy$IntegerScaledValueObserver;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.RangedValueTarget;
import com.bitwig.flt.control_surface.values.ValueProxy;
import com.bitwig.flt.prefs.XYv;
import com.bitwig.ramona.core.I2N;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRangedValueProxy
extends ValueProxy
implements CJF,
SettableRangedValue {
    public static double TAKEOVER_THRESHOLD = 0.05;
    private double mRawValue;
    private double mNormalizedValue;
    private List mRawValueCallbacks;
    private List mIntegerScaledValueObservers;
    protected final ComputedStringValue mDisplayedValue = this.createDisplayedValue();
    private boolean mHasBeenCaught;
    private boolean mIsSettingValue;
    private double mLastSetNormalizedValue = -1.0;
    private JRA mValueChangedEventSource;
    private double mLastSetControllerValue = -1.0;

    protected AbstractRangedValueProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    @Override
    public double getRaw() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mRawValue;
    }

    @Override
    public double get() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mNormalizedValue;
    }

    @Override
    public StringValue displayedValue() {
        this.newSince(2);
        return this.mDisplayedValue;
    }

    public ComputedStringValue getDisplayedValue() {
        return this.mDisplayedValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    @Override
    protected boolean wantsToSendInitialDefaultValue() {
        return false;
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (bhj.W1d(false));
        assert (bhj.W1d(this.isControlSurfaceThread()));
    }

    @Override
    public void addValueObserver(int n2, IntegerValueChangedCallback integerValueChangedCallback) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        if (n2 <= 1) {
            throw new mHK("Range must be > 1");
        }
        this.doMarkInterested();
        if (this.mIntegerScaledValueObservers == null) {
            this.mIntegerScaledValueObservers = new ArrayList(2);
        }
        this.mIntegerScaledValueObservers.add(new AbstractRangedValueProxy$IntegerScaledValueObserver(n2, integerValueChangedCallback));
    }

    @Override
    public final void set(Number number, Number number2) {
        double d2;
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (number == null || number2 == null) {
            throw new mHK("Cannot provide null for value or resolution");
        }
        double d3 = number.doubleValue();
        if (d3 > (d2 = number2.doubleValue()) - 1.0) {
            this.getControlSurface().t3p("Value must be <= range - 1. Setting value to range - 1");
        }
        if (d3 < 0.0) {
            this.getControlSurface().t3p("Value must be >= 0. Setting value to 0");
        }
        d3 = Us.t3p(d3, 0.0, d2 - 1.0);
        assert (bhj.W1d(number != null));
        assert (bhj.W1d(number2 != null));
        double d4 = d2 >= 2.0 ? 1.0 / (d2 - 1.0) : 1.0;
        double d5 = d3 * d4;
        assert (bhj.W1d(d5 >= 0.0 && d5 <= 1.0));
        this.setNormalizedValue(d5, this.shouldSetImmediately());
    }

    @Override
    public final void set(double d2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.inRange(d2, 0.0, 1.0, "value");
        this.setNormalizedValue(d2, this.shouldSetImmediately());
    }

    void updateHasBeenCaughtFromCurrentDistance() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.getTarget() != null) {
            this.mHasBeenCaught = this.mLastSetControllerValue == -1.0 ? false : AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(this.mLastSetControllerValue, this.getCurrentValue());
        }
    }

    private boolean shouldSetImmediately() {
        abW abW2 = this.getControlSurface();
        if (abW2.FAX().FI()) {
            return !abW2.UaU().FI();
        }
        return false;
    }

    @Override
    public void setImmediately(double d2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.newSince(4);
        this.inRange(d2, 0.0, 1.0, "value");
        this.setNormalizedValue(d2, true);
    }

    private void setNormalizedValue(double d2, boolean bl2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(d2 >= 0.0 && d2 <= 1.0));
        this.postEvent(new Bwg(this, d2, bl2, this.getTouchId()));
    }

    protected int getTouchId() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        return 0;
    }

    public void doSetNormalizedValueWithTakeOver(double d2, XYv xYv, cHr cHr2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(d2 >= 0.0 && d2 <= 1.0));
        assert (bhj.W1d(xYv != null));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            boolean bl2;
            boolean bl3 = this.mLastSetControllerValue != -1.0;
            double d3 = d2 - this.mLastSetControllerValue;
            this.mLastSetControllerValue = d2;
            boolean bl4 = bl2 = !rangedValueTarget.isContinuous();
            if (this.mHasBeenCaught || xYv == XYv.WCG || bl2) {
                this.doSetNormalizedValueImmediately(d2);
            } else if (xYv == XYv.W1d) {
                assert (bhj.t3p(!this.mHasBeenCaught));
                double d4 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                if (AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d2, d4)) {
                    this.doSetNormalizedValueImmediately(d2);
                    return;
                }
                if (bl3) {
                    boolean bl5 = d3 > 0.0;
                    double d5 = bl5 ? 1.0 : 0.0;
                    double d6 = d2 - d5;
                    double d7 = d4 - d5;
                    if (Math.abs(d6) > 0.01) {
                        double d8 = d7 / d6;
                        this.doIncNormalized(d3 * d8);
                    }
                }
                if (rangedValueTarget.shouldShowPopupNotifications()) {
                    this.doShowVisualizations();
                }
            } else {
                assert (bhj.W1d(!this.mHasBeenCaught));
                assert (bhj.W1d(xYv != XYv.WCG));
                double d9 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                boolean bl6 = false;
                if (this.mLastSetNormalizedValue != -1.0) {
                    double d10 = cHr2 != null ? cHr2.aaP(0) : d2;
                    bl6 = AbstractRangedValueProxy.shouldBeCaughtByMovement(this.mLastSetNormalizedValue, d10, d9, xYv);
                }
                if (!bl6 && cHr2 != null) {
                    for (int i2 = 0; !bl6 && i2 < cHr2.size() - 1; ++i2) {
                        double d11 = cHr2.aaP(i2);
                        double d12 = cHr2.aaP(i2 + 1);
                        bl6 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d11, d12, d9, xYv);
                    }
                    if (!bl6) {
                        double d13 = cHr2.aaP(cHr2.size() - 1);
                        bl6 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d13, d2, d9, xYv);
                    }
                }
                if (!bl6 && cHr2 == null) {
                    bl6 = AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d2, d9);
                }
                if (bl6) {
                    this.doSetNormalizedValueImmediately(d2);
                } else if (rangedValueTarget.shouldShowPopupNotifications()) {
                    this.doShowVisualizations();
                }
            }
        }
    }

    private static boolean shouldBeCaughtByMovement(double d2, double d3, double d4, XYv xYv) {
        assert (bhj.W1d(d2 >= 0.0 && d2 <= 1.0));
        assert (bhj.W1d(d3 >= 0.0 && d3 <= 1.0));
        assert (bhj.W1d(d4 >= 0.0 && d4 <= 1.0));
        assert (bhj.W1d(xYv != null));
        double d5 = Math.min(d2, d3);
        double d6 = Math.max(d2, d3);
        if (d4 >= d5 && d4 <= d6) {
            return true;
        }
        return Us.W1d(d4, Math.min(d2, d3), Math.max(d2, d3)) || AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d2, d4) || AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d3, d4);
    }

    private static boolean isValueCloseEnoughForTakeOver(double d2, double d3) {
        return Math.abs(d2 - d3) <= TAKEOVER_THRESHOLD;
    }

    public void doSetNormalizedValueImmediately(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(d2 >= 0.0 && d2 <= 1.0));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            double d3 = this.normalizedValueToValue(d2);
            this.setCurrentValue(d3);
            this.mLastSetNormalizedValue = d2;
            this.mLastSetControllerValue = d2;
            this.mHasBeenCaught = true;
        }
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    @Override
    public final void inc(Number number, Number number2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (number == null) {
            throw new mHK("increment cannot be null");
        }
        if (number2 == null) {
            throw new mHK("range cannot be null");
        }
        if (number2.doubleValue() <= 1.0) {
            throw new mHK("range must be > 1");
        }
        double d2 = number.doubleValue() / (number2.doubleValue() - 1.0);
        this.incNormalized(d2);
    }

    @Override
    public void inc(double d2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.inRange(d2, -1.0, 1.0, "increment");
        this.newSince(2);
        this.incNormalized(d2);
    }

    public void incNormalized(double d2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(d2 >= -1.0 && d2 <= 1.0));
        this.postEvent(new Bwg(this, d2, this.getTouchId()));
    }

    public boolean isMappable() {
        return false;
    }

    public boolean addMapping(wSA wSA2, boolean bl2, I2N i2N, qnz qnz2) {
        assert (bhj.W1d(this.isMappable()));
        return false;
    }

    @Override
    public void addRawValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.notNull(doubleValueChangedCallback, "callback");
        this.checkIsInitializingDriver();
        this.doMarkInterested();
        if (this.mRawValueCallbacks == null) {
            this.mRawValueCallbacks = new ArrayList(2);
        }
        this.mRawValueCallbacks.add(doubleValueChangedCallback);
    }

    @Override
    public void setRaw(double d2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetRaw(d2));
    }

    private void doSetRaw(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(d2));
        }
    }

    @Override
    public void incRaw(double d2) {
        this.exec(() -> this.doIncRaw(d2));
    }

    private void doIncRaw(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(this.getCurrentValue() + d2));
        }
    }

    protected double validateRawValue(double d2) {
        return d2;
    }

    protected void connectToTargetAlways(RangedValueTarget rangedValueTarget) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(rangedValueTarget != null));
        assert (bhj.W1d(this.mValueChangedEventSource == null));
        super.connectToTargetAlways(rangedValueTarget);
        this.mValueChangedEventSource = rangedValueTarget.getValueChangedEventSource();
        if (this.mValueChangedEventSource != null) {
            this.mValueChangedEventSource.addListener(this);
        }
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    public void connectToTarget(RangedValueTarget rangedValueTarget) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(rangedValueTarget != null));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(this.isActiveOnDocumentThread()));
        rangedValueTarget.connected();
        this.updateValueFromTarget();
    }

    protected void disconnectFromTargetAlways(RangedValueTarget rangedValueTarget) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(rangedValueTarget != null));
        super.disconnectFromTargetAlways(rangedValueTarget);
        if (this.mValueChangedEventSource != null) {
            this.mValueChangedEventSource.removeListener(this);
            this.mValueChangedEventSource = null;
        }
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    public void disconnectFromTarget(RangedValueTarget rangedValueTarget) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(rangedValueTarget != null));
        rangedValueTarget.disconnected();
        this.queueNotifyObservers(0.0, 0.0);
        if (this.mDisplayedValue.isInterested()) {
            this.mDisplayedValue.unassign();
        }
    }

    @Override
    public void eventOccurred(Object object) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        this.updateValueFromTarget();
        if (!this.mIsSettingValue) {
            this.updateHasBeenCaughtFromCurrentDistance();
        }
    }

    private void updateValueFromTarget() {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        double d2 = this.getCurrentValue();
        if (this.isInterested()) {
            this.queueNotifyObserversRaw(d2);
        }
        if (this.mDisplayedValue.isInterested()) {
            PkP pkP = this.createTruncatableString(d2);
            assert (bhj.W1d(pkP != null));
            this.mDisplayedValue.setValue(pkP);
        }
    }

    protected ComputedStringValue createDisplayedValue() {
        return new ComputedStringValue(this);
    }

    protected PkP createTruncatableString(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).createTruncatableStringForValue(d2);
    }

    protected double getCurrentValue() {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).getCurrentValue();
    }

    protected void setCurrentValue(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        assert (bhj.W1d(((RangedValueTarget)this.getTarget()).isSettable()));
        assert (bhj.W1d(!this.mIsSettingValue));
        this.beginSettingValue();
        ((RangedValueTarget)this.getTarget()).setCurrentValue(d2);
        this.endSettingValue();
    }

    protected double valueToNormalizedValue(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).valueToNormalizedValue(d2);
    }

    protected double normalizedValueToValue(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).normalizedValueToValue(d2);
    }

    public void doIncNormalized(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(!this.mIsSettingValue));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.beginSettingValue();
            rangedValueTarget.incrementNormalized(d2);
            this.endSettingValue();
        }
    }

    private void beginSettingValue() {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(!this.mIsSettingValue));
        this.mIsSettingValue = true;
    }

    private void endSettingValue() {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.mIsSettingValue));
        assert (bhj.W1d(this.getTarget() != null));
        assert (bhj.W1d(((RangedValueTarget)this.getTarget()).isSettable()));
        this.mIsSettingValue = false;
        if (((RangedValueTarget)this.getTarget()).shouldShowPopupNotifications()) {
            this.doShowVisualizations();
        }
    }

    public void showVisualizations() {
        assert (bhj.W1d(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable() && rangedValueTarget.shouldShowPopupNotifications()) {
            this.doShowVisualizations();
        }
    }

    private void doShowVisualizations() {
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(rangedValueTarget != null));
        assert (bhj.W1d(rangedValueTarget.isSettable()));
        assert (bhj.W1d(rangedValueTarget.shouldShowPopupNotifications()));
        this.getControlSurface().WCG(this);
    }

    private final void queueNotifyObserversRaw(double d2) {
        assert (bhj.W1d(this.isInterested()));
        double d3 = this.valueToNormalizedValue(d2);
        this.queueNotifyObservers(d2, d3);
    }

    private void queueNotifyObservers(double d2, double d3) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(d3 >= 0.0 && d3 <= 1.0));
        assert (bhj.W1d(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(d2, d3));
    }

    private void notifyObservers(double d2, double d3) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInterested()));
        assert (bhj.W1d(d3 >= 0.0 && d3 <= 1.0));
        double d4 = this.mRawValue;
        double d5 = this.mNormalizedValue;
        this.mRawValue = d2;
        this.mNormalizedValue = d3;
        if (d3 != d5) {
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(d3);
                }
            }
            if (this.mIntegerScaledValueObservers != null) {
                for (Object object : this.mIntegerScaledValueObservers) {
                    IntegerValueChangedCallback integerValueChangedCallback = AbstractRangedValueProxy$IntegerScaledValueObserver.access$000((AbstractRangedValueProxy$IntegerScaledValueObserver)object);
                    int n2 = AbstractRangedValueProxy$IntegerScaledValueObserver.access$100((AbstractRangedValueProxy$IntegerScaledValueObserver)object);
                    int n3 = Us.WCG(Math.round((float)d3 * (float)n2 - 0.5f), 0, n2 - 1);
                    integerValueChangedCallback.valueChanged(n3);
                }
            }
        }
        if (d2 != d4 && this.mRawValueCallbacks != null) {
            for (Object object : this.mRawValueCallbacks) {
                object.valueChanged(d2);
            }
        }
    }

    public void doTouch(boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
    }

    public boolean hasBeenCaught() {
        assert (bhj.t3p(this.isDocumentThread()));
        return this.mHasBeenCaught;
    }

    public double getLastSetControllerValue() {
        return this.mLastSetControllerValue;
    }
}

