/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.UsbInterfaceMatcher;
import com.bitwig.extension.controller.api.UsbInterface;
import com.bitwig.extension.controller.api.UsbPipe;
import com.bitwig.flt.control_surface.proxy.UsbBulkInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbBulkOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbDeviceImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbPipeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UsbInterfaceImpl
implements UsbInterface {
    private final UsbDeviceImpl mDevice;
    private bzA mClaimedInterface;
    private final gwi mMatchResult;
    private final List mPipes;

    UsbInterfaceImpl(UsbDeviceImpl usbDeviceImpl, gwi gwi2) {
        this.mDevice = usbDeviceImpl;
        this.mMatchResult = gwi2;
        this.mPipes = new ArrayList(gwi2.W1d().size());
        for (e e3 : gwi2.W1d()) {
            UsbPipeImpl usbPipeImpl = UsbInterfaceImpl.createUsbPipe(usbDeviceImpl, e3);
            this.mPipes.add(usbPipeImpl);
        }
    }

    private static UsbPipeImpl createUsbPipe(UsbDeviceImpl usbDeviceImpl, e e3) {
        bzG bzG2 = e3.WCG().WCG();
        boolean bl2 = e3.WCG().t3p();
        switch (bzG2) {
            case W1d: {
                return bl2 ? new UsbBulkOutputPipeImpl(usbDeviceImpl, e3) : new UsbBulkInputPipeImpl(usbDeviceImpl, e3);
            }
            case pqd: {
                return bl2 ? new UsbInterruptOutputPipeImpl(usbDeviceImpl, e3) : new UsbInterruptInputPipeImpl(usbDeviceImpl, e3);
            }
        }
        throw new IllegalStateException("Unknown matcher transfer type " + (Object)((Object)bzG2));
    }

    @Override
    public UsbInterfaceMatcher interfaceMatcher() {
        return this.mMatchResult.t3p();
    }

    @Override
    public List pipes() {
        return Collections.unmodifiableList(this.mPipes);
    }

    @Override
    public UsbPipe pipe(int n2) {
        return (UsbPipe)this.mPipes.get(n2);
    }

    @Override
    public int pipeCount() {
        return this.mPipes.size();
    }

    void claim() {
        this.mClaimedInterface = this.mDevice.getDeviceHandle().t3p(this.mMatchResult.WCG().W1d);
    }

    void release() {
        if (this.mClaimedInterface != null) {
            this.mClaimedInterface.WCG();
            this.mClaimedInterface = null;
        }
    }
}

