/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.api.Color;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.extension.controller.api.Settings;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.BooleanSetting;
import com.bitwig.flt.control_surface.values.ColorSetting;
import com.bitwig.flt.control_surface.values.EnumSetting;
import com.bitwig.flt.control_surface.values.NumberSetting;
import com.bitwig.flt.control_surface.values.SignalSetting;
import com.bitwig.flt.control_surface.values.StringSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SettingsProxy
extends ControlSurfaceDocumentProxy
implements Settings {
    protected Map mSettings = new HashMap(32);
    protected List mCategories = new ArrayList(4);

    public SettingsProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.setKey(string);
    }

    private void addSetting(Setting setting) {
        List<Setting> list;
        assert (bhj.W1d(setting != null));
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.checkCanAddSetting(setting.getLabel(), setting.getCategory());
        this.addChild((ControlSurfaceObject)((Object)setting));
        String string = setting.getCategory();
        if (!this.mCategories.contains(string)) {
            this.mCategories.add(string);
        }
        if (this.mSettings.containsKey(string)) {
            list = (List)this.mSettings.get(string);
        } else {
            list = new ArrayList(32);
            this.mSettings.put(string, list);
        }
        list.add(setting);
    }

    protected final int getSettingIndex(Setting setting) {
        return this.getSettings(setting.getCategory()).indexOf(setting);
    }

    public List getSettings(String string) {
        return (List)this.mSettings.get(string);
    }

    private void checkCanAddSetting(String string, String string2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (string == null || string.isEmpty()) {
            throw new mHK("Label must be provided for a setting");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new mHK("Category must be provided for a setting");
        }
        if (!this.getControlSurface().BiT()) {
            throw new mHK("Settings can only be added during script initialization");
        }
        List list = (List)this.mSettings.get(string2);
        if (list != null && list.stream().anyMatch(setting -> setting.getLabel().equals(string))) {
            throw new mHK("A setting with name " + string + " in category " + string2 + " has already been added");
        }
    }

    @Override
    public SignalSetting getSignalSetting(String string, String string2, String string3) {
        this.notEmpty(string, "label");
        SignalSetting signalSetting = new SignalSetting(this, string, string2, string3);
        this.addSetting(signalSetting);
        return signalSetting;
    }

    @Override
    public NumberSetting getNumberSetting(String string, String string2, double d2, double d3, double d4, String string3, double d5) {
        this.notEmpty(string, "label");
        NumberSetting numberSetting = new NumberSetting(this, string, string2, d2, d3, d4, string3, d5);
        this.addSetting(numberSetting);
        return numberSetting;
    }

    @Override
    public EnumSetting getEnumSetting(String string, String string2, String[] stringArray, String string3) {
        this.notEmpty(string, "label");
        EnumSetting enumSetting = new EnumSetting(this, string, string2, stringArray, string3);
        this.addSetting(enumSetting);
        return enumSetting;
    }

    @Override
    public StringSetting getStringSetting(String string, String string2, int n2, String string3) {
        this.notEmpty(string, "label");
        StringSetting stringSetting = new StringSetting(this, string, string2, string3);
        this.addSetting(stringSetting);
        return stringSetting;
    }

    @Override
    public SettableColorValue getColorSetting(String string, String string2, Color color) {
        this.newSince(5);
        this.notEmpty(string, "label");
        this.validColor(color, "initialColor");
        ColorSetting colorSetting = new ColorSetting((ControlSurfaceObject)this, string, string2, color);
        this.addSetting(colorSetting);
        return colorSetting;
    }

    @Override
    public SettableBooleanValue getBooleanSetting(String string, String string2, boolean bl2) {
        this.newSince(7);
        this.notEmpty(string, "label");
        BooleanSetting booleanSetting = new BooleanSetting(this, string, string2, bl2);
        this.addSetting(booleanSetting);
        return booleanSetting;
    }
}

