/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.flt.app.l2R;
import com.bitwig.flt.control_surface.proxy.ListToFixedSizeWindowValue$1;
import com.bitwig.flt.control_surface.proxy.ListToFixedSizeWindowValue$ChangeListener;
import java.util.ArrayList;
import java.util.List;

public class ListToFixedSizeWindowValue
extends cAE {
    private ArrayList mSlaves;
    private P3Z mCanScrollUp;
    private P3Z mCanScrollDown;
    private P3Z mCanScrollPageUp;
    private P3Z mCanScrollPageDown;
    private VZf mWindowOffset;
    private VZf mListItemCount;
    private final int mWindowSize;
    private final oSh mList;
    private List mCurrentWindow;
    private ListToFixedSizeWindowValue$ChangeListener mListener;
    private boolean mHasBeenDisposed;
    private int mPageAlignment;
    private boolean mHasInvalidatedWindow;

    public ListToFixedSizeWindowValue(int n2, oSh oSh2, ListToFixedSizeWindowValue$ChangeListener listToFixedSizeWindowValue$ChangeListener) {
        super(true);
        assert (bhj.t3p(n2 > 0));
        this.mWindowSize = n2;
        this.mList = oSh2;
        this.mListener = listToFixedSizeWindowValue$ChangeListener;
        this.mWindowOffset = new VZf(0);
        this.mListItemCount = new VZf(0);
        this.mSlaves = new ArrayList(3);
        this.mCanScrollUp = new P3Z(false);
        this.mCanScrollDown = new P3Z(false);
        this.mCanScrollPageUp = new P3Z(false);
        this.mCanScrollPageDown = new P3Z(false);
        this.addSource(this.mList);
    }

    public void addSlave(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        this.mSlaves.add(listToFixedSizeWindowValue);
        listToFixedSizeWindowValue.scrollToOffset(this.mWindowOffset.getValue(), true, false);
    }

    public void removeSlave(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        this.mSlaves.remove(listToFixedSizeWindowValue);
    }

    private void invalidateWindow() {
        if (!this.mHasInvalidatedWindow) {
            this.mHasInvalidatedWindow = true;
            l2R.j_().pqd(new ListToFixedSizeWindowValue$1(this));
        }
    }

    private void updateWindow() {
        int n2;
        int n3;
        if (this.mHasBeenDisposed || this.mWindowSize == 0) {
            return;
        }
        List list = this.mCurrentWindow;
        ArrayList<Object> arrayList = new ArrayList<Object>(this.mWindowSize);
        int n4 = this.mList.t3p();
        for (n3 = 0; n3 < this.mWindowSize; ++n3) {
            n2 = this.mWindowOffset.getValue() + n3;
            if (n2 < n4) {
                arrayList.add(this.mList.t3p(n2));
                continue;
            }
            arrayList.add(null);
        }
        n3 = this.mCurrentWindow == null ? 1 : 0;
        this.mCurrentWindow = arrayList;
        if (n3 != 0) {
            n2 = 0;
            for (Object e3 : arrayList) {
                this.mListener.onAssign(n2++, null, e3);
            }
        } else {
            for (n2 = 0; n2 < this.mWindowSize; ++n2) {
                if (arrayList.get(n2) == list.get(n2)) continue;
                this.mListener.onAssign(n2, list.get(n2), arrayList.get(n2));
            }
        }
        this.mListItemCount.setValue(n4);
        this.updateScrollableStatus();
    }

    public P3Z getCanScrollDown() {
        return this.mCanScrollDown;
    }

    public P3Z getCanScrollUp() {
        return this.mCanScrollUp;
    }

    public P3Z getCanScrollPageDown() {
        return this.mCanScrollPageDown;
    }

    public P3Z getCanScrollPageUp() {
        return this.mCanScrollPageUp;
    }

    private void updateScrollableStatus() {
        int n2 = this.mList.t3p();
        this.mCanScrollUp.WCG(this.mWindowOffset.getValue() > 0);
        this.mCanScrollDown.WCG(this.mWindowOffset.getValue() < n2 - this.mWindowSize);
        this.mCanScrollPageUp.WCG(this.mWindowOffset.getValue() > 0);
        int n3 = (n2 - 1) / this.mWindowSize * this.mWindowSize;
        this.mCanScrollPageDown.WCG(this.mWindowOffset.getValue() < n3);
    }

    public void dispose() {
        assert (bhj.ocA(!this.mHasBeenDisposed));
        this.removeSource(this.mList);
        this.mHasBeenDisposed = true;
    }

    public void shiftWindow(int n2) {
        this.shiftWindow(n2, false);
    }

    public void shiftWindow(int n2, boolean bl2) {
        this.scrollToOffset(this.mWindowOffset.getValue() + n2, bl2, false);
    }

    public void shiftWindowPage(int n2) {
        int n3 = this.mWindowOffset.getValue() + n2 * this.mWindowSize;
        this.scrollToOffset(n3, true, true);
    }

    public void scrollTo(int n2) {
        this.scrollToOffset(n2, false, true);
    }

    public void scrollToOffset(int n2, boolean bl2, boolean bl3) {
        int n3;
        int n4 = bl3 ? this.quantizePosition(n2) : (n3 = Math.max(0, Math.min(n2, this.mList.t3p() - (bl2 ? 1 : this.mWindowSize))));
        if (this.mWindowOffset.getValue() != n3) {
            this.mWindowOffset.setValue(n3);
            this.updateWindow();
            for (ListToFixedSizeWindowValue listToFixedSizeWindowValue : this.mSlaves) {
                listToFixedSizeWindowValue.scrollToOffset(this.mWindowOffset.getValue(), bl2, false);
            }
        }
    }

    protected int quantizePosition(int n2) {
        int n3 = this.mPageAlignment % this.mWindowSize;
        int n4 = (n2 - n3) / this.mWindowSize * this.mWindowSize + n3;
        if (n4 < this.mWindowOffset.getValue() - this.mWindowSize) {
            n4 += this.mWindowSize;
        }
        int n5 = (this.mList.t3p() - 1) / this.mWindowSize * this.mWindowSize;
        return Us.WCG(n4, 0, n5);
    }

    @Override
    public void changedItems(oSh oSh2, int n2, int n3) {
        this.invalidateWindow();
    }

    @Override
    public void addedAsListenerTo(oSh oSh2) {
        this.invalidateWindow();
    }

    @Override
    public void aboutToRemoveAsListenerFrom(oSh oSh2) {
        for (int i2 = 0; i2 < this.mWindowSize; ++i2) {
            if (this.mCurrentWindow == null || this.mCurrentWindow.get(i2) == null) continue;
            this.mListener.onAssign(i2, this.mCurrentWindow.get(i2), null);
        }
        this.mListItemCount.setValue(0);
        this.updateScrollableStatus();
    }

    @Override
    public void insertedItems(oSh oSh2, int n2, int n3) {
        this.invalidateWindow();
    }

    @Override
    public void aboutToRemoveItems(oSh oSh2, int n2, int n3) {
        this.invalidateWindow();
    }

    @Override
    protected void insertedItem(oSh oSh2, Object object, int n2) {
        this.invalidateWindow();
    }

    @Override
    protected void aboutToRemoveItem(oSh oSh2, Object object, int n2) {
        this.invalidateWindow();
    }

    public oSh getList() {
        return this.mList;
    }

    public xrp getPosition() {
        return this.mWindowOffset;
    }

    public xrp getListItemCount() {
        return this.mListItemCount;
    }

    public int getPageAlignment() {
        return this.mPageAlignment;
    }

    public void setPageAlignment(int n2) {
        this.mPageAlignment = n2;
    }

    static /* synthetic */ void access$000(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        listToFixedSizeWindowValue.updateWindow();
    }

    static /* synthetic */ boolean access$102(ListToFixedSizeWindowValue listToFixedSizeWindowValue, boolean bl2) {
        listToFixedSizeWindowValue.mHasInvalidatedWindow = bl2;
        return listToFixedSizeWindowValue.mHasInvalidatedWindow;
    }
}

