/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.DrumPadBank;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DrumPadProxy;
import com.bitwig.flt.document.core.iface.doC;
import java.util.ArrayList;
import java.util.List;

public class DrumPadBankProxy
extends ChannelBankProxy
implements DrumPadBank {
    private boolean mIsIndicating = true;
    private final int mNumLanes;
    private final List mPads;

    public DrumPadBankProxy(ControlSurfaceObject controlSurfaceObject, int n2, int n3) {
        super(controlSurfaceObject, "DrumPadBank-" + n2, n2, n3);
        if (n2 < 1) {
            throw new mHK("At least 1 track is required.");
        }
        this.mNumLanes = n2;
        this.mPads = new ArrayList(n2);
        this.mChannelScrollStepSize = 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getKey() + "/Pad" + i2;
            DrumPadProxy drumPadProxy = new DrumPadProxy(this, string, i2, n3, this.mIsIndicating);
            this.mPads.add(drumPadProxy);
            this.addChild(drumPadProxy);
        }
        this.initChannelProxies();
    }

    @Override
    public Class getTargetType() {
        return dQv.class;
    }

    protected doC getDocumentFromTarget(dQv dQv2) {
        return dQv2.dCO();
    }

    @Override
    public void setIndication(boolean bl2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetIndication(bl2));
    }

    private void doSetIndication(boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            DrumPadProxy drumPadProxy = (DrumPadProxy)controlSurfaceProxy;
            drumPadProxy.setIndicating(bl2);
        }
    }

    @Override
    protected int getScrollPositionThatPageShouldAlignTo() {
        return 36;
    }

    @Override
    protected DrumPadProxy createChannelProxy(int n2, int n3, String string) {
        return new DrumPadProxy(this, string + n3, n3, n2, this.mIsIndicating);
    }

    protected oSh getChannelsListValueFromTarget(dQv dQv2) {
        return dQv2.ocA();
    }

    protected void connectToTarget(dQv dQv2) {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (K2 k2 : dQv2.xzw()) {
            int n4 = k2.tGl().BiT();
            n2 = Math.min(n4, n2);
            n3 = Math.max(n4, n3);
        }
        int n5 = this.mChannelBankUpdater.getScrollPositionValue();
        if (n3 >= 0 && (n5 < n2 || n5 > n3)) {
            int n6 = n2 / 4;
            this.mChannelBankUpdater.doScrollTo(4 * n6, true);
        } else {
            this.mChannelBankUpdater.doScrollTo(36, true);
        }
    }

    protected void disconnectFromTarget(dQv dQv2) {
    }
}

