/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.NoteInput$NoteExpression;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import com.bitwig.flt.control_surface.proxy.MIDIEventFilter;
import com.bitwig.flt.control_surface.proxy.ObjectThatWantsToDisposeOnControlSurfaceThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DirectNoteInput
extends ControlSurfaceObject
implements NoteInput,
ObjectThatWantsToDisposeOnControlSurfaceThread {
    private int mEngineNoteInputId;
    private List mFilters;
    private String mName;
    private int mPort;

    public DirectNoteInput(ControlSurfaceObject controlSurfaceObject, int n2, String string, String[] stringArray, boolean bl2) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.INIT);
        this.mPort = n2;
        this.mName = string;
        this.mEngineNoteInputId = this.getMidiReceiver().WCG(bl2);
        this.mFilters = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            try {
                MIDIEventFilter mIDIEventFilter = new MIDIEventFilter(string2);
                this.mFilters.add(mIDIEventFilter);
            }
            catch (mHK mHK2) {
                bhj.WCG.pqd("Could not parse note input mask", mHK2);
            }
        }
        this.sendNoteInputMasks();
    }

    public int getEngineNoteInputId() {
        return this.mEngineNoteInputId;
    }

    @Override
    public void disposeOnControlSurfaceThread() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        try {
            assert (bhj.t3p(this.mEngineNoteInputId >= 0));
            this.getMidiReceiver().WCG(this.mEngineNoteInputId);
            this.mEngineNoteInputId = -1;
        }
        catch (IOException iOException) {
            bhj.WCG.WCG(iOException);
        }
    }

    private void sendNoteInputMasks() {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        int n2 = this.mFilters.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            nArray[n3] = mIDIEventFilter.getCheckMask();
            nArray2[n3] = mIDIEventFilter.getMatchMask();
            ++n3;
        }
        this.getMidiReceiver().WCG(this.mEngineNoteInputId, nArray, nArray2);
    }

    private void sendKeyMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (bhj.W1d(byArray.length == 128));
        this.getMidiReceiver().WCG(this.mEngineNoteInputId, byArray);
    }

    private void sendVelocityMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (bhj.W1d(byArray.length == 128));
        this.getMidiReceiver().t3p(this.mEngineNoteInputId, byArray);
    }

    private pne getMidiReceiver() {
        return (pne)this.getControlSurface().tzx().get(this.mPort);
    }

    public int getPort() {
        return this.mPort;
    }

    @Override
    public void setShouldConsumeEvents(boolean bl2) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiReceiver().WCG(this.mEngineNoteInputId, bl2);
        }
        catch (IOException iOException) {
            throw new Ehy(iOException);
        }
    }

    private byte[] convertJavaScriptArrayToByteArray(Object[] objectArray) {
        byte[] byArray = new byte[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!(objectArray[i2] instanceof Number)) {
                throw new mHK("Object in array not instance of Number");
            }
            Number number = (Number)objectArray[i2];
            if (number.intValue() < -128 || number.intValue() > 127) {
                throw new mHK("Value out of range");
            }
            byArray[i2] = number.byteValue();
        }
        return byArray;
    }

    @Override
    public void setKeyTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new mHK("Map must have a length of 128");
        }
        try {
            this.sendKeyMap(this.convertJavaScriptArrayToByteArray(objectArray));
        }
        catch (IOException iOException) {
            throw new Ehy(iOException);
        }
    }

    @Override
    public void setVelocityTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new mHK("Map must have a length of 128");
        }
        try {
            this.sendVelocityMap(this.convertJavaScriptArrayToByteArray(objectArray));
        }
        catch (IOException iOException) {
            throw new Ehy(iOException);
        }
    }

    @Override
    public void assignPolyphonicAftertouchToExpression(int n2, NoteInput$NoteExpression noteInput$NoteExpression, int n3) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiReceiver().WCG(this.mEngineNoteInputId, n2, noteInput$NoteExpression, n3);
        }
        catch (IOException iOException) {
            throw new Ehy(iOException);
        }
    }

    @Override
    public void setUseExpressiveMidi(boolean bl2, int n2, int n3) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n2 != 0 && n2 != 15) {
            throw new mHK("baseChannel must be either 0 or 15");
        }
        if (n3 < 0 || n3 > 96) {
            throw new mHK("pitchBendRange must be between 0 or 96");
        }
        try {
            this.getMidiReceiver().WCG(this.mEngineNoteInputId, bl2, n2, n3);
        }
        catch (IOException iOException) {
            throw new Ehy(iOException);
        }
    }

    @Override
    public void setUseMultidimensionalPolyphonicExpression(boolean bl2, int n2) {
        this.deprecated(1, 2);
        this.setUseExpressiveMidi(bl2, n2, 48);
    }

    @Override
    public void sendRawMidiEvent(int n2, int n3, int n4) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n2 < 128 || n2 > 255) {
            throw new mHK("Status byte out of range");
        }
        if (n3 < 0 || n3 > 127) {
            throw new mHK("data0 byte out of range");
        }
        if (n4 < 0 || n4 > 127) {
            throw new mHK("data1 byte out of range");
        }
        try {
            this.getMidiReceiver().WCG(this.mEngineNoteInputId, n2, n3, n4);
        }
        catch (IOException iOException) {
            throw new Ehy(iOException);
        }
    }

    public boolean isMatchAll() {
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            if (!mIDIEventFilter.isMatchAll()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.mName;
    }
}

