/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.Browser;
import com.bitwig.extension.controller.api.DeviceBank;
import com.bitwig.extension.controller.api.DeviceChain;
import com.bitwig.extension.controller.api.InsertionPoint;
import com.bitwig.flt.control_surface.proxy.BitwigStudioHost;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceBankProxy;
import com.bitwig.flt.control_surface.proxy.DeviceChainBrowserProxy;
import java.util.ArrayList;
import java.util.List;

public abstract class DeviceChainProxy
extends ControlSurfaceDocumentObjectProxy
implements DeviceChain {
    private lUs mDeviceChain;
    private List mDeviceBanks = new ArrayList(2);
    private DeviceChainBrowserProxy mDeviceBrowser;
    private final VMi mStartOfDeviceChainInsertionPoint = new VMi(this);
    private final WEA mEndOfDeviceChainInsertionPoint = new WEA(this);

    public DeviceChainProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.setKey(string);
    }

    @Override
    public void browseToInsertAtEndOfChain() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.deprecated(2, 7, "Use endOfDeviceChainInsertionPoint().browse() instead.");
        this.exec(this::doBrowseToInsertAtEndOfChain);
    }

    private void doBrowseToInsertAtEndOfChain() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mDeviceChain != null) {
            Cc.t3p(null, this.mDeviceChain);
        }
    }

    @Override
    public void browseToInsertAtStartOfChain() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.deprecated(2, 7, "Use startOfDeviceChainInsertionPoint().browse() instead.");
        this.exec(this::doBrowseToInsertAtStartOfChain);
    }

    private void doBrowseToInsertAtStartOfChain() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mDeviceChain != null) {
            Cc.WCG(null, this.mDeviceChain);
        }
    }

    @Override
    public InsertionPoint startOfDeviceChainInsertionPoint() {
        return this.mStartOfDeviceChainInsertionPoint;
    }

    @Override
    public InsertionPoint endOfDeviceChainInsertionPoint() {
        return this.mEndOfDeviceChainInsertionPoint;
    }

    protected void setDeviceChain(lUs lUs2) {
        if (lUs2 != this.mDeviceChain) {
            if (this.mDeviceChain != null) {
                this.disconnectFromDeviceChain(this.mDeviceChain);
            }
            this.mDeviceChain = lUs2;
            if (this.mDeviceChain != null) {
                this.connectToDeviceChain(this.mDeviceChain);
            }
        }
    }

    private void connectToDeviceChain(lUs lUs2) {
        assert (bhj.ocA(lUs2 != null));
        for (DeviceBankProxy deviceBankProxy : this.mDeviceBanks) {
            deviceBankProxy.setTarget(lUs2);
        }
        if (this.mDeviceBrowser != null) {
            this.mDeviceBrowser.connectToDeviceChain(lUs2);
        }
        this.connectObservers(lUs2);
    }

    private void disconnectFromDeviceChain(lUs lUs2) {
        assert (bhj.ocA(lUs2 != null));
        assert (bhj.ocA(lUs2 == this.mDeviceChain));
        this.disconnectObservers(lUs2);
        if (this.mDeviceBrowser != null) {
            this.mDeviceBrowser.disconnectFromDeviceChain(lUs2);
        }
        for (DeviceBankProxy deviceBankProxy : this.mDeviceBanks) {
            deviceBankProxy.clearTarget();
        }
    }

    @Override
    public DeviceBank createDeviceBank(int n2) {
        DeviceBankProxy deviceBankProxy = new DeviceBankProxy(this, n2, this.getNumSends());
        this.mDeviceBanks.add(deviceBankProxy);
        return deviceBankProxy;
    }

    protected int getNumSends() {
        return 0;
    }

    @Override
    public void select() {
        this.selectInEditor();
    }

    @Override
    public void addIsSelectedObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2);
        this.addIsSelectedInEditorObserver(booleanValueChangedCallback);
    }

    public lUs getDeviceChain() {
        return this.mDeviceChain;
    }

    protected abstract String getAutomaticNotificationPrefix();

    protected abstract String getName();

    protected void showSelectionNotification() {
        BitwigStudioHost bitwigStudioHost = this.getHost();
        if (bitwigStudioHost.getNotificationSettings().shouldShowTrackSelectionNotifications()) {
            this.getControlSurface().WCG(this.getAutomaticNotificationPrefix(), this.getName());
        }
    }

    @Override
    public Browser createDeviceBrowser(int n2, int n3) {
        if (this.mDeviceBrowser == null) {
            this.mDeviceBrowser = new DeviceChainBrowserProxy(this, n2, n3);
            this.addChild(this.mDeviceBrowser);
            if (this.mDeviceChain != null) {
                this.mDeviceBrowser.connectToDeviceChain(this.mDeviceChain);
            }
        }
        return this.mDeviceBrowser;
    }
}

