/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.DeviceBank;
import com.bitwig.extension.controller.api.DeviceChain;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceBankProxy$1;
import com.bitwig.flt.control_surface.proxy.DeviceBankProxy$2;
import com.bitwig.flt.control_surface.proxy.DeviceBankProxy$3;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.DeviceProxy;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.flt.document.core.iface.doC;

public class DeviceBankProxy
extends ControlSurfaceDocumentObjectProxy
implements DeviceBank {
    private final int mNumDevices;
    private final DeviceProxy[] mDeviceProxies;
    private final ListValueBankItemTargetUpdater mDeviceBankUpdater;
    private DeviceChain mDeviceChainSection;

    protected DeviceBankProxy(DeviceChainProxy deviceChainProxy, int n2, int n3) {
        super(deviceChainProxy);
        this.setKey("Device Chain");
        if (n2 < 1) {
            throw new mHK("At least 1 device is required.");
        }
        this.mDeviceChainSection = deviceChainProxy;
        this.mNumDevices = n2;
        this.mDeviceProxies = new DeviceProxy[n2];
        for (int i2 = 0; i2 < this.mNumDevices; ++i2) {
            this.mDeviceProxies[i2] = new DeviceProxy(this, this.getKey() + " / Device " + i2, n3, deviceChainProxy);
        }
        this.mDeviceBankUpdater = new ListValueBankItemTargetUpdater((ControlSurfaceObject)this, this.mDeviceProxies);
    }

    @Override
    public Class getTargetType() {
        return lUs.class;
    }

    protected doC getDocumentFromTarget(lUs lUs2) {
        return lUs2.dCO();
    }

    @Override
    public DeviceChain getDeviceChain() {
        return this.mDeviceChainSection;
    }

    @Override
    public IntegerValue itemCount() {
        return this.mDeviceBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mDeviceBankUpdater.getCursorIndex();
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mDeviceBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mDeviceBankUpdater.getCanScrollForwards();
    }

    @Override
    public int getSizeOfBank() {
        return this.mDeviceBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n2) {
        this.mDeviceBankUpdater.setSizeOfBank(n2);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mDeviceBankUpdater.getCapacityOfBank();
    }

    @Override
    public Device getItemAt(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mDeviceBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n2) {
        this.newSince(7);
        this.mDeviceBankUpdater.scrollIntoView(n2);
    }

    @Override
    public void scrollBy(int n2) {
        this.mDeviceBankUpdater.scrollBy(n2);
    }

    @Override
    public void scrollByPages(int n2) {
        this.mDeviceBankUpdater.scrollByPages(n2);
    }

    public void navigateToDeviceLayer(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0) {
            throw new mHK("layerIndex must be >= 0");
        }
        this.exec(new DeviceBankProxy$1(this, n2, n3));
    }

    public void navigateToKeyPad(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0 || n3 > 127) {
            throw new mHK("Invalid key");
        }
        this.exec(new DeviceBankProxy$2(this, n2, n3));
    }

    public void navigateToDeviceSlot(int n2, String string) {
        this.validIndex(this.mDeviceProxies, n2);
        this.notNull(string, "chain");
        this.exec(new DeviceBankProxy$3(this, n2, string));
    }

    @Override
    public void scrollPageUp() {
        this.mDeviceBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageDown() {
        this.mDeviceBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollUp() {
        this.mDeviceBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.mDeviceBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollTo(int n2) {
        this.mDeviceBankUpdater.scrollIntoView(n2);
    }

    @Override
    public Device getDevice(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    protected void connectToTarget(lUs lUs2) {
        assert (bhj.ocA(lUs2 != null));
        this.mDeviceBankUpdater.setTarget(lUs2.tzx());
        this.connectObservers(lUs2);
    }

    protected void disconnectFromTarget(lUs lUs2) {
        this.mDeviceBankUpdater.clearTarget();
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        this.deprecated(1, 2, "Use scrollPosition() instead");
        this.mDeviceBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback, n2);
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollBackwards() instead");
        this.mDeviceBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollForwards() instead");
        this.mDeviceBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addDeviceCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use itemCount().addValueObserver(callback)");
        this.mDeviceBankUpdater.getListItemCount().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public void browseToInsertDevice(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.inRange(n2, 0, this.getSizeOfBank(), "index");
        this.exec(() -> this.doBrowseToInsertDevice(n2));
    }

    private void doBrowseToInsertDevice(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(n2 >= 0 && n2 <= this.getSizeOfBank()));
        lUs lUs2 = (lUs)this.getTarget();
        if (lUs2 != null) {
            int n3 = Us.WCG(this.mDeviceBankUpdater.getScrollPositionValue() + n2, 0, lUs2.DNK());
            if (n3 > 0) {
                Vbh vbh = lUs2.t3p(n3 - 1);
                Cc.WCG(null, new BV(vbh));
            } else {
                Cc.WCG(null, new BY(lUs2));
            }
        }
    }

    static /* synthetic */ DeviceProxy[] access$000(DeviceBankProxy deviceBankProxy) {
        return deviceBankProxy.mDeviceProxies;
    }
}

