/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.HardwareControlType;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CursorRemoteControlsPageProxy$SelectedPageIndexValue;
import com.bitwig.flt.control_surface.proxy.ParameterBankProxy;
import com.bitwig.flt.control_surface.proxy.RemoteControlProxy;
import com.bitwig.flt.control_surface.proxy.RemoteControlsPageProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.IntegerValueProxy;
import com.bitwig.flt.control_surface.values.SettableIntegerValueProxy;
import com.bitwig.flt.control_surface.values.StringArrayValueProxy;
import com.bitwig.ramona.core.r2H;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class CursorRemoteControlsPageProxy
extends ControlSurfaceDocumentObjectProxy
implements SlN,
CursorRemoteControlsPage,
ParameterBankProxy {
    private static final String[] NO_PAGE_NAMES = new String[0];
    private final CJF mPagesChangedListener = object -> this.invalidatePages();
    private HardwareControlType mHardwareControlType = HardwareControlType.KNOB;
    private int mHardwareColumns = 8;
    private boolean mHasScheduledUpdateToPages;
    private List mPages;
    private final StringArrayValueProxy mPageNamesValue;
    private final SettableIntegerValueProxy mSelectedPageIndexValue;
    private final bIS mPageNames;
    private final VZf mPageCount = new VZf(0);
    private final IntegerValueProxy mPageCountValue;
    private final RemoteControlsPageProxy mSelectedPageProxy;
    private final P3Z mHasPrevParameterPage = new P3Z(false);
    private final P3Z mHasNextParameterPage = new P3Z(false);
    private final CursorRemoteControlsPageProxy$SelectedPageIndexValue mSelectedPageIndex = new CursorRemoteControlsPageProxy$SelectedPageIndexValue(this, 0, null);
    private final BooleanValueProxy mHasNextPageValue;
    private final BooleanValueProxy mHasPreviousPageValue;
    private SDC mPageSelector;
    private boolean mIsChangingPageFromController;
    private final YLB mSelectedPageListener = beJ2 -> this.scheduleUpdateSelectedPage();
    private boolean mHasScheduledUpdateSelectedPage;
    private boolean mWasChangingPageFromControllerWhenScheduling;

    protected CursorRemoteControlsPageProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2) {
        super(controlSurfaceObject);
        assert (bhj.W1d(string != null));
        assert (bhj.W1d(n2 >= 1));
        this.mSelectedPageProxy = new RemoteControlsPageProxy(this, string, n2);
        this.mPageNamesValue = new StringArrayValueProxy((ControlSurfaceObject)this, NO_PAGE_NAMES);
        this.mPageNames = new bIS(NO_PAGE_NAMES);
        this.mSelectedPageIndexValue = new SettableIntegerValueProxy((ControlSurfaceObject)this, -1);
        this.mHasNextPageValue = new BooleanValueProxy(this);
        this.mHasPreviousPageValue = new BooleanValueProxy(this);
        this.mPageCountValue = new IntegerValueProxy(this);
    }

    @Override
    public int getParameterCount() {
        return this.mSelectedPageProxy.getParameterCount();
    }

    @Override
    public RemoteControlProxy getParameter(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        return this.mSelectedPageProxy.getParameter(n2);
    }

    public RemoteControlsPageProxy getSelectedPage() {
        return this.mSelectedPageProxy;
    }

    @Override
    public StringValue getName() {
        this.newSince(4);
        return this.mSelectedPageProxy.getName();
    }

    @Override
    public SettableIntegerValue selectedPageIndex() {
        return this.mSelectedPageIndexValue;
    }

    @Override
    public IntegerValue pageCount() {
        this.newSince(7);
        return this.mPageCountValue;
    }

    private void doSelectPageAtIndex(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mPageSelector != null && n2 >= 0) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.WCG(n2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPreviousPage(boolean bl2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectPreviousPage(bl2));
    }

    private void doSelectPreviousPage(boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.t3p(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectFirst() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(this::doSelectFirst);
    }

    private void doSelectFirst() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.ocA();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectLast() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(this::doSelectLast);
    }

    private void doSelectLast() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.gD_();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectNext() {
        this.selectNextPage(false);
    }

    @Override
    public void selectNextPage(boolean bl2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectNextPage(bl2));
    }

    private void doSelectNextPage(boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.WCG(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectNextPageMatching(String string, boolean bl2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (string == null) {
            throw new mHK("expression cannot be null");
        }
        this.exec(() -> this.doSelectNextPageMatching(string, bl2));
    }

    private void doSelectNextPageMatching(String string, boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.WCG(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPrevious() {
        this.selectPreviousPage(false);
    }

    @Override
    public void selectPreviousPageMatching(String string, boolean bl2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (string == null) {
            throw new mHK("expression cannot be null");
        }
        this.exec(() -> this.doSelectPreviousPageMatching(string, bl2));
    }

    private void doSelectPreviousPageMatching(String string, boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.t3p(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void addCanSelectNextObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasNextPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanSelectPreviousObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasPreviousPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue hasPrevious() {
        return this.mHasPreviousPageValue;
    }

    @Override
    public BooleanValue hasNext() {
        return this.mHasNextPageValue;
    }

    protected abstract SDC getPageSelectorForRemoteControls(uDN var1);

    protected void connectToTarget(uDN uDN2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(uDN2 != null));
        assert (bhj.W1d(this.mPageSelector == null));
        this.mPageSelector = this.getPageSelectorForRemoteControls(uDN2);
        this.mPageNamesValue.setTarget(this.mPageNames);
        uDN2.WCG(this.mPagesChangedListener);
        this.mPageSelector.WCG(this.mSelectedPageListener);
        this.mSelectedPageIndexValue.setTarget(this.mSelectedPageIndex);
        this.mHasNextPageValue.setTarget(this.mHasNextParameterPage);
        this.mHasPreviousPageValue.setTarget(this.mHasPrevParameterPage);
        this.mPageCountValue.setTarget(this.mPageCount);
        this.updatePages();
        this.updateSelectedPage();
    }

    protected void disconnectFromTarget(uDN uDN2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(uDN2 != null));
        assert (bhj.W1d(this.mPageSelector != null));
        this.mSelectedPageIndexValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mPageNamesValue.clearTarget();
        this.mPageSelector.t3p(this.mSelectedPageListener);
        uDN2.t3p(this.mPagesChangedListener);
        this.mPageSelector = null;
        this.mSelectedPageProxy.clearTarget();
    }

    private void invalidatePages() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateToPages) {
            this.mHasScheduledUpdateToPages = true;
            this.runAtEndOfEvent(this::updatePages);
        }
    }

    @Override
    public StringArrayValue pageNames() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        return this.mPageNamesValue;
    }

    private void ensurePagesUpdated() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mHasScheduledUpdateToPages) {
            this.updatePages();
        }
    }

    private void updatePages() {
        assert (bhj.W1d(this.isDocumentThread()));
        this.mHasScheduledUpdateToPages = false;
        this.setPages(this.calculatePages());
    }

    private void setPages(List list) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(list != null));
        if (!Objects.equals(this.mPages, list)) {
            int n2;
            urL urL2;
            this.mPages = list;
            int n3 = this.mPages.size();
            this.mPageCount.setIntegerValue(n3);
            if (this.mPageSelector == null) {
                assert (bhj.W1d(this.mPages.isEmpty()));
                urL2 = null;
                n2 = 0;
            } else {
                urL2 = this.mPageSelector.BiT();
                n2 = this.mPages.indexOf(urL2);
                assert (bhj.W1d(n3 > 0 ? n2 != -1 : true));
                if (n2 == -1) {
                    n2 = this.mSelectedPageIndex.getIntegerValue();
                    if (n2 < 0 || n2 >= n3) {
                        n2 = n3 > 0 ? n3 - 1 : 0;
                    }
                    urL2 = n3 > 0 ? (urL)this.mPages.get(n2) : null;
                    this.mPageSelector.t3p(this.mSelectedPageListener);
                    this.mPageSelector.WCG(urL2);
                    this.mPageSelector.WCG(this.mSelectedPageListener);
                }
            }
            this.mSelectedPageIndex.doSetValue(n2);
            this.mSelectedPageProxy.setTarget(urL2);
            this.mHasPrevParameterPage.setBoolValue(n2 > 0);
            this.mHasNextParameterPage.setBoolValue(n2 + 1 < n3);
        }
        this.updatePageNames();
    }

    private void updateHasNextAndPrevPage() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mHasScheduledUpdateSelectedPage) {
            this.updateSelectedPage();
        }
        if (this.getTarget() != null) {
            int n2 = this.getPageCount();
            int n3 = this.mSelectedPageIndex.getValue();
            assert (bhj.W1d(n3 == this.clampPageToRange(n3)));
            this.mPageCount.setValue(n2);
            this.mHasPrevParameterPage.WCG(n3 > 0);
            this.mHasNextParameterPage.WCG(n3 < n2 - 1);
        } else {
            this.mPageCount.setValue(0);
            this.mHasPrevParameterPage.WCG(false);
            this.mHasNextParameterPage.WCG(false);
        }
    }

    private void scheduleUpdateSelectedPage() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateSelectedPage) {
            this.mHasScheduledUpdateSelectedPage = true;
            this.mWasChangingPageFromControllerWhenScheduling = this.mIsChangingPageFromController;
            this.runAtEndOfEvent(this::updateSelectedPage);
        }
    }

    private void updateSelectedPage() {
        assert (bhj.W1d(this.isDocumentThread()));
        this.ensurePagesUpdated();
        this.mHasScheduledUpdateSelectedPage = false;
        urL urL2 = this.mPageSelector != null ? this.mPageSelector.BiT() : null;
        this.mSelectedPageProxy.setTarget(urL2);
        if (urL2 != null) {
            int n2 = this.getPageIndex(urL2);
            assert (bhj.W1d(n2 >= 0));
            this.mSelectedPageIndex.doSetValue(n2);
            if (this.mWasChangingPageFromControllerWhenScheduling) {
                this.getControlSurface().WCG(this);
            }
        } else {
            this.mSelectedPageIndex.doSetValue(0);
        }
        this.updateHasNextAndPrevPage();
    }

    protected int clampPageToRange(int n2) {
        int n3 = this.getPageCount();
        return n3 > 0 ? Us.WCG(n2, 0, n3 - 1) : 0;
    }

    private List calculatePages() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.mPageSelector == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mPageSelector.t3p();
    }

    private void updatePageNames() {
        this.setPageNames(this.calculatePageNames());
    }

    private String[] calculatePageNames() {
        int n2 = this.getPageCount();
        if (n2 == 0) {
            return NO_PAGE_NAMES;
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)this.getPageAt(i2).LZT().getValue();
        }
        return stringArray;
    }

    private void setPageNames(String[] stringArray) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(stringArray != null));
        Object[] objectArray = (String[])this.mPageNames.getValue();
        assert (bhj.W1d(objectArray != null));
        if (!Arrays.equals(stringArray, objectArray)) {
            this.mPageNames.setValue(stringArray);
        }
    }

    public int getPageCount() {
        assert (bhj.W1d(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (bhj.W1d(!this.mHasScheduledUpdateToPages));
        return this.mPages != null ? this.mPages.size() : 0;
    }

    public urL getPageAt(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (bhj.W1d(!this.mHasScheduledUpdateToPages));
        return (urL)this.mPages.get(n2);
    }

    public int getPageIndex(urL urL2) {
        assert (bhj.W1d(urL2 != null));
        assert (bhj.W1d(this.isDocumentThread()));
        this.ensurePagesUpdated();
        return this.mPages.indexOf(urL2);
    }

    @Override
    public bJO createVisualizationWidget() {
        assert (bhj.WCG(this.isDocumentThread()));
        cjW cjW2 = cjW.HAj();
        cjW2.WCG(object -> this.createWidgetForPage(object));
        bJO.WCG((r2H)cjW2.AMf(), this.mSelectedPageIndex);
        return cjW2;
    }

    private bJO createWidgetForPage(Object object) {
        bJH bJH2 = bJH.FAX("");
        bJH2.W1d(bJH2.Apg().VhC());
        bJH2.t3p(bJe.pqd);
        bJH2.cUO("Bold Smaller");
        bEg bEg2 = bEg.t3p(bJH2, true, false);
        bEg2.a_(new UqU(61L));
        cjG cjG2 = cjG.WCG(0, bEg2);
        cjG2.ocA(0.5f);
        cjG2.WGS(true);
        int n2 = this.getParameterCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            RemoteControlProxy remoteControlProxy = this.getSelectedPage().getParameter(i2);
            if (!remoteControlProxy.shouldIndicate()) continue;
            bJO bJO2 = remoteControlProxy.createVisualizationWidget();
            cjG2.liD(bJO2);
        }
        String[] stringArray = (String[])this.mPageNames.getValue();
        int n3 = this.mSelectedPageIndex.getValue();
        if (stringArray != null && n3 >= 0 && n3 < stringArray.length) {
            bJH2.Zjp(stringArray[n3].toUpperCase());
        }
        return cjG2;
    }

    @Override
    public void setHardwareLayout(HardwareControlType hardwareControlType, int n2) {
        assert (bhj.WCG(this.isControlSurfaceThread()));
        this.newSince(7);
        this.mHardwareControlType = hardwareControlType;
        this.mHardwareColumns = n2;
    }

    @Override
    public HardwareControlType getHardwareLayoutControlType() {
        return this.mHardwareControlType;
    }

    @Override
    public int getHardwareLayoutColumns() {
        return this.mHardwareColumns;
    }

    static /* synthetic */ void access$000(CursorRemoteControlsPageProxy cursorRemoteControlsPageProxy, int n2) {
        cursorRemoteControlsPageProxy.doSelectPageAtIndex(n2);
    }
}

