/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CueMarker;
import com.bitwig.extension.controller.api.CueMarkerBank;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CueMarkerProxy;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.flt.document.core.iface.doC;

public class CueMarkerBankProxy
extends ControlSurfaceDocumentProxy
implements CueMarkerBank {
    private final CueMarkerProxy[] mMarkers;
    private final ListValueBankItemTargetUpdater mBankUpdater;

    protected CueMarkerBankProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2) {
        super(controlSurfaceObject);
        this.setKey(string);
        if (n2 < 1) {
            throw new mHK("At least 1 cue marker is required.");
        }
        this.mMarkers = new CueMarkerProxy[n2];
        this.mBankUpdater = new ListValueBankItemTargetUpdater(this, this.mMarkers, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            CueMarkerProxy cueMarkerProxy;
            this.mMarkers[i2] = cueMarkerProxy = this.createCueMarkerProxy(controlSurfaceObject, i2, this.getKey());
            this.addChild(cueMarkerProxy);
        }
    }

    private CueMarkerProxy createCueMarkerProxy(ControlSurfaceObject controlSurfaceObject, int n2, String string) {
        CueMarkerProxy cueMarkerProxy = new CueMarkerProxy(controlSurfaceObject);
        cueMarkerProxy.setKey(string + "/" + n2);
        return cueMarkerProxy;
    }

    protected void connectToTarget(doC doC2) {
        assert (bhj.ocA(doC2 != null));
        UQF uQF = doC2.euz().w2F().t3p();
        this.mBankUpdater.setTarget(uQF.cUO());
    }

    protected void disconnectFromTarget(doC doC2) {
        assert (bhj.ocA(doC2 != null));
        this.mBankUpdater.setTarget(null);
    }

    @Override
    public int getSizeOfBank() {
        return this.mBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n2) {
        this.mBankUpdater.setSizeOfBank(n2);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mBankUpdater.getCapacityOfBank();
    }

    @Override
    public CueMarker getItemAt(int n2) {
        return (CueMarker)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public IntegerValue itemCount() {
        return this.mBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mBankUpdater.getCursorIndex();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n2) {
        this.newSince(7);
        this.mBankUpdater.scrollIntoView(n2);
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mBankUpdater.getCanScrollForwards();
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mBankUpdater.getCanScrollBackwards();
    }

    @Override
    public void scrollByPages(int n2) {
        this.mBankUpdater.scrollByPages(n2);
    }

    @Override
    public void scrollPageForwards() {
        this.scrollByPages(1);
    }

    @Override
    public void scrollPageBackwards() {
        this.scrollByPages(-1);
    }

    @Override
    public void scrollBy(int n2) {
        this.mBankUpdater.scrollBy(n2);
    }

    @Override
    public void scrollForwards() {
        this.scrollBy(1);
    }

    @Override
    public void scrollBackwards() {
        this.scrollBy(-1);
    }

    @Override
    public void scrollToMarker(int n2) {
        this.mBankUpdater.scrollIntoView(n2);
    }
}

