/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.ObjectProxy;
import com.bitwig.extension.controller.api.Subscribable;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DelegatingControlSurfaceObjectProxy;
import java.util.Objects;

public abstract class ControlSurfaceProxy
extends ControlSurfaceObject
implements Subscribable {
    private final bIS mTarget = new bIS();
    private boolean mIsSubscribed;
    private boolean mIsSubscribedOnDocumentThread;

    protected ControlSurfaceProxy(ControlSurfaceObject controlSurfaceObject, boolean bl2) {
        super(controlSurfaceObject);
        this.mIsSubscribed = bl2;
        this.mIsSubscribedOnDocumentThread = bl2;
    }

    protected ControlSurfaceProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, true);
    }

    public Object getTargetOfType(Class clazz) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(clazz != null));
        if (clazz.isAssignableFrom(this.getTargetType())) {
            return this.getTarget();
        }
        return null;
    }

    public final Object getDeepestTarget() {
        ControlSurfaceProxy controlSurfaceProxy = this.getDeepestProxy();
        assert (bhj.W1d(controlSurfaceProxy != null));
        assert (bhj.W1d(!(controlSurfaceProxy instanceof DelegatingControlSurfaceObjectProxy)));
        return controlSurfaceProxy.getTarget();
    }

    public ControlSurfaceProxy getDeepestProxy() {
        return this;
    }

    @Override
    public final void subscribe() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.setIsSubscribed(true);
    }

    @Override
    public final void unsubscribe() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.setIsSubscribed(false);
    }

    public abstract Class getTargetType();

    public final Object getTarget() {
        assert (bhj.W1d(this.isDocumentThread()));
        return this.mTarget.getValue();
    }

    public final boolean hasTarget() {
        return this.getTarget() != null;
    }

    public final bIS getTargetValue() {
        assert (bhj.W1d(this.isDocumentThread()));
        return this.mTarget;
    }

    public void setTarget(Object object) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.isTargetValid(object)));
        Object object2 = this.mTarget.getValue();
        if (!Objects.equals(object, object2)) {
            if (object2 != null) {
                this.disconnectFromTargetAlways(object2);
                if (this.mIsSubscribedOnDocumentThread && this.isInterested()) {
                    this.disconnectFromTarget(object2);
                }
            }
            this.mTarget.setValue(object);
            this.targetChanged();
            if (object != null) {
                this.connectToTargetAlways(object);
                if (this.mIsSubscribedOnDocumentThread && this.isInterested()) {
                    this.connectToTarget(object);
                }
            }
        }
    }

    public final void clearTarget() {
        this.setTarget(null);
    }

    protected boolean isTargetValid(Object object) {
        assert (bhj.W1d(this.isDocumentThread()));
        return true;
    }

    protected void targetChanged() {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.isTargetValid(this.mTarget.getValue())));
        this.getHost().targetChanged(this, this.mTarget.getValue());
    }

    public final BooleanValue createEqualsValue(ObjectProxy objectProxy) {
        return this.getHost().createAreProxiesEqualValue(this, (ControlSurfaceProxy)((Object)objectProxy));
    }

    @Override
    public final boolean isSubscribed() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        return this.mIsSubscribed;
    }

    @Override
    public final void setIsSubscribed(boolean bl2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (bl2 != this.mIsSubscribed) {
            this.mIsSubscribed = bl2;
            this.exec(() -> this.doSetIsSubscribed(bl2));
        }
        assert (bhj.W1d(this.mIsSubscribed == bl2));
    }

    private void doSetIsSubscribed(boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        if (bl2 != this.mIsSubscribedOnDocumentThread) {
            this.mIsSubscribedOnDocumentThread = bl2;
            if (this.mTarget.getValue() != null && this.isInterested()) {
                if (bl2) {
                    this.connectToTarget(this.mTarget.getValue());
                } else {
                    this.disconnectFromTarget(this.mTarget.getValue());
                }
            }
        }
    }

    public final boolean isActiveOnDocumentThread() {
        assert (bhj.W1d(this.isDocumentThread()));
        return this.mIsSubscribedOnDocumentThread;
    }

    protected abstract void connectToTarget(Object var1);

    protected abstract void disconnectFromTarget(Object var1);

    protected void connectToTargetAlways(Object object) {
    }

    protected void disconnectFromTargetAlways(Object object) {
    }

    protected boolean isInterested() {
        return true;
    }
}

