/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.base.sound.BoL;
import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.StepDataChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableBeatTimeValue;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.flt.app.l2R;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ClipProxy$1;
import com.bitwig.flt.control_surface.proxy.ClipProxy$2;
import com.bitwig.flt.control_surface.proxy.ClipProxy$3;
import com.bitwig.flt.control_surface.proxy.ClipProxy$Step;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.LaunchQuantizationProxy;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.NoteLaneProxy;
import com.bitwig.flt.control_surface.proxy.TrackProxy;
import com.bitwig.flt.control_surface.values.AbsBeatTimeProxy;
import com.bitwig.flt.control_surface.values.BeatTimeProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.RangedValueProxy;
import com.bitwig.flt.control_surface.values.RelativeBeatTimeProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.control_surface.values.SettableEnumAttributeProxy;
import com.bitwig.flt.document.core.iface.doC;
import com.bitwig.ramona.core.CEd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;

public class ClipProxy
extends ControlSurfaceDocumentObjectProxy
implements Clip {
    private CJF mPlaybackPositionListener = beJ2 -> {
        double d2 = (Double)beJ2.t3p();
        assert (bhj.W1d(d2 >= 0.0 || d2 == -1.0));
        this.setPlayingStep(d2 >= 0.0 ? (int)Math.floor(d2 / this.getStepSize()) : -1);
    };
    private CEd mHierarchyListener = new ClipProxy$2(this);
    private vIx mSelectionChangeListener = new ClipProxy$3(this);
    private Esg mStepGrid;
    private final int mGridHeight;
    private final int mGridWidth;
    private List mSteps;
    private int mChannel;
    private int mBaseKey;
    private int mBaseStep;
    private int mLastPlaybackStep = -1;
    private double mStepSize = 0.25;
    private final ComputedBooleanValue mCanScrollKeysUp;
    private final ComputedBooleanValue mCanScrollKeysDown;
    private final ComputedBooleanValue mCanScrollStepsBackwards;
    private final ComputedBooleanValue mCanScrollStepsForwards;
    private NoteLaneProxy[] mNoteLanes;
    private final ListValueBankItemTargetUpdater mNoteLanesBankUpdater;
    private SettableBooleanValueProxy mShuffle;
    private RangedValueProxy mAccent;
    private SettableBooleanValueProxy mIsLoopEnabled;
    private BeatTimeProxy mPlayStart;
    private BeatTimeProxy mPlayStop;
    private BeatTimeProxy mLoopStart;
    private BeatTimeProxy mLoopLength;
    private boolean mHasInvalidatedGrid = false;
    private final TrackProxy mTrackSection;
    private final SettableColorValueProxy mColor;
    private final ComputedIntegerValue mPlayingStep;
    private final List mStepDataChangedCallbacks = new ArrayList(2);
    private TimerTask mUpdateTimerTask = null;
    private final SettableEnumAttributeProxy mLaunchQuantization;
    private final SettableBooleanValueProxy mUseLoopStartAsQuantizationReference;
    private final SettableEnumAttributeProxy mLaunchMode;
    private final SettableBooleanValueProxy mLegatoMode;

    public ClipProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3) {
        super(controlSurfaceObject);
        int n4;
        this.setKey(string);
        this.mGridHeight = n3;
        this.mGridWidth = n2;
        this.mBaseKey = 0;
        this.mStepGrid = new WsE(this.mStepSize);
        this.mSteps = new ArrayList(this.mGridHeight * this.mGridWidth);
        for (n4 = 0; n4 < n3; ++n4) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mSteps.add(new ClipProxy$Step(this, i2, n4));
            }
        }
        if (this.mGridHeight > 0) {
            this.mNoteLanes = new NoteLaneProxy[this.mGridHeight];
            for (n4 = 0; n4 < this.mGridHeight; ++n4) {
                NoteLaneProxy noteLaneProxy;
                String string2 = string + "/NoteLane" + n4;
                this.mNoteLanes[n4] = noteLaneProxy = new NoteLaneProxy(this, string2, n4);
                this.addChild(noteLaneProxy);
            }
            this.mNoteLanesBankUpdater = new ListValueBankItemTargetUpdater((ControlSurfaceObject)this, this.mNoteLanes);
        } else {
            this.mNoteLanes = null;
            this.mNoteLanesBankUpdater = null;
        }
        this.mShuffle = new SettableBooleanValueProxy(this);
        this.mAccent = new RangedValueProxy(this);
        this.mIsLoopEnabled = new SettableBooleanValueProxy(this);
        this.mPlayStart = new AbsBeatTimeProxy(this);
        this.mPlayStop = new AbsBeatTimeProxy(this);
        this.mLoopStart = new AbsBeatTimeProxy(this);
        this.mLoopLength = new RelativeBeatTimeProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mTrackSection = new TrackProxy(this, "ClipParentTrack", -1, 0, 1);
        this.mCanScrollKeysDown = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollKeysUp = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsBackwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsForwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mPlayingStep = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
        this.mLaunchQuantization = new LaunchQuantizationProxy((ControlSurfaceObject)this, true);
        this.mUseLoopStartAsQuantizationReference = new SettableBooleanValueProxy(this);
        this.mLaunchMode = new SettableEnumAttributeProxy((ControlSurfaceObject)this, kWy.WCG);
        this.mLegatoMode = new SettableBooleanValueProxy(this);
    }

    @Override
    public Class getTargetType() {
        return Rn.class;
    }

    protected doC getDocumentFromTarget(Rn rn2) {
        return rn2.dGg();
    }

    @Override
    public BooleanValue canScrollKeysUp() {
        this.newSince(2);
        return this.mCanScrollKeysUp;
    }

    @Override
    public void addCanScrollKeysUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysUp() instead");
        this.mCanScrollKeysUp.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollKeysDown() {
        this.newSince(2);
        return this.mCanScrollKeysDown;
    }

    @Override
    public void addCanScrollKeysDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysDown() instead");
        this.mCanScrollKeysDown.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsBackwards() {
        this.newSince(2);
        return this.mCanScrollStepsBackwards;
    }

    @Override
    public void addCanScrollStepsBackwardsObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsBackwards() instead");
        this.mCanScrollStepsBackwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsForwards() {
        this.newSince(2);
        return this.mCanScrollStepsForwards;
    }

    @Override
    public void addCanScrollStepsForwardObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsForwards() instead");
        this.mCanScrollStepsForwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void scrollKeysPageUp() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(this.mGridHeight));
    }

    @Override
    public void scrollKeysPageDown() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(-this.mGridHeight));
    }

    private void doScrollKeysBy(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        int n3 = this.mBaseKey + n2;
        if (n3 >= 0 && n3 <= 127) {
            this.doScrollToKey(n3);
        }
    }

    @Override
    public void scrollKeysStepUp() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(1));
    }

    @Override
    public void scrollKeysStepDown() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(-1));
    }

    @Override
    public void scrollToKey(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.validKey(n2);
        this.exec(() -> this.doScrollToKey(n2));
    }

    private void doScrollToKey(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(n2 >= 0 && n2 <= 127));
        if (n2 != this.mBaseKey) {
            this.mBaseKey = n2;
            Rn rn2 = (Rn)this.getTarget();
            if (rn2 != null) {
                this.updateGrid();
            }
        }
    }

    @Override
    public void scrollToStep(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToStep(n2));
    }

    private void doScrollToStep(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null && this.mBaseStep != n2) {
            this.mBaseStep = n2;
            this.updateGrid();
        }
    }

    @Override
    public void setName(String string) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.notNull(string, "name");
        this.exec(() -> this.doSetName(string));
    }

    private void doSetName(String string) {
        assert (bhj.W1d(this.isDocumentThread()));
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null && rn2.Mom() != null) {
            rn2.Mom().WCG(string);
        }
    }

    @Override
    public void scrollStepsPageForward() {
        this.exec(() -> this.doScrollStepsBy(this.mGridWidth));
    }

    @Override
    public void scrollStepsPageBackwards() {
        this.exec(() -> this.doScrollStepsBy(-this.mGridWidth));
    }

    @Override
    public void scrollStepsStepForward() {
        this.exec(() -> this.doScrollStepsBy(1));
    }

    @Override
    public void scrollStepsStepBackwards() {
        this.exec(() -> this.doScrollStepsBy(-1));
    }

    private void doScrollStepsBy(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        this.doScrollToStep(this.mBaseStep + n2);
    }

    @Override
    public void toggleStep(int n2, int n3, int n4) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.validPosition(n2, n3);
        this.inRange(n4, 0, 127, "insertVelocity");
        this.exec(() -> this.doToggleStep(n2, n3, n4));
    }

    private void doToggleStep(int n2, int n3, int n4) {
        assert (bhj.W1d(this.isDocumentThread()));
        PxH pxH = this.getClip();
        if (pxH == null) {
            return;
        }
        Rn rn2 = (Rn)this.getTarget();
        assert (bhj.W1d(rn2 != null));
        int n5 = pxH.YEX().FsX().AhM();
        int n6 = this.getKeyForY(n3);
        double d2 = this.getTimeForCell(n2);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        if (BoL.pqd(n6)) {
            mK3 mK32 = pxH.gR_().WCG(n5, n6, false);
            List list = mK32 != null ? mK32.ocA(d2, d3) : Collections.EMPTY_LIST;
            rn2.eqW().uNU();
            if (list.isEmpty()) {
                pxH.WCG(d2, this.mStepSize, n5, n6, (float)n4 * 0.007874016f, rn2.eqW().LQe());
            } else {
                for (ITU iTU2 : list) {
                    mK32.t3p(iTU2);
                }
            }
        }
    }

    @Override
    public void setStep(int n2, int n3, int n4, double d2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.validPosition(n2, n3);
        this.inRange(n4, 0, 127, "insertVelocity");
        this.greaterThan(d2, 0.0, "insertDuration");
        this.exec(() -> this.doSetStep(n2, n3, n4, prQ.WCG(d2)));
    }

    private void doSetStep(int n2, int n3, int n4, double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        PxH pxH = this.getClip();
        if (pxH == null) {
            return;
        }
        Rn rn2 = (Rn)this.getTarget();
        assert (bhj.W1d(rn2 != null));
        int n5 = n3 + this.mBaseKey;
        double d3 = this.getTimeForCell(n2);
        if (n5 >= 0 && n5 < 128) {
            pxH.WCG(d3, d2, this.mChannel, n5, (float)n4 * 0.007874016f, rn2.eqW().LQe());
        }
    }

    @Override
    public void clearStep(int n2, int n3) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.validPosition(n2, n3);
        this.exec(() -> this.doClearStep(n2, n3));
    }

    private void doClearStep(int n2, int n3) {
        assert (bhj.W1d(this.isDocumentThread()));
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null) {
            PxH pxH = this.getClip();
            if (pxH == null) {
                return;
            }
            int n4 = n3 + this.mBaseKey;
            double d2 = this.getTimeForCell(n2);
            double d3 = d2 + this.getStepSize() - 1.0E-4;
            if (n4 >= 0 && n4 < 128) {
                mK3 mK32 = pxH.gR_().WCG(this.mChannel, n4, false);
                if (mK32 != null) {
                    List list = mK32.ocA(d2, d3);
                    for (qDF qDF2 : list) {
                        mK32.t3p(qDF2);
                    }
                }
                rn2.eqW().uNU();
            }
        }
    }

    @Override
    public void clearSteps() {
        this.exec(() -> this.doClearSteps());
    }

    private void doClearSteps() {
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null) {
            PxH pxH = this.getClip();
            if (pxH == null) {
                return;
            }
            pxH.ocA().BiT(-1.7976931348623157E308, Double.MAX_VALUE);
            rn2.eqW().uNU();
        }
    }

    @Override
    public void clearSteps(int n2) {
        this.validY(n2);
        this.exec(() -> this.doClearSteps(n2));
    }

    private void doClearSteps(int n2) {
        assert (bhj.ocA(this.isDocumentThread()));
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null) {
            mK3 mK32;
            PxH pxH = this.getClip();
            if (pxH == null) {
                return;
            }
            int n3 = n2 + this.mBaseKey;
            if (n3 >= 0 && n3 < 128 && (mK32 = pxH.gR_().WCG(this.mChannel, n3, false)) != null) {
                mK32.lQE();
            }
        }
    }

    @Override
    public void selectStepContents(int n2, int n3, boolean bl2) {
        this.validPosition(n2, n3);
        this.exec(() -> this.doSelectStepContents(n2, n3, bl2));
    }

    private void doSelectStepContents(int n2, int n3, boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null) {
            PxH pxH = this.getClip();
            if (pxH == null) {
                return;
            }
            int n4 = n3 + this.mBaseKey;
            double d2 = this.getTimeForCell(n2);
            double d3 = d2 + this.getStepSize() - 1.0E-4;
            if (n4 >= 0 && n4 < 128) {
                mK3 mK32 = pxH.gR_().WCG(this.mChannel, n4, false);
                List list = mK32 != null ? mK32.ocA(d2, d3) : Collections.EMPTY_LIST;
                LY lY2 = rn2.eqW();
                if (bl2) {
                    lY2.uNU();
                }
                for (SFw sFw : list) {
                    lY2.ocA(sFw.WCG(0, false));
                }
            }
        }
    }

    @Override
    public void setStepSize(double d2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.greaterThan(d2, 0.0, "lengthInBeatTime");
        this.exec(() -> this.doSetStepSize(d2));
    }

    private void doSetStepSize(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        Rn rn2 = (Rn)this.getTarget();
        if (this.mStepSize != d2) {
            this.mStepSize = d2;
            this.mStepGrid = new WsE(this.mStepSize);
            if (!this.mHasInvalidatedGrid && rn2 != null) {
                this.mHasInvalidatedGrid = true;
                if (this.mUpdateTimerTask != null) {
                    this.mUpdateTimerTask.cancel();
                }
                this.mUpdateTimerTask = this.scheduleTimerTaskOnDocumentThread(this::updateGridFromTimer, 100L);
            }
        }
    }

    private void updateGridFromTimer() {
        assert (bhj.WCG(this.isDocumentThread()));
        assert (bhj.WCG(this.mUpdateTimerTask != null));
        this.updateGrid();
        this.mHasInvalidatedGrid = false;
        this.mUpdateTimerTask = null;
    }

    private double getStepSize() {
        return this.mStepSize;
    }

    private double getTimeForCell(int n2) {
        return prQ.WCG((double)(this.mBaseStep + n2) * this.getStepSize());
    }

    private int getKeyForY(int n2) {
        return this.mBaseKey + n2;
    }

    private PxH getClip() {
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null && rn2.Mom() instanceof PxH) {
            return (PxH)rn2.Mom();
        }
        return null;
    }

    private void invalidateGrid() {
        if (!this.mHasInvalidatedGrid) {
            this.mHasInvalidatedGrid = true;
            l2R.j_().pqd(new ClipProxy$1(this));
        }
    }

    private void updateGrid() {
        assert (bhj.W1d(this.isDocumentThread()));
        PxH pxH = this.getClip();
        Rn rn2 = (Rn)this.getTarget();
        for (int i2 = 0; i2 < this.mGridWidth; ++i2) {
            Npo npo;
            double d2 = this.getTimeForCell(i2);
            double d3 = d2 + this.getStepSize() - 1.0E-4;
            if (pxH != null) {
                assert (bhj.ocA(pxH.KOw().pqd()));
                npo = pxH.gR_();
            } else {
                npo = null;
            }
            int n2 = Math.min(127 - this.mBaseKey + 1, this.mGridHeight);
            for (int i4 = 0; i4 < n2; ++i4) {
                mK3 mK32;
                ClipProxy$Step clipProxy$Step = (ClipProxy$Step)this.mSteps.get(i2 + i4 * this.mGridWidth);
                int n3 = this.getKeyForY(i4);
                assert (bhj.W1d(BoL.pqd(n3)));
                List list = Collections.emptyList();
                if (npo != null && (mK32 = npo.WCG(this.mChannel, n3, false)) != null) {
                    list = mK32.ocA(d2, d3);
                }
                int n4 = 0;
                boolean bl2 = false;
                for (ITU iTU2 : list) {
                    qDF qDF2 = (qDF)iTU2;
                    if (qDF2.ocA() != n3) continue;
                    int n5 = n4 = qDF2.w2F() >= d2 ? 2 : 1;
                    if (!rn2.eqW().WCG(qDF2)) continue;
                    bl2 = true;
                }
                clipProxy$Step.setNoteState(n4);
                clipProxy$Step.setHasSelectedNote(bl2);
            }
        }
        this.mCanScrollKeysDown.setBoolValue(this.mBaseKey > 0);
        this.mCanScrollKeysUp.setBoolValue(this.mBaseKey < 128 - this.mGridWidth * this.mGridHeight);
    }

    @Override
    public void addStepDataObserver(StepDataChangedCallback stepDataChangedCallback) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(stepDataChangedCallback, "callback");
        this.mStepDataChangedCallbacks.add(stepDataChangedCallback);
    }

    @Override
    public IntegerValue playingStep() {
        this.newSince(2);
        return this.mPlayingStep;
    }

    @Override
    public void addPlayingStepObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use playingStep() instead");
        this.mPlayingStep.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public SettableBooleanValueProxy getShuffle() {
        return this.mShuffle;
    }

    @Override
    public SettableRangedValue getAccent() {
        return this.mAccent;
    }

    @Override
    public SettableBeatTimeValue getPlayStart() {
        return this.mPlayStart;
    }

    @Override
    public SettableBeatTimeValue getPlayStop() {
        return this.mPlayStop;
    }

    @Override
    public SettableBooleanValueProxy isLoopEnabled() {
        return this.mIsLoopEnabled;
    }

    @Override
    public SettableBeatTimeValue getLoopStart() {
        return this.mLoopStart;
    }

    @Override
    public SettableBeatTimeValue getLoopLength() {
        return this.mLoopLength;
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    @Override
    public void duplicate() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(this::doDuplicate);
    }

    private void doDuplicate() {
        assert (bhj.W1d(this.isDocumentThread()));
        doC doC2 = this.getDocument();
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null && doC2 != null) {
            JHP jHP = rn2.Mom();
            bNx bNx2 = (bNx)jHP.ocA(bNx.class);
            if (bNx2 != null) {
                ixJ ixJ2 = doC2.Kds().BiT();
                ixJ2.LZT(bNx2);
                ixJ2.gfK();
                if (ixJ2.tCt()) {
                    ixJ2.eK3();
                }
            }
            jHP.PxT();
        }
    }

    @Override
    public void duplicateContent() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(this::doDuplicateContent);
    }

    private void doDuplicateContent() {
        assert (bhj.W1d(this.isDocumentThread()));
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null) {
            rn2.Mom().PxT();
        }
    }

    @Override
    public void transpose(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(() -> this.doTranspose(n2));
    }

    private void doTranspose(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null) {
            rn2.Mom().WCG(n2);
        }
    }

    @Override
    public void quantize(double d2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new mHK("Clip.quantize: amount parameter value should be greater than zero and maximal one.");
        }
        this.exec(() -> this.doQuantize(d2));
    }

    private void doQuantize(double d2) {
        assert (bhj.W1d(this.isDocumentThread()));
        Rn rn2 = (Rn)this.getTarget();
        if (rn2 != null) {
            rn2.WCG(d2, this.mStepGrid);
        }
    }

    @Override
    public Track getTrack() {
        return this.mTrackSection;
    }

    protected void connectToTarget(Rn rn2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(rn2 != null));
        JHP jHP = rn2.Mom();
        VpB vpB = jHP.cUO();
        PxH pxH = this.getClip();
        this.mUseLoopStartAsQuantizationReference.setTarget(jHP.YaF());
        this.mLaunchMode.setTarget(jHP.dGg());
        this.mLegatoMode.setTarget(jHP.NyO());
        if (pxH != null) {
            pxH.ocA().W1d(this.mPlaybackPositionListener);
            pxH.gXx().WCG(this.mHierarchyListener);
        }
        rn2.eqW().WPP().WCG(this.mSelectionChangeListener);
        if (this.mNoteLanes != null) {
            this.mNoteLanesBankUpdater.setTarget(jHP.DNK().DNK());
        }
        this.mShuffle.setTarget(vpB.kv_());
        this.mAccent.setTarget(vpB.DNK());
        mmL mmL2 = vpB.WGS();
        this.mPlayStart.setTarget(mmL2.dV_().spF());
        this.mPlayStop.setTarget(mmL2.kL_().spF());
        this.mIsLoopEnabled.setTarget(mmL2.aaP());
        this.mLoopStart.setTarget(mmL2.hFD().spF());
        this.mLoopLength.setTarget(mmL2.hFD().oeT());
        this.mColor.setTarget(jHP.gN_(), jHP.lQE());
        this.mLaunchQuantization.setTarget(jHP.Zsf());
        if (this.mTrackSection != null) {
            bNx bNx2;
            ClipLauncherSlotBankProxy clipLauncherSlotBankProxy = this.mTrackSection.getClipLauncherSlots();
            Cdg cdg2 = jHP.YEX();
            this.mTrackSection.setTarget(cdg2);
            if (clipLauncherSlotBankProxy != null && (bNx2 = (bNx)jHP.ocA(bNx.class)) != null) {
                clipLauncherSlotBankProxy.scrollToScene(bNx2);
            }
        }
        this.connectObservers(jHP);
    }

    protected void disconnectFromTarget(Rn rn2) {
        assert (bhj.W1d(rn2 != null));
        JHP jHP = rn2.Mom();
        this.disconnectObservers(jHP);
        PxH pxH = this.getClip();
        if (this.mTrackSection != null) {
            this.mTrackSection.clearTarget();
        }
        if (pxH != null) {
            pxH.ocA().pqd(this.mPlaybackPositionListener);
            pxH.gXx().t3p(this.mHierarchyListener);
        }
        VpB vpB = jHP.cUO();
        this.mPlayStart.clearTarget();
        this.mPlayStop.clearTarget();
        this.mIsLoopEnabled.clearTarget();
        this.mLoopStart.clearTarget();
        this.mLoopLength.clearTarget();
        this.mColor.clearTarget();
        this.mShuffle.clearTarget();
        this.mAccent.clearTarget();
        if (this.mNoteLanes != null) {
            this.mNoteLanesBankUpdater.clearTarget();
        }
        this.mLaunchQuantization.clearTarget();
        this.mUseLoopStartAsQuantizationReference.clearTarget();
        this.mLaunchMode.clearTarget();
        this.mLegatoMode.clearTarget();
        rn2.eqW().WPP().t3p(this.mSelectionChangeListener);
        this.setPlayingStep(-1);
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.updateGrid();
    }

    private void sendNoteStateToObservers(int n2, int n3, int n4) {
        assert (bhj.W1d(this.isDocumentThread()));
        this.queueCallback(() -> this.notifyStepDataObservers(n2, n3, n4));
    }

    private void notifyStepDataObservers(int n2, int n3, int n4) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        for (StepDataChangedCallback stepDataChangedCallback : this.mStepDataChangedCallbacks) {
            stepDataChangedCallback.stepStateChanged(n2, n3, n4);
        }
    }

    private void setPlayingStep(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(n2 >= -1));
        if (n2 != this.mLastPlaybackStep) {
            this.mLastPlaybackStep = n2;
            this.mPlayingStep.setIntegerValue(n2);
        }
    }

    private void validPosition(int n2, int n3) {
        this.validX(n2);
        this.validY(n3);
    }

    private void validKey(int n2) {
        this.inRange(n2, 0, 127, "key");
    }

    private void validX(int n2) {
        this.inRange(n2, 0, this.mGridWidth - 1, "x");
    }

    private void validY(int n2) {
        this.inRange(n2, 0, this.mGridHeight - 1, "y");
    }

    @Override
    public SettableEnumValue launchQuantization() {
        this.newSince(8);
        return this.mLaunchQuantization;
    }

    @Override
    public SettableBooleanValue useLoopStartAsQuantizationReference() {
        this.newSince(8);
        return this.mUseLoopStartAsQuantizationReference;
    }

    @Override
    public SettableBooleanValue launchLegato() {
        this.deprecated(8, 9);
        return this.mLegatoMode;
    }

    @Override
    public SettableEnumValue launchMode() {
        this.newSince(9);
        return this.mLaunchMode;
    }

    static /* synthetic */ void access$000(ClipProxy clipProxy) {
        clipProxy.updateGrid();
    }

    static /* synthetic */ boolean access$102(ClipProxy clipProxy, boolean bl2) {
        clipProxy.mHasInvalidatedGrid = bl2;
        return clipProxy.mHasInvalidatedGrid;
    }

    static /* synthetic */ void access$200(ClipProxy clipProxy, int n2, int n3, int n4) {
        clipProxy.sendNoteStateToObservers(n2, n3, n4);
    }

    static /* synthetic */ void access$300(ClipProxy clipProxy) {
        clipProxy.invalidateGrid();
    }
}

