/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.NotePlaybackCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.HardwareControlType;
import com.bitwig.extension.controller.api.Send;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableStringValue;
import com.bitwig.extension.controller.api.SoloValue;
import com.bitwig.flt.control_surface.proxy.ChannelProxy$1;
import com.bitwig.flt.control_surface.proxy.ChannelProxy$2;
import com.bitwig.flt.control_surface.proxy.ChannelProxy$VuMeterObserver;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.SendBankProxy;
import com.bitwig.flt.control_surface.values.ComputedPlayingNoteArrayValue;
import com.bitwig.flt.control_surface.values.PlayingNote;
import com.bitwig.flt.control_surface.values.RemappableParameterProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.control_surface.values.SettableStringValueProxy;
import com.bitwig.flt.control_surface.values.SoloProxy;
import com.bitwig.flt.document.core.iface.WQ1;
import com.bitwig.flt.document.core.iface.doC;
import com.bitwig.flt.document.core.iface.r2H;
import com.bitwig.ramona.core.gMo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ChannelProxy
extends DeviceChainProxy
implements Channel {
    protected final SettableBooleanValueProxy mIsActivated;
    protected final SettableBooleanValueProxy mMute;
    protected final SoloProxy mSolo;
    protected final Map mPlayingNotes = new HashMap();
    protected final ComputedPlayingNoteArrayValue mPlayingNotesValue;
    protected final RemappableParameterProxy mVolume;
    protected final RemappableParameterProxy mPan;
    protected final SettableColorValueProxy mColor;
    private final SettableStringValueProxy mNameProxy;
    protected final SendBankProxy mSendBankProxy;
    private final List mNotePlaybackCallbacks = new ArrayList();
    private NQL mNoteObserverAtom;
    private final CJF mNotePlaybackListener = nEl2 -> this.notePlayed(nEl2.W1d(), nEl2.pqd(), nEl2.ocA());
    private boolean mHasScheduledUpdatePlayingNotes = false;

    public ChannelProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3) {
        super(controlSurfaceObject, string);
        this.mNameProxy = new SettableStringValueProxy(this);
        this.mIsActivated = new SettableBooleanValueProxy((ControlSurfaceObject)this, true);
        this.mMute = new SettableBooleanValueProxy(this);
        this.mPan = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Pan");
        this.mPan.setHardwareControlType(HardwareControlType.KNOB);
        this.mVolume = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Volume");
        this.mVolume.setHardwareControlType(HardwareControlType.SLIDER);
        this.mSolo = new SoloProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mPlayingNotesValue = new ComputedPlayingNoteArrayValue(this);
        this.addChild(this.mIsActivated);
        this.addChild(this.mMute);
        this.addChild(this.mSolo);
        this.addChild(this.mVolume);
        this.addChild(this.mPan);
        this.addChild(this.mPlayingNotesValue);
        this.mVolume.setIndexInGroup(n2);
        this.mPan.setIndexInGroup(n2);
        this.mSendBankProxy = n3 > 0 ? new SendBankProxy(this, string + "/Send/", n3, n2) : null;
    }

    @Override
    protected int getNumSends() {
        return this.mSendBankProxy != null ? this.mSendBankProxy.getSizeOfBank() : 0;
    }

    @Override
    public void select() {
        this.selectInEditor();
    }

    @Override
    public void duplicate() {
        this.exec(() -> {
            KWS kWS;
            if (this.getTarget() != null && (kWS = this.getEditorChannelSelection((WQ1)this.getTarget())) != null) {
                kWS.LZT((gMo)this.getTarget());
                kWS.gfK();
                if (kWS.tCt()) {
                    kWS.eK3();
                }
            }
        });
    }

    @Override
    public SettableBooleanValue isActivated() {
        return this.mIsActivated;
    }

    @Override
    public RemappableParameterProxy getVolume() {
        this.deprecated(1, 5, "Use volume() instead");
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy volume() {
        this.newSince(5);
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy getPan() {
        this.deprecated(1, 5, "Use pan() instead");
        return this.mPan;
    }

    @Override
    public RemappableParameterProxy pan() {
        this.newSince(5);
        return this.mPan;
    }

    @Override
    public SettableBooleanValue getMute() {
        this.deprecated(1, 5, "Use mute() instead");
        return this.mMute;
    }

    @Override
    public SettableBooleanValue mute() {
        this.newSince(5);
        return this.mMute;
    }

    @Override
    public SoloProxy getSolo() {
        this.deprecated(1, 5, "Use solo() instead");
        return this.mSolo;
    }

    @Override
    public SoloValue solo() {
        this.newSince(5);
        return this.mSolo;
    }

    @Override
    public SendBankProxy sendBank() {
        if (this.mSendBankProxy == null) {
            throw new mHK("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy;
    }

    public SendBankProxy getSendBankOnDocumentThread() {
        assert (bhj.WCG(this.isDocumentThread()));
        return this.mSendBankProxy;
    }

    @Override
    public Send getSend(int n2) {
        if (this.mSendBankProxy == null) {
            if (this.getRequiredApiVersion() == 1) {
                return null;
            }
            throw new mHK("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy.getItemAt(n2);
    }

    @Override
    public SettableStringValue name() {
        this.newSince(2);
        return this.mNameProxy;
    }

    @Override
    public void addNameObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use name() instead");
        this.mNameProxy.addValueObserver(n2, string, stringValueChangedCallback);
    }

    @Override
    public void addVuMeterObserver(int n2, int n3, boolean bl2, IntegerValueChangedCallback integerValueChangedCallback) {
        if (n3 < -1 || n3 > 1) {
            throw new mHK("No such channel.");
        }
        this.addObserver(new ChannelProxy$VuMeterObserver(this, this.getControlSurface(), integerValueChangedCallback, n2, n3, bl2));
    }

    @Override
    public ComputedPlayingNoteArrayValue playingNotes() {
        return this.mPlayingNotesValue;
    }

    @Override
    public void addNoteObserver(NotePlaybackCallback notePlaybackCallback) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(notePlaybackCallback, "callback");
        this.mNotePlaybackCallbacks.add(notePlaybackCallback);
    }

    private void notePlayed(boolean bl2, int n2, float f2) {
        assert (bhj.W1d(this.isDocumentThread()));
        if (!this.mNotePlaybackCallbacks.isEmpty()) {
            this.queueCallback(() -> this.notifyNotePlayed(bl2, n2, f2));
        }
        if (!this.mPlayingNotesValue.isInterested()) {
            return;
        }
        if (bl2) {
            this.mPlayingNotes.put(n2, new PlayingNote(n2, (int)(127.0f * f2)));
        } else {
            this.mPlayingNotes.remove(n2);
        }
        this.invalidatePlayingNotes();
    }

    private void invalidatePlayingNotes() {
        assert (bhj.WCG(this.isDocumentThread()));
        if (!this.mHasScheduledUpdatePlayingNotes) {
            this.mHasScheduledUpdatePlayingNotes = true;
            this.runAtEndOfEvent(this::updatePlayingNotes);
        }
    }

    private void updatePlayingNotes() {
        assert (bhj.WCG(this.isDocumentThread()));
        this.mHasScheduledUpdatePlayingNotes = false;
        PlayingNote[] playingNoteArray = this.mPlayingNotes.values().toArray(new PlayingNote[this.mPlayingNotes.size()]);
        this.mPlayingNotesValue.setValue(playingNoteArray);
    }

    private void notifyNotePlayed(boolean bl2, int n2, float f2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        for (NotePlaybackCallback notePlaybackCallback : this.mNotePlaybackCallbacks) {
            notePlaybackCallback.notePlaybackEventOccurred(bl2, n2, f2);
        }
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    public gnD getColor() {
        aHC aHC2 = this.mColor.getEditableValue();
        if (aHC2 != null) {
            return (gnD)aHC2.getValue();
        }
        return null;
    }

    protected abstract KWS getEditorChannelSelection(WQ1 var1);

    protected KWS getMixerChannelSelection() {
        doC doC2 = this.getDocument();
        if (doC2 != null) {
            return doC2.Kds().t3p();
        }
        return null;
    }

    @Override
    public void addIsSelectedInEditorObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new ChannelProxy$1(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void addIsSelectedInMixerObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new ChannelProxy$2(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void selectInEditor() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(this::doSelectInEditor);
    }

    private void doSelectInEditor() {
        KWS kWS;
        assert (bhj.W1d(this.isDocumentThread()));
        kng kng2 = this.getDocumentGUIWrapper();
        if (kng2 != null && this.getTarget() != null && (kWS = this.getEditorChannelSelection((WQ1)this.getTarget())) != null) {
            kWS.LQe((gMo)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void selectInMixer() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(this::doSelectInMixer);
    }

    private void doSelectInMixer() {
        KWS kWS;
        assert (bhj.W1d(this.isDocumentThread()));
        kng kng2 = this.getDocumentGUIWrapper();
        if (kng2 != null && this.getTarget() != null && (kWS = this.getMixerChannelSelection()) != null) {
            kWS.LQe((gMo)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void makeVisibleInMixer() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInMixer);
    }

    private void doMakeVisibleInMixer() {
        fy fy2;
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.getTarget() != null && (fy2 = this.getDocumentWidget()) != null) {
            List list = fy2.W1d(Zr.class, true);
            for (Zr zr2 : list) {
                zr2.WCG((WQ1)this.getTarget());
            }
        }
    }

    @Override
    public void makeVisibleInArranger() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInArranger);
    }

    private void doMakeVisibleInArranger() {
        fy fy2;
        assert (bhj.W1d(this.isDocumentThread()));
        if (this.getTarget() instanceof r2H && (fy2 = this.getDocumentWidget()) != null) {
            List list = fy2.W1d(ca.class, true);
            for (ca ca2 : list) {
                ca2.t3p((r2H)this.getTarget());
            }
        }
    }

    @Override
    protected String getName() {
        WQ1 wQ1 = (WQ1)this.getTarget();
        if (wQ1 != null) {
            return wQ1.dX_();
        }
        return "(none)";
    }

    protected void connectToTarget(WQ1 wQ1) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(wQ1 != null));
        assert (bhj.W1d(wQ1.Tf1()));
        EZd eZd = wQ1.ea_();
        this.mNameProxy.setTarget(wQ1.Bip(), wQ1.kHo());
        this.mIsActivated.setTarget(wQ1.dGg());
        this.mMute.setTarget(eZd.LZT().be_());
        this.mSolo.setMixerModule(eZd);
        this.mVolume.setTargetAtom(eZd.fk_());
        this.mPan.setTargetAtom(eZd.PB());
        this.mColor.setTarget(wQ1.apE(), wQ1.vdZ());
        this.mPlayingNotes.clear();
        this.invalidatePlayingNotes();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.setTarget(wQ1);
        }
        assert (bhj.W1d(this.mNoteObserverAtom == null));
        this.mNoteObserverAtom = wQ1.cUO();
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.W1d(this.mNotePlaybackListener);
            this.mNoteObserverAtom.YD().t3p();
        }
        for (kSn kSn2 : this.getObservers()) {
            if (!(kSn2 instanceof ChannelProxy$VuMeterObserver)) continue;
            ChannelProxy$VuMeterObserver channelProxy$VuMeterObserver = (ChannelProxy$VuMeterObserver)kSn2;
            int n2 = channelProxy$VuMeterObserver.mChannel;
            if (channelProxy$VuMeterObserver.mPeak) {
                channelProxy$VuMeterObserver.sendValue(((HCE)eZd.aaP().ez_().get(n2)).eA_());
                ((HCE)eZd.aaP().ez_().get(n2)).W1d(channelProxy$VuMeterObserver);
                continue;
            }
            channelProxy$VuMeterObserver.sendValue(((HCE)eZd.aaP().ez_().get(n2)).t3p());
            ((HCE)eZd.aaP().ez_().get(n2)).WCG(channelProxy$VuMeterObserver);
        }
        this.setDeviceChain(wQ1.fx_());
        this.connectObservers(wQ1);
    }

    protected void disconnectFromTarget(WQ1 wQ1) {
        assert (bhj.W1d(this.getTarget() != null));
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.pqd(this.mNotePlaybackListener);
            this.mNoteObserverAtom.YD().ocA();
            this.mNoteObserverAtom = null;
        }
        this.mNameProxy.clearTarget();
        this.disconnectObservers(wQ1);
        this.setDeviceChain(null);
        EZd eZd = ((WQ1)this.getTarget()).ea_();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.clearTarget();
        }
        for (kSn kSn2 : this.getObservers()) {
            if (!(kSn2 instanceof ChannelProxy$VuMeterObserver)) continue;
            ChannelProxy$VuMeterObserver channelProxy$VuMeterObserver = (ChannelProxy$VuMeterObserver)kSn2;
            int n2 = channelProxy$VuMeterObserver.mChannel;
            HCE hCE = (HCE)eZd.aaP().ez_().get(n2);
            if (channelProxy$VuMeterObserver.mPeak) {
                hCE.pqd(channelProxy$VuMeterObserver);
            } else {
                hCE.t3p(channelProxy$VuMeterObserver);
            }
            channelProxy$VuMeterObserver.sendValue(0.0);
        }
        this.mIsActivated.clearTarget();
        this.mMute.clearTarget();
        this.mSolo.setMixerModule(null);
        this.mVolume.clearTarget();
        this.mPan.clearTarget();
        this.mColor.clearTarget();
        this.mPlayingNotes.clear();
        this.invalidatePlayingNotes();
    }

    protected WQ1 getChannel() {
        return (WQ1)this.getTarget();
    }
}

