/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.ChannelBank;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.ramona.core.gMo;

public abstract class ChannelBankProxy
extends ControlSurfaceDocumentObjectProxy
implements ChannelBank {
    protected final int mNumChannels;
    protected final int mNumSends;
    protected final ListValueBankItemTargetUpdater mChannelBankUpdater;
    protected final ControlSurfaceProxy[] mChannels;
    protected int mChannelScrollStepSize = 1;
    private oSh mChannelsListValue;

    public ChannelBankProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3) {
        super(controlSurfaceObject);
        this.setKey(string);
        if (n2 < 1) {
            throw new mHK("At least 1 track is required.");
        }
        this.mNumChannels = n2;
        this.mNumSends = n3;
        this.mChannels = new ControlSurfaceProxy[this.mNumChannels];
        this.mChannelBankUpdater = new ListValueBankItemTargetUpdater(this, this.mChannels, this.getScrollPositionThatPageShouldAlignTo());
    }

    protected void initChannelProxies() {
        for (int i2 = 0; i2 < this.mNumChannels; ++i2) {
            ControlSurfaceProxy controlSurfaceProxy;
            this.mChannels[i2] = controlSurfaceProxy = this.createChannelProxy(this.mNumSends, i2, this.getKey());
            this.addChild(controlSurfaceProxy);
        }
    }

    @Override
    public int getSizeOfBank() {
        return this.mChannelBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n2) {
        this.mChannelBankUpdater.setSizeOfBank(n2);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mChannelBankUpdater.getCapacityOfBank();
    }

    @Override
    public Channel getItemAt(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        return (Channel)((Object)this.mChannelBankUpdater.getItemAt(n2));
    }

    @Override
    public IntegerValue itemCount() {
        return this.mChannelBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mChannelBankUpdater.getCursorIndex();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mChannelBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n2) {
        this.newSince(7);
        this.mChannelBankUpdater.scrollIntoView(n2);
    }

    @Override
    public void scrollBy(int n2) {
        this.mChannelBankUpdater.scrollBy(n2);
    }

    @Override
    public void scrollByPages(int n2) {
        this.mChannelBankUpdater.scrollByPages(n2);
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mChannelBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mChannelBankUpdater.getCanScrollForwards();
    }

    protected abstract ControlSurfaceProxy createChannelProxy(int var1, int var2, String var3);

    public void setTarget(gMo gMo2) {
        gMo gMo3 = (gMo)this.getTarget();
        if (gMo2 != gMo3) {
            this.setChannelsListValue(gMo2 != null ? this.getChannelsListValueFromTarget(gMo2) : null);
            super.setTarget(gMo2);
        }
    }

    protected abstract oSh getChannelsListValueFromTarget(gMo var1);

    protected oSh getChannelsListValue() {
        return this.mChannelsListValue;
    }

    private void setChannelsListValue(oSh oSh2) {
        if (oSh2 != this.mChannelsListValue) {
            this.mChannelsListValue = oSh2;
            this.mChannelBankUpdater.setTarget(oSh2);
        }
    }

    protected int getScrollPositionThatPageShouldAlignTo() {
        return 0;
    }

    @Override
    public void scrollChannelsPageUp() {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollChannelsPageDown() {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollChannelsUp() {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollBy(-this.mChannelScrollStepSize);
    }

    @Override
    public void scrollChannelsDown() {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollBy(this.mChannelScrollStepSize);
    }

    @Override
    public void scrollToChannel(int n2) {
        this.deprecated(1, 6);
        this.mChannelBankUpdater.scrollIntoView(n2);
    }

    @Override
    public void scrollSendsPageUp() {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollPageBackwards();
        }
    }

    @Override
    public void scrollSendsPageDown() {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollPageForwards();
        }
    }

    @Override
    public void scrollSendsUp() {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollBackwards();
        }
    }

    @Override
    public void scrollSendsDown() {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollForwards();
        }
    }

    @Override
    public void scrollToSend(int n2) {
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            ((Channel)((Object)controlSurfaceProxy)).sendBank().scrollPosition().set(n2);
        }
    }

    @Override
    public Channel getChannel(int n2) {
        this.deprecated(1, 6);
        if (this.mChannels != null && n2 >= 0 && n2 < this.mNumChannels) {
            return (Channel)((Object)this.mChannels[n2]);
        }
        return null;
    }

    @Override
    public void setChannelScrollStepSize(int n2) {
        this.atLeast(n2, 1, "stepSize");
        this.mChannelScrollStepSize = n2;
    }

    @Override
    public IntegerValue channelScrollPosition() {
        this.newSince(2);
        return this.mChannelBankUpdater.getScrollPosition();
    }

    @Override
    public void addChannelScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        this.mChannelBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback, n2);
    }

    @Override
    public void addCanScrollChannelsUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollChannelsUp().addValueObserver(callback)");
        this.mChannelBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollChannelsUp() {
        this.newSince(2);
        return this.mChannelBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollChannelsDown() {
        this.newSince(2);
        return this.mChannelBankUpdater.getCanScrollForwards();
    }

    @Override
    public void addCanScrollChannelsDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollChannelsDown().addValueObserver(callback)");
        this.mChannelBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollSendsUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
    }

    @Override
    public void addCanScrollSendsDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
    }

    @Override
    public IntegerValue channelCount() {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        return this.mChannelBankUpdater.getListItemCount();
    }

    @Override
    public void addChannelCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.deprecated(1, 2, "Use channelCount().addValueObserver(callback)");
        this.mChannelBankUpdater.getListItemCount().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addSendCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
    }

    public ListValueBankItemTargetUpdater getChannelBankUpdater() {
        return this.mChannelBankUpdater;
    }
}

