/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankCursorIndex;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.BankScrollPosition;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceCursorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.ramona.core.gMo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BankItemTargetUpdater
extends ControlSurfaceProxy
implements Pq2 {
    private final ControlSurfaceProxy[] mItemProxies;
    private final ComputedBooleanValue mCanScrollBackwards;
    private final ComputedBooleanValue mCanScrollForwards;
    private final BankScrollPosition mScrollPosition;
    private final BankCursorIndex mCursorIndex;
    private ControlSurfaceCursorProxy mCursorProxyToFollow;
    private final ComputedIntegerValue mListItemCount;
    private final int mScrollPositionThatPageShouldAlignTo;
    private boolean mHasScheduledUpdate;
    private gMo mCursor;
    private List mScrollPositionSlaves;
    private BankItemTargetUpdater mMasterScrollPositionBankUpdater;
    private int mSize;

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray, int n2) {
        super(controlSurfaceObject);
        assert (bhj.W1d(controlSurfaceProxyArray != null));
        assert (bhj.W1d(n2 >= 0));
        this.mItemProxies = controlSurfaceProxyArray;
        this.mSize = controlSurfaceProxyArray.length;
        this.mCanScrollBackwards = new ComputedBooleanValue(this);
        this.mCanScrollForwards = new ComputedBooleanValue(this);
        this.mScrollPosition = new BankScrollPosition(this);
        this.mCursorIndex = new BankCursorIndex(this);
        this.mListItemCount = new ComputedIntegerValue((ControlSurfaceObject)this, 0);
        this.mScrollPositionThatPageShouldAlignTo = n2;
    }

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray) {
        this(controlSurfaceObject, controlSurfaceProxyArray, 0);
    }

    public void setSizeOfBank(int n2) {
        this.newSince(7);
        this.inRange(n2, 0, this.getCapacityOfBank(), "size");
        this.mSize = n2;
    }

    public int getSizeOfBank() {
        return this.mSize;
    }

    public int getCapacityOfBank() {
        this.newSince(7);
        return this.mItemProxies.length;
    }

    public ControlSurfaceProxy getItemAt(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.inRange(n2, 0, this.getSizeOfBank(), "index");
        return (ControlSurfaceProxy)this.returnArrayItem(this.mItemProxies, n2);
    }

    public void scrollTo(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.postEvent(tmS.WCG(this, Math.max(0, n2)));
    }

    public void scrollIntoView(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.postEvent(tmS.t3p(this, Math.max(0, n2)));
    }

    public void doScrollTo(int n2, boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(n2 >= 0));
        if (n2 >= this.mListItemCount.getValue()) {
            return;
        }
        if (this.mMasterScrollPositionBankUpdater != null) {
            this.mMasterScrollPositionBankUpdater.doScrollTo(n2, bl2);
        } else {
            this.doScrollToImpl(n2, bl2);
        }
    }

    protected int quantizePosition(int n2, int n3) {
        assert (bhj.W1d(this.isDocumentThread()));
        int n4 = this.mItemProxies.length;
        int n5 = n4 < this.mScrollPositionThatPageShouldAlignTo ? this.mScrollPositionThatPageShouldAlignTo % n4 : 0;
        int n6 = (n2 - n5) / n4 * n4 + n5;
        if (n6 < this.mScrollPosition.getValue() - n4) {
            n6 += n4;
        }
        int n7 = (n3 - 1) / n4 * n4;
        return Us.WCG(n6, 0, n7);
    }

    private void doScrollToImpl(int n2, boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        int n3 = bl2 ? this.mListItemCount.getValue() - 1 : this.mListItemCount.getValue() - this.mSize;
        int n4 = Us.WCG(n2, 0, Math.max(0, n3));
        List list = this.getList();
        int n5 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n6 = n4 + i2;
            if (n6 < list.size()) {
                object = (gMo)list.get(n6);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && this.mCursor == object) {
                    n5 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n6);
        }
        if (this.mScrollPositionSlaves != null) {
            for (ControlSurfaceProxy controlSurfaceProxy : this.mScrollPositionSlaves) {
                super.doScrollToImpl(n4, bl2);
            }
        }
        this.mScrollPosition.setIntegerValue(n4);
        if (n5 >= 0) {
            this.mCursorIndex.setIntegerValue(n5);
        } else {
            this.mCursorIndex.unassigned();
        }
        this.mCanScrollForwards.setBoolValue(n4 + this.getSizeOfBank() < list.size());
        this.mCanScrollBackwards.setBoolValue(n4 > 0);
    }

    public void scrollBy(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (n2 != 0) {
            this.postEvent(tmS.WCG(this, n2, Math.abs(n2) > 1));
        }
    }

    public void doScrollBy(int n2, boolean bl2) {
        assert (bhj.W1d(this.isDocumentThread()));
        this.doScrollTo(Math.max(0, this.mScrollPosition.getValue() + n2), bl2);
    }

    public void scrollByPages(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        this.scrollBy(n2 * this.mItemProxies.length);
    }

    public ControlSurfaceProxy[] getItemProxies() {
        return this.mItemProxies;
    }

    public BooleanValue getCanScrollForwards() {
        return this.mCanScrollForwards;
    }

    public BooleanValue getCanScrollBackwards() {
        return this.mCanScrollBackwards;
    }

    public IntegerValue getListItemCount() {
        return this.mListItemCount;
    }

    public SettableIntegerValue getScrollPosition() {
        return this.mScrollPosition;
    }

    public int getScrollPositionValue() {
        assert (bhj.W1d(this.isDocumentThread()));
        return this.mScrollPosition.getValue();
    }

    public void listChanged() {
        assert (bhj.W1d(this.isDocumentThread()));
        if (!this.mHasScheduledUpdate) {
            this.mHasScheduledUpdate = true;
            this.runAtEndOfEvent(this::update);
        }
    }

    private void update() {
        assert (bhj.W1d(this.isDocumentThread()));
        List list = this.getList();
        this.update(list);
        this.mHasScheduledUpdate = false;
    }

    @Override
    protected void connectToTarget(Object object) {
        this.update();
    }

    @Override
    protected void disconnectFromTarget(Object object) {
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            controlSurfaceProxy.clearTarget();
        }
    }

    private List getList() {
        assert (bhj.W1d(this.isDocumentThread()));
        Object object = this.getTarget();
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        return this.calculateList(object);
    }

    protected abstract List calculateList(Object var1);

    protected void update(List list) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(list != null));
        int n2 = list.size() <= this.mItemProxies.length ? 0 : this.determineNewOffset(list);
        assert (bhj.W1d(n2 >= 0));
        assert (bhj.W1d(this.mItemProxies.length < list.size() ? n2 + this.mItemProxies.length <= list.size() : n2 == 0));
        int n3 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n4 = n2 + i2;
            if (n4 < list.size()) {
                object = (gMo)list.get(n4);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && object == this.mCursor) {
                    n3 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n4);
        }
        Object object = this.getTarget();
        if (object != null) {
            this.mScrollPosition.setIntegerValue(n2);
            this.mListItemCount.setIntegerValue(list.size());
            this.mCanScrollForwards.setBoolValue(n2 + this.getSizeOfBank() < list.size());
            this.mCanScrollBackwards.setBoolValue(n2 > 0);
        } else {
            this.mScrollPosition.unassigned();
            this.mListItemCount.unassigned();
            this.mCanScrollForwards.unassigned();
            this.mCanScrollBackwards.unassigned();
        }
        if (n3 >= 0) {
            this.mCursorIndex.setIntegerValue(n3);
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    private int determineNewOffset(List list) {
        assert (bhj.W1d(list.size() >= this.mItemProxies.length));
        assert (bhj.W1d(this.isDocumentThread()));
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            int n2;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            gMo gMo2 = (gMo)controlSurfaceProxy.getTarget();
            if (gMo2 == null || (n2 = list.indexOf(gMo2)) < 0) continue;
            return Us.WCG(n2, 0, list.size() - this.mItemProxies.length);
        }
        return Us.WCG(this.mScrollPosition.getValue(), 0, list.size() - this.mItemProxies.length);
    }

    public void addScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (bhj.W1d(bankItemTargetUpdater != null));
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInitializingDriver()));
        if (this.mScrollPositionSlaves == null) {
            this.mScrollPositionSlaves = new ArrayList(8);
        }
        this.mScrollPositionSlaves.add(bankItemTargetUpdater);
        assert (bhj.W1d(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == null));
        bankItemTargetUpdater.mMasterScrollPositionBankUpdater = this;
    }

    public void removeScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (bhj.W1d(bankItemTargetUpdater != null));
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(this.isInitializingDriver()));
        assert (bhj.W1d(this.mScrollPositionSlaves != null));
        if (this.mScrollPositionSlaves != null) {
            assert (bhj.W1d(this.mScrollPositionSlaves.contains(bankItemTargetUpdater)));
            this.mScrollPositionSlaves.remove(bankItemTargetUpdater);
            assert (bhj.W1d(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == this));
            bankItemTargetUpdater.mMasterScrollPositionBankUpdater = null;
        }
    }

    @Override
    public gMo getFirstItem(gMo gMo2) {
        assert (bhj.W1d(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (gMo)list.get(0);
        }
        return null;
    }

    @Override
    public gMo getLastItem(gMo gMo2) {
        assert (bhj.W1d(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (gMo)list.get(list.size() - 1);
        }
        return null;
    }

    @Override
    public gMo getPreviousItem(gMo gMo2) {
        assert (bhj.W1d(this.isDocumentThread()));
        List list = this.getList();
        if (gMo2 == null) {
            if (!list.isEmpty()) {
                return (gMo)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(gMo2);
        if (n2 > 0) {
            return (gMo)list.get(n2 - 1);
        }
        return null;
    }

    @Override
    public gMo getNextItem(gMo gMo2) {
        assert (bhj.W1d(this.isDocumentThread()));
        List list = this.getList();
        if (gMo2 == null) {
            if (!list.isEmpty()) {
                return (gMo)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(gMo2);
        if (n2 + 1 < list.size()) {
            return (gMo)list.get(n2 + 1);
        }
        return null;
    }

    protected void cursorMovedToItem(gMo gMo2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(this.mCursorProxyToFollow != null));
        this.mCursor = gMo2;
        if (gMo2 != null) {
            this.doScrollToItem(gMo2);
            int n2 = -1;
            for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
                ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
                gMo gMo3 = (gMo)controlSurfaceProxy.getTarget();
                if (gMo3 != gMo2) continue;
                n2 = i2;
                break;
            }
            if (n2 >= 0) {
                this.mCursorIndex.setIntegerValue(n2);
            } else {
                this.mCursorIndex.unassigned();
            }
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    public void doScrollToItem(gMo gMo2) {
        assert (bhj.W1d(gMo2 != null));
        assert (bhj.W1d(this.isDocumentThread()));
        List list = this.getList();
        int n2 = list.indexOf(gMo2);
        if (n2 >= 0) {
            this.doScrollIntoView(n2, list.size(), true);
        }
    }

    public void doScrollIntoView(int n2) {
        assert (bhj.W1d(n2 >= 0));
        assert (bhj.W1d(this.isDocumentThread()));
        this.doScrollIntoView(n2, true);
    }

    public void doScrollIntoView(int n2, boolean bl2) {
        assert (bhj.W1d(n2 >= 0));
        assert (bhj.W1d(this.isDocumentThread()));
        List list = this.getList();
        this.doScrollIntoView(n2, list.size(), bl2);
    }

    private void doScrollIntoView(int n2, int n3, boolean bl2) {
        assert (bhj.W1d(n2 >= 0));
        assert (bhj.W1d(this.isDocumentThread()));
        int n4 = this.mScrollPosition.getValue();
        if (n2 < n4 || n2 >= n4 + this.mItemProxies.length) {
            int n5 = this.quantizePosition(n2, n3);
            assert (bhj.W1d(n2 >= n5 && n2 < n5 + this.mItemProxies.length));
            this.doScrollTo(n5, bl2);
        }
    }

    public void followCursorProxy(ControlSurfaceCursorProxy controlSurfaceCursorProxy) {
        this.notNull(controlSurfaceCursorProxy, "cursor");
        this.checkIsInitializingDriver();
        if (this.mCursorProxyToFollow != null) {
            throw new mHK("This bank is already following a cursor");
        }
        this.mCursorProxyToFollow = controlSurfaceCursorProxy;
        controlSurfaceCursorProxy.addBankFollowingCursor(this);
    }

    public SettableIntegerValue getCursorIndex() {
        assert (bhj.W1d(this.mCursorIndex != null));
        return this.mCursorIndex;
    }

    protected void moveCursorIndexTo(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        assert (bhj.W1d(n2 >= 0 && n2 < this.getSizeOfBank()));
        if (this.mCursorProxyToFollow == null) {
            throw new mHK("This bank is not following any cursor");
        }
        this.exec(() -> this.doMoveCursorToIndex(n2));
    }

    private void doMoveCursorToIndex(int n2) {
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(n2 >= 0 && n2 < this.getSizeOfBank()));
        assert (bhj.W1d(this.mCursorProxyToFollow != null));
        ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[n2];
        gMo gMo2 = (gMo)controlSurfaceProxy.getTarget();
        if (gMo2 != null) {
            this.mCursorProxyToFollow.doSelect(gMo2);
        }
    }

    protected void moveCursorIndexBy(int n2) {
        assert (bhj.W1d(this.isControlSurfaceThread()));
        if (this.mCursorProxyToFollow == null) {
            throw new mHK("This bank is not following any cursor");
        }
        if (n2 != 0) {
            this.exec(() -> this.doMoveCursorIndexBy(n2));
        }
    }

    private void doMoveCursorIndexBy(int n2) {
        int n3;
        assert (bhj.W1d(this.isDocumentThread()));
        assert (bhj.W1d(n2 != 0));
        assert (bhj.W1d(this.mCursorProxyToFollow != null));
        int n4 = this.mCursorIndex.getValue();
        assert (bhj.W1d(n4 >= 0 && n4 < this.getSizeOfBank() || n4 == -1));
        if (n4 >= 0 && n4 < this.getSizeOfBank() && (n3 = n4 + n2) >= 0 && n3 < this.getSizeOfBank()) {
            this.doMoveCursorToIndex(n3);
        }
    }
}

