/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscBundle;
import com.bitwig.extension.api.opensoundcontrol.OscPacket;
import com.bitwig.flt.control_surface.opensoundcontrol.OZu;
import com.bitwig.flt.control_surface.opensoundcontrol.htX;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class TAK {
    private ByteBuffer t3p = null;
    private byte[] W1d = null;

    TAK() {
    }

    OscPacket WCG(byte[] byArray, int n2, int n3) {
        try {
            this.W1d = byArray;
            this.t3p = ByteBuffer.wrap(byArray, n2, n3);
            this.t3p.order(ByteOrder.BIG_ENDIAN);
            return this.WCG(null);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private OscPacket WCG(OscBundle oscBundle) {
        String string = this.WCG();
        if (string.equals("#bundle")) {
            return this.t3p(oscBundle);
        }
        return this.WCG(oscBundle, string);
    }

    private String WCG() {
        byte by2;
        int n2 = this.t3p.position();
        assert (bhj.WCG(n2 % 4 == 0));
        while ((by2 = this.t3p.get()) != 0) {
        }
        String string = new String(this.W1d, n2, this.t3p.position() - n2 - 1);
        this.BiT();
        return string;
    }

    private int t3p() {
        assert (bhj.WCG(this.t3p.order() == ByteOrder.BIG_ENDIAN));
        return this.t3p.getInt();
    }

    private long W1d() {
        assert (bhj.WCG(this.t3p.order() == ByteOrder.BIG_ENDIAN));
        return this.t3p.getLong();
    }

    private float pqd() {
        return this.t3p.getFloat();
    }

    private double ocA() {
        return this.t3p.getDouble();
    }

    private byte[] LQe() {
        int n2 = this.t3p();
        if (n2 < 0) {
            throw new IOException("Invalid blob size: " + n2);
        }
        byte[] byArray = new byte[n2];
        this.t3p.get(byArray);
        this.BiT();
        return byArray;
    }

    private void BiT() {
        int n2 = this.t3p.position() % 4;
        if (n2 != 0) {
            int n3 = this.t3p.position() + 4 - n2;
            this.t3p.position(n3);
        }
        assert (bhj.WCG(this.t3p.position() % 4 == 0));
    }

    private htX WCG(OscBundle oscBundle, String string) {
        String string2 = this.WCG();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!string2.isEmpty() && string2.charAt(0) == ',') {
            block11: for (int i2 = 1; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                switch (c2) {
                    case 'F': {
                        arrayList.add(false);
                        continue block11;
                    }
                    case 'T': {
                        arrayList.add(true);
                        continue block11;
                    }
                    case 'N': {
                        arrayList.add(null);
                        continue block11;
                    }
                    case 'i': {
                        arrayList.add(this.t3p());
                        continue block11;
                    }
                    case 'h': {
                        arrayList.add(this.W1d());
                        continue block11;
                    }
                    case 'f': {
                        arrayList.add(Float.valueOf(this.pqd()));
                        continue block11;
                    }
                    case 'd': {
                        arrayList.add(this.ocA());
                        continue block11;
                    }
                    case 'b': {
                        arrayList.add(this.LQe());
                        continue block11;
                    }
                    case 's': {
                        arrayList.add(this.WCG());
                        continue block11;
                    }
                    default: {
                        i2 = string2.length();
                    }
                }
            }
        }
        return new htX(oscBundle, string, string2, arrayList);
    }

    private OZu t3p(OscBundle oscBundle) {
        long l2 = this.W1d();
        OZu oZu = new OZu(oscBundle, l2);
        while (this.t3p.position() < this.t3p.limit()) {
            int n2 = this.t3p();
            if (this.t3p.limit() < this.t3p.position() + n2) {
                throw new IOException("OSC: Invalid Packet Size (" + n2 + ") which exceeds the packet by " + (this.t3p.position() + n2 - this.W1d.length) + " bytes.");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.W1d, this.t3p.position(), n2);
            ByteBuffer byteBuffer2 = this.t3p;
            byteBuffer2.position(byteBuffer2.position() + n2);
            this.t3p = byteBuffer;
            OscPacket oscPacket = this.WCG(oZu);
            oZu.WCG(oscPacket);
            assert (bhj.WCG(byteBuffer.position() <= byteBuffer2.position()));
            this.t3p = byteBuffer2;
        }
        return oZu;
    }
}

